#ifndef __BOARDCFG_H__
#define __BOARDCFG_H__
/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_gpio.h"
#include "stm32f10x_rcc.h"
#include "stm32f10x_type.h"
//Einstellungen
//############################################################



//############################################################
//Einstellungen


typedef u8  BYTE;
typedef unsigned short WORD;
typedef unsigned long  DWORD;
typedef bool BOOL;

#define BOARD_AHB_RCCs		 RCC_AHBPeriph_DMA1
#define BOARD_APB2_RCCs		 RCC_APB2Periph_SPI1|RCC_APB2Periph_ADC1|RCC_APB2Periph_AFIO //0x0000463D==USART1.ADC2.ADC1.GPIOD.GPIOC.GPIOB.GPIOA.AFIO
#define BOARD_APB1_RCCs		 RCC_APB1Periph_USB|RCC_APB1Periph_PWR //RCC_APB1Periph_ALL

/* LEDs und buttons #####################*/
#define LED2_On()		GPIO_SetBits(GPIOA,GPIO_Pin_2)
#define LED2_Off()		GPIO_ResetBits(GPIOA,GPIO_Pin_2)
#define LED3_On()		GPIO_SetBits(GPIOA,GPIO_Pin_3)
#define LED3_Off()		GPIO_ResetBits(GPIOA,GPIO_Pin_3)
#define Button1 		((GPIOA->IDR & GPIO_Pin_0) != GPIO_Pin_0)
#define Button2 		((GPIOA->IDR & GPIO_Pin_1) != GPIO_Pin_1)

/* LCD #####################*/
//#define Use_LCD_8Bit_Latch //Display im 16bit Mode ber Latch
//#define Use_LCD_8Bit_Direct //Display im 8bit Mode
#define Use_LCD_16Bit //Display im 16bit Mode
#define LCD_LE_H()				GPIOB->BSRR = GPIO_Pin_5; //fr 8bit
#define LCD_LE_L()				GPIOB->BRR = GPIO_Pin_5; //fr 8bit
#define LCD_CS_H()				GPIOC->BSRR = GPIO_Pin_8;
#define LCD_CS_L()				GPIOC->BRR = GPIO_Pin_8;
#define LCD_RS_H()				GPIOC->BSRR = GPIO_Pin_9;
#define LCD_RS_L()				GPIOC->BRR = GPIO_Pin_9;
#define LCD_WR_H()				GPIOC->BSRR = GPIO_Pin_10;
#define LCD_WR_L()				GPIOC->BRR = GPIO_Pin_10;
#define LCD_RD_H()				GPIOC->BSRR = GPIO_Pin_11;
#define LCD_RD_L()				GPIOC->BRR = GPIO_Pin_11;
#define LCD_LED_H()				GPIOC->BSRR = GPIO_Pin_12;
#define LCD_LED_L()				GPIOC->BRR = GPIO_Pin_12;
#define LCD_DataPort_0to7		GPIOC //bei 8bit wie LCD_DataPort_8to15
#define LCD_DataPort_8to15		GPIOB
/* LCD Zusatz*/


/* Soft I2C Bus #####################*/
#define I2C_PORT_SCL			GPIOA
#define I2C_PIN_SCL				GPIO_Pin_8
#define I2C_PORT_DATA			GPIOB
#define I2C_PIN_DATA			GPIO_Pin_1
#define I2C_Delay_Long()		Delay=1; while(Delay--){;}
#define I2C_Delay_Short()		Delay=0; while(Delay--){;}
//#define I2C_Delay_Long()		Delay=0; Delay=0; Delay=0; Delay=0; 
//#define I2C_Delay_Short()		Delay=0; Delay=0;
/* I2C Optional */
#define IC2_DATA_MACRO_IN		GPIOB->CRL = (GPIOB->CRL & 0xFFFFFF0F) | 0x00000040;   //Pin1 -> IF
#define IC2_DATA_MACRO_OUT		GPIOB->CRL = (GPIOB->CRL & 0xFFFFFF0F) | 0x00000070;   //Pin1 -> OD 50MHz
/* I2C Device 16bit IO expander (MCP23017) */
#define IO16_DirA		0
#define IO16_DirB		1
#define IO16_OutA		18
#define IO16_OutB		19

/* SPI #####################*/
#define GPIO_SD_Port		GPIOA
#define GPIO_Pin_SD_SCK		GPIO_Pin_5
#define GPIO_Pin_SD_MISO	GPIO_Pin_6
#define GPIO_Pin_SD_MOSI	GPIO_Pin_7
/* SPI Devices */
#define GPIO_FLASH_CS		GPIOB	//unbenutzt
#define GPIO_Pin_FLASH_CS	GPIO_Pin_6 //unbenutzt
#define GPIO_TP_CS			GPIOA
#define GPIO_Pin_TP_CS		GPIO_Pin_4
#define TP_PenDown		((GPIOC->IDR & GPIO_Pin_13) != GPIO_Pin_13) //TP_INT
#define GPIO_SD_CS			GPIOB
#define GPIO_Pin_SD_CS		GPIO_Pin_7

/* USB #####################*/
#define USB_VID					0x0483
#define USB_PID					0x0001
#define BOARD_USB_ENABLE_PORT	GPIOD
#define BOARD_USB_ENABLE_PIN	GPIO_Pin_2
#define INREPORT_SIZE           63 //Ausgang zum USB
#define OUTREPORT_SIZE          63 //Eingang vom USB
#define USB_IN_SPEED            1
#define USB_OUT_SPEED           1

/* SPI Configs*/
#define Mode_0			0
#define Mode_1			1
#define Mode_2			2
#define Mode_3			3
#define Mode_OFF		255
#define Databit8		8
#define Databit16		16
#define BaudScale_2		2	//36 MHz
#define BaudScale_4		4	//18 MHz
#define BaudScale_8		8	//9 MHz
#define BaudScale_16	16	//4.5 MHz
#define BaudScale_32	32	//2.25 MHz
#define BaudScale_64	64	//1.125 MHz
#define BaudScale_128	128	//562.5 KHz
#define BaudScale_256	255	//281.25 KHz
/* Makros */
#define SD_ON				GPIO_ResetBits(GPIO_SD_CS, GPIO_Pin_SD_CS)
#define SD_OFF				GPIO_SetBits(GPIO_SD_CS, GPIO_Pin_SD_CS)
#define TP_ON  				GPIO_ResetBits(GPIO_TP_CS,GPIO_Pin_TP_CS)
#define TP_OFF 				GPIO_SetBits(GPIO_TP_CS,GPIO_Pin_TP_CS)
#define F_ON  				GPIO_ResetBits(GPIO_TP_CS,GPIO_Pin_TP_CS)
#define F_OFF 				GPIO_SetBits(GPIO_FLASH_CS,GPIO_Pin_FLASH_CS)
#define I2C_SCL_H()     		I2C_PORT_SCL->BSRR = I2C_PIN_SCL;
#define I2C_SCL_L()     		I2C_PORT_SCL->BRR =  I2C_PIN_SCL;
#define I2C_DATA_STATE	 		I2C_PORT_DATA->IDR & I2C_PIN_DATA
#define I2C_SCL_STATE	 		I2C_PORT_SCL->IDR & I2C_PIN_SCL
#define I2C_DATA_H()     		I2C_PORT_DATA->BSRR = I2C_PIN_DATA;
#define I2C_DATA_L()    		I2C_PORT_DATA->BRR =  I2C_PIN_DATA;
/* weit bekannte Funktionen/variablen */
u8 I2C_Read(u8 adresse, u8 reg, u8 *data);
u8 I2C_Send(u8 adresse, u8 reg, u8 data);
u16 readADC1(u8 channel);
u16 TP_SPI_RW(u16 c);
void TP_GetAdXY(vs16 *x,vs16 *y);
__inline void delay_us(u16 i) { while( i--) { } }
__inline void delay_ms(u16 time) { while(time--) { delay_us(10000); } }
extern BYTE OutReport[OUTREPORT_SIZE],InReport[INREPORT_SIZE];
extern vu16 ADCConvertedValue;

#endif
