﻿using System;
using System.Drawing;
using System.Collections.Generic;
using JoeC_Thermovision;
using System.Linq;
using System.Threading;
using System.Windows.Forms;
using WinUSB;
using System.Text;

namespace TC_SeekThermal
{
	public class TCamera : iCamera
	{
		#region <<<Vars>>>
		WinUSBDevice device;
        const ushort _vendorID = 0x289D;
		const ushort _productID = 0x0010;
        const int _seekW = 206, _seekH = 156;
        const int _seekProW = 320, _seekProH = 240;
        const ushort _productIDPro = 0x0011;

        int W = 0, H = 0;
        bool _isSeekPro = false;
        string _DeviceFW = "";
        string _DeviceSerial = "";
        enum CMD {
		 READ_CHIP_ID                    = 54,
		 TOGGLE_SHUTTER                  = 55,
		 SET_OPERATION_MODE              = 0x3c,
		 SET_IMAGE_PROCESSING_MODE       = 0x3e,
		 GET_FIRMWARE_INFO               = 78,
		 START_GET_IMAGE_TRANSFER        = 0x53,
		 SET_FACTORY_SETTINGS_FEATURES   = 0x56,
        	
//		 BEGIN_MEMORY_WRITE              = 82,
//		 COMPLETE_MEMORY_WRITE           = 81,
//		 GET_OPERATION_MODE              = 61,
//		 GET_BIT_DATA                    = 59,
//		 GET_CURRENT_COMMAND_ARRAY       = 68,
//		 GET_DATA_PAGE                   = 65,
//		 GET_DEFAULT_COMMAND_ARRAY       = 71,
//		 GET_ERROR_CODE                  = 53,
//		 GET_FACTORY_SETTINGS            = 88,
//		 GET_IMAGE_PROCESSING_MODE       = 63,
//		 GET_RDAC_ARRAY                  = 77,
//		 GET_SHUTTER_POLARITY            = 57,
//		 GET_VDAC_ARRAY                  = 74,
//		 RESET_DEVICE                    = 89,
//		 SET_BIT_DATA_OFFSET             = 58,
//		 SET_CURRENT_COMMAND_ARRAY       = 67,
//		 SET_CURRENT_COMMAND_ARRAY_SIZE  = 66,
//		 SET_DATA_PAGE                   = 64,
//		 SET_DEFAULT_COMMAND_ARRAY       = 70,
//		 SET_DEFAULT_COMMAND_ARRAY_SIZE  = 69,
//		 SET_FACTORY_SETTINGS            = 87,
//		 SET_FIRMWARE_INFO_FEATURES      = 85,
//		 SET_RDAC_ARRAY                  = 76,
//		 SET_RDAC_ARRAY_OFFSET_AND_ITEMS = 75,
//		 SET_SHUTTER_POLARITY            = 56,
//		 SET_VDAC_ARRAY                  = 73,
//		 SET_VDAC_ARRAY_OFFSET_AND_ITEMS = 72,
//		 TARGET_PLATFORM                 = 84,
//		 UPLOAD_FIRMWARE_ROW_SIZE        = 79,
//		 WRITE_MEMORY_DATA               = 80,
		};
		#endregion
		
		#region ExternalFunctions
		public CamResponse Connect(string info)
		{
			try {
				WinUSBEnumeratedDevice dev = TCamera.Enumerate_SeekPro().First();
                if (dev == null) {
                    dev = TCamera.Enumerate_SeekNormal().First();
                    if (dev == null) { 
                        return CamResponse.NotFound;
                    }
                    //normal Seek found
                    W = _seekW;
                    H = _seekH;
                    _isSeekPro = false;
                } else {
                    //Seek pro found
                    W = _seekProW;
                    H = _seekProH;
                    _isSeekPro = true;
                }
	            device = new WinUSBDevice(dev);
                
                //get FW version
	            byte[] DevFW = device.ControlTransferIn(0xC1, (byte)CMD.GET_FIRMWARE_INFO , 0, 0, 4);
                _DeviceFW = $"{DevFW[0]}.{DevFW[1]}.{DevFW[2]}.{DevFW[3]}";
                //get device serial
                byte[] DevID = device.ControlTransferIn(0xC1, (byte)CMD.READ_CHIP_ID , 0, 0, 12);
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < DevID.Length; i++) {
                    if (DevID[i]==0) { continue; }
                    sb.Append(DevID[i]);
                }
                _DeviceSerial = sb.ToString();
                
				Seek_SendInit(false);
				return CamResponse.Pass;
			} catch (Exception) {
				return CamResponse.Fail;
			}
			
			return CamResponse.Fail;
		}
		public CamResponse Disconnect(string info)
		{
			try {
				Seek_Deinit();
			} catch (Exception) {
				return CamResponse.Fail;
			}
			return CamResponse.Pass;
		}
		
		public Point Get_Resolution()
		{
			return new Point(W,H);
		}
		
		public float[] Get_ThermalFrame()
		{
            ushort[] raw = Get_RawFrame();
            if (raw == null) { return null; }
            //translate to temperature
            float[] output = new float[W * H];
            int cnt = 0;

            //quick & dirty temperature translation
            for (int i = 0; i < raw.Length; i++) {
                output[i] = (float)(raw[i] * 0.08)-550f;
            }
            return output;
        }
		
		public ushort[] Get_RawFrame()
		{
			//get a frame
			ThermalFrame TF = Grab_VisualFrame();
            if (TF == null) { return null; }
			//Translate to Array
			ushort[] output = new ushort[W*H];
			int cnt = 0;
			for (int y = 0; y < H; ++y) {
				for (int x = 0; x < W; ++x) {
					output[cnt] = TF.Data[x,y]; cnt++;
				}
			}
			return output;
		}
        public bool[] Get_DeathPixels() {
            //get a frame
            if (DeathPixMap == null) { return null; }
            //Translate to Array
            bool[] output = new bool[W * H];
            int cnt = 0;
            for (int y = 0; y < H; ++y) {
                for (int x = 0; x < W; ++x) {
                    output[cnt] = DeathPixMap[x, y]; cnt++;
                }
            }
            return output;
        }

        public CamResponse SendCommand(string CMD)
		{
			return CamResponse.NotFound;
		}
        public string SendQuery(string CMD) 
        {
            switch (CMD) {
                case "SER": return _DeviceSerial;
                case "FW": return _DeviceFW;
            }
            return $"Unknown '{CMD}'";
        }
        #endregion

        static IEnumerable<WinUSBEnumeratedDevice> Enumerate_SeekNormal()
        {
            //first look for Pros and use them
            foreach (WinUSBEnumeratedDevice dev in WinUSBDevice.EnumerateAllDevices()) {
                // Seek Thermal "iAP Interface" device - Use Zadig to install winusb driver on it.
                if (dev.VendorID == _vendorID && dev.ProductID == _productID && dev.UsbInterface == 0) {
                    yield return dev;
                }
            }
            yield return null;
        }
        static IEnumerable<WinUSBEnumeratedDevice> Enumerate_SeekPro() {
            //first look for Pros and use them
            foreach (WinUSBEnumeratedDevice dev in WinUSBDevice.EnumerateAllDevices()) {
                // Seek Thermal "iAP Interface" device - Use Zadig to install winusb driver on it.
                if (dev.VendorID == _vendorID && dev.ProductID == _productIDPro && dev.UsbInterface == 0) {
                    yield return dev;
                }
            }
            yield return null;
        }
       
        void Seek_SendInit(bool RawMode)
		{
            if (_isSeekPro) {
                //Seek Pro Only
                device.ControlTransferOut(0x41, 0x54, 0, 0, new byte[] { 1, 0, 0, 0 });
                device.ControlTransferOut(0x41, 0x3c, 0, 0, new byte[] { 0x00, 0x00 });

                device.ControlTransferOut(0x41, (byte)CMD.SET_FACTORY_SETTINGS_FEATURES, 0, 0, new byte[] { 0x06, 0x00, 0x08, 0x00, 0x00, 0x00 });
                device.ControlTransferOut(0x41, 0x55, 0, 0, new byte[] { 0x17, 0x00 });
                device.ControlTransferOut(0x41, (byte)CMD.SET_FACTORY_SETTINGS_FEATURES, 0, 0, new byte[] { 0x01, 0x00, 0x00, 0x06, 0x00, 0x00 });
                device.ControlTransferOut(0x41, (byte)CMD.SET_FACTORY_SETTINGS_FEATURES, 0, 0, new byte[] { 0x01, 0x00, 0x01, 0x06, 0x00, 0x00 });
                byte ValA = 0x00;
                byte ValB = 0x00;
                while (true) {
                    //(valueA valueB)=(00 00) to (09 e0) step 20
                    device.ControlTransferOut(0x41, (byte)CMD.SET_FACTORY_SETTINGS_FEATURES, 0, 0, new byte[] { 0x02, 0x00, ValB, ValA, 0x00, 0x00 });
                    if (ValB < 0xe0) { ValB += 0x20; } else { ValB = 0; ValA++; }
                    if (ValA == 0x09 && ValB == 0xe0) { break; }
                }
                device.ControlTransferOut(0x41, 0x55, 0, 0, new byte[] { 0x15, 0x00 });
                if (RawMode) {
                    device.ControlTransferOut(0x41, 62, 0, 0, new byte[] { 1, 0x00 });
                } else {
                    device.ControlTransferOut(0x41, 62, 0, 0, new byte[] { 8, 0x00 });
                }
                device.ControlTransferOut(0x41, (byte)CMD.SET_OPERATION_MODE, 0, 0, new byte[] { 0x01, 0x00 });
                //device.ControlTransferOut(0x41, 0x53, 0, 0, new byte[] { 0x58, 0x5b, 0x01, 0x00});

                return;
            }
			device.ControlTransferOut(0x41, (byte)CMD.TOGGLE_SHUTTER , 0, 0, new byte[] { 1,0,0,0 });
        	device.ControlTransferOut(0x41, (byte)CMD.SET_OPERATION_MODE , 0, 0, new byte[] { 0x00, 0x00 });
        	
        	device.ControlTransferOut(0x41, (byte)CMD.SET_FACTORY_SETTINGS_FEATURES, 0, 0, new byte[] { 0x01 });
            device.ControlTransferOut(0x41, (byte)CMD.SET_FACTORY_SETTINGS_FEATURES, 0, 0, new byte[] { 0x00, 0x00 });
            device.ControlTransferOut(0x41, (byte)CMD.SET_FACTORY_SETTINGS_FEATURES, 0, 0, new byte[] { 0x06, 0x00, 0x08, 0x00, 0x00, 0x00 });
            device.ControlTransferOut(0x41, (byte)CMD.SET_FACTORY_SETTINGS_FEATURES, 0, 0, new byte[] { 0x01, 0x00, 0x00, 0x06, 0x00, 0x00 });
			device.ControlTransferOut(0x41, (byte)CMD.SET_FACTORY_SETTINGS_FEATURES, 0, 0, new byte[] { 0x01, 0x00, 0x01, 0x06, 0x00, 0x00 });
			device.ControlTransferOut(0x41, (byte)CMD.SET_FACTORY_SETTINGS_FEATURES, 0, 0, new byte[] { 0x20, 0x00, 0x30, 0x00, 0x00, 0x00 });
			device.ControlTransferOut(0x41, (byte)CMD.SET_FACTORY_SETTINGS_FEATURES, 0, 0, new byte[] { 0x20, 0x00, 0x50, 0x00, 0x00, 0x00 });
			device.ControlTransferOut(0x41, (byte)CMD.SET_FACTORY_SETTINGS_FEATURES, 0, 0, new byte[] { 0x0C, 0x00, 0x70, 0x00, 0x00, 0x00 });
			if (RawMode) {
				device.ControlTransferOut(0x41, 62, 0, 0, new byte[] { 1, 0x00 });
			} else {
				device.ControlTransferOut(0x41, 62, 0, 0, new byte[] { 8, 0x00 });
			}
			device.ControlTransferOut(0x41, (byte)CMD.SET_OPERATION_MODE , 0, 0, new byte[] { 0x01, 0x00 });
		}
		void Seek_Deinit()
        {
            device.ControlTransferOut(0x41, 0x3C, 0, 0, new byte[] { 0x00, 0x00 });
            device.ControlTransferOut(0x41, 0x3C, 0, 0, new byte[] { 0x00, 0x00 });
            device.ControlTransferOut(0x41, 0x3C, 0, 0, new byte[] { 0x00, 0x00 });
            device.Dispose();
        }
		byte[] GetFrame_asBytes()
        {
            if (_isSeekPro) { 
                device.ControlTransferOut(0x41, (byte)CMD.START_GET_IMAGE_TRANSFER, 0, 0, new byte[] { 0x58, 0x5b, 0x01, 0x00 });
                return device.ReadExactPipe(0x81, 177840);
            }
            // Request frame (vendor interface request 0x53; data "C0 7e 00 00" which is half the size of the return data)
            device.ControlTransferOut(0x41, (byte)CMD.START_GET_IMAGE_TRANSFER, 0, 0, new byte[] {0xc0, 0x7e, 0, 0});
            // Read data from IN 1 pipe
            return device.ReadExactPipe(0x81, 64896); //32448 words (0x81, 0x7ec0 * 2);
        }
		ThermalFrame GetFrame_asClass()
        {
            return new ThermalFrame(GetFrame_asBytes(),W,H);
        }
		
		bool useInternalProcessing = true;
		double[,] GainMap;
    	bool[,] DeathPixMap;
    	ThermalFrame FrameID1;
		ThermalFrame Grab_VisualFrame()
        {
        	ThermalFrame TF=null;
        	int trys = 40;
        	while (trys>0) {
                // Get frame
                trys--;
                TF = GetFrame_asClass();
                if (TF.Data==null) {
                	//System.Windows.Forms.MessageBox.Show("No Framedata Recived.\r\n" + "Reconnect USB and try again.");
                	return null; 
                }
                // Keep the first 6 frames, or anytime those frame IDs are encountered.
                //The first frames have the following IDs:
                //4,9,8,7,10,5,1 (shutter off after),3...
                //So, after the initialization sequence, you'll get something like this:
                //6, 1, 3, 3, 3, 6, 1, 3, 3, 3, 3, 3, 6, 1, 3, 3, 3, 3, 3, 3 etc.
				if (TF.StatusByte==4) {
					//internal Gain Cal
					DeathPixMap=TF.Cal_GetDefPixel();
					GainMap=TF.Cal_GetGains(ref DeathPixMap,TF.AvrValue);
				} else if (TF.StatusByte==1) {
					if (FrameID1==null) { FrameID1 = TF; }
					FrameID1 = TF;
					continue;
				} else if (TF.StatusByte==3) {
					//IsUsableFrame
					if (DeathPixMap==null) { DeathPixMap=TF.Cal_GetDefPixel(); }
					TF.Frame_ShutterGaincal(ref DeathPixMap,FrameID1.Data,GainMap,FrameID1.AvrValue);
					TF.Frame_CalcMinMax(DeathPixMap,true);
					TF.Frame_RemoveDeathPixel(DeathPixMap);
					break;
				} else {
					//if stream offset rise
					if (TF.StatusByte>10) { Thread.Sleep(10); }
				}
            } //while...
        	if (trys==0) {
        		return null;
        	}
        	return TF;
        }

        
    }
}