﻿/*
 * Erstellt mit SharpDevelop.
 * Benutzer: talentfrei
 * Datum: 12.01.2015
 * Zeit: 06:31
 * 
 * Sie können diese Vorlage unter Extras > Optionen > Codeerstellung > Standardheader ändern.
 */
using System;
using System.Windows.Forms;
using System.Drawing.Imaging;
//using System.Drawing.Drawing2D;
using System.Drawing;

namespace SeekThermal_Form
{
	/// <summary>
	/// Class with program entry point.
	/// </summary>
	internal sealed class Program
	{
		/// <summary>
		/// Program entry point.
		/// </summary>
		[STAThread]
		private static void Main(string[] args)
		{
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);
			Application.Run(new MainForm());
		}
		
	}
	 #region UnsafeBitmap
    public unsafe class UnsafeBitmap
	{
		Bitmap bitmap;

		// three elements used for MakeGreyUnsafe
		int W;
		BitmapData bitmapData = null;
		Byte* pBase = null;
		public UnsafeBitmap(Bitmap bitmap)
		{
			this.bitmap = new Bitmap(bitmap);
		}
		public UnsafeBitmap(int W, int H)
		{
			this.bitmap = new Bitmap(W, H, PixelFormat.Format24bppRgb);
		}
		public void Dispose()
		{
			bitmap.Dispose();
		}
		public Bitmap Bitmap
		{
			get
			{
				return(bitmap);
			}
		}
		private Point PixelSize
		{
			get
			{
				GraphicsUnit unit = GraphicsUnit.Pixel;
				RectangleF bounds = bitmap.GetBounds(ref unit);

				return new Point((int) bounds.Width, (int) bounds.Height);
			}
		}
		public void LockBitmap()
		{
			GraphicsUnit unit = GraphicsUnit.Pixel;
			RectangleF boundsF = bitmap.GetBounds(ref unit);
			Rectangle bounds = new Rectangle((int) boundsF.X,
			                                 (int) boundsF.Y,
			                                 (int) boundsF.Width,
			                                 (int) boundsF.Height);
			
			// Figure out the number of bytes in a row
			// This is rounded up to be a multiple of 4
			// bytes, since a scan line in an image must always be a multiple of 4 bytes
			// in length.
			W = (int) boundsF.Width * sizeof(PixelData);
			if (W % 4 != 0)
			{
				W = 4 * (W / 4 + 1);
			}
			bitmapData =
				bitmap.LockBits(bounds, ImageLockMode.ReadWrite, PixelFormat.Format24bppRgb);
			pBase = (Byte*) bitmapData.Scan0.ToPointer();
		}
		public PixelData GetPixel(int x, int y)
		{
			//x=337 / y=489
			try {
				PixelData returnValue = *PixelAt(x, y);
				return returnValue;
			} catch (Exception) {
				PixelData returnValue = *PixelAt(1, 1);
				return returnValue;
			}
			
		}
		public void SetPixel(int x, int y, PixelData colour)
		{
			PixelData* pixel = PixelAt(x, y);
			*pixel = colour;
		}
		public void UnlockBitmap()
		{
			bitmap.UnlockBits(bitmapData);
			bitmapData = null;
			pBase = null;
		}
		public PixelData* PixelAt(int x, int y)
		{
			return (PixelData*)(pBase + y * W + x * sizeof(PixelData));
		}
	}
	public struct PixelData
	{
		public byte blue;
		public byte green;
		public byte red;
	}
    #endregion
	
}
