﻿#region Usings
using System;
using System.Drawing;
using System.Threading;
using System.Windows.Forms;
using System.IO;
using System.Reflection;
using System.Drawing.Drawing2D;

using JoeC_Thermovision;
#endregion

namespace SeekThermal_Form
{
    public partial class MainForm : Form
    {
		#region <<<Vars>>>
		ushort[,] _lastRawFrame;
        float[,] _lastTempFrame;
        short[,] CalOffsetMap;
		#endregion
		
		#region Form
        public MainForm()
        {
            InitializeComponent();
            Kernel_DrawPalette(); //init palette
//            Kernel_readCalData();
        }
        void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
        	Disconnect_Camera();
            if (_dll_CamObj!=null) {
				_dll_CamObj=null;
            }
        }
        
        void Btn_connectSeekClick(object sender, EventArgs e)
	    {
        	if (btn_connectSeek.BackColor==Color.LimeGreen) {
        		Disconnect_Camera();
        		btn_connectSeek.BackColor=Color.Gainsboro;
        		return;
        	}
        	
        	btn_connectSeek.BackColor=Color.Gold;
        	if (!Init_Extern_Dll()) {
        		btn_connectSeek.BackColor=Color.Red;
        		return;
        	}
	    	if (!Connect_Camera()) {
        		btn_connectSeek.BackColor=Color.Red;
        		return;
        	}
        	btn_connectSeek.BackColor=Color.LimeGreen;
	    	btn_connectSeek.Refresh();
    		
			Btn_GetProcByteStreamingClick(null,null);
        }
        void Btn_GetFrame_AsByteArrayClick(object sender, EventArgs e)
        {
        	GetFrameAndDisplayIt();
        }
        void Btn_GetProcByteStreamingClick(object sender, EventArgs e)
        {
        	if (btn_connectSeek.BackColor!=Color.LimeGreen) { return; }
        	
        	if (_streaming) {
        		_streaming = false;
        		_ThrStraming.Abort();
        		btn_GetProcByteStreaming.Text="Start Streaming";
        		btn_GetProcByteStreaming.BackColor=Color.Gainsboro;
        	} else {
        		_ThrStraming = new Thread(Streaming);
        		_streaming=true;
        		_ThrStraming.Start();
        		Thread.Sleep(100);
        		if (_StreamThreadRunning) {
        			btn_GetProcByteStreaming.Text="Stop Streaming";
        			btn_GetProcByteStreaming.BackColor=Color.LimeGreen;
        		} else {
        			btn_GetProcByteStreaming.Text="Start Streaming";
        			btn_GetProcByteStreaming.BackColor=Color.Red;
        		}
        	}
        }
        
        void Btn_CalibrateClick(object sender, EventArgs e)
		{
			_GetRefFrame=true;
			chk_useRefFrame.Checked=true;
		}
        
        void PicBoxMainMouseMove(object sender, MouseEventArgs e)
		{
			if (rad_CamRawMode.Checked) {
				if (_lastRawFrame!=null) {
					int readX = (int)((float)e.X/(float)PicBoxMain.Width*(float)_dll_Resolution.X);
					int readY = (int)((float)e.Y/(float)PicBoxMain.Height*(float)_dll_Resolution.Y);
					txt_mousePos.Text = readX+"x"+readY;
					try {
						txt_mouseValue.Text=_lastRawFrame[readX,readY].ToString();
					} catch (Exception) {
						txt_mouseValue.Text="xxx";
					}
				}
			}
            if (rad_CamTempMode.Checked) {
                if (_lastTempFrame != null) {
                    int readX = (int)((float)e.X / (float)PicBoxMain.Width * (float)_dll_Resolution.X);
                    int readY = (int)((float)e.Y / (float)PicBoxMain.Height * (float)_dll_Resolution.Y);
                    txt_mousePos.Text = readX + "x" + readY;
                    try {
                        txt_mouseValue.Text = _lastTempFrame[readX, readY].ToString();
                    }
                    catch (Exception) {
                        txt_mouseValue.Text = "xxx";
                    }
                }
            }
        }
        
        
        Bitmap Kernel_DrawImage()
        {
        	if (_lastRawFrame==null&&rad_CamRawMode.Checked) {
        		return new Bitmap(2, 2);
        	}
            if (_lastTempFrame == null && rad_CamTempMode.Checked) {
                return new Bitmap(2, 2);
            }
            PixelData Col = new PixelData();
        	UnsafeBitmap ubmp=null;
        	ubmp = new UnsafeBitmap(_dll_Resolution.X, _dll_Resolution.Y);
        	ubmp.LockBitmap();

            if (rad_CamRawMode.Checked) { //Raw Mode ###########################
                ushort max,min;
        	    if (chk_AutoRange.Checked) {
                    ushort val;
                    min = 0xFFFF;
                    max = 0x0000;
                    int stopX = _dll_Resolution.X-20;
                    int stopY = _dll_Resolution.Y-20;
	                for (int y = 20; y < stopY; y++) {
                        for (int x = 20; x < stopX; x++) {
                            val = _lastRawFrame[x,y];
                            if (val < min) min = val;
                            if (val > max) max = val;
                        }
                    }
                    txt_FrameInfos.Text="Max/Min: "+max+"/"+min+"\r\nRange: "+(max-min);
        	    } else {
        		    max=(ushort)trackBar_max.Value;
        		    min=(ushort)trackBar_min.Value;
        	    }
        	
        	    // Scale data to be within [0-255] for LUT mapping.
        	    ushort maxmin = (ushort)(max-min);
                if (maxmin<10) { maxmin=10; }// Avoid divide by 0
                for (int y = 0; y < _dll_Resolution.Y; y++) {
                    for (int x = 0; x < _dll_Resolution.X; x++) {
                        int v = _lastRawFrame[x,y];
                    
                        v = (v - min) * 256 / maxmin;
                        if (v < 0) { v = 0; }
                        if (v > 255) {  v = 255; }
                    
                        if (lastPalette>1) {
                    	    Col.red=map_r[v];
                    	    Col.green=map_g[v];
	                        Col.blue=map_b[v];
                        } else { // Greyscale output (would always be limited to 256 colors)
	                        Col.red=(byte)v;
	                        Col.green=(byte)v;
	                        Col.blue=(byte)v;
                        }
                    
                        ubmp.SetPixel(x, y, Col);
                    }
                }
            } //Raw Mode ###########################
            if (rad_CamTempMode.Checked) { //Raw Mode ###########################
                float max, min;
                float val;
                min = 0xFFFF;
                max = 0x0000;
                int stopX = _dll_Resolution.X - 20;
                int stopY = _dll_Resolution.Y - 20;
                for (int y = 20; y < stopY; y++) {
                    for (int x = 20; x < stopX; x++) {
                        val = _lastTempFrame[x, y];
                        if (val < min) min = val;
                        if (val > max) max = val;
                    }
                }
                txt_FrameInfos.Text = "Max/Min: " + Math.Round(max,1)  + "/" + Math.Round(min, 1) + "\r\nRange: " + Math.Round((max - min), 1);

                // Scale data to be within [0-255] for LUT mapping.
                float maxmin = (float)(max - min);
                if (maxmin < 1) { maxmin = 1; }// Avoid divide by 0
                for (int y = 0; y < _dll_Resolution.Y; y++) {
                    for (int x = 0; x < _dll_Resolution.X; x++) {
                        int v = (int)((_lastTempFrame[x, y] - min) * 256f / maxmin);
                        if (v < 0) { v = 0; }
                        if (v > 255) { v = 255; }

                        if (lastPalette > 1) {
                            Col.red = map_r[v];
                            Col.green = map_g[v];
                            Col.blue = map_b[v];
                        }
                        else { // Greyscale output (would always be limited to 256 colors)
                            Col.red = (byte)v;
                            Col.green = (byte)v;
                            Col.blue = (byte)v;
                        }

                        ubmp.SetPixel(x, y, Col);
                    }
                }
            } //Temp Mode ###########################

            ubmp.UnlockBitmap();
        	try {
	        	if (chk_BilatSmooth.Checked) {
	        		AForge.Imaging.Filters.BilateralSmoothing BS = new AForge.Imaging.Filters.BilateralSmoothing();
	        		BS.KernelSize=(int)num_BS_kernel.Value;
	        		BS.SpatialFactor=(int)num_BS_SpartFact.Value;
	        		BS.SpatialPower=(int)num_BS_SpartPow.Value;
	        		Bitmap bmp = BS.Apply((Bitmap)ubmp.Bitmap.Clone());
	        		return bmp;
	        	}
        	} catch (Exception ) {
        		
        	}
        	return ubmp.Bitmap;
			//PicBoxMain.Image=ubmp.Bitmap;
        }
        
        #endregion
        
        #region Extern_DLL
        MethodInfo _dllMethod_Connect;
        MethodInfo _dllMethod_Disconnect;
        MethodInfo _dllMethod_GetTemperatures;
        MethodInfo _dllMethod_GetRaw;
        MethodInfo _dllMethod_GetResolution;
        MethodInfo _dllMethod_GetCameraQuery;
        MethodInfo _dllMethod_SendCameraCommand;
        Point _dll_Resolution;
        string _dll_CameraInfoString =""; //optional to handle multiple cameras
        bool _dll_init = false;
        bool _dll_CamConnect = false;
        object _dll_CamObj;
        
        bool Init_Extern_Dll()
        {
        	try {
        		if (_dll_init) {
        			return true;
        		}
	        	string dll_fullname = Application.StartupPath+"\\TC_SeekThermal.dll";
	        	if (!File.Exists(dll_fullname)) {
	        		MessageBox.Show("DLL dont exist");
	        		return false;
	        	}
	        	txt_dll_log.Text="Load Dll...";
	        	FileStream dll_FS = new FileStream(dll_fullname, FileMode.Open);
	        	BinaryReader dll_BR = new BinaryReader(dll_FS);
	        	byte[] RawDll = dll_BR.ReadBytes((int)dll_FS.Length);
	        	dll_BR.Close();
	        	dll_FS.Close();
	        	
	    		Assembly TIC = Assembly.Load(RawDll);
	    		txt_dll_log.Text+="\r\n Search Class...";
	    		Type[] types = TIC.GetExportedTypes();
	    		Type TIC_ClassT = null;
	    		foreach(Type type in TIC.GetExportedTypes()) {
	    			if (type.Name.EndsWith("TCamera")) {
	    				TIC_ClassT = type;
	    				break;
	    			}
	            }
	    		if (TIC_ClassT==null) {
	    			MessageBox.Show("Class in DLL not found"); return false;
	    		}
	    		//get some function references
	    		txt_dll_log.Text+="\r\n Search Functions...";
                _dll_CamObj = Activator.CreateInstance(TIC_ClassT);
	    		_dllMethod_Connect = TIC_ClassT.GetMethod("Connect");
	    		_dllMethod_Disconnect = TIC_ClassT.GetMethod("Disconnect");
                _dllMethod_SendCameraCommand = TIC_ClassT.GetMethod("SendCommand");
	    		_dllMethod_GetTemperatures = TIC_ClassT.GetMethod("Get_ThermalFrame");
	    		_dllMethod_GetRaw = TIC_ClassT.GetMethod("Get_RawFrame");
                _dllMethod_GetResolution = TIC_ClassT.GetMethod("Get_Resolution");
                _dllMethod_GetCameraQuery = TIC_ClassT.GetMethod("SendQuery");

                txt_dll_log.Text+="\r\n Init done...";
	    		_dll_init = true;
	    		return true;
        	} catch (Exception ex) {
	    		txt_dll_log.Text+="\r\n Error:\r\n"+ex.Message;
        		MessageBox.Show(ex.Message,"Error Init_Extern_Dll()");
        	}
        	return false;
        }
        bool Connect_Camera()
        {
        	try {
        		if (!_dll_init) {
        			return false;
        		}
	        	if (_dll_CamConnect) {
        			return true;
	        	}
	    		//Connect Camera
	    		CamResponse resp = (CamResponse)_dllMethod_Connect.Invoke(_dll_CamObj,new object[]{_dll_CameraInfoString});
				txt_dll_log.Text += "\r\nConnect: "+resp.ToString();
                if (resp != CamResponse.Pass) {
                    return false;
	    		}
                //get resolution
	    		txt_dll_log.Text+="\r\n Get Resolution...";
	    		_dll_Resolution = (Point)_dllMethod_GetResolution.Invoke(_dll_CamObj,null);
	    		if (_dll_Resolution.X == 0 || _dll_Resolution.Y == 0) {
	    			MessageBox.Show("Camera Resolution fail: " + _dll_Resolution.ToString()); return false;
	    		}
                txt_dll_log.Text += "\r\n"+ _dll_Resolution.ToString();
                _dll_CamConnect = true;
				return true;
				
        	} catch (Exception ex) {
	    		txt_dll_log.Text+="\r\n Error:\r\n"+ex.Message;
        		MessageBox.Show(ex.Message,"Error Connect_Camera()");
        	}
        	return false;
        }
        void Disconnect_Camera()
        {
        	try {
        		_dll_CamConnect = false;
        		if (_ThrStraming != null) {
					_streaming = false;
					_ThrStraming.Abort();
					int n = 1000;
					while (n > 0) {
						n--;
						if (!_StreamThreadRunning) { break; }
						if (!_ThrStraming.IsAlive) { break; }
						Thread.Sleep(10);
					}
					btn_GetProcByteStreaming.BackColor=Color.Gainsboro;
	            }
                if (!_dll_init) {
        			return;
        		}
	    		//Connect Camera
	    		CamResponse resp = (CamResponse)_dllMethod_Disconnect.Invoke(_dll_CamObj, new object[] { _dll_CameraInfoString } );
                txt_dll_log.Text += "\r\nDisconnect: " + resp.ToString();
        	} catch (Exception ex) {
	    		txt_dll_log.Text+="\r\n Error:\r\n"+ex.Message;
        	}
        }
        ushort[,] GetRawFrame()
        {
        	try {
        		ushort[] RawFrame = (ushort[])_dllMethod_GetRaw.Invoke(_dll_CamObj,null);
                if (RawFrame == null) { return null; }
	    		ushort[,] output = new ushort[_dll_Resolution.X,_dll_Resolution.Y];
				int x=0,y=0;
				for (int i=0;i<RawFrame.Length ;i++ ) {
					output[x,y] = RawFrame[i];
	                x++;
	                if (x==_dll_Resolution.X) {
	                	y++;
	                	x=0;
	                	if (y==_dll_Resolution.Y) {
	                		break;
	                	}
	                }
				}
        		return output;
        	} catch (Exception) { ; }
        	return null;
        }
        float[,] GetTempFrame() {
            try {
                float[] RawFrame = (float[])_dllMethod_GetTemperatures.Invoke(_dll_CamObj, null);
                if (RawFrame == null) { return null; }
                float[,] output = new float[_dll_Resolution.X, _dll_Resolution.Y];
                int x = 0, y = 0;
                for (int i = 0; i < RawFrame.Length; i++) {
                    output[x, y] = RawFrame[i];
                    x++;
                    if (x == _dll_Resolution.X) {
                        y++;
                        x = 0;
                        if (y == _dll_Resolution.Y) {
                            break;
                        }
                    }
                }
                return output;
            }
            catch (Exception) {; }
            return null;
        }
        #endregion


        #region Get_and_Process_ByteArray
        bool _GetRefFrame=false;
        
        void GetReferenceFrame()
        {
        	CalOffsetMap = new short[_dll_Resolution.X,_dll_Resolution.Y];
            long avr=0;int cnt=0;
            int stopX = _dll_Resolution.X-20;
            int stopY = _dll_Resolution.Y-20;
            for (int y = 20; y < stopY; y++) {
                for (int x = 20; x < stopX; x++) {
            		avr += _lastRawFrame[x,y]; cnt++;
                }
            }
            int center = (int)(avr/(long)cnt);
			for (int y = 0; y < _dll_Resolution.Y; y++) {
                for (int x = 0; x < _dll_Resolution.X; x++) {
        			int val = (_lastRawFrame[x,y]-center);
        			if (val < -32768) { val = -32768; } if (val>32767) { val=32767; }
        			CalOffsetMap[x,y]=(short)val;
                }
            }
            _GetRefFrame=false;
        }
        void GetFrameAndDisplayIt()
        {
        	if (rad_CamRawMode.Checked) {
	        	//get frame
	    		_lastRawFrame = GetRawFrame();
	    		if (_lastRawFrame==null) { return; }
				
				if (chk_useRefFrame.Checked) {
			    	if (_GetRefFrame) { GetReferenceFrame(); }
	    			
					if (CalOffsetMap!=null) {
	    				for (int y = 0; y < _dll_Resolution.Y; y++) {
			                for (int x = 0; x < _dll_Resolution.X; x++) {
			        			int val = (_lastRawFrame[x,y]-CalOffsetMap[x,y]);
			        			if (val<0) { val=0; } if (val>0xffff) { val=0xffff; }
			        			_lastRawFrame[x,y]=(ushort)val;
			                }
			            }
                    } //if (CalOffsetMap!=null)
                } //if (chk_useRefFrame.Checked)
            } //if (rad_CamRawMode.Checked)
            if (rad_CamTempMode.Checked) {
                //get frame
                _lastTempFrame = GetTempFrame();
                if (_lastTempFrame == null) { return; }
            }
            PicBoxMain.Image = Kernel_DrawImage();
            Application.DoEvents();
        }
        //Thread streaming
        Thread _ThrStraming;
        bool _streaming = false;
        bool _StreamThreadRunning = false;
        
        void Streaming()
        {
        	_StreamThreadRunning=true;
        	while (_streaming) {
        		this.Invoke(new Action(GetFrameAndDisplayIt));
        	}
        	_StreamThreadRunning=false;
        }
        
        #endregion
        
        #region Tab_Draw_Palette
        byte[] map_r = new byte[256];
        byte[] map_g = new byte[256];
      	byte[] map_b = new byte[256];
      	byte lastPalette = 0;
      	Bitmap Farbscala;
        void TrackBar_maxScroll(object sender, EventArgs e)
        {
        	if (trackBar_min.Value>trackBar_max.Value) {
        		trackBar_min.Value=trackBar_max.Value;
        	}
        	label_ScaleValues.Text="MaxValue: "+trackBar_max.Value.ToString()+
        		"\r\nMinValue: "+trackBar_min.Value.ToString();
//        	Kernel_DrawImage();
        }
        void TrackBar_minScroll(object sender, EventArgs e)
        {
        	if (trackBar_min.Value>trackBar_max.Value) {
        		trackBar_max.Value=trackBar_min.Value;
        	}
        	label_ScaleValues.Text="MaxValue: "+trackBar_max.Value.ToString()+
        		"\r\nMinValue: "+trackBar_min.Value.ToString();
//        	Kernel_DrawImage();
        }
        
        //color palette
        void Rad_Pal_All_CheckedChanged(object sender, EventArgs e)
        {
        	Kernel_DrawPalette();
        }
        void panel_PalColAllClick(object sender, EventArgs e)
        {
        	if (colorDialog1.ShowDialog()==DialogResult.OK) {
        		Panel P = sender as Panel;
        		P.BackColor=colorDialog1.Color;
        		rad_Pal_SelfDual.Checked=true;
        		draw_dual_palette(panel_PalCol1.BackColor,panel_PalCol2.BackColor);
        	}
        }
        
        void Kernel_DrawPalette()
        {
        	byte pal = 0;
        	if (rad_Pal_Grayscale.Checked) { pal=1; }
        	if (rad_Pal_Ironbow.Checked) { pal=2; }
        	if (rad_Pal_Rainbow.Checked) { pal=3; }
        	if (rad_Pal_SelfDual.Checked) { pal=4; }
        	if (lastPalette==pal) { return; }
        	lastPalette=pal;
        	switch (lastPalette) {
        		case 1: draw_dual_palette(Color.White,Color.Black); break;
        		case 2: draw_IronBow_palette(); break;
        		case 3: draw_rainbow_palette(); break;
        		case 4: draw_dual_palette(panel_PalCol1.BackColor,panel_PalCol2.BackColor); break;
        	}
//        	Kernel_DrawImage();
        }
        void draw_dual_palette(Color Hot_Col,Color Cold_Col)
		{
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			Farbscala = new Bitmap(30, 256);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(Farbscala);
			Rectangle rect = new Rectangle(0, 0, 30, 256);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Hot_Col, Cold_Col, LinearGradientMode.Vertical);
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			Bitmap img = (Bitmap)Farbscala;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(1,255-i);
				map_r[i] = col.R;
				map_g[i] = col.G;
				map_b[i] = col.B;
			}
			PicBoxPalette.Image=img;
		}
        void draw_IronBow_palette()
		{	//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			Farbscala = new Bitmap(30, 256);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(Farbscala);
			Rectangle rect = new Rectangle(0, 0, 30, 256);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Color.Red, Color.Blue, LinearGradientMode.Vertical);
			//start und endfarbe mit neuen überschreiben
			ColorBlend CB = new ColorBlend();
			CB.Colors = new Color[]
			{
				Color.White,Color.Yellow,Color.Orange,Color.Crimson,Color.DarkViolet,Color.MediumBlue,Color.Black
			};
			//punkte festlegen, an denen die farben sein sollen, was dazwischen liegt
			//wird zum farbverlauf
      		float[] CP = new float[7];
      		//anfags und endpunkte müssen festliegen, 
      		//deshalb sind die anfangs und endfarben auch zweimal vorhanden
      		CP[0] = 0.0f;
      		CP[1] = 0.2f;
      		CP[2] = 0.3f;
      		CP[3] = 0.5f;
      		CP[4] = 0.7f;
      		CP[5] = 0.9f;
      		CP[6] = 1.0f;
      			
      		//werte übergeben
      		CB.Positions = CP;
			GB.InterpolationColors = CB;
			
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			Bitmap img = (Bitmap)Farbscala;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(1,255-i);
				map_r[i] = col.R;
				map_g[i] = col.G;
				map_b[i] = col.B;
			}
			PicBoxPalette.Image=img;
		}
        void draw_rainbow_palette()
		{
			Farbscala = new Bitmap(30, 256);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(Farbscala);
			Rectangle rect = new Rectangle(0, 0, 30, 256);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Color.Red, Color.Blue, LinearGradientMode.Vertical);
			
			ColorBlend CB = new ColorBlend();
			CB.Colors = new Color[]
			{
				Color.White, Color.White,Color.Red,Color.Gold,Color.Yellow,
				Color.LimeGreen,Color.DodgerBlue,Color.DarkBlue,Color.Black,Color.Black
			};
      		float[] CP = new float[10];
      		CP[0] = 0.0f; CP[9] = 1.0f;
      		for (float i = 1; i < 9; i++ ) {	
      			CP[(int)i] = (float)( (i+-0.75)/7.5 );
      		}
      		CB.Positions = CP; GB.InterpolationColors = CB;
			
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			Bitmap img = (Bitmap)Farbscala;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(1,255-i);
				map_r[i] = col.R;
				map_g[i] = col.G;
				map_b[i] = col.B;
			}
			PicBoxPalette.Image=img;
		}






        #endregion

        private void btn_GetSerialNumber_Click(object sender, EventArgs e) {

            try {
                string devFW = (string)_dllMethod_GetCameraQuery.Invoke(_dll_CamObj, new object[] { "FW" });
                string devSer = (string)_dllMethod_GetCameraQuery.Invoke(_dll_CamObj, new object[] { "SER" });
                txt_FwSerial.Text += $"Device FW: {devFW}\r\nSerial: {devSer}";
            }
            catch (Exception err) {
                //Console.WriteLine("Error: " + err.Message);
                //MessageBox.Show(err.Message, "Error");
                txt_FwSerial.Text += "\r\n" + err.Message;
            }
        }
    }
}
