﻿#region Usings
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using System.IO;

using System.Drawing.Imaging;
using System.Drawing.Drawing2D;

using SeekThermal;
#endregion

namespace SeekThermal_Form
{
    public partial class MainForm : Form
    {
		#region <<<Vars>>>
//		readonly int Width=206, Height=156;
        SeekThermalClass thermal;
        Thread thermalThread;
        System.Diagnostics.Stopwatch STWatch = new System.Diagnostics.Stopwatch();
        int frameCount;
        bool stopThread;
        
        ThermalFrame lastFrame;
        bool LockCtrl = false;
        delegate void Dele_V_Bitmap(Bitmap bmp);
        delegate void Dele_V_U16Array(ushort[,] data);
        UInt16[,] LastPreProcessed_Uint16;
        UInt16[,] LastLoaded_Uint16;
        short[,] CalOffsetMap;
        bool[,] CalDefPixelMap=new bool[209,157];
        bool[,] CalDefPixelMapbase=new bool[209,157];
		#endregion
		
		#region Form
        public MainForm()
        {
            InitializeComponent();
            Kernel_DrawPalette(); //init palette
            Kernel_readCalData();
        }
        void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            stopThread = true;
            if (thermal != null) {
            	if (thermal.Streaming) {
	        		thermal.Streaming=false; Thread.Sleep(500);
	        	}
                if (thermalThread!=null) {
        			thermalThread.Join(500);
        		}
                thermal.Deinit();
            }
        }
        
        void Btn_connectSeekClick(object sender, EventArgs e)
	    {
	        if (btn_connectSeek.BackColor==Color.LimeGreen) {
	        	stopThread = true;
	            if (thermal != null) {
		        	if (thermal.Streaming) {
		        		thermal.Streaming=false; Thread.Sleep(500);
		        	}
	        		if (thermalThread!=null) {
	        			thermalThread.Join(500);
	        		}
	                thermal.Deinit();
	            }
    			btn_GetProcByteStreaming.Text="Start Streaming";
    			btn_GetProcByteStreaming.BackColor=Color.Gainsboro;
	        	btn_connectSeek.BackColor=Color.Gainsboro;
	        } else {
	        	btn_connectSeek.BackColor=Color.Gold; btn_connectSeek.Refresh();
//	            var device = SeekThermalClass.Enumerate().First();
//	            if(device == null) {
//	            	btn_connectSeek.BackColor=Color.Red; btn_connectSeek.Refresh();
//	                //MessageBox.Show("No Seek Thermal devices found.");
//	                return;
//	            }
	            
	            thermal = new SeekThermalClass();
	            thermal.SeekStreamEvent += new SeekThermalClass.EventDelegate(Event_SeekStreamRecived);
	            
	            btn_connectSeek.BackColor=Color.LimeGreen;
	            Btn_GetProcByteStreamingClick(null,null);
	        }
            
        }
        void Event_SeekStreamRecived()
		{
        	BeginInvoke(new Dele_V_U16Array(SeekStream_GetByteArray),new object[]{thermal.lastProcessedFrame} );
		}
        void Kernel_readCalData()
        {
        	if (!File.Exists("Cal_OffsetMap.dat")) { return; }
//        	if (lastFrame==null) {
//        		return;
//        	}
        	FileStream FS = new FileStream("Cal_OffsetMap.dat",FileMode.Open);
        	if (FS.Length==0) { return; }
        	byte[] inhalt = new byte[FS.Length];
        	FS.Read(inhalt,0,(int)FS.Length-1);
        	CalOffsetMap=new short[206,156];
			FS.Close();
			
			int x=0,y=0;
        	for (int i =0;i<inhalt.Length-1 ;i+=2 ) {
				short val = (short)((inhalt[i]<<8|inhalt[i+1])-32767);
				CalOffsetMap[x,y]=val;
//				y++;
//                if (y==Height) {
//                	x++;
//                	if (x==Width) {
//                		break;
//                	}
//                	y=0;
//                }
				x++;
                if (x==206) {
                	y++;
                	if (y==156) {
                		break;
                	}
                	x=0;
                }
        	}
			Kernel_Draw_OffsetMap();
			
			if (!File.Exists("Cal_DefpixelMap.dat")) { return; }
			StreamReader txt = new StreamReader("Cal_DefpixelMap.dat");
			string[] inhaltS = txt.ReadToEnd().Split('\n');
			txt.Close();
			y=0;
			foreach(string S in inhaltS) {
				x=0;
				foreach(char C in S) {
					switch (C) {
						case '_': CalDefPixelMap[x,y]=false; x++; break;
						case '#': CalDefPixelMap[x,y]=true; x++; break;
					}
				}
				y++;
			}
			
        	Kernel_Draw_DefPixMap();
			
//			CalGainmap_processed=new float[CalGainmap_Uint16.Length];
//			float max=CalGainmap_Uint16[0];
//			float min=CalGainmap_Uint16[1];
//			float HalfMax=(((CalGainmap_Uint16[0]-min)/max))/2;
//			for (int i =0;i<CalGainmap_Uint16.Length ;i++ ) {
//				float val = CalGainmap_Uint16[i];
//				CalGainmap_processed[i]=(((val-min)/max))-HalfMax+1f;
//			}
        }
        #endregion
        
        
		
        
        #region Get_and_Process_ByteArray
        UInt16[,] LastDataIn_Uint16;
        bool doGetRefFrame=false;
        //RANDOM N
        void Kernel_PreProcessImage()
        {
			if (LastPreProcessed_Uint16==null) { return; }
			
            // Display last sensor min/max values.
			if (thermal!=null) {
				label6.Text = "Cal Hi: " + thermal.FrameID1.MaxValue;
	            label7.Text = "Cal Lo: " + thermal.FrameID1.MinValue;
			}
//            if (chk_useMedian.Checked) {
//            	sub_PreProcessMedian();
////            	sub_PreProcessMedian();
////            	sub_PreProcessMedian();
//    		}
            if (chk_Average.Checked) {
            	if (LastDataIn_Uint16==null) {
            		LastDataIn_Uint16=LastPreProcessed_Uint16;
            	} else {
		            for (int y = 0; y < 156; y++) {
		                for (int x = 0; x < 206; x++) {
			        		long val = (long)LastDataIn_Uint16[x,y]*2L;
		            		val+=LastPreProcessed_Uint16[x,y];
		            		LastPreProcessed_Uint16[x,y]=(ushort)(val/3L);
		            		LastDataIn_Uint16[x,y]=LastPreProcessed_Uint16[x,y];
		                }
		            }
            	}
            }
            
			if (chk_qualiLog.Checked) {
				ushort minValue = 0xFFFF;
                ushort maxValue = 0x0000;
                for (int y = 20; y < 130; y++) {
                    for (int x = 20; x < 180; x++) {
                        ushort val = LastPreProcessed_Uint16[x,y];
                        if (val < minValue) minValue = val;
                        if (val > maxValue) maxValue = val;
                        //data[2+ y * 206 + x]=0;
                    }
                }
                if (MaxRaw<(maxValue-minValue)) { MaxRaw=maxValue-minValue; }
			}
            if (chk_useRefFrame.Checked&&!doGetRefFrame) {
            	for (int y = 0; y < 156; y++) {
	                for (int x = 0; x < 206; x++) {
	        			int val = (LastPreProcessed_Uint16[x,y]-CalOffsetMap[x,y]);
	        			if (val<0) { val=0; } if (val>0xffff) { val=0xffff; }
	        			LastPreProcessed_Uint16[x,y]=(ushort)val;
	                }
	            }
            }
            if (chk_useMedian.Checked) {//&&!doGetRefFrame
				int medians = (int)num_medians.Value;
				for (int x = 0; x < medians; x++) {
					//sub_PreProcessMedianFull();
					//sub_PreProcessMedian();
					LastPreProcessed_Uint16=thermal.DataProc_Median(LastPreProcessed_Uint16);
                }
    		}
            if (chk_useENH.Checked&&!doGetRefFrame) {
            	sub_PreProcessENH();
            }
            // Recompute the min max after the image is all fixed
            // unless the sliders have overriden values, then it doesn't matter.
            if (chk_AutoRange.Checked) {
                ushort val;
                ushort minValue = 0xFFFF;
                ushort maxValue = 0x0000;
                for (int y = 10; y < 146; y++) {
                    for (int x = 10; x < 196; x++) {
                        val = LastPreProcessed_Uint16[x,y];
                        if (val < minValue) minValue = val;
                        if (val > maxValue) maxValue = val;
                        //data[2+ y * 206 + x]=0;
                    }
                }
                if (MaxRef<(maxValue-minValue)) { MaxRef=maxValue-minValue; }
                trackBar_max.Value = maxValue;
                trackBar_min.Value = minValue;
            }
            
            
            if (doGetRefFrame) {
            	doGetRefFrame=false;
            	Kernel_DoCalibration();
            }
        }
        void sub_PreProcessENH()
        {
        	//Frame without edges
        	float multi = (float)num_T.Value;
        	ushort val;
            ushort minValue = 0xFFFF;
            ushort maxValue = 0x0000;
            for (int y = 20; y < 130; y++) {
                for (int x = 20; x < 180; x++) {
                    val = LastPreProcessed_Uint16[x,y];
                    if (val < minValue) minValue = val;
                    if (val > maxValue) maxValue = val;
                    //data[2+ y * 206 + x]=0;
                }
            }
            int startVal = ((maxValue-minValue)/2)+minValue;
        	for (int y = 1; y < 155; y++) {
                for (int x = 1; x < 205; x++) {
                    //1  2  3
                    //4  5  6
                    //7  8  9
                    int src = LastPreProcessed_Uint16[x,y];
					int val6 = src-LastPreProcessed_Uint16[x+1,y];
					int data =(int)((float)val6*multi);
					int val4 = src-LastPreProcessed_Uint16[x-1,y];
					data+=(int)((float)val4*multi);
					int val2 = src-LastPreProcessed_Uint16[x,y-1];
					data+=(int)((float)val2*multi);
					int val8 = src-LastPreProcessed_Uint16[x,y+1];
					data+=(int)((float)val8*multi);
					data=startVal+data;
					if (data > 65535) { data = 65535;} if (data < 0) { data = 0; }
					LastPreProcessed_Uint16[x,y]=(ushort)data;
                }
            }
        }
        void sub_PreProcessMedianFull()
        {
        	long val=0; int cnt=0;
        	ushort[,] Proc = new ushort[thermal.Width,thermal.Height];
        	//Frame without edges
        	for (int y = 1; y < 155; y++) {
                for (int x = 1; x < 205; x++) {
                    //1  2  3
                    //4  5  6
                    //7  8  9
                    val=0; cnt=0;
                    val += LastPreProcessed_Uint16[x-1,y-1]; cnt++;  //1
                    val += LastPreProcessed_Uint16[x,y-1]; cnt++;  //2
                    val += LastPreProcessed_Uint16[x+1,y-1]; cnt++;  //3
                    val += LastPreProcessed_Uint16[x-1,y]; cnt++;  //4
                    val += LastPreProcessed_Uint16[x,y]; cnt++;  //5
                    val += LastPreProcessed_Uint16[x+1,y]; cnt++;  //6
                    val += LastPreProcessed_Uint16[x-1,y+1]; cnt++;  //7
                    val += LastPreProcessed_Uint16[x,y+1]; cnt++;  //8
                    val += LastPreProcessed_Uint16[x+1,y+1]; cnt++;  //9
                    Proc[x,y] = (ushort)(val/(long)cnt);
                }
            }
        	//edge W --------------------------------------------
    		for (int y = 1; y < 155; y++) {
                val=0; cnt=0;
                val += LastPreProcessed_Uint16[0,y-1]; cnt++;  //2
                val += LastPreProcessed_Uint16[1,y-1]; cnt++;  //3
                val += LastPreProcessed_Uint16[1,y]; cnt++;  //6
                val += LastPreProcessed_Uint16[0,y+1]; cnt++;  //8
                val += LastPreProcessed_Uint16[1,y+1]; cnt++;  //9
				Proc[0,y] = (ushort)(val/(long)cnt);
            }
        	//edge E --------------------------------------------
    		for (int y = 1; y < 155; y++) {
                val=0; cnt=0;
                val += LastPreProcessed_Uint16[204,y-1]; cnt++;  //1
                val += LastPreProcessed_Uint16[205,y-1]; cnt++;  //2
                val += LastPreProcessed_Uint16[204,y]; cnt++;  //4
                val += LastPreProcessed_Uint16[204,y+1]; cnt++;  //7
                val += LastPreProcessed_Uint16[205,y+1]; cnt++;  //8
                Proc[205,y] = (ushort)(val/(long)cnt); 
            }
        	//edge N --------------------------------------------
    		for (int x = 1; x < 205; x++) {
                val=0; cnt=0;
                val += LastPreProcessed_Uint16[x-1,0]; cnt++;  //4
                val += LastPreProcessed_Uint16[x+1,0]; cnt++;  //6
                val += LastPreProcessed_Uint16[x-1,1]; cnt++;  //7
                val += LastPreProcessed_Uint16[x,1]; cnt++;  //8
                val += LastPreProcessed_Uint16[x+1,1]; cnt++;  //9
				Proc[x,0] = (ushort)(val/(long)cnt); 
            }
        	//edge S --------------------------------------------
    		for (int x = 1; x < 205; x++) {
                val=0; cnt=0;
                val += LastPreProcessed_Uint16[x-1,154]; cnt++;  //1
                val += LastPreProcessed_Uint16[x,154]; cnt++;  //2
                val += LastPreProcessed_Uint16[x+1,154]; cnt++;  //3
                val += LastPreProcessed_Uint16[x-1,155]; cnt++;  //4
                val += LastPreProcessed_Uint16[x+1,155]; cnt++;  //6
				Proc[x,155] = (ushort)(val/(long)cnt); 
            }
        	//übertragen
        	Proc[0,0]=LastPreProcessed_Uint16[0,0];
        	Proc[0,155]=LastPreProcessed_Uint16[0,155];
        	Proc[205,0]=LastPreProcessed_Uint16[205,0];
        	Proc[205,155]=LastPreProcessed_Uint16[205,155];
        	for (int y = 0; y < 156; y++) {
                for (int x = 0; x < 206; x++) {
                   LastPreProcessed_Uint16[x,y]=Proc[x,y];
                }
            }
        	
        }
        void sub_PreProcessMedian()
        {
        	long val=0; int cnt=0;
        	//Frame without edges
        	for (int y = 1; y < 155; y++) {
                for (int x = 1; x < 205; x++) {
        			if (CalDefPixelMap[x,y]) {
        				if (chk_cal_useDefPixMap.Checked) { continue; }
        			}
                    //1  2  3
                    //4  5  6
                    //7  8  9
                    val=0; cnt=0;
                    if (CalDefPixelMap[x-1,y-1]) { val += LastPreProcessed_Uint16[x-1,y-1]; cnt++; } //1
                    if (CalDefPixelMap[x,y-1]) { val += LastPreProcessed_Uint16[x,y-1]; cnt++; } //2
                    if (CalDefPixelMap[x+1,y-1]) { val += LastPreProcessed_Uint16[x+1,y-1]; cnt++; } //3
                    if (CalDefPixelMap[x-1,y]) { val += LastPreProcessed_Uint16[x-1,y]; cnt++; } //4
                    if (CalDefPixelMap[x+1,y]) { val += LastPreProcessed_Uint16[x+1,y]; cnt++; } //6
                    if (CalDefPixelMap[x-1,y+1]) { val += LastPreProcessed_Uint16[x-1,y+1]; cnt++; } //7
                    if (CalDefPixelMap[x,y+1]) { val += LastPreProcessed_Uint16[x,y+1]; cnt++; } //8
                    if (CalDefPixelMap[x+1,y+1]) { val += LastPreProcessed_Uint16[x+1,y+1]; cnt++; } //9
                    
                    if (cnt>0) { LastPreProcessed_Uint16[x,y] = (ushort)(val/(long)cnt); }
                }
            }
        	//edge W --------------------------------------------
    		for (int y = 1; y < 155; y++) {
    			if (CalDefPixelMap[0,y]) {
    				if (chk_cal_useDefPixMap.Checked) { continue; }
    			}
                val=0; cnt=0;
                if (CalDefPixelMap[0,y-1]) { val += LastPreProcessed_Uint16[0,y-1]; cnt++; } //2
                if (CalDefPixelMap[1,y-1]) { val += LastPreProcessed_Uint16[1,y-1]; cnt++; } //3
                if (CalDefPixelMap[1,y]) { val += LastPreProcessed_Uint16[1,y]; cnt++; } //6
                if (CalDefPixelMap[0,y+1]) { val += LastPreProcessed_Uint16[0,y+1]; cnt++; } //8
                if (CalDefPixelMap[1,y+1]) { val += LastPreProcessed_Uint16[1,y+1]; cnt++; } //9
				
                if (cnt>0) { LastPreProcessed_Uint16[0,y] = (ushort)(val/(long)cnt); }
            }
        	//edge E --------------------------------------------
    		for (int y = 1; y < 155; y++) {
    			if (CalDefPixelMap[205,y]) {
    				if (chk_cal_useDefPixMap.Checked) { continue; }
    			}
                val=0; cnt=0;
                if (CalDefPixelMap[204,y-1]) { val += LastPreProcessed_Uint16[204,y-1]; cnt++; } //1
                if (CalDefPixelMap[205,y-1]) { val += LastPreProcessed_Uint16[205,y-1]; cnt++; } //2
                if (CalDefPixelMap[204,y]) { val += LastPreProcessed_Uint16[204,y]; cnt++; } //4
                if (CalDefPixelMap[204,y+1]) { val += LastPreProcessed_Uint16[204,y+1]; cnt++; } //7
                if (CalDefPixelMap[205,y+1]) { val += LastPreProcessed_Uint16[205,y+1]; cnt++; } //8
                
                if (cnt>0) { LastPreProcessed_Uint16[205,y] = (ushort)(val/(long)cnt); }
            }
        	//edge N --------------------------------------------
    		for (int x = 1; x < 205; x++) {
    			if (CalDefPixelMap[x,0]) {
    				if (chk_cal_useDefPixMap.Checked) { continue; }
    			}
                val=0; cnt=0;
                if (CalDefPixelMap[x-1,0]) { val += LastPreProcessed_Uint16[x-1,0]; cnt++; } //4
                if (CalDefPixelMap[x+1,0]) { val += LastPreProcessed_Uint16[x+1,0]; cnt++; } //6
                if (CalDefPixelMap[x-1,1]) { val += LastPreProcessed_Uint16[x-1,1]; cnt++; } //7
                if (CalDefPixelMap[x,1]) { val += LastPreProcessed_Uint16[x,1]; cnt++; } //8
                if (CalDefPixelMap[x+1,1]) { val += LastPreProcessed_Uint16[x+1,1]; cnt++; } //9
				
                if (cnt>0) { LastPreProcessed_Uint16[x,0] = (ushort)(val/(long)cnt); }
            }
        	//edge S --------------------------------------------
    		for (int x = 1; x < 205; x++) {
    			if (CalDefPixelMap[x,155]) {
    				if (chk_cal_useDefPixMap.Checked) { continue; }
    			}
                val=0; cnt=0;
                if (CalDefPixelMap[x-1,154]) { val += LastPreProcessed_Uint16[x-1,154]; cnt++; } //1
                if (CalDefPixelMap[x,154]) { val += LastPreProcessed_Uint16[x,154]; cnt++; } //2
                if (CalDefPixelMap[x+1,154]) { val += LastPreProcessed_Uint16[x+1,154]; cnt++; } //3
                if (CalDefPixelMap[x-1,155]) { val += LastPreProcessed_Uint16[x-1,155]; cnt++; } //4
                if (CalDefPixelMap[x+1,155]) { val += LastPreProcessed_Uint16[x+1,155]; cnt++; } //6
				
                if (cnt>0) { LastPreProcessed_Uint16[x,155] = (ushort)(val/(long)cnt); }
            }
        }
        int framecount=0;
        int MaxRaw=0;
        int MaxRef=0;
        
        Bitmap Kernel_DrawImage()
        {
        	UInt16[,] Frame = LastPreProcessed_Uint16;
        	if (Frame==null) { return null; }
        	
        	bool Interpolate_x4 = chk_InterpolationX2.Checked;
        	PixelData Col = new PixelData();
        	UnsafeBitmap ubmp=null;
        	if (Interpolate_x4) {
        		ubmp = new UnsafeBitmap(206*4, 156*4);
        	} else {
        		ubmp = new UnsafeBitmap(206, 156);
        	}
        	ubmp.LockBitmap();
        	ushort max,min;
        	
        	if (chk_AutoRange.Checked) {
                ushort val;
                min = 0xFFFF;
                max = 0x0000;
	            for (int y = 20; y < 140; y++) {
                    for (int x = 20; x < 180; x++) {
                        val = Frame[x,y];
                        if (val < min) min = val;
                        if (val > max) max = val;
                    }
                }
        	} else {
        		max=(ushort)trackBar_max.Value;
        		min=(ushort)trackBar_min.Value;
        	}
        	
        	// Display displayed data min/max value.
        	
        	if (thermal.LastFrameStatusByte==3) {
        		framecount++;
	        	decimal TC_off=num_temp_offset.Value;
	            decimal TC_mul=num_temp_multi.Value;
	            label9.Text = "Max: " + max;
	            label10.Text = "Min: " + min;
	            label13.Text = "Range: " + (max-min);
	            decimal Temperatur = ((decimal)max-TC_off)/TC_mul;
	            if (Temperatur<-999) { Temperatur=-999; } if (Temperatur>999) { Temperatur=999; }
	            num_max.Value=Temperatur;
	            Temperatur = ((decimal)min-TC_off)/TC_mul;
	            if (Temperatur<-999) { Temperatur=-999; } if (Temperatur>999) { Temperatur=999; }
	            num_min.Value=Temperatur;
        	} else { 
        		if (thermal.LastFrameStatusByte==6&&chk_qualiLog.Checked) {
        			string time = STWatch.Elapsed.ToString().Split('.')[0];
        			txt_frameDataLog.Text+=time+"\t"+MaxRaw+"\t"+MaxRef+"\t"+framecount+"\r\n";
        		}
        		framecount=0; MaxRaw=0; MaxRef=0;
        	}
            
            
        	// Scale data to be within [0-255] for LUT mapping.
        	ushort maxmin = (ushort)(max-min);
            if (maxmin<10) { maxmin=10; }// Avoid divide by 0
            for (int y = 0; y < 156; y++) {
                for (int x = 0; x < 206; x++) {
                    int v = Frame[x,y];
                    
                    v = (v - min) * 256 / maxmin;
                    if (v < 0) { v = 0; }
                    if (v > 255) {  v = 255; }
                    
                    if (lastPalette>1) {
                    	Col.red=map_r[v];
                    	Col.green=map_g[v];
	                    Col.blue=map_b[v];
                    } else { // Greyscale output (would always be limited to 256 colors)
	                    Col.red=(byte)v;
	                    Col.green=(byte)v;
	                    Col.blue=(byte)v;
                    }
                    
                    if (Interpolate_x4) {
						for (int x2=0; x2<4; x2++ ) {
							for (int y2=0; y2<4; y2++ ) {
								ubmp.SetPixel(x*4+x2,y*4+y2,Col);
							}
						}
                    } else {
	                    ubmp.SetPixel(x, y, Col);
                    }
                }
            }
        	
        	ubmp.UnlockBitmap();
        	return ubmp.Bitmap;
			//PicBoxMain.Image=ubmp.Bitmap;
        }
        
        void Btn_GetFrame_AsByteArrayClick(object sender, EventArgs e)
        {
        	stopThread=false;
        	//UInt16[,] data = GetCameraFrame();
        	LastPreProcessed_Uint16=thermal.Grab_VisualFrame().Data;
        	Kernel_PreProcessImage();
        	PicBoxMain.Image=Kernel_DrawImage();
        }
        //Thread streaming
        void Btn_GetProcByteStreamingClick(object sender, EventArgs e)
        {
        	if (btn_connectSeek.BackColor!=Color.LimeGreen) { return; }
        	if (thermal.Streaming) {
        		thermal.Streaming=false;
        		STWatch.Stop();STWatch.Reset();
        		btn_GetProcByteStreaming.Text="Start Streaming";
        		btn_GetProcByteStreaming.BackColor=Color.Gainsboro;
        	} else {
        		thermal.Start_ProcByte_Stream();
        		STWatch.Start();
        		Thread.Sleep(100);
        		if (thermal.Streaming) {
        			btn_GetProcByteStreaming.Text="Stop Streaming";
        			btn_GetProcByteStreaming.BackColor=Color.LimeGreen;
        		} else {
        			btn_GetProcByteStreaming.Text="Start Streaming";
        			btn_GetProcByteStreaming.BackColor=Color.Red;
        		}
        	}
        }
        void SeekStream_GetByteArray(ushort[,] data)
        {
        	if (data==null) { return; }
        	LastPreProcessed_Uint16=data;
        	switch (thermal.LastFrameStatusByte) {
				case 1: PicBox_ID1.Image=Kernel_DrawImage();
					CalDefPixelMap=thermal.DeathPixMap;
					CalDefPixelMapbase=thermal.DeathPixMapBase;
    				Kernel_Draw_DefPixMap();
					return;
				case 6: PicBox_ID6.Image=Kernel_DrawImage(); return;
			}
        	if (thermal.LastFrameStatusByte!=(byte)num_frameID.Value) { return; }
        	if (btn_GetProcByteStreaming.BackColor==Color.LimeGreen) {
				Kernel_PreProcessImage();
    			PicBoxMain.Image=Kernel_DrawImage();
        	}
        }
        #endregion
        
        #region Tab_Draw_Palette
        byte[] map_r = new byte[256];
        byte[] map_g = new byte[256];
      	byte[] map_b = new byte[256];
      	byte lastPalette = 0;
      	Bitmap Farbscala;
        void TrackBar_maxScroll(object sender, EventArgs e)
        {
        	if (LockCtrl) { return; }
        	if (trackBar_min.Value>trackBar_max.Value) {
        		trackBar_min.Value=trackBar_max.Value;
        	}
        	label_ScaleValues.Text="MaxValue: "+trackBar_max.Value.ToString()+
        		"\r\nMinValue: "+trackBar_min.Value.ToString();
        	Kernel_DrawImage();
        }
        void TrackBar_minScroll(object sender, EventArgs e)
        {
        	if (LockCtrl) { return; }
        	if (trackBar_min.Value>trackBar_max.Value) {
        		trackBar_max.Value=trackBar_min.Value;
        	}
        	label_ScaleValues.Text="MaxValue: "+trackBar_max.Value.ToString()+
        		"\r\nMinValue: "+trackBar_min.Value.ToString();
        	Kernel_DrawImage();
        }
        
        //color palette
        void Rad_Pal_All_CheckedChanged(object sender, EventArgs e)
        {
        	Kernel_DrawPalette();
        }
        void panel_PalColAllClick(object sender, EventArgs e)
        {
        	if (colorDialog1.ShowDialog()==DialogResult.OK) {
        		Panel P = sender as Panel;
        		P.BackColor=colorDialog1.Color;
        		rad_Pal_SelfDual.Checked=true;
        		draw_dual_palette(panel_PalCol1.BackColor,panel_PalCol2.BackColor);
        	}
        }
        
        void Kernel_DrawPalette()
        {
        	byte pal = 0;
        	if (rad_Pal_Grayscale.Checked) { pal=1; }
        	if (rad_Pal_Ironbow.Checked) { pal=2; }
        	if (rad_Pal_Rainbow.Checked) { pal=3; }
        	if (rad_Pal_SelfDual.Checked) { pal=4; }
        	if (lastPalette==pal) { return; }
        	lastPalette=pal;
        	switch (lastPalette) {
        		case 1: draw_dual_palette(Color.White,Color.Black); break;
        		case 2: draw_IronBow_palette(); break;
        		case 3: draw_rainbow_palette(); break;
        		case 4: draw_dual_palette(panel_PalCol1.BackColor,panel_PalCol2.BackColor); break;
        	}
        	Kernel_DrawImage();
        }
        void draw_dual_palette(Color Hot_Col,Color Cold_Col)
		{
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			Farbscala = new Bitmap(30, 256);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(Farbscala);
			Rectangle rect = new Rectangle(0, 0, 30, 256);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Hot_Col, Cold_Col, LinearGradientMode.Vertical);
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			Bitmap img = (Bitmap)Farbscala;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(1,255-i);
				map_r[i] = col.R;
				map_g[i] = col.G;
				map_b[i] = col.B;
			}
			PicBoxPalette.Image=img;
		}
        void draw_IronBow_palette()
		{	//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			Farbscala = new Bitmap(30, 256);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(Farbscala);
			Rectangle rect = new Rectangle(0, 0, 30, 256);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Color.Red, Color.Blue, LinearGradientMode.Vertical);
			//start und endfarbe mit neuen überschreiben
			ColorBlend CB = new ColorBlend();
			CB.Colors = new Color[]
			{
				Color.White,Color.Yellow,Color.Orange,Color.Crimson,Color.DarkViolet,Color.MediumBlue,Color.Black
			};
			//punkte festlegen, an denen die farben sein sollen, was dazwischen liegt
			//wird zum farbverlauf
      		float[] CP = new float[7];
      		//anfags und endpunkte müssen festliegen, 
      		//deshalb sind die anfangs und endfarben auch zweimal vorhanden
      		CP[0] = 0.0f;
      		CP[1] = 0.2f;
      		CP[2] = 0.3f;
      		CP[3] = 0.5f;
      		CP[4] = 0.7f;
      		CP[5] = 0.9f;
      		CP[6] = 1.0f;
      			
      		//werte übergeben
      		CB.Positions = CP;
			GB.InterpolationColors = CB;
			
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			Bitmap img = (Bitmap)Farbscala;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(1,255-i);
				map_r[i] = col.R;
				map_g[i] = col.G;
				map_b[i] = col.B;
			}
			PicBoxPalette.Image=img;
		}
        void draw_rainbow_palette()
		{
			Farbscala = new Bitmap(30, 256);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(Farbscala);
			Rectangle rect = new Rectangle(0, 0, 30, 256);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Color.Red, Color.Blue, LinearGradientMode.Vertical);
			
			ColorBlend CB = new ColorBlend();
			CB.Colors = new Color[]
			{
				Color.White, Color.White,Color.Red,Color.Gold,Color.Yellow,
				Color.LimeGreen,Color.DodgerBlue,Color.DarkBlue,Color.Black,Color.Black
			};
      		float[] CP = new float[10];
      		CP[0] = 0.0f; CP[9] = 1.0f;
      		for (float i = 1; i < 9; i++ ) {	
      			CP[(int)i] = (float)( (i+-0.75)/7.5 );
      		}
      		CB.Positions = CP; GB.InterpolationColors = CB;
			
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			Bitmap img = (Bitmap)Farbscala;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(1,255-i);
				map_r[i] = col.R;
				map_g[i] = col.G;
				map_b[i] = col.B;
			}
			PicBoxPalette.Image=img;
		}
		#endregion
        #region Tab_RawFrame
        void num_SetupFrameAllChanged(object sender, EventArgs e)
        {
//        	thermal.GetFrame_SetupData[0]=(byte)num_SetupFrame1.Value;
//        	thermal.GetFrame_SetupData[1]=(byte)num_SetupFrame2.Value;
//        	thermal.GetFrame_SetupData[2]=(byte)num_SetupFrame3.Value;
//        	thermal.GetFrame_SetupData[3]=(byte)num_SetupFrame4.Value;
        }
        
        void Btn_GrabRAWFrameClick(object sender, EventArgs e)
        {
        	if (btn_connectSeek.BackColor!=Color.LimeGreen) { return; }
        	btn_GrabRAWFrame.BackColor=Color.Gold; btn_GrabRAWFrame.Refresh();
        	thermal.Write(55);
        	btn_GrabRAWFrame.BackColor=Color.Gainsboro;
        }
        void Timer_rawframeTick(object sender, EventArgs e)
        {
        	Btn_GrabRAWFrameClick(null,null);
        }
        void Chk_auto_GetRawFrameCheckedChanged(object sender, EventArgs e)
        {
        	timer_rawframe.Enabled=chk_auto_GetRawFrame.Checked;
        }
        #endregion
        
        #region _____Old_and_Test_Area
        void Num_ref_offsetValueChanged(object sender, EventArgs e)
        {
        	Kernel_DrawImage();
        }
        
        void Trylater()
        {
        	Bitmap bm = new Bitmap(20,20);
        	
        	BitmapData srcData = bm.LockBits(
            new Rectangle(0, 0, bm.Width, bm.Height), 
            ImageLockMode.ReadOnly, 
            PixelFormat.Format32bppArgb);

			int stride = srcData.Stride;
			
			IntPtr Scan0 = srcData.Scan0;
			
			long[] totals = new long[] {0,0,0};
			
			int width = bm.Width;
			int height = bm.Height;
			
			unsafe
			{
			  byte* p = (byte*) (void*) Scan0;
			
			  for (int y = 0; y < height; y++)
			  {
			    for (int x = 0; x < width; x++)
			    {
			      for (int color = 0; color < 3; color++)
			      {
			        int idx = (y*stride) + x*4 + color;
			
			        totals[color] += p[idx];
			      }
			    }
			  }
			}
			
			int avgB = (int)totals[0] / (width*height);
			int avgG = (int)totals[1] / (width*height);
			int avgR = (int)totals[2] / (width*height);
        }
        void old_Kernel_DrawImage()
        {
        	if (LastPreProcessed_Uint16==null) { return; }
        	bool Interpolate_x2 = chk_InterpolationX2.Checked;
        	PixelData Col = new PixelData();
        	UnsafeBitmap ubmp=null;
        	if (Interpolate_x2) {
        		ubmp = new UnsafeBitmap(206*2, 156*2);
        	} else {
        		ubmp = new UnsafeBitmap(206, 156);
        	}
        	ubmp.LockBitmap();
        	ushort max,min;
        	
        	if (chk_AutoRange.Checked) {
                ushort val;
                min = 0xFFFF;
                max = 0x0000;
	            for (int y = 20; y < 140; y++) {
                    for (int x = 20; x < 180; x++) {
//                		if (chk_useRefFrame.Checked) {
//                			val = (ushort)(LastPreProcessed_Uint16[2+ y * 208 + x]-CalOffsetMap[2+ y * 208 + x]);
//                			LastPreProcessed_Uint16[2+ y * 208 + x]=val;
//                		} else {
//                			
//                		}
                        val = LastPreProcessed_Uint16[x,y];
                        if (val < min) min = val;
                        if (val > max) max = val;
//                        if (chk_useRefFrame.Checked) {
//                        	val = CalRefframe_Uint16[2+ y * 208 + x];
//                        	if (val < Vmin) Vmin = val;
//                        	if (val > Vmax) Vmax = val;
//                        	//val=(ushort)(LastPreProcessed_Uint16[2+ y * 208 + x]-CalRefframe_Uint16[2+ y * 208 + x]+LastPreProcessed_Uint16[1]+CalRefframe_Uint16[1]);
//	                    }
                        
                    }
                }
        	} else {
//        		ushort val;
        		max=(ushort)trackBar_max.Value;
        		min=(ushort)trackBar_min.Value;
        		
//        		for (int y = 0; y < 156; y++) {
//                    for (int x = 0; x < 206; x++) {
//                		if (chk_useRefFrame.Checked) {
//                			val = (ushort)(LastPreProcessed_Uint16[2+ y * 208 + x]-CalOffsetMap[2+ y * 208 + x]);
//                			LastPreProcessed_Uint16[2+ y * 208 + x]=val;
//                		} else {
//                			val = LastPreProcessed_Uint16[2+ y * 208 + x];
//                		}
//                    }
//                }
        	}
//        	int offset = (int)Num_ref_offset.Value;
        	int center = ((max-min)/2)+min;
//        	if (chk_useRefFrame.Checked) { //be shure, the reference is only active if valid
//        		if (LastFullProcessed_Uint16==null) {
//        			LastFullProcessed_Uint16=new ushort[LastPreProcessed_Uint16.Length];
//        		}
//        		if (CalRefframe_Uint16==null) {
//        			chk_useRefFrame.Checked=false;
//        		}
//        	}
            for (int y = 0; y < 156; y++) {
                for (int x = 0; x < 206; x++) {
                    int v = LastPreProcessed_Uint16[x,y];
					
                    // Scale data to be within [0-255] for LUT mapping.
                    ushort maxmin = max;
                    if (maxmin>min) {
                    	maxmin -= min;
                    } else {
                    	maxmin=0;
                    }
                    
//                    if (chk_useRefFrame.Checked) {
////                    	v=LastPreProcessed_Uint16[2+ y * 208 + x]-CalRefframe_Uint16[2+ y * 208 + x]+min+((max-min)/2)+offset;
//						v = LastPreProcessed_Uint16[2+ y * 208 + x]+CalOffsetMap[2+ y * 208 + x];
//						LastFullProcessed_Uint16[2+ y * 208 + x]=(ushort)v;
//                    }
                    
                    
                    if (maxmin == 0) { maxmin = 1; }// Avoid divide by 0
                    v = (v - min) * 256 / maxmin;
//                    if (chk_cal_useGainmap.Checked) {
//                    	v=(v+CalGainmap_Uint16[2+ y * 208 + x])/2;
//                    	v=(int)(((double)(v)/(double)CalGainmap_processed[2+ y * 208 + x]));
//                    }
                    if (v < 0) { v = 0; }
                    if (v > 255) {  v = 255; }
                    
//                    if (CalcOffset) {
//                    	if (v < Vmin) Vmin = v;
//                        if (v > Vmax) Vmax = v;
//                    }

                    if (lastPalette>1) {
                    	Col.red=map_r[v];
                    	Col.green=map_g[v];
	                    Col.blue=map_b[v];
                    } else { // Greyscale output (would always be limited to 256 colors)
	                    Col.red=(byte)v;
	                    Col.green=(byte)v;
	                    Col.blue=(byte)v;
                    }
                    
                    if (Interpolate_x2) {
                    	ubmp.SetPixel(x * 2, y * 2, Col);
	                    ubmp.SetPixel(x * 2 + 1, y * 2, Col);
	                    ubmp.SetPixel(x * 2, y * 2 + 1, Col);
	                    ubmp.SetPixel(x * 2 + 1, y * 2 + 1, Col);
                    } else {
	                    ubmp.SetPixel(x, y, Col);
                    }
                }
            }
//        	if (chk_useRefFrame.Checked) {
//        		LastFullProcessed_Uint16[0]=max;
//        		LastFullProcessed_Uint16[1]=min;
//        	}
        	
//        	if (CalcOffset) {
//	        	CalcOffset=false;
//	        	numericUpDown1.Value=255-Vmax;
//        	}
        	
        	ubmp.UnlockBitmap();
			PicBoxMain.Image=ubmp.Bitmap;
        }
        void StartStream() 
        {
        	thermalThread = new Thread(ThermalThreadProc);
		    thermalThread.IsBackground = true;
		    thermalThread.Start();
        }
        void ThermalThreadProc()
        {
            DateTime currentFrameTime = DateTime.Now;
            DateTime previousFrameTime = currentFrameTime;
            DateTime currentTime = DateTime.Now;
            DateTime previousTime = currentTime;
//            int framesToCapture = 20;

            // Initialize frame (1 based)
            frameCount = 1;

            // Create the output files to save first 20 frames and associated metadata.
//            bw = new BinaryWriter(new FileStream("data.dat", FileMode.Create));
//            tw = new BinaryWriter(new FileStream("data.txt", FileMode.Create));

            while (!stopThread && thermal != null) {
                bool progress = false;

                // Store the previous frame time and compute the new one.
                previousFrameTime = currentFrameTime;
                currentFrameTime = DateTime.Now;

                // Get frame
                lastFrame = thermal.GetFrame_asClass();

                // Keep the first 6 frames, or anytime those frame IDs are encountered.
                // They might be usefull for image processing.
                switch (lastFrame.RawDataU16[10])
                {
                    case 4:
                        thermal.FrameID4 = lastFrame;
                        //frameID4.Inverse();
                        break;
//                    case 9:
//                        frameID9 = lastFrame;
//                        break;
//                    case 8:
//                        frameID8 = lastFrame;
//                        break;
//                    case 7:
//                        frameID7 = lastFrame;
//                        break;
//                    case 10:
//                        frameID10 = lastFrame;
//                        break;
//                    case 5:
//                        frameID5 = lastFrame;
//                        break;
                    default:
                        // Ignore the rest from safe keeping, since they are dealt with later.
                        //
                        // ID 1 is a calibration frame
                        // ID 6 is a pre-calibration frame
                        // ID 3 is a visual frame.
                        break;
                }

                // Time after frame capture
                previousTime = currentTime;
                currentTime = DateTime.Now;

                if(lastFrame.StatusByte==1) {
                    thermal.FrameID1 = lastFrame;
                } else {
                    if(thermal.FrameID1 != null && lastFrame.StatusByte==3) {
//						lastUsableFrame = lastFrame.ProcessFrameU16(thermal.FrameID1, thermal.FrameID4);
                        progress = true;
                    }
                }

                // Toggle between automatic to manual range.
//                if (rangeOverrideToggle) {
//                    useAutomaticRange = !useAutomaticRange;
//                    rangeOverrideToggle = false;
//                }

                // Increase frame count.
                frameCount++;

                if(progress) {
                    Invalidate();
                }
            }
        }
        
        #endregion
        
        #region Calibration
        
        
        void Btn_SaveLastByteArrayToDatClick(object sender, EventArgs e)
        {
        	if (LastPreProcessed_Uint16==null) { return; }
        	saveFileDialog1.FileName="LastPreProcessed_Uint16.dat";
        	if (saveFileDialog1.ShowDialog()!=DialogResult.OK) { return; }
        	
        	FileStream FS = new FileStream(saveFileDialog1.FileName,FileMode.Create);
        	for (int y = 0; y < 156; y++) {
                for (int x = 0; x < 206; x++) {
		            int val = LastPreProcessed_Uint16[x,y];
	        		byte B1 = (byte)(val>>8&0xff);
	        		byte B2 = (byte)(val&0xff);
	        		FS.WriteByte(B1); FS.WriteByte(B2);
                }
            }
        	FS.Close();
        	
        	MessageBox.Show("File Saved:\r\n"+saveFileDialog1.FileName);
        }
        void Btn_LoadLastByteArrayFromDatClick(object sender, EventArgs e)
        {
        	if (openFileDialog1.ShowDialog()!=DialogResult.OK) { return; }
        	if (!File.Exists(openFileDialog1.FileName)) { return; }
        	FileStream FS = new FileStream(openFileDialog1.FileName,FileMode.Open);
        	byte[] inhalt = new byte[FS.Length];
        	FS.Read(inhalt,0,(int)FS.Length-1);
        	
        	LastPreProcessed_Uint16=new ushort[206,156];
        	LastLoaded_Uint16=new ushort[206,156];
			FS.Close();
			
			int x=0,y=0;
        	for (int i =0;i<inhalt.Length-1 ;i+=2 ) {
				ushort val = (ushort)(inhalt[i]<<8|inhalt[i+1]);
				LastPreProcessed_Uint16[x,y]=val;
				LastLoaded_Uint16[x,y]=val;
				x++;
                if (x==206) {
                	y++;
                	if (y==156) {
                		break;
                	}
                	x=0;
                }
        	}
			Kernel_DrawImage();
			
        	//MessageBox.Show("File loadet:\r\n"+openFileDialog1.FileName);
        }
        void Btn_SaveLastByteArrayToTxtClick(object sender, EventArgs e)
        {
        	if (LastPreProcessed_Uint16==null) { return; }
        	saveFileDialog1.FileName="LastPreProcessed_Uint16.txt";
        	if (saveFileDialog1.ShowDialog()!=DialogResult.OK) { return; }
        	
        	StreamWriter txt = new StreamWriter(saveFileDialog1.FileName);
        	for (int y = 0; y < 156; y++) {
                for (int x = 0; x < 206; x++) {
    				txt.Write(LastPreProcessed_Uint16[x,y].ToString()+"#");
                }
            }
        	txt.Close();
        	
        	MessageBox.Show("File Saved:\r\n"+saveFileDialog1.FileName);
        }  
        
        void Kernel_Draw_OffsetMap()
        {
        	UnsafeBitmap ubmp = new UnsafeBitmap(206, 156);
        	PixelData Col = new PixelData();
        	ubmp.LockBitmap();
            for (int y = 0; y < 156; y++) {
                for (int x = 0; x < 206; x++) {
                    int v = CalOffsetMap[x,y]+128; 
                    
                    if (v < 0) { v = 0; }
                    if (v > 255) {  v = 255; }
					
                    Col.red=(byte)v;
	                Col.green=(byte)v;
	                Col.blue=(byte)v;
                    
	                ubmp.SetPixel(x, y, Col);
                }
            }
        	ubmp.UnlockBitmap();
			PicBox_ID1.Image=ubmp.Bitmap;
        }
        void Kernel_Draw_DefPixMap()
        {
        	UnsafeBitmap ubmp = new UnsafeBitmap(206, 156);
        	PixelData Col = new PixelData();
        	ubmp.LockBitmap();
            for (int y = 0; y < 156; y++) {
                for (int x = 0; x < 206; x++) {
        			if (!CalDefPixelMap[x,y]) {
	        			Col.red=0;
		                Col.green=0;
		                Col.blue=0;
        			} else {
        				Col.red=255;
		                Col.green=255;
		                Col.blue=255;
        			}
					
	                ubmp.SetPixel(x, y, Col);
                }
            }
        	ubmp.UnlockBitmap();
			PicBox_DpixMap.Image=ubmp.Bitmap;
			ubmp = new UnsafeBitmap(206, 156);
        	ubmp.LockBitmap();
            for (int y = 0; y < 156; y++) {
                for (int x = 0; x < 206; x++) {
        			if (!CalDefPixelMapbase[x,y]) {
	        			Col.red=0;
		                Col.green=0;
		                Col.blue=0;
        			} else {
        				Col.red=255;
		                Col.green=255;
		                Col.blue=255;
        			}
					
	                ubmp.SetPixel(x, y, Col);
                }
            }
        	ubmp.UnlockBitmap();
			PicBox_DpixMapBase.Image=ubmp.Bitmap;
        }
        
        void Btn_CalibrateClick(object sender, EventArgs e)
        {
        	if (LastPreProcessed_Uint16==null) { return; }
        	doGetRefFrame=true;
        }
        void Kernel_DoCalibration()
        {
        	FileStream FS = new FileStream("Cal_OffsetMap.dat",FileMode.Create);
        	CalDefPixelMap=new bool[207,157];
        	long Gesamt = 0L; int GesCount = 0;int Tresh = 250;
        	short minValue = 32766;
            short maxValue = -32766;
            for (int y = 0; y < 156; y++) {
                for (int x = 1; x < 206; x++) {
	                int diff = LastPreProcessed_Uint16[x,y]-LastPreProcessed_Uint16[x-1,y];
	        		if (diff<Tresh||0-diff>Tresh) {
	        			Gesamt+=LastPreProcessed_Uint16[x-1,y]; GesCount++;
	                } else { CalDefPixelMap[x,y]=true; }
                }
            }
            
        	int Durchschnitt = (int)(Gesamt/(long)GesCount);
        	
        	CalOffsetMap = new short[209,157];
        	for (int y = 0; y < 156; y++) {
                for (int x = 0; x < 206; x++) {
		            int val = LastPreProcessed_Uint16[x,y]-Durchschnitt;
	        		CalOffsetMap[x,y]=(short)val;
	        		if (val < minValue) { minValue = (short)val; } 
	        		if (val > maxValue) { maxValue = (short)val; } 
	        		val+=32767; //offset zum speichern
	        		byte B1 = (byte)(val>>8&0xff);
	        		byte B2 = (byte)(val&0xff);
	        		FS.WriteByte(B1); FS.WriteByte(B2);
                }
            }
        	FS.Close();
        	//Save Def Pixel Map
        	StreamWriter txt = new StreamWriter("Cal_DefpixelMap.dat",false);
        	for (int y = 0; y < 156; y++) {
                for (int x = 0; x < 206; x++) {
	        		if (CalDefPixelMap[x,y]) {
        				txt.Write("#");
	                } else { txt.Write("_"); }
                }
        		txt.WriteLine();
            }
        	txt.Close();
        	
        	Kernel_Draw_OffsetMap();
        	Kernel_Draw_DefPixMap();
        }
        
        #endregion
        
        void Num_para_0KeyDown(object sender, KeyEventArgs e)
        {
        	if (e.KeyData==Keys.Enter) {
        		thermal.Parameter[0] = (ushort)num_para_0.Value;
        		thermal.Parameter[1] = (ushort)num_para_1.Value;
        		thermal.Parameter[2] = (ushort)num_para_2.Value;
        		thermal.Parameter[3] = (ushort)num_para_3.Value;
        	}
        }
        
        void Chk_AllProcessing_CheckedChanged(object sender, EventArgs e)
        {
        	if (btn_GetProcByteStreaming.BackColor==Color.LimeGreen) { return; }
        	if (LastLoaded_Uint16==null) { return; }
        	for (int y = 0; y < 156; y++) {
                for (int x = 0; x < 206; x++) {
        			LastPreProcessed_Uint16[x,y]=LastLoaded_Uint16[x,y];
                }
            }
        	Kernel_PreProcessImage();
        	Kernel_DrawImage();
        }
        void num_AllProcessing_ValChanged(object sender, EventArgs e)
        {
        	if (btn_GetProcByteStreaming.BackColor==Color.LimeGreen) { return; }
        	if (LastPreProcessed_Uint16==null) { return; }
        	for (int y = 0; y < 156; y++) {
                for (int x = 0; x < 206; x++) {
        			LastPreProcessed_Uint16[x,y]=LastLoaded_Uint16[x,y];
                }
            }
        	Kernel_PreProcessImage();
        	Kernel_DrawImage();
        }
        
        
        void Timer_statusbyteTick(object sender, EventArgs e)
        {
        	if (thermal==null) { return; }
        	label_dev_statusbyte.Text=thermal.LastFrameStatusByte.ToString();
        	switch (label_dev_statusbyte.Text) {
        		case "3": label_dev_statusbyte.BackColor=Color.LimeGreen; break;
        		case "6": label_dev_statusbyte.BackColor=Color.Gold; break;
        		case "1": label_dev_statusbyte.BackColor=Color.Blue; break;
        		default: label_dev_statusbyte.BackColor=Color.White; break;
        	}
        	label_dev_statusbyte.Refresh();
        }
        
        void Chk_dev_showTFstatusBCheckedChanged(object sender, EventArgs e)
        {
        	timer_statusbyte.Enabled=chk_dev_showTFstatusB.Checked;
        }
        
        void Num_para_2ValueChanged(object sender, EventArgs e)
        {
        	thermal.Parameter[2] = (ushort)num_para_2.Value;
        		
        }
        
        void Num_para_3ValueChanged(object sender, EventArgs e)
        {
        	thermal.Parameter[3] = (ushort)num_para_3.Value;
        }
    }
}
