﻿/*
 * Erstellt mit SharpDevelop.
 * Benutzer: Talentfrei
 * Datum: 05.07.2010
 * Zeit: 8:42
 * 
 * Sie können diese Vorlage unter Extras > Optionen > Codeerstellung > Standardheader ändern.
 * ... und dennoch lass ich es lieber...
 */
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;

using AForge;
using AForge.Imaging;
using AForge.Imaging.Filters;
using AForge.Controls;

namespace Pseudocolor
{
	public partial class MainForm : Form
	{
		//erstellen der Variablen
		byte[] map_r = new byte[256];
      	byte[] map_g = new byte[256];
      	byte[] map_b = new byte[256];
      	string main_image = "image.jpg";
      	//###############################################
      	//Formcode (Steuerelemente usw.) ################
		//###############################################
      	public MainForm()
		{
			InitializeComponent();
		}
		void MainFormSizeChanged(object sender, EventArgs e)
		{	//Bild der Fenstergröße anpassen
			pictureBox1.Width = MainForm.ActiveForm.Width - pictureBox1.Left - 9;
			pictureBox1.Height = MainForm.ActiveForm.Height - 36;
		}
		
		void Switch_normalCheckedChanged(object sender, EventArgs e)
		{	//Bild normal laden
			pictureBox1.Image = new Bitmap(main_image);
			draw_dual_palette(Color.Black,Color.White);
		}
		void Switch_pseudo1CheckedChanged(object sender, EventArgs e)
		{	//Bild laden und in sinus pseudocolor ändern
			draw_sin_rainbow_palette();
			pictureBox1.Image = new Bitmap(main_image);
			do_main_pseudocolor();
		}
		void Scroll_spanScroll(object sender, ScrollEventArgs e)
		{	
			//offset darf nicht größer als span sein
			scroll_offset.Maximum = scroll_span.Value;
			scroll_offset.Minimum = 0 - scroll_span.Value;
			//span ins label schreiben
			label_span.Text = scroll_span.Value.ToString();
			if (switch_pseudo1.Checked) 
			{	//diese abfrage verhindert, dass die Funktion ausgeführt
				//wird, obwohl eine andere Pseudocolorfunktion aktiv ist
				draw_sin_rainbow_palette();
				pictureBox1.Image = new Bitmap(main_image);
				do_main_pseudocolor();
			}
		}
		void Scroll_offsetScroll(object sender, ScrollEventArgs e)
		{	
			//offset ins label schreiben
			label_offset.Text = scroll_offset.Value.ToString();
			if (switch_pseudo1.Checked) 
			{	//diese abfrage verhindert, dass die Funktion ausgeführt
				//wird, obwohl eine andere Pseudocolorfunktion aktiv ist
				draw_sin_rainbow_palette();
				pictureBox1.Image = new Bitmap(main_image);
				do_main_pseudocolor();
			}
		}
		
		void Switch_pseudo2CheckedChanged(object sender, EventArgs e)
		{	//Bild laden und in 8x gradient pseudocolor ändern
			draw_rainbow_palette();
			pictureBox1.Image = new Bitmap(main_image);
			do_main_pseudocolor();
		}
		void Scroll_span2Scroll(object sender, ScrollEventArgs e)
		{
			float val = ((float)scroll_span2.Value / 10f);
			label_span2.Text = val.ToString();
			scroll_offset2.Maximum = (int)(scroll_span2.Value / 1.3);
			scroll_offset2.Minimum = 0 - (int)(scroll_span2.Value / 1.3);
			if (switch_pseudo2.Checked) 
			{
				Switch_pseudo2CheckedChanged(sender,e);
			}
		}
		void Scroll_offset2Scroll(object sender, ScrollEventArgs e)
		{
			float val = ((float)scroll_offset2.Value / 10f);
			label_offset2.Text = val.ToString();
			if (switch_pseudo2.Checked) 
			{
				Switch_pseudo2CheckedChanged(sender,e);
			}
		}
		
		void Switch_pseudo3CheckedChanged(object sender, EventArgs e)
		{	//Bild laden und in 2x gradient pseudocolor ändern
			
			//RGB Farbe durch die eingaben auf der oberfläche erzeugen
			Color anf = Color.FromArgb(255,(int)num_r.Value,(int)num_g.Value,(int)num_b.Value);
			Color ende = Color.FromArgb(255,(int)num_r2.Value,(int)num_g2.Value,(int)num_b2.Value);
			//palette erstellen und colormap erzeugen
			draw_dual_palette(anf,ende);
			//bild laden und darauf die colormap anwenden
			pictureBox1.Image = new Bitmap(main_image);
			do_main_pseudocolor();
		}
		void Num_x_ValueChanged(object sender, EventArgs e)
		{	//da bei allen 6 das gleiche passieren soll
			//verwenden sie den selben System.EventHandler
			if (switch_pseudo3.Checked) 
			{	//diese abfrage verhindert, dass die Funktion ausgeführt
				//wird, obwohl eine andere Pseudocolorfunktion aktiv ist
				Switch_pseudo3CheckedChanged(sender, e);
			}
		}
		//###############################################
		//berechnen und zeichnen ########################
		//###############################################
		void draw_dual_palette(Color startfarbe,Color endfarbe)
		{	//erzeuge einen Farbverlauf und eine dementsprechende farbtabelle
			
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			pic_palette.Image = new Bitmap(256, pic_palette.Height);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(pic_palette.Image);
			Rectangle rect = new Rectangle(0, 0, pic_palette.Image.Width, pic_palette.Image.Height);
			LinearGradientBrush GB = new LinearGradientBrush(rect, startfarbe, endfarbe, LinearGradientMode.Horizontal);
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			
			//neue farbtabelle erstellen
			Bitmap img = (Bitmap)pic_palette.Image;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(i,1);
				map_r[i] = col.R;
				map_g[i] = col.G;
				map_b[i] = col.B;
			}
		}
		void draw_rainbow_palette()
		{	//erzeuge einen Farbverlauf und eine dementsprechende farbtabelle
			
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			pic_palette.Image = new Bitmap(256, pic_palette.Height);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(pic_palette.Image);
			Rectangle rect = new Rectangle(0, 0, pic_palette.Image.Width, pic_palette.Image.Height);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Color.Red, Color.Blue, LinearGradientMode.Horizontal);
			//start und endfarbe mit neuen überschreiben
			ColorBlend CB = new ColorBlend();
			CB.Colors = new Color[]
			{
				Color.Black,
				Color.Black,
            	Color.DarkViolet,
            	Color.Blue,
            	Color.DodgerBlue,
            	Color.LimeGreen,
            	Color.Orange,
            	Color.Crimson,
            	Color.White,
            	Color.White
			};
			//punkte festlegen, an denen die farben sein sollen, was dazwischen liegt
			//wird zum farbverlauf
      		float[] CP = new float[10];
      		//anfags und endpunkte müssen festliegen, 
      		//deshalb sind die anfangs und endfarben auch zweimal vorhanden
      		CP[0] = 0.0f;
      		CP[9] = 1.0f;
      		float span = (float) ( ((float)scroll_span2.Value - 20f) / 10f);
      		float offset = (float) ( (float)scroll_offset2.Value / 10f);
      		for (float i = 1; i < 9; i++ ) 
      		{	
      			CP[(int)i] = (float)( (i + (span*0.75) + offset) / ((span*1.5) + 9) );
      		}
      			
      		//werte übergeben
      		CB.Positions = CP;
			GB.InterpolationColors = CB;
			
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			
			//neue farbtabelle erstellen
			Bitmap img = (Bitmap)pic_palette.Image;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(i,1);
				map_r[i] = col.R;
				map_g[i] = col.G;
				map_b[i] = col.B;
			}
		}
		void draw_sin_rainbow_palette()
		{
			//neue graustufen farbpalette
        	draw_dual_palette(Color.Black,Color.White);
        	
			//variablen erstellen
			int span = scroll_span.Value;
			int offset = scroll_offset.Value;
			int colspan = 270 - (span * 2);
			
			//Palette von 0-255 durchlaufen
        	for ( int i = 0; i < 256; i++ )
			{
				if (i < (span + offset)) 
				{	//schwarz am Anfang
					map_r[i] = 0;
					map_g[i] = 0;
					map_b[i] = 0;
				}
				else if (i < (256 - (span - offset)))
				{
					// Neue Farbe [-1,1]:
					double red = Math.Sin( (i - span - offset) * 2 * Math.PI / colspan - Math.PI);
					double green = Math.Sin( (i - span - offset) * 2 * Math.PI / colspan - Math.PI / 2);
					double blue = Math.Sin( (i - span - offset) * 2 * Math.PI / colspan);
			
					// Neue Farbe [0,255]:
					red = (red + 1) * 0.5 * 255;
					green = (green + 1) * 0.5 * 255;
					blue = (blue + 1) * 0.5 * 255;
					
					map_r[i] = (byte)red;
				    map_g[i] = (byte)green;
				    map_b[i] = (byte)blue;
				}
				else
				{	//weiß am Ende
					map_r[i] = 255;
					map_g[i] = 255;
					map_b[i] = 255;
				}
			}
        	Bitmap img = (Bitmap)pic_palette.Image.Clone();
       		ColorRemapping filter2 = new ColorRemapping( map_r, map_g, map_b );
        	pic_palette.Image = filter2.Apply(img);
		}
		void do_main_pseudocolor()
        {
			//Bild zum bearbeiten laden
			Bitmap img = (Bitmap)pictureBox1.Image.Clone();
			//Bild (sicherheitshalber) in graustufen umwandeln
        	IFilter grayscale = new Grayscale( 0.2125, 0.7154, 0.0721 );
            Bitmap tmp = grayscale.Apply(img);
			//Bild von graustufen auf RGB setzten
			//es ändert sich äußerlich nicht, hat aber eine andere Farbscala
            GrayscaleToRGB filter1 = new GrayscaleToRGB();
			img = filter1.Apply(tmp);
			
			//Bildfarben aus der "byte color map" neu verteilen
			ColorRemapping filter2 = new ColorRemapping( map_r, map_g, map_b );
			pictureBox1.Image = filter2.Apply(img);
        }
	}
}
