﻿#region Usings...
using System;
using System.Text;
using System.Collections.Generic;
using System.Drawing;
using System.IO.Ports;
using System.IO;
using System.Threading;
using System.Windows.Forms;
#endregion

namespace Picaxe
{
	public partial class MainForm : Form
	{
		SerialPort SP = new SerialPort();
		public MainForm()
		{
			InitializeComponent();
			SP.BaudRate = 19200;
			SP.Encoding = System.Text.Encoding.Default;
			//Standard ist ASCII
			//Bytes über 127 erzeugen einen Paritätsfehler und werden als
			//63 übertragen. Mit Encoding.Default werden Bytes ordentlich versendet.
		}
		void Btn_RClick(object sender, EventArgs e)
		{
			send_to_PICAXE(2);
		}
		void Btn_GClick(object sender, EventArgs e)
		{
			send_to_PICAXE(1);
		}
		void Btn_RGClick(object sender, EventArgs e)
		{
			send_to_PICAXE(3);
		}
		void Btn_offClick(object sender, EventArgs e)
		{
			send_to_PICAXE(4);
		}
		
		void send_to_PICAXE(byte ser)
		{
			try {
				//Port festlegen und öffnen
				SP.PortName = txt_Port.Text;
				SP.Open();
				//datentransfer
				SP.DiscardInBuffer(); //bisher empfangendes verwerfen
				int n = 0;
				while (true) {
					if (n > 5) {
						//6 fehlgeschlagene Sendeversuche -> Abbruch
						label_status.Text = "Senden fehlgeschlagen";
						label_status.BackColor = Color.Red;
						SP.Close();
						return;
					}
					//Daten senden mit kleiner Pause, da Mikrocontroller etwas träge ist
					SP.Write(new byte[] {48},0,1); Thread.Sleep(10);
					SP.Write(new byte[] {ser},0,1);
					//100 ms Warten (alle 10ms überprüfen)
					for (int i = 0;i<10;i++ ) {
						Thread.Sleep(10);
						if (SP.BytesToRead > 2) {
							//mindestens 3 Bytes empfangen -> Übertragung abgeschlossen
							break;
						}
					}
					if (SP.BytesToRead > 2) {
						//mindestens 3 Bytes empfangen -> Übertragung abgeschlossen
						break;
					} else {
						//Timeout... neuer Sendeversuch
						n++;
						continue;
					}
				}
				//alle empfangenen Zeichen auslesen
				string read = SP.ReadExisting();
				SP.Close();
				
				byte[] bytes = new byte[read.Length]; //Byte Array erstellen (größe = empfangsmenge)
				char[] chars = read.ToCharArray(); //empfangenes in einzelne Zeichen zerlegen
				bytes = UnicodeEncoding.Default.GetBytes(chars); //umwandeln: Zeichen -> Bytes
				
				//Bytes als Text ausgeben
				string bytes_s = "";
				foreach (byte B in bytes) {
					bytes_s += B.ToString()+" ";
				}
				label_status.BackColor = Color.Lime;
				label_status.Text = "Info: "+bytes_s;
				
				if (bytes[1] == 3) {
					//3 = beide LEDs an
					MessageBox.Show("Beide LEDs Aktiv.");
				}
        	} catch (Exception err) {
				//Fehler als Status ausgeben
        		label_status.BackColor = Color.Red;
        		label_status.Text = err.Message;
			}
		}
		
		void Btn_exitClick(object sender, EventArgs e)
		{
			Application.Exit();
		}
	}
}
