/********************************************************************************
                           ###     ####       ###
                            #      #   #     #   #
                            #      ####      #   #
                            #      #   #     #  ##
                           ###     #   #      ####
********************************************************************************/
//#include "stm32f10x_it.h"
#include "type.h"
#include "stm32f10x_usart.h"
//#include "stm32f10x_exti.h"
//#include "stm32f10x_rtc.h"
#include "stm32f10x_gpio.h"
//#include "sd_spi_stm32.h"
//#include <stdio.h>

volatile u32 ms_tick,TimingDelay = 0;
extern volatile unsigned char usart_data,usart_rx,usart_rx1;
extern vu8 U1RxBuff[],U1Rx,SameU1Rx;
extern vu16 usb_timeout;
//extern vs16 x,y;

//Externe Funktionen
void disk_timerproc (void);

void USART1_IRQHandler(void) //UART1
{
	if(USART_GetFlagStatus(USART1,USART_IT_RXNE)==SET) {
		U1RxBuff[U1Rx] = USART_ReceiveData(USART1);
		SameU1Rx = 0;
		if (U1Rx < 55) { U1Rx++; }
	}
}

void EXTI0_IRQHandler(void)
{
	if(EXTI_GetITStatus(EXTI_Line0) != RESET)
	{
		//GPIOA->ODR ^= GPIO_Pin_2;	 // toggle LED2
		EXTI_ClearITPendingBit(EXTI_Line0);
	}
}

void EXTI1_IRQHandler(void)
{
	//wurde deaktiviert, wegen A1 -> Stop Mode
	if(EXTI_GetITStatus(EXTI_Line1) != RESET)
	{
		EXTI_ClearITPendingBit(EXTI_Line1);
	}
}

void RTC_IRQHandler(void)
{
	if (RTC_GetITStatus(RTC_IT_SEC) != RESET) {
		RTC_ClearITPendingBit(RTC_IT_SEC);

		GPIOA->ODR ^= GPIO_Pin_3;	 // toggle LED3
		/* Reset RTC Counter when Time is 23:59:59 */
		if (RTC_GetCounter() == 0x00015180) {
			RTC_SetCounter(0x0);
			RTC_WaitForLastTask();
		}
	}
}
void SysTick_Handler(void)
{
//    GPIOA->ODR ^= GPIO_Pin_2;	 // toggle LED3
//	disk_timerproc(); // to be called every 10ms
	if (TimingDelay>0) { TimingDelay--; }
	if (usb_timeout>1) { usb_timeout--; }
	ms_tick++;
}
//andere Funktionen ##################################################
void NMIException(void)
{}
void HardFaultException(void)
{ while (1) { ; } }
void MemManageException(void)
{ while (1) { ; } }
void BusFaultException(void)
{ while (1) { ; } }
void UsageFaultException(void)
{ while (1) { ; } }

void NMI_Handler(void)
{}
void MemManage_Handler(void)
{ while (1) { ; } }
void BusFault_Handler(void)
{ while (1) { ; } }
void UsageFault_Handler(void)
{ while (1) { ; } }
void SVC_Handler(void)
{ ; }
void DebugMon_Handler(void)
{ ; }
void PendSV_Handler(void)
{ ; }
void DebugMonitor(void)
{ ; }
void SVCHandler(void)
{ ; }
void PendSVC(void)
{ ; }
void WWDG_IRQHandler(void)
{ ; }
void PVD_IRQHandler(void)
{ ; }
void TAMPER_IRQHandler(void)
{ ; }
void FLASH_IRQHandler(void)
{ ; }
void RCC_IRQHandler(void)
{ ; }
void RTCAlarm_IRQHandler(void)
{ ; }

void EXTI2_IRQHandler(void)
{ ; }
void EXTI3_IRQHandler(void)
{ ; }
void EXTI4_IRQHandler(void)
{ ; }
void EXTI9_5_IRQHandler(void)
{ ; }//IRQ 5 bis 9
void EXTI15_10_IRQHandler(void)
{ ; }//IRQ 10 bis 15

void ADC1_2_IRQHandler(void)
{ ; }
void ADC3_IRQHandler(void)
{ ; }

void I2C1_EV_IRQHandler(void)
{ ; }
void I2C2_EV_IRQHandler(void)
{ ; }
void I2C2_ER_IRQHandler(void)
{ ; }

void SPI1_IRQHandler(void)
{ ; }
void SPI2_IRQHandler(void)
{ ; }
void SPI3_IRQHandler(void)
{ ; }

//void USBWakeUp_IRQHandler(void)
//{}
void USB_HP_CAN_TX_IRQHandler(void)
{ ; }
void CAN_RX1_IRQHandler(void)
{ ; }
void CAN_SCE_IRQHandler(void)
{ ; }
//void USB_LP_CAN_RX0_IRQHandler(void)
//{}

void FSMC_IRQHandler(void)
{ ; }

void SDIO_IRQHandler(void)
{ ; }

void USART2_IRQHandler(void)
{ ; }
void USART3_IRQHandler(void)
{ ; }
void UART4_IRQHandler(void)
{ ; }
void UART5_IRQHandler(void)
{ ; }

void TIM1_BRK_IRQHandler(void)
{ ; }
void TIM1_UP_IRQHandler(void)
{ ; }
void TIM1_TRG_COM_IRQHandler(void)
{ ; }
void TIM1_CC_IRQHandler(void)
{ ; }
void TIM2_IRQHandler(void)
{ ; }
void TIM3_IRQHandler(void)
{ ; }
void TIM4_IRQHandler(void)
{ ; }
void TIM5_IRQHandler(void)
{ ; }
void TIM6_IRQHandler(void)
{ ; }
void TIM7_IRQHandler(void)
{ ; }
void TIM8_CC_IRQHandler(void)
{ ; }
void TIM8_BRK_IRQHandler(void)
{ ; }
void TIM8_UP_IRQHandler(void)
{ ; }
void TIM8_TRG_COM_IRQHandler(void)
{ ; }

void DMA1_Channel1_IRQHandler(void)
{ ; }
void DMA1_Channel2_IRQHandler(void)
{ ; }
void DMA1_Channel3_IRQHandler(void)
{ ; }
void DMA1_Channel4_IRQHandler(void)
{ ; }
void DMA1_Channel5_IRQHandler(void)
{ ; }
void DMA1_Channel6_IRQHandler(void)
{ ; }
void DMA1_Channel7_IRQHandler(void)
{ ; }
void DMA2_Channel1_IRQHandler(void)
{ ; }
void DMA2_Channel2_IRQHandler(void)
{ ; }
void DMA2_Channel3_IRQHandler(void)
{ ; }
void DMA2_Channel4_5_IRQHandler(void)
{ ; }
/******************* (C) COPYRIGHT 2010 STMicroelectronics *****END OF FILE****/
