#include "misc.h"
#include <stdio.h>
#include <string.h> /* strcpy,strlen */
#include "main.h"
#include "boardcfg.h"
#include "hw_config.h"
#include "lcd.h"
#include "ff_Macros.h"

#include "usb_pwr.h" //enum bDeviceState
#include "usb_core.h" //DEVICE_INFO
extern DEVICE_INFO	Device_Info;
//Allgemeines
static volatile ErrorStatus HSEStartUpStatus = SUCCESS;
bool Init = false;
vs16 x=0,y=0;
char buf[12],text[60] = "0: ",PenCol_s[12];
u8 b_Modus=0,b_ff_FuncState=0,Rx_Idx=0;
u16 Data=0,PenCol=0,PenPress=0,Btn1Cnt=0;
u16 XX=0,YY=0,Trigger=1500;
u8 Trig_range=5,ADC_Buff[322],ADC_Buff2[322];
//USB
extern BYTE OutReport[RECIVE_SIZE],InReport[TRANSMITT_SIZE];
extern vu16 ADCConvertedValue;
extern vu16 AdcValues[2];
vu8 usart_data=0,usart_rx=0,usart_rx1=0;
vu8 U1RxBuff[56],U1Rx=0,LastU1Rx=0,SameU1Rx=0,TxCounter=0,TempCount=0;
vu16 usb_timeout=0;
//GUI Test ber USB
u8 USB_Txt1[20],USB_Txt2[20],USB_BtnTxt1[12],USB_BtnTxt2[12];

//Externe Funktionen
u32 USB_SIL_Write(u8 bEpAddr, u8* pBufferPointer, u32 wBufferSize);
void System_Init(void);
void SetEPTxValid(u8 /*bEpNum*/);
void SetEPRxValid(u8 /*bEpNum*/);

int main(void) {
	System_Init(); //hw_config.c
	b_Modus = 3; //paintmode

	PenCol=Color_White;
	strcpy((char*)PenCol_s,"Weiss");

    if (bDeviceState>0) { //USB Verbindung erkannt
        LCD_Clear(Color_Black);
        LCD_DrawText(60,120,"Warte auf USB CONFIG",Color_Yellow,0x0000,font_8x16);
        while(bDeviceState!=5) {
            LED2_On();
            delay_ms(100);
            LED2_Off();
            delay_ms(100);
        }
        //Sende und Empfangsberreitschaft melden
        SetEPTxValid(1); SetEPRxValid(1);
        LCD_DrawText(60,120,"USB Verbindung PASS ",Color_Green,0x0000,font_8x16);
        delay_ms(500);
    }
	if (b_Modus==2) {
		//16bit IO Expander Setup...alle Pins: 255->In / 0->Out
		I2C_Send(32, IO16_DirA, 0); //Direction Port A: alle Outs
		LED2_On();
	}

	while(1){
		if (Init) { doBackground(); }

		switch (b_Modus) {
			case 1: Modus_FatSDDemo(); break;
			case 2: Modus_I2CDemo(); break;
			case 3: Modus_PaintDemo(); break;
			case 4: Modus_GraphDemo(); break;
			case 5: continue; //USB GUI Mode
		}

//Wegen Encoder abgeschaltet
//		if (Button2) { //Zwischen Paint und Fat FS wechseln
//			if (b_Modus==3) {
//				b_Modus=1;
//			} else {
//				b_ff_FuncState=255; //unmount -> paint
//			}
//			while(Button2) { //LED blinkt solange die Taste 2 noch unten ist
//				LED2_On(); delay_ms(200);
//				LED2_Off(); delay_ms(200);
//			}
//			Init=false; continue;
//		}

//		if (b_Modus==1) { continue; } //Bei Fat FS Mode nicht abschalten

//		if (Button1) { //abschalten
//			if (Btn1Cnt>100) {
//				LCD_SetProgBar(0,4,151,26,70,100,0xF800,HORI,100);
//				LCD_DrawBars();
//				while(Button1) { //LED blinkt solange die Taste 1 noch unten ist
//					LED2_On(); delay_ms(200);
//					LED2_Off(); delay_ms(200);
//				}
//
//				StopMode(); //low power
//				//PWR_EnterSTANDBYMode(); //turn off
//				while(Button1) { //LED blinkt solange die Taste 1 noch unten ist
//					LED2_On(); delay_ms(200);
//					LED2_Off(); delay_ms(200);
//				}
//
//				Init = false; Btn1Cnt=99;
//			} else {
//				Btn1Cnt++;
//				LCD_SetBarVal(0,Btn1Cnt);
//				LCD_DrawBars();
//
//			}
//		} else {
//			if (Btn1Cnt>0) {
//				Btn1Cnt--;
//				LCD_SetBarVal(0,Btn1Cnt);
//				LCD_DrawBars();
//			}
//		}

//		Data = readADC1(8); //B0 (Trimmer) alte direkt ADC Version
		InReport[1] = ADCConvertedValue>>8; InReport[2] = ADCConvertedValue;
//		Data = readADC1(9); //B1... ist jetzt I2C SDA
//		InReport[3] = Data>>8; InReport[4] = Data;
	}
} //int main(void)

void doBackground(void) {
	#ifdef TP_PenDown
	if (TP_PenDown) {
		SPI_SelectDevice(2); //0=off 1=SD 2=TP 3=FLASH
		TP_GetAdXY(&x,&y);
	} else {
		x=0;y=0;
	}
	//schaltflchen abfragen
	if (x>0&&y>0){
        if (PenPress<50) { PenPress++; }
	}
	if(PenPress>5){
        if (x==0&&y==0) { PenPress=0; }
		LCD_DrawButtons(x,y);
	}
	#else
	SPI_SelectDevice(2); //0=off 1=SD 2=TP 3=FLASH
	TP_GetAdXY(&x,&y);
	LCD_DrawButtons(x,y);
	#endif

	if (bDeviceState>0&&bDeviceState!=5) {
        LCD_Clear(Color_Black);
        LCD_DrawText(60,120,"Warte auf USB CONFIG",Color_Yellow,0x0000,font_8x16);
        while(bDeviceState!=5) {
            LED2_On();
            delay_ms(100);
            LED2_Off();
            delay_ms(100);
        }
        //Sende und Empfangsberreitschaft melden
        SetEPTxValid(1); SetEPRxValid(1);
//			LCD_Clear(Color_Green);
        LCD_DrawText(60,120,"USB Verbindung PASS ",Color_Green,0x0000,font_8x16);
        delay_ms(500); Init=false;
    }

    if (usb_timeout==1) {
        bDeviceState=0; usb_timeout=0;
        LCD_Clear(Color_Black);
        LCD_DrawText(70,120,"USB Entfernt",Color_Red,0x0000,font_8x16);
        delay_ms(500); Init=false;
    }
}

void Modus_I2CDemo(void) {
	//x = bytevariable
	//y = fehlerzhler
	x++;
	if (x>255) { x=0; }

	//bertragung
	I2C_Send(32, IO16_OutA, x); //adr, reg, data
	I2C_Read(32, IO16_OutB, &Rx_Idx); //adr, reg, data

	//anzeige
	if (Rx_Idx!=x) { y++; }
	strcpy(text,"Cnt: ");
	itoa(x, buf, 10); strcat(text,buf);
	LCD_DrawText(0, 0, text, Color_Blue, Color_Black,font_8x16);
	strcpy(text,"Err: ");
	itoa(y, buf, 10); strcat(text,buf);
	LCD_DrawText(0, 16, text, Color_Blue, Color_Black,font_8x16);
}

void Modus_PaintDemo(void) {
	if (!Init) {
		Init = true;
		LCD_ClearBars(false);
		LCD_ClearButtons(false);
		//Rechtecke:
		LCD_DrawFilledRect(81,1,178,238,0x0000);
		LCD_DrawFilledRect(0,180,60,320,0x8410);
		LCD_DrawFilledRect(0,0,180,80,0x8410);
		LCD_DrawRect(80,0,180,240,0xFFFF);
		LCD_DrawRect(3,81,20,72,0xFFFF);
		LCD_DrawFilledRect(4,82,18,70,0x0000);
		//Texte:
		LCD_DrawText(87,182,"Joe-C Miniboard V007 Paint",0xF800,0x8410,font_8x16);
		LCD_DrawText(11,0,"T: 8888",0x001F,0x8410,font_8x16);
		LCD_DrawText(11,16,"X: 8888",0x001F,0x8410,font_8x16);
		LCD_DrawText(11,32,"Y: 8888",0x001F,0x8410,font_8x16);
		LCD_DrawText(3,48,"B1: xxxx",0xF800,0x8410,font_8x16);
		LCD_DrawText(3,65,"Farbe:",0xFFFF,0x8410,font_8x16);
		LCD_DrawText(17,83,"Weiss",0xFFFF,0x0000,font_8x16);
		//Buttons:
		LCD_SetButtons(1,9,200,31,33," W",BtnNormal,font_8x16,0x0000,0xFFFF);
		LCD_SetButtons(2,49,200,31,33," R",BtnNormal,font_8x16,0x0000,0xF800);
		LCD_SetButtons(3,90,200,31,33," G",BtnNormal,font_8x16,0x0000,0x07E0);
		LCD_SetButtons(4,132,200,31,33," B",BtnNormal,font_8x16,0x0000,0x001F);
		LCD_SetButtons(5,8,110,31,63," Clear",BtnNormal,font_8x16,0x0000,0x8410);
		LCD_SetButtons(6,247,200,31,68," Fast",BtnAnzeige,font_8x16,0x001F,0x8410);
		LCD_SetButtons(7,179,200,31,49," Graph",BtnNormal,font_6x10,0xFFFF,0x0000);
		//Progressbars:
		//LCD_SetProgBar(0,4,151,26,70,100,0x001F,HORI,0);
		//Lines:
		LCD_DrawButtons(0,0); //initialisieren
		//LCD_DrawBars();

		LCD_DrawText(85,15,"font_4x6",Color_Green,Color_Black,font_4x6);
        LCD_DrawText(85,21,"font_5x8",Color_Green,Color_Black,font_5x8);
        LCD_DrawText(85,29,"font_5x12",Color_Green,Color_Black,font_5x12);
        LCD_DrawText(85,41,"font_6x10",Color_Green,Color_Black,font_6x10);
        LCD_DrawText(85,51,"font_8x12",Color_Green,Color_Black,font_8x12);
        LCD_DrawText(85,63,"font_8x16",Color_Blue,Color_Black,font_8x16);
        LCD_DrawText(85,79,"font_12x16",Color_Green,Color_Black,font_12x16);
        LCD_DrawText(85,95,"22x36",Color_Green,Color_Black,font_22x36);
        LCD_DrawText(85,131,"PASS",Color_White,Color_Green,font_22x36);
	}

	//Zeichnen (wenn innerhalb des Zeichenfeldes)
	if (x>80&&y<178) {
		if (LCD_GetButtonstate(6)==BtnIsOn) {
			LCD_DrawLine(x,y,2,VERT,PenCol);
			LCD_DrawLine(x+1,y,2,VERT,PenCol);
//			LCD_DrawPoint( x, y, PenCol);
			//delay_ms(1);
			return;
		} else {
			LCD_DrawLine(x,y,2,VERT,PenCol);
			LCD_DrawLine(x+1,y,2,VERT,PenCol);
		}
	}

	//Daten anzeigen
	strcpy(text,"");//AdcValues[0]
	itoa(RTC_GetCounter(), buf, 10); strcat(text,buf);
	LCD_DrawTextBlock(35,0,text,0x001F,0x8410,5," ",font_8x16);
	if (x==0&&y==0) {
		strcpy(text,"up  ");
		LCD_DrawTextBlock(35,16,text,0x001F,0x8410,4," ",font_8x16);
		strcpy(text,"up  ");
		LCD_DrawTextBlock(35,32,text,0x001F,0x8410,4," ",font_8x16);
	} else {
		strcpy(text,"");
		itoa(x, buf, 10); strcat(text,buf);
		LCD_DrawTextBlock(35,16,text,0x001F,0x8410,4," ",font_8x16);
		strcpy(text,"");
		itoa(y, buf, 10); strcat(text,buf);
		LCD_DrawTextBlock(35,32,text,0x001F,0x8410,4," ",font_8x16);
	}

	//Analogeingang
	strcpy(text,"");
	//Data = readADC1(8);ADCConvertedValue TIM2->CNT usb_timeout
	itoa(AdcValues[1], buf, 10); strcat(text,buf);
	LCD_DrawTextBlock(35,48,text,0xF800,0x8410,4," ",font_8x16);
	LCD_DrawTextBlock(17,83,PenCol_s,PenCol,0x0000,5," ",font_8x16);
}
void Modus_FatSDDemo(void) {
	SPI_SelectDevice(1); //0=off 1=SD 2=TP
	if (!Init) {
		Init = true;
		LCD_ClearBars(false);
		LCD_ClearButtons(false);
		//Rechtecke:
		LCD_DrawFilledRect(81,1,178,238,0x0000);
		LCD_DrawFilledRect(0,180,60,320,0x8410);
		LCD_DrawFilledRect(0,0,180,80,0x8410);
		LCD_DrawRect(80,0,180,240,0xFFFF);
		//Texte:
		LCD_DrawText(87,182,"Joe-C Miniboard V007 Fat SD",0x001F,0x8410,font_8x16);
		//Buttons:
		LCD_SetButtons(1,4,150,30,72," Paint",BtnNormal,font_8x16,0xFFFF,0x0000);
		LCD_SetButtons(2,4,200,30,72," Read TXT",BtnNormal,font_6x10,0x0000,0x8410);
		LCD_SetButtons(3,84,200,30,72," Write TXT",BtnNormal,font_6x10,0x0000,0x8410);
		LCD_SetButtons(4,164,200,30,72," Read Disk",BtnNormal,font_6x10,0x0000,0x8410);
		LCD_SetButtons(5,242,200,30,72," Uart1",BtnAnzeige,font_8x16,0xF800,0x8410);
		LCD_SetButtons(6,4,56,30,72," Del TXT",BtnNormal,font_6x10,0x0000,0x8410);
		//Progressbars:
		//Lines:
		LCD_DrawButtons(0,0); //initialisieren
		LCD_SetButtonstate(5,BtnSetOn);

		ff_res = f_mount(&fatfs,"0:/",1);
		if (usb_timeout!=0) {
            usb_timeout=USB_DISCONNECT_TIME; //Reset USBtimer
		}
		ff_LCD_FRESULT(85,10,"f_mount:",ff_res);
	 	if (ff_res!=FR_OK) {
			LCD_DrawText(87,138,"Init FAIL",0xFFFF,0xF800,font_22x36);
		} else {
			LCD_DrawText(87,138,"Init PASS",0xFFFF,0x07E0,font_22x36);
		}
		b_ff_FuncState=0;
	}
	switch (b_ff_FuncState) {
		case 1: //read txt
			LCD_DrawFilledRect(81,1,178,238,Color_Black);
			LFF_X=85; LFF_Y=2;
			ff_TxtRead("0:/pics/hund wer nicht kauft/test.txt");
			break;
		case 2: //write txt
			LCD_DrawFilledRect(81,1,178,238,Color_Black);
			LFF_X=85; LFF_Y=2;
			ff_TxtWrite("0:/pics/hund wer nicht kauft/test.txt","neue testzeile...", ff_WrMode_AddNewLine);
			break;
		case 3: //read Disk
			LCD_DrawFilledRect(81,1,178,238,Color_Black);
			LFF_X=85; LFF_Y=2;
			strcpy(FF_Path, "");
			ff_DiscFindFiles(FF_Path);
			break;
		case 4: //delete txt
			LCD_DrawFilledRect(81,1,178,238,Color_Black);
			LFF_X=85; LFF_Y=2;
			ff_remove("0:/pics/hund wer nicht kauft/test.txt");
			break;
		case 255: //read Disk
			LCD_DrawFilledRect(81,1,178,238,Color_Black);
			ff_res = f_mount(0,"0:/",1);
			ff_LCD_FRESULT(85,10,"f_mount(unmount):",ff_res);
		 	if (ff_res!=FR_OK) {
				LCD_DrawText(87,138,"No DeInit",0xFFFF,0xF800,font_22x36);
			} else {
				LCD_DrawText(87,138,"unmount OK",0xFFFF,0x07E0,font_22x36);
			}
			delay_ms(1000);
			Init=false; b_Modus=3;
			break;
	}
	b_ff_FuncState=0;
}
void Modus_GraphDemo(void) {
	if (!Init) {
		Init = true;
		LCD_ClearBars(false);
		LCD_ClearButtons(false);
		TIM2->CNT=Trigger;
        //Rechtecke:
        LCD_DrawFilledRect(81,1,178,238,0x0000);
        LCD_DrawFilledRect(0,180,60,320,0x8410);
        LCD_DrawFilledRect(0,0,180,80,0x8410);
        LCD_DrawRect(80,0,180,240,0xFFFF);
        LCD_DrawRect(5,54,97,73,0x0000);
        LCD_DrawFilledRect(6,54,18,71,0x001F);
        //Texte:
        LCD_DrawText(87,182,"Joe-C Miniboard V007 Graph",0x07E0,0x8410,font_8x16);
        LCD_DrawText(16,55,"Modus:",0xFFFF,0x001F,font_8x16);
        LCD_DrawText(8,154,"Trig. Level:",0x0000,0x8410,font_5x12);
        //Buttons:
        LCD_SetButtons(1,4,4,30,72," Fat SD",BtnNormal,font_8x16,0xFFFF,0x0000);
        LCD_SetButtons(2,10,77,30,60," Roll",BtnAnzeige,font_5x12,0x07E0,0x8410);
        LCD_SetButtons(3,10,114,30,60," Frame",BtnAnzeige,font_5x12,0x001F,0x8410);
        LCD_SetButtons(4,7,200,30,93," Frame Trig B1",BtnAnzeige,font_5x12,0x0000,0x8410);
        LCD_SetButtons(5,109,200,30,55," B1 Gelb",BtnNormal,font_5x12,0xFFE0,0x8410);
        //Progressbars:
        //Lines:
        LCD_DrawButtons(0,0); //initialisieren
	}

	if (LCD_GetButtonstate(2)==BtnIsOn) { //roll mode
        LCD_GraphCurve_AddPoint(0,(u8)(((float)(4096-AdcValues[0])/(float)4096)*(float)178)+1);
        LCD_GraphCurve_AddPoint(1,(u8)(((float)(4096-AdcValues[1])/(float)4096)*(float)178)+1);
        delay_us(550);
        //LCD_DrawRect(60,20,180,240,0xFFFF);
        LCD_DrawGraph(80,0,180,240,Graph_right);
	}
	if (LCD_GetButtonstate(3)==BtnIsOn) { //frame mode
        if (LCD_GetButtonstate(4)==BtnIsOn) { //mit Trigger
            //erkennung der Schaltschwelle
            if (AdcValues[1]>Trigger+Trig_range||
                AdcValues[1]<Trigger-Trig_range) {
                ADC_Buff2[XX++]=AdcValues[1];
                if (XX>200) { XX=20; }
                return;
            }
            if (XX<20) { return; }
            if (ADC_Buff2[XX]>ADC_Buff2[XX-20]) { //alter wert kleiner -> steigende Flanke
                XX=0; return;
            }
        }
        //Daten erfassen
        for(XX=0;XX<250;XX++) {
            ADC_Buff[XX]=(u8)(((float)(4096-AdcValues[0])/(float)4096)*(float)178)+1;
            ADC_Buff2[XX]=(u8)(((float)(4096-AdcValues[1])/(float)4096)*(float)178)+1;
            delay_us(1000);
        }

        //Daten bertragen
        LCD_GraphCurve_SetValues(0,&ADC_Buff[0]);
        LCD_GraphCurve_SetValues(1,&ADC_Buff2[0]);

        if (LCD_GetButtonstate(4)==BtnIsOn) { //Trigger anzeigen
            for(XX=0;XX<240;XX++) {
                ADC_Buff[XX]=(u8)(((float)(4096-Trigger)/(float)4096)*(float)178)+1;
            }
            LCD_GraphCurve_AddCurve(2,Color_Magenta,&ADC_Buff[0]);
        } else {
            LCD_GraphCurve_init(2,0); //Kurve abschalten
        }

        //Daten anzeigen
        LCD_DrawGraph(80,0,180,240,Graph_left);
	}

	//Encoder abfragen und anzeigen(Triggerlevel)
    Trigger=TIM2->CNT;
    itoa(TIM2->CNT, buf, 10); strcpy(text," "); strcat(text,buf);
	LCD_DrawTextBlock(8,170,text,0x07E0,0x0000,7," ",font_8x16);
}
// GUI Buttons  ###################################################################################
void LCD_BTN_down(u8 index) {
	if (b_Modus==1) { //Fatfs
		switch (index) {
			case 1: b_ff_FuncState=255; break; //unmount
			case 2: b_ff_FuncState=1; break; //read txt
			case 3: b_ff_FuncState=2; break; //write txt
			case 4: b_ff_FuncState=3; break; //read Disk
			case 6: b_ff_FuncState=4; break; //del txt
		}
		return;
	}
	if (b_Modus==3) { //Paint
		switch (index) {
			case 1: PenCol=Color_White;	strcpy(PenCol_s,"Weiss "); InReport[9]=0; break;
			case 2: PenCol=Color_Red;		strcpy(PenCol_s,"Rot   "); InReport[9]=1; break;
			case 3: PenCol=Color_Green;	strcpy(PenCol_s,"Grn "); InReport[9]=2; break;
			case 4: PenCol=Color_Blue;	strcpy(PenCol_s,"Blau  "); InReport[9]=3; break;
			case 5: InReport[14]=1; //Clearbefehl
					LCD_DrawFilledRect(81,1,178,238,Color_Black);
					LCD_DrawText(87,182,"Zeichenfeld gelscht...    ",Color_Green,0x8410,font_8x16);
					break;
			case 7: Init=false; b_Modus=4; break; //goto graph
		}
		return;
	}
    if (b_Modus==4) { //Graph
		switch (index) {
			case 1: Init=false; b_Modus=1; break; //goto fat sd
			case 2: LCD_SetButtonstate(3,BtnSetOff); //roll mode (frame off)
                    LCD_GraphCurve_init(0,Color_Blue);
                    LCD_GraphCurve_init(1,Color_Green);
                    LCD_GraphCurve_init(2,0); break;
			case 3: LCD_SetButtonstate(2,BtnSetOff); //frame mode (roll off)
                    LCD_GraphCurve_init(0,Color_Blue);
                    LCD_GraphCurve_init(1,Color_Green); break;
			case 4:  break; //Frame trig
			case 5: LCD_GraphCurve_SetColor(1,Color_Yellow); break; //B1 gelb
		}
		return;
	}
}
void LCD_BTN_up(u8 index) { ; }
// USB  ############################################################################################
//##################################################################################################
void GetInReport_TRANSMITT (void) { //c Ausgang USB->PC
    usb_timeout=USB_DISCONNECT_TIME;
	if (U1Rx > 0) {
		if (SameU1Rx > 3) {
			//es wurde was empfangen und nach der 3. abfrage war die menge gleich
			InReport[0] = 9;//uart1 rx
			InReport[1] = U1Rx++;
			while (U1Rx!=0)	{
			    U1Rx--;
				InReport[2+U1Rx] = U1RxBuff[U1Rx];
			}
			USB_SIL_Write(0x81, &InReport[0], sizeof(InReport));
			InReport[0] = 3;
			b_Modus = 3; SameU1Rx = 0; SetEPTxValid(1); return;
		}
		if (LastU1Rx == U1Rx) {
			SameU1Rx++;
		}
		LastU1Rx = U1Rx;
	}
	//nix vom UART1 empfangen
	switch (b_Modus) {
		case 1:
		case 3:
        case 4:
		    InReport[0] = 2;//analogabfrage
			InReport[1] = b_Modus;
			if (Button1) {
				InReport[20] = 2;
			} else {
				InReport[20] = 3;
			}
			InReport[10] = x>>8; InReport[11] = x;
			InReport[12] = y>>8; InReport[13] = y;
			USB_SIL_Write(0x81, &InReport[0], sizeof(InReport));
			//Clearbefehl lschen
			if (InReport[14]==1) { InReport[14]=0; }
			break;
		case 5: //mach nix (USB GUI Mode)
			break;
		default:
		    InReport[0] = b_Modus;
		    USB_SIL_Write(0x81, &InReport[0], sizeof(InReport));
			break;
	}
	SetEPTxValid(1);
}

void SetOutReport_RECIVE (void) { //c Eingang USB<-PC
	u16 X,Y,H,W,Col1,Col2,Val;
	u8 i;
//	b_Modus = OutReport[0];
	switch (OutReport[0]) {
		case 1: Rx_Idx=OutReport[1];
			break;
		case 2:
			b_Modus=3;
			if (OutReport[1]==0) {
				LED2_Off();
			} else {
				LED2_On();
			}
			break;
		case 3: break; //Modus_PaintDemo
		case 4: break; //Modus_I2CDemo
		case 5: break; //Modus_GUIDemo
		case 10: //UART1 Tx
			TxCounter = 2; OutReport[0] = 0; b_Modus = 3;
			while (OutReport[1]!=0) {
				USART_SendData(USART1, (u8) OutReport[TxCounter]);
				OutReport[TxCounter] = 0;
				while(USART_GetFlagStatus(USART1, USART_FLAG_TC) == RESET) {}
				TxCounter++; OutReport[1]--;
			}
			USB_SIL_Write(0x81, &InReport[0], sizeof(InReport)); SetEPTxValid(1); break;
		case 20: //Clear Screen
			b_Modus = 5; //Modus_GUIDemo
			LCD_Clear(Color_Black);
			break;
		case 21: //set txt
			b_Modus = 5; //Modus_GUIDemo
			X=OutReport[1]<<8|OutReport[2];
			Y=OutReport[3]<<8|OutReport[4];
			Col1=OutReport[5]<<8|OutReport[6];
			Col2=OutReport[7]<<8|OutReport[8];
            for(i=0;i<OutReport[10];i++) {
                USB_Txt1[i]=OutReport[11+i];
            }
            USB_Txt1[OutReport[10]]=0;//end of string
            LCD_DrawText(X, Y,(char*)&USB_Txt1[0] ,Col1,Col2,OutReport[9]);
			break;
		case 22: //set btn
			b_Modus = 5; //Modus_GUIDemo
			X=OutReport[1]<<8|OutReport[2];
			Y=OutReport[3]<<8|OutReport[4];
			H=OutReport[5]<<8|OutReport[6];
			W=OutReport[7]<<8|OutReport[8];
			Col1=OutReport[11]<<8|OutReport[12];//ForeCol
			Col2=OutReport[13]<<8|OutReport[14];//BackCol
            for(i=0;i<OutReport[15];i++) {
                USB_BtnTxt1[i]=OutReport[16+i];
            }
            USB_BtnTxt1[OutReport[15]]=0; //end of string
            LCD_SetButtons(0,X,Y,H,W,(char*)&USB_BtnTxt1[0],OutReport[9],OutReport[10],Col1,Col2);//nr,X,Y,H,W,txt,font,front,back
			LCD_DrawRect(X-1,Y-1,H+2,W+2,Color_Black);//X,Y,H,W,C
			LCD_DrawButtons(0,0); //initialisieren
			break;
        case 23: //set bar
			b_Modus = 5; //Modus_GUIDemo
			X=OutReport[1]<<8|OutReport[2];
			Y=OutReport[3]<<8|OutReport[4];
			H=OutReport[5]<<8|OutReport[6];
			W=OutReport[7]<<8|OutReport[8];
			Col1=OutReport[9]<<8|OutReport[10];//max
			Col2=OutReport[11]<<8|OutReport[12];//farbe
			Val=OutReport[14]<<8|OutReport[15];//val
			if (OutReport[13]==1) { //richtung
			    LCD_SetProgBar(0,X,Y,H,W,Col1,Col2,VERT,Val);
			} else {
			    LCD_SetProgBar(0,X,Y,H,W,Col1,Col2,HORI,Val);
			}
			LCD_DrawRect(X-1,Y-1,H+2,W+2,Color_Black);//X,Y,H,W,C
			LCD_DrawBars(); //initialisieren
			break;
        case 24: //set rechtecke
			b_Modus = 5; //Modus_GUIDemo
			X=OutReport[1]<<8|OutReport[2];
			Y=OutReport[3]<<8|OutReport[4];
			H=OutReport[5]<<8|OutReport[6];
			W=OutReport[7]<<8|OutReport[8];
			Col1=OutReport[9]<<8|OutReport[10];//farbe
			if (OutReport[11]==1) { //gefllt
			    LCD_DrawFilledRect(X,Y,H,W,Col1);
			    //LCD_DrawEllipse(X,Y,H,W,Col1);
			} else {
			    LCD_DrawRect(X,Y,H,W,Col1);
			}
			break;
        case 25: //set line
			b_Modus = 5; //Modus_GUIDemo
			X=OutReport[1]<<8|OutReport[2];
			Y=OutReport[3]<<8|OutReport[4];
			H=OutReport[5]<<8|OutReport[6];//len
			Col1=OutReport[8]<<8|OutReport[9];//farbe
			if (OutReport[7]==1) {
                LCD_DrawLine(X,Y,H,VERT,Col1);
			} else {
			    LCD_DrawLine(X,Y,H,HORI,Col1);
			}
			break;
		default:
		    USB_SIL_Write(0x81, &InReport[0], sizeof(InReport)); SetEPTxValid(1);
			break;
	}
	InReport[0] = 128;
	InReport[1] = OutReport[0];
	SetEPRxValid(1);
}
//##################################################################################################

ErrorStatus Get_HSEStartUpStatus(void) { return (HSEStartUpStatus); }
/******************* (C) COPYRIGHT 2008 STMicroelectronics *****END OF FILE****/
