#ifndef __LCD_H__
#define __LCD_H__
#include "_LCD_SET.h"
#include "font.h"
#include "type.h"

/* LCD color */
#define Color_White          0xFFFF
#define Color_Gray           0x8410
#define Color_GrayHigh       0xC618
#define Color_GrayLow        0x528A
#define Color_Black          0x0000
#define Color_Blue           0x001F
#define Color_Orange         0xFA20
#define Color_Red            0xF800
#define Color_Magenta        0xF81F
#define Color_Green          0x07E0
#define Color_Cyan           0x07FF
#define Color_Yellow         0xFFE0

/* Schreibrichtung des LCD :
Nach der Kennung EM_ folgt die erste, dann die zweite schreibrichtung.
Standard ist EM_Up_Re: bis zum Displayrand nach oben,
dann eins rechts und wieder bis zum rand nach oben.
Displayunterseite ist da, wo die Anschlussleitungen raus kommen. */
#define EM_Le_Up                1
#define EM_Re_Up                2
#define EM_Le_Dn                3
#define EM_Re_Dn                4
#define EM_Up_Le                5
#define EM_Up_Re                6
#define EM_Dn_Le                7
#define EM_Dn_Re                8

/* Flagbezeichnungen */
#define Graph_left              0
#define Graph_right             1
#define HORI					EM_Up_Re
#define VERT					EM_Re_Up
#define BtnNormal				255
#define BtnAnzeige			    254
#define BtnIsOn                 3
#define BtnIsOff                4
#define BtnSetOn                5
#define BtnSetOff               6

/* Externe Funktionen */
void LCD_GraphCurve_init(u8 i, u16 Color);
void LCD_GraphCurve_AddCurve(u8 i, u16 Color, u8 *Values);
void LCD_GraphCurve_SetValues(u8 i, u8 *Values);
void LCD_GraphCurve_AddPoint(u8 i, u8 Value);
void LCD_GraphCurve_SetColor(u8 i, u16 Color);
void LCD_DrawGraph(u16 Xpos, u16 Ypos, u16 Height, u16 Width, u8 Mode);
void LCD_BTN_down(u8 index);
void LCD_BTN_up(u8 index);
void LCD_Initializtion(void);
void LCD_DrawPicture(u16 StartX,u16 StartY,u16 EndX,u16 EndY,u16 *pic);
void LCD_SetButtons(u8 index, u16 Xpos, u16 Ypos, u16 Height, u16 Width, char *txt, u8 state, u8 font, u16 foreC, u16 backC);
void LCD_SetButtonstate(u8 i, u8 state);
u8 LCD_GetButtonstate(u8 i);
void LCD_ReDrawButtons();
void LCD_ClearButtons(bool doDraw);
void LCD_DrawButtons(u16 Xpos, u16 Ypos);
void LCD_SetProgBar(u8 i, u16 Xpos, u16 Ypos, u16 Height, u16 Width, u16 Max, u16 Color, u8 Typ, u16 Value);
void LCD_SetBarVal(u8 i, u16 Value);
void LCD_DrawBars();
void LCD_ClearBars(bool doDraw);
void LCD_DrawPoint(u16 x,u16 y,u16 point);
void LCD_DrawText(u16 x, u16 y, char *text, u16 charColor, u16 bkColor, u8 font);
void LCD_DrawTextBlock(u16 x, u16 y, char *text, u16 charColor, u16 bkColor, u8 Fill_cnt, char *Fill_char, u8 font);
void LCD_Clear(u16 bkColor);
void LCD_DrawMonoPict(u8 *Pict);
void LCD_Enable(u8 status);
void LCD_DrawLine(u16 Xpos, u16 Ypos, u16 Length, u8 Direction, u16 Color);
void LCD_DrawRect(u16 Xpos, u16 Ypos, u16 Height, u16 Width, u16 Color);
void LCD_DrawFilledRect(u16 Xpos, u16 Ypos, u16 Height, u16 Width, u16 Color);

/* Interne Funktionen */
void LCD_WriteRegister(u16 index,u16 dat);
void LCD_SetCursor(u16 x,u16 y);
void LCD_SetWindows(u16 StartX,u16 StartY,u16 EndX,u16 EndY);
void LCD_PutChar(u16 x,u16 y,u8 c,u16 charColor,u16 bkColor, u8 font);
void LCD_Delay(u32 nCount);
void LCD_Test(void);
void LCD_SetOrientation(u8 Entry_Mode);
void LCD_WriteRAM_Prepare(void);
void LCD_WriteData(u16 dat);
void LCD_WriteIndex(u16 idx);
void sub_WR_Dataline(u8 data, u8 a,u8 d,u8 e,u16 colC,u16 colB);
u16 LCD_BGR2RGB(u16 c);
u16 LCD_RGB2Pixel565(u8 r, u8 g, u8 b);

#endif	// __LCD_H__

