﻿#region Usings...
using System;
using System.Text;
using System.Collections.Generic;
using System.Drawing;
using System.IO.Ports;
using System.IO;
using System.Threading;
using System.Windows.Forms;

#endregion
 
namespace J_Tools
{
	public partial class MainForm : Form
	{
		#region Allgemeines
		//Variablen
		bool recived_last = false;
		bool is_sending = false;
		bool Graph1_OnChange = false;
		List<int> Data_CD = new List<int>();
		List<int> Data_CTS = new List<int>();
		List<int> Data_DSR = new List<int>();
		List<int> Data_Byte = new List<int>();
		List<int> Data_RTS = new List<int>();
		List<int> Data_DTR = new List<int>();
		int Graphrange = 0;
		int Peakrange1 = 0;
		int Perioderange1 = 0;
		int Peakrange2 = 0;
		int Perioderange2 = 0;
		int stopuhr_h = 0;
		int stopuhr_m = 0;
		int stopuhr_s = 0;
		int countdown_h = 0;
		int countdown_m = 0;
		int countdown_s = 10;
		//Delegaten zur interaktion zwischen 
		//verschiedenen Threads
		delegate void Data_recived_delegate(string text);
		delegate void Pin_Changed_delegate();
		
		void Version(){
			//Titel aktualisieren
			this.Text += " 1.1";
		}
		
		public MainForm()
		{
			InitializeComponent();
			//Comboboxen befüllen
			CB_RS232_G1_Datenaufnahme.Items.Add("Inaktiv");
			CB_RS232_G1_Datenaufnahme.Items.Add("bei Änderung");
			CB_RS232_G1_Datenaufnahme.Items.Add("Autorun: 0.1 Sek");
			CB_RS232_G1_Datenaufnahme.Items.Add("Autorun: 0.5 Sek");
			CB_RS232_G1_Datenaufnahme.Items.Add("Autorun: 1 Sek");
			CB_RS232_G1_Datenaufnahme.Items.Add("Autorun: 5 Sek");
			CB_RS232_G1_Datenaufnahme.SelectedIndex = 0;
			
			CB_baudrate.Items.Add("4800");
			CB_baudrate.Items.Add("9600");
			CB_baudrate.Items.Add("19200");
			CB_baudrate.Items.Add("38400");
			CB_baudrate.Items.Add("57600");
			CB_baudrate.Items.Add("115200");
			CB_baudrate.SelectedIndex = 5;
			
			CB_time_stopuhr_rs232.Items.Add("Start/Stop CD");
			CB_time_stopuhr_rs232.Items.Add("Start/Stop CTS");
			CB_time_stopuhr_rs232.Items.Add("Start/Stop DSR");
			CB_time_stopuhr_rs232.Items.Add("nur Start CD");
			CB_time_stopuhr_rs232.Items.Add("nur Start CTS");
			CB_time_stopuhr_rs232.Items.Add("nur Start DSR");
			CB_time_stopuhr_rs232.Items.Add("nur Stop CD");
			CB_time_stopuhr_rs232.Items.Add("nur Stop CTS");
			CB_time_stopuhr_rs232.Items.Add("nur Stop DSR");
			CB_time_stopuhr_rs232.SelectedIndex = 0;
			
			CB_time_countdown_rs232.Items.Add("Set RTS");
			CB_time_countdown_rs232.Items.Add("Set DTR");
			CB_time_countdown_rs232.Items.Add("Send Byte");
			CB_time_countdown_rs232.Items.Add("Send Text");
			CB_time_countdown_rs232.SelectedIndex = 0;
			
			for (int i = 0;i<60;i++ ) {
				CB_countdown_H.Items.Add(i.ToString());
				CB_countdown_M.Items.Add(i.ToString());
				CB_countdown_S.Items.Add(i.ToString());
			}
			CB_countdown_H.SelectedIndex = 0;
			CB_countdown_M.SelectedIndex = 0;
			CB_countdown_S.SelectedIndex = 10;
			
			CB_Port.Items.Add("1");CB_Port.Items.Add("2");CB_Port.Items.Add("3");
			CB_Port.Items.Add("4");CB_Port.Items.Add("5");CB_Port.Items.Add("6");
			//Standard ist ASCII
			//Bytes über 127 erzeugen einen Paritätsfehler und werden als
			//63 übertragen. Mit Encoding.Default werden Bytes ordentlich versendet.
			SP.Encoding = System.Text.Encoding.Default;
			Version(); //Titel aktualisieren
		}
		void Main_Saveto_txt(string Dateiname, string Inhalt)
		{
			if (File.Exists(Dateiname)) {
				//wenn die Datei schon existiert
				//fragen, ob der Inhalt hinhalt hinzugefügt werden soll
				DialogResult result = MessageBox.Show(Dateiname + " existiert schon.\r\n"
					+ "Soll der aktuelle Inhalt\r\nhinzugefügt werden?","Als TXT speichern", MessageBoxButtons.YesNo, MessageBoxIcon.Question,MessageBoxDefaultButton.Button1);
				if (result != DialogResult.Yes) {
					// wenn nicht auf JA gedrückt wird -> Abbruch
					return;
				}
			}
			TextWriter txt = new StreamWriter(Dateiname,true); //datei erstellen oder inhalt hinzufügen
			txt.Write(Inhalt); //datei befüllen
			txt.Close(); //datei schließen (hebt sperrung für andere Programme auf)
			MessageBox.Show(Dateiname+" erstellt.\r\n" +
			                "Eingefügte Zeichen: "+Inhalt.Length.ToString(),"Als TXT speichern");
		}
		
		void Btn_main_allClick(object sender, EventArgs e)
		{
			//da alle Schaltflächen auf dem Maintab die gleiche
			//funktion ansprechen, muss beim Aufruf das Objekt erkannt werden
			
			//dazu den auslöser als schaltfläche definieren
			Button btn = sender as Button;
			//da alle durchnummeriert sind, den platz der Zahl als
			//string ausgeben und vergleichen
			switch (btn.Name[9].ToString()) {
				case "0": //exit
					Application.Exit(); break;
				case "1": //conv 1
					tabControl_main.SelectedIndex = 1; break;
				case "2": //conv 2
					tabControl_main.SelectedIndex = 2; break;
				case "3": //rs-232
					tabControl_main.SelectedIndex = 3; break;
				case "4": //Timer
					tabControl_main.SelectedIndex = 4; break;	
			}
		}
		#endregion
		
		#region Tab_RS232
		//Allgemein
		void Btn_sendClick(object sender, EventArgs e)
		{
			if (btn_open.BackColor != Color.Lime) {
				//Port ist geschlossen, daher nur kurz zum senden öffen
				try {
					switch (CB_baudrate.SelectedIndex) { //baudrate aktualisieren
						case 0://4800
							SP.BaudRate = 4800; break;
						case 1://9600
							SP.BaudRate = 9600; break;
						case 2://19200
							SP.BaudRate = 19200; break;
						case 3://38400
							SP.BaudRate = 38400; break;
						case 4://57600
							SP.BaudRate = 57600; break;
						case 5://115200
							SP.BaudRate = 115200; break;
						default:
							throw new Exception("Baudrate nicht definiert.");
					}
					SP.PortName = txt_Port.Text; //Portname aktualisieren
					SP.Open();
					label_status.BackColor = Color.Lime;
					label_status.Refresh();
				} catch (Exception err) {
					//erkannte Fehler ausgeben und Abbruch...
					SP.Close();
					label_status.Text = err.Message;
					label_status.BackColor = Color.Red;
					return;
				}
			}
			//port ist offen
			if (Sel_SendText.Checked) {
				is_sending = true;
				SP.Write(txt_send_text.Text); //als Text senden
				label_status.Text = "Send: " + txt_send_text.Text;
				if (CHK_write_send.Checked) {
					//gesendete daten in die
					//textbox schreiben
					recived_last = false;
					txt_recive.Text += "\r\nSend:\r\n	"+txt_send_text.Text;
					txt_recive.Focus();
					txt_recive.Select(txt_recive.Text.Length,0);
					txt_recive.ScrollToCaret();
				}
				is_sending = false;
				//da der Empfang kurz unterbunden wurde
				//aktualsieren
				Data_recived(SP.ReadExisting());
			} else if (Sel_SendBytes.Checked){ //als Bytes senden (mit Sendepause)
				try {
					//buffer befüllen
					string[] split_s = txt_send_byte.Text.Split(' ');
					byte[] buffer = new byte[split_s.Length];
					is_sending = true;
					for (int i = 0; i<split_s.Length; i++) {
						buffer[i] = byte.Parse(split_s[i]);
						SP.Write(buffer,i,1);
						Thread.Sleep(5);
					}
					//alle Bytes erfolgreich erkannt und gesendet
					label_status.Text = "Send: " + txt_send_byte.Text;
					if (CHK_write_send.Checked) {
						recived_last = false;
						txt_recive.Text += "\r\nSend:\r\n	"+txt_send_byte.Text;
						txt_recive.Focus();
						txt_recive.Select(txt_recive.Text.Length,0);
						txt_recive.ScrollToCaret();
					}
					is_sending = false;
					//da der Empfang kurz unterbunden wurde
					//aktualsieren
					Data_recived(SP.ReadExisting());
				} catch (Exception err) {
					//erkannte Fehler ausgeben...
					is_sending = false;
					label_status.Text = err.Message;
					label_status.BackColor = Color.Red;
				}
			}
			if (btn_open.BackColor != Color.Lime) {
				//Port war geschlossen, daher wieder schließen
				//schließen..
				SP.Close();
				label_status.BackColor = Color.Gainsboro;
				btn_open.BackColor = Color.Gainsboro;
			}
			
		}
		void TabControl3SelectedIndexChanged(object sender, EventArgs e)
		{
			//zum darstellen der Graphen, wenn auf den Tab geschaltet wird
			if (tabControl_rs232.SelectedIndex == 2) {
				Application.DoEvents();
				Draw_graph1_Fortlaufend(0);
			}
			if (tabControl_rs232.SelectedIndex == 3) {
				Application.DoEvents();
				Daten_Graph2_erstellen();
				Draw_graph2();
			}
			//MessageBox.Show(tabControl3.SelectedIndex.ToString());
		}
		
		//Tab Setup
		void CB_PortSelectedIndexChanged(object sender, EventArgs e)
		{
			//Zum wechsel des Port ohne Tastatur
			txt_Port.Text = "COM"+(CB_Port.SelectedIndex+1).ToString();
		}
		void Btn_openClick(object sender, EventArgs e)
		{
			if (btn_open.BackColor == Color.Lime) {
				//Port ist offen -> schließen
				SP.Close();
				label_status.Text = "Port geschlossen";
				label_status.BackColor = Color.Gainsboro;
				btn_open.BackColor = Color.Gainsboro;
			} else {
				//Port ist geschlossen -> versuchen zu öffen
				try {
					switch (CB_baudrate.SelectedIndex) { //baudrate aktualisieren
						case 0://4800
							SP.BaudRate = 4800; break;
						case 1://9600
							SP.BaudRate = 9600; break;
						case 2://19200
							SP.BaudRate = 19200; break;
						case 3://38400
							SP.BaudRate = 38400; break;
						case 4://57600
							SP.BaudRate = 57600; break;
						case 5://115200
							SP.BaudRate = 115200; break;
						default:
							throw new Exception("Baudrate nicht definiert.");
					}
					SP.PortName = txt_Port.Text; //Portname aktualisieren
					SP.Open();
					Refresh_pins_at_label();
					//was ab hier kommt wird nur ausgefürt, wenn es keine Fehler gab
					//der Port ist also offen. Noch ein paar optische infos...
					label_status.Text = SP.PortName + "(" + SP.BaudRate.ToString() + ") is Open.";
					label_status.BackColor = Color.Lime;
					btn_open.BackColor = Color.Lime;
				} catch (Exception err) {
					//erkannte Fehler ausgeben...
					label_status.Text = err.Message;
					label_status.BackColor = Color.Red;
					btn_open.BackColor = Color.Red;
				}
			}
		}
		void Btn_rs232_RTSClick(object sender, EventArgs e)
		{
			//Steuerleitung vom Port
			if (btn_rs232_RTS.BackColor == Color.Lime) {
				SP.RtsEnable = false;
				btn_rs232_RTS.BackColor = Color.Gainsboro;
			} else {
				SP.RtsEnable = true;
				btn_rs232_RTS.BackColor = Color.Lime;
			}
		}
		void Btn_rs232_DTRClick(object sender, EventArgs e)
		{
			//Steuerleitung vom Port
			if (btn_rs232_DTR.BackColor == Color.Lime) {
				SP.DtrEnable = false;
				btn_rs232_DTR.BackColor = Color.Gainsboro;
			} else {
				SP.DtrEnable = true;
				btn_rs232_DTR.BackColor = Color.Lime;
			}
		}
		
		//Tab Recive
		void Btn_clearClick(object sender, EventArgs e)
		{
			txt_recive.Text = "";
		}
		void Btn_SaveClick(object sender, EventArgs e)
		{
			Main_Saveto_txt("RS232_data.txt",txt_recive.Text);
		}
		
		//Tab Graph1
		void CB_RS232_G1_DatenaufnahmeSelectedValueChanged(object sender, EventArgs e)
		{
			//die Combobox über dem Graph legt fest,
			//wann dieser aktualisiert wird
			switch (CB_RS232_G1_Datenaufnahme.SelectedIndex) {
				case 0: //Inaktiv
					timer_G1.Enabled = false;
					Graph1_OnChange = false; break;
				case 1: //bei Änderung
					timer_G1.Enabled = false;
					Graph1_OnChange = true; break;
				case 2: //Auto: 0.1 Sek
					timer_G1.Interval = 100;
					timer_G1.Enabled = true;
					Graph1_OnChange = false; break;
				case 3: //Auto: 0.5 Sek
					timer_G1.Interval = 500;
					timer_G1.Enabled = true;
					Graph1_OnChange = false; break;
				case 4: //Auto: 1 Sek
					timer_G1.Interval = 1000;
					timer_G1.Enabled = true;
					Graph1_OnChange = false; break;
				case 5: //Auto: 5 Sek
					timer_G1.Interval = 5000;
					timer_G1.Enabled = true;
					Graph1_OnChange = false; break;
				default:
					MessageBox.Show("noch nicht Eingebaut...");
					break;
			}
			if (Data_CD.Count > 200) {
				Scroll_Graph1.Maximum = Data_CD.Count - 200;
				Scroll_Graph1.Value = Scroll_Graph1.Maximum;
			}
			Draw_graph1_Fortlaufend(0);
			Graphrange = 0;
			if ((CB_RS232_G1_Datenaufnahme.SelectedIndex > 1)&&!SP.IsOpen) {
				//Automatik aktiv aber Port geschlossen
				timer_G1.Enabled = false;
				label_status.Text = "Autorun abgeschaltet da Port geschlossen.";
				label_status.BackColor = Color.Gold;
				CB_RS232_G1_Datenaufnahme.SelectedIndex = 0;
			}
		}
		void Scroll_Graph1ValueChanged(object sender, EventArgs e)
		{
			//Verlauf der Daten anzeigen
			int data = Scroll_Graph1.Maximum - Scroll_Graph1.Value;
			Draw_graph1_Fortlaufend(data);
		}
		void Btn_RS232_G1_ClearClick(object sender, EventArgs e)
		{
			//daten löschen
			Data_CD.Clear();
			Data_CTS.Clear();
			Data_DSR.Clear();
			//anzeige frei machen
			Graphics G = panel_graph1.CreateGraphics();
			Pen P_B = new Pen(Color.Black, 90);
			G.DrawLine(P_B,0,45,234,45);
			Graphrange = 0;
			//Label und Scrollbar zurücksetzen
			label_Messpunkte.Text = "-";
			Scroll_Graph1.Value = 0;
			Scroll_Graph1.Maximum = 1;
		}
		void Btn_RS232_G1_toTXTClick(object sender, EventArgs e)
		{
			if (Data_CD.Count < 2) {
				MessageBox.Show("Zu wenig Messpunkte...");
				return;
			}
			//string mit Dateninhalt erstellen
			string output = "Messpunkte: "+(Data_CD.Count).ToString()+"\r\n";
			for (int i = 0;i < Data_CD.Count;i++ ) {
				output += Data_CD[i].ToString()+",";
				output += Data_CTS[i].ToString()+",";
				output += Data_DSR[i].ToString()+"\r\n";
			}
			//als Datei speichern
			Main_Saveto_txt("Steuerleitungen.txt",output);
		}
		void Timer_G1Tick(object sender, EventArgs e)
		{
			if (!SP.IsOpen) {
				//Port ist geschlossen
				timer_G1.Enabled = false;
				CB_RS232_G1_Datenaufnahme.SelectedIndex = 0;
				MessageBox.Show("Timer1 läuft aber Port ist geschlossen");
				return;
			}
			Refresh_pins_at_graph();
			label_Messpunkte.Text = Data_CD.Count.ToString();
		}
		
		void Draw_graph1_Fortlaufend(int offset)
		{
			if (Data_CD.Count < 3) {
				return;
			}
			Graphics G = panel_graph1.CreateGraphics();
			
			int n = 1;
			int last_CD = (int)(((decimal)Data_CD[Data_CD.Count-1-offset]/1)*26);
			int last_CTS = (int)(((decimal)Data_CTS[Data_CTS.Count-1-offset]/1)*26);
			int last_DSR = (int)(((decimal)Data_DSR[Data_DSR.Count-1-offset]/1)*26);
			
			//daten von hinten nach vorn zeichnen
			for (int i = 200;i > 1;i--) {
				//clear
				Pen P_B = new Pen(Color.Black, 1);
				G.DrawLine(P_B,i-1,0,i-1,190);
				//background
				Pen P_Gr = new Pen(Color.Gray, 1);
				G.DrawLine(P_Gr,i-1,29,i,29);
				G.DrawLine(P_Gr,i-1,59,i,59);
				//daten
				Pen P_G = new Pen(Color.Lime, 1);
				int New_CD = (int)(((decimal)Data_CD[Data_CD.Count-n-offset]/1)*26);
				int New_CTS = (int)(((decimal)Data_CTS[Data_CTS.Count-n-offset]/1)*26);
				int New_DSR = (int)(((decimal)Data_DSR[Data_DSR.Count-n-offset]/1)*26);
				
				//um ein sauberes rechteck darzustellen,
				//bei änderungen anders zeichnen
				if (New_CD != last_CD) {
     				G.DrawLine(P_G,i, 27-New_CD,i, 27-last_CD);
     			} else {
     				G.DrawLine(P_G,i-1, 27-New_CD,i, 27-last_CD);
     			}
     			if (New_CTS != last_CTS) {
     				G.DrawLine(P_G,i, 57-New_CTS,i, 57-last_CTS);
     			} else {
     				G.DrawLine(P_G,i-1, 57-New_CTS,i, 57-last_CTS);
     			}
     			if (New_DSR != last_DSR) {
     				G.DrawLine(P_G,i, 87-New_DSR,i, 87-last_DSR);
     			} else {
     				G.DrawLine(P_G,i-1, 87-New_DSR,i, 87-last_DSR);
     			}
				
				//der aktuelle wird zum letzten Messwert
     			last_CD = New_CD; last_CTS = New_CTS; last_DSR = New_DSR;
     			
     			if (i == 200) {
     				//beim ersten durchlauf die Legende rechts zeichnen
     				Pen P_B2 = new Pen(Color.Black, 32);
     				Font f = new Font("Arial", 8,FontStyle.Regular);
     				SolidBrush br = new SolidBrush(Color.Lime);
					G.DrawLine(P_B2,215,0,215,190);
					G.DrawString("CT",f,br,202,7);
					G.DrawString("CTS",f,br,202,34);
					G.DrawString("DSR",f,br,202,61);
				}
	 			n++;
	 			if (Data_CD.Count == n) {
	 				//alle vorhandenen daten sind dargestellt,
	 				//abbruch...
	  				break;
	  			}
			}
		}
		void Draw_graph1_Selektiv()
		{
			if (Data_CD.Count < 3) {
				return;
			}
			Graphics G = panel_graph1.CreateGraphics();
			
			int last_CD = (int)(((decimal)Data_CD[Data_CD.Count-1]/1)*26);
			int last_CTS = (int)(((decimal)Data_CTS[Data_CTS.Count-1]/1)*26);
			int last_DSR = (int)(((decimal)Data_DSR[Data_DSR.Count-1]/1)*26);
			
			//clear
			Pen P_B = new Pen(Color.Black, 1);
			Pen P_W = new Pen(Color.White, 1);
			G.DrawLine(P_B,Graphrange,0,Graphrange,190);
			G.DrawLine(P_W,Graphrange+1,0,Graphrange+1,190);
			//background
			Pen P_Gr = new Pen(Color.Gray, 1);
			G.DrawLine(P_Gr,Graphrange-1,29,Graphrange,29);
			G.DrawLine(P_Gr,Graphrange-1,59,Graphrange,59);
			//daten
			Pen P_G = new Pen(Color.Lime, 1);
			int New_CD = (int)(((decimal)Data_CD[Data_CD.Count-2]/1)*26);
			int New_CTS = (int)(((decimal)Data_CTS[Data_CTS.Count-2]/1)*26);
			int New_DSR = (int)(((decimal)Data_DSR[Data_DSR.Count-2]/1)*26);
			
     		//um ein sauberes rechteck darzustellen,
			//bei änderungen anders zeichnen
 			if (New_CD != last_CD) {
 				G.DrawLine(P_G,Graphrange, 27-New_CD,Graphrange, 27-last_CD);
 			} else {
 				G.DrawLine(P_G,Graphrange-1, 27-New_CD,Graphrange, 27-last_CD);
 			}
 			if (New_CTS != last_CTS) {
 				G.DrawLine(P_G,Graphrange, 57-New_CTS,Graphrange, 57-last_CTS);
 			} else {
 				G.DrawLine(P_G,Graphrange-1, 57-New_CTS,Graphrange, 57-last_CTS);
 			}
 			if (New_DSR != last_DSR) {
 				G.DrawLine(P_G,Graphrange, 87-New_DSR,Graphrange, 87-last_DSR);
 			} else {
 				G.DrawLine(P_G,Graphrange-1, 87-New_DSR,Graphrange, 87-last_DSR);
 			}
			
			//der aktuelle wird zum letzten Messwert
 			last_CD = New_CD; last_CTS = New_CTS; last_DSR = New_DSR;
 			
 			if (Graphrange == 0) {
	 			//beim ersten durchlauf die Legende rechts zeichnen
				Pen P_B2 = new Pen(Color.Black, 32);
				Font f = new Font("Arial", 8,FontStyle.Regular);
				SolidBrush br = new SolidBrush(Color.Lime);
				
				G.DrawLine(P_B2,215,0,215,190);
				G.DrawString("CT",f,br,202,7);
				G.DrawString("CTS",f,br,202,34);
				G.DrawString("DSR",f,br,202,61);
 			}
 			//Messlienie nach rechts verschieben
			Graphrange++;
			if (Graphrange == 200) {
				//wenn an der Legende angelagt,
				//wieder von vorn Anfangen
				Graphrange = 0;
			}
		}
		
		//Tab Graph2
		void Btn_Graph2_runClick(object sender, EventArgs e)
		{
			//schaltet den Signalgenerator an
			if (btn_Graph2_run.BackColor == Color.Lime) {
				timer_G2.Enabled = false;
				btn_Graph2_run.BackColor = Color.Gainsboro;
			} else {
				//Zähler zurrücksetzen
				Peakrange1 = 0;
				Perioderange1 = 0;
				Peakrange2 = 0;
				Perioderange2 = 0;
				if (SP.IsOpen) {
					timer_G2.Enabled = true;
					btn_Graph2_run.BackColor = Color.Lime;
				} else {
					btn_Graph2_run.BackColor = Color.Red;
					label_status.Text = "Taktgenerator abgeschaltet,\r\nda Port geschlossen.";
					label_status.BackColor = Color.Gold;
				}
				
			}
		}
		void Scroll_RTS_PeakValueChanged(object sender, EventArgs e)
		{
			Daten_Graph2_erstellen(); Draw_graph2();
		}
		void Scroll_RTS_PeriodeValueChanged(object sender, EventArgs e)
		{
			int data = Scroll_RTS_Periode.Value+9;
			//Peak darf nur maximal die größer der
			//Periode haben
			if (Scroll_RTS_Peak.Value > data) {
				Scroll_RTS_Peak.Value = data;
			}
			Scroll_RTS_Peak.Maximum = data;
			
			Daten_Graph2_erstellen(); Draw_graph2();
		}
		void Scroll_DTR_PeakValueChanged(object sender, EventArgs e)
		{
			Daten_Graph2_erstellen(); Draw_graph2();
		}
		void Scroll_DTR_PeriodeValueChanged(object sender, EventArgs e)
		{
			int data = Scroll_DTR_Periode.Value+9;
			//Peak darf nur maximal die größer der
			//Periode haben
			if (Scroll_DTR_Peak.Value > data) {
				Scroll_DTR_Peak.Value = data;
			}
			Scroll_DTR_Peak.Maximum = data;
			Daten_Graph2_erstellen(); Draw_graph2();
		}
		void Timer_G2Tick(object sender, EventArgs e)
		{
			//RTS #################################
			if ((Peakrange1 == 0) && (Perioderange1 == 0)) {
				//beide zähler auf 0
				//neue Periode anfangen
				Peakrange1 = Scroll_RTS_Peak.Value;
				Perioderange1 = Scroll_RTS_Periode.Value-Peakrange1;
				label_RTS.BackColor = Color.Lime;
				SP.RtsEnable = true;
			}
			if (Peakrange1 > 0) {
				Peakrange1--;
			} else {
				//peakzähler abgleaufen
				//Steuerleitung abschalten und Pausenzähler
				//herunterzählen
				label_RTS.BackColor = Color.Gainsboro;
				SP.RtsEnable = false;
				Perioderange1--;
			}
			
			//DTR #################################
			if ((Peakrange2 == 0) && (Perioderange2 == 0)) {
				//beide zähler auf 0
				//neue Periode anfangen
				Peakrange2 = Scroll_DTR_Peak.Value;
				Perioderange2 = Scroll_DTR_Periode.Value-Peakrange2;
				label_DTR.BackColor = Color.Lime;
				SP.DtrEnable = true;
			}
			if (Peakrange2 > 0) {
				Peakrange2--;
			} else {
				//peakzähler abgleaufen
				//Steuerleitung abschalten und Pausenzähler
				//herunterzählen
				label_DTR.BackColor = Color.Gainsboro;
				SP.DtrEnable = false;;
				Perioderange2--;
			}
		}
		
		void Daten_Graph2_erstellen()
		{
			int Peak1 = Scroll_RTS_Peak.Value;
			int Periode1 = Scroll_RTS_Periode.Value;
			int Peak2 = Scroll_DTR_Peak.Value;
			int Periode2 = Scroll_DTR_Periode.Value;
			Data_DTR.Clear();
			Data_RTS.Clear();
			
			//RTS start
			for (int i = 0;i < 3;i++) {
				Data_RTS.Add(0);
			}
			//RTS Daten auffüllen
			while (Data_RTS.Count < 205) {
				//Peak
				for (int i = 0;i < Peak1;i++) {
					Data_RTS.Add(1);
				}
				//Pause
				for (int i = 0;i < (Periode1-Peak1);i++) {
					Data_RTS.Add(0);
				}
			}
			
			//DTR start
			for (int i = 0;i < 3;i++) {
				Data_DTR.Add(0);
			}
			//DTR Daten auffüllen
			while (Data_DTR.Count < 205) {
				//Peak
				for (int i = 0;i < Peak2;i++) {
					Data_DTR.Add(1);
				}
				//Pause
				for (int i = 0;i < (Periode2-Peak2);i++) {
					Data_DTR.Add(0);
				}
			}
		}
		void Draw_graph2()
		{
			//Variablen erstellen und Infobox befüllen
			decimal Peak1 = (decimal)Scroll_RTS_Peak.Value/10;
			decimal Periode1 = (decimal)Scroll_RTS_Periode.Value/10;
			decimal Peak2 = (decimal)Scroll_DTR_Peak.Value/10;
			decimal Periode2 = (decimal)Scroll_DTR_Periode.Value/10;
			txt_Graph2_info.Text = "Graph ca. 20 Sec\r\n";
			txt_Graph2_info.Text += "RTS Puls: "+Math.Round(Peak1,1).ToString()+" Sec\r\n";
			txt_Graph2_info.Text += "RTS Periode: "+Math.Round(Periode1,1).ToString()+" Sec\r\n";
			txt_Graph2_info.Text += "DTR Puls: "+Math.Round(Peak2,1).ToString()+" Sec\r\n";
			txt_Graph2_info.Text += "DTR Periode: "+Math.Round(Periode2,1).ToString()+" Sec";
			
			
			Graphics G = panel_graph2.CreateGraphics();
			//anzeige frei machen
			Pen P_B = new Pen(Color.Black, 90);
			G.DrawLine(P_B,0,45,234,45);
			//background
			Pen P_Gr = new Pen(Color.Gray, 1);
			G.DrawLine(P_Gr,0,29,205,29);
			//Legende rechts
			Pen P_B2 = new Pen(Color.Black, 28);
			Font f = new Font("Arial", 8,FontStyle.Regular);
			SolidBrush br = new SolidBrush(Color.Lime);
			G.DrawLine(P_B2,220,0,220,190);
			G.DrawString("RTS",f,br,208,7);
			G.DrawString("DTR",f,br,208,34);
			
			int last_RTS = (int)(((decimal)Data_RTS[0]/1)*26);
			int last_DTR = (int)(((decimal)Data_DTR[0]/1)*26);
			
			for (int i = 1;i < 205;i++) {
				//daten zeichnen
				Pen P_G = new Pen(Color.Lime, 1);
				int New_RTS = (int)(((decimal)Data_RTS[i]/1)*26);
				int New_DTR = (int)(((decimal)Data_DTR[i]/1)*26);
				
     			if (New_RTS != last_RTS) {
     				G.DrawLine(P_G,i, 27-New_RTS,i, 27-last_RTS);
     			} else {
     				G.DrawLine(P_G,i+1, 27-New_RTS,i, 27-last_RTS);
     			}
     			if (New_DTR != last_DTR) {
     				G.DrawLine(P_G,i, 57-New_DTR,i, 57-last_DTR);
     			} else {
     				G.DrawLine(P_G,i+1, 57-New_DTR,i, 57-last_DTR);
     			}
				
     			last_RTS = New_RTS; last_DTR = New_DTR;
			}
		}
		//RS232 daten Empfangen
		void SPDataReceived(object sender, SerialDataReceivedEventArgs e)
		{
			//MessageBox.Show(e.EventType.ToString()); //test
			if (is_sending) {
				return; //nicht wärend des sendens, empfangenes auswerten
			}
			string data = SP.ReadExisting();
			//Diese Funktion wird aus einem anderen Thread aufgerufen,
			//damit auf Steuerelemente aus diesem zugegriffen werden kann,
			//muss ein neuer Zugriff auf eine Funktion erstellt werden.
			//Der Zugriff verfällt, nachdem die Funktion durchlaufen ist.
			//darum wird er mit "new" immer wieder neu erstellt...
			this.BeginInvoke(new Data_recived_delegate(Data_recived), new object[] { data }); 
		}
		void SPPinChanged(object sender, SerialPinChangedEventArgs e)
		{
			this.BeginInvoke(new Pin_Changed_delegate(Refresh_pins_at_label)); 
		}
		void Refresh_pins_at_label()
		{
			//Steuerleitungslabels aktualisieren
			if (SP.CDHolding) {
				label_CD.BackColor = Color.Lime;
			} else {
				label_CD.BackColor = Color.Gainsboro;
			}
			if (SP.CtsHolding) {
				label_CTS.BackColor = Color.Lime;
			} else {
				label_CTS.BackColor = Color.Gainsboro;
			}
			if (SP.DsrHolding) {
				label_DSR.BackColor = Color.Lime;
			} else {
				label_DSR.BackColor = Color.Gainsboro;
			}
			if (Graph1_OnChange) {
				//im graph darstellen, falls aktiviert
				Refresh_pins_at_graph();
			}
//			MessageBox.Show("Pin Changed");
		}
		void Refresh_pins_at_graph()
		{
			//Steuerleitungszustand als
			//daten aufnehmen
			if (SP.CDHolding) {
				Data_CD.Add(1);
			} else {
				Data_CD.Add(0);
			}
			if (SP.CtsHolding) {
				Data_CTS.Add(1);
			} else {
				Data_CTS.Add(0);
			}
			if (SP.DsrHolding) {
				Data_DSR.Add(1);
			} else {
				Data_DSR.Add(0);
			}
			//für Stopuhr
			if (CHK_time_stopuhr_rs232E.Checked) {
				switch (CB_time_stopuhr_rs232.SelectedIndex) {
					case 0: //Start/Stop CD
						if (SP.CDHolding) {
							Btn_time_stopuhr_startClick(null,null);
						} else {
							Btn_time_stopuhr_stopClick(null,null);
						}
						break;
					case 1: //Start/Stop CTS
						if (SP.CtsHolding) {
							Btn_time_stopuhr_startClick(null,null);
						} else {
							Btn_time_stopuhr_stopClick(null,null);
						}
						break;
					case 2: //Start/Stop DSR
						if (SP.DsrHolding) {
							Btn_time_stopuhr_startClick(null,null);
						} else {
							Btn_time_stopuhr_stopClick(null,null);
						}
						break;
					case 3: //nur Start CD
						if (SP.CDHolding) {
							Btn_time_stopuhr_startClick(null,null);
						}
						break;
					case 4: //nur Start CTS
						if (SP.CtsHolding) {
							Btn_time_stopuhr_startClick(null,null);
						}
						break;
					case 5: //nur Start DSR
						if (SP.DsrHolding) {
							Btn_time_stopuhr_startClick(null,null);
						}
						break;
					case 6: //nur Stop CD
						if (SP.CDHolding) {
							Btn_time_stopuhr_stopClick(null,null);
						}
						break;
					case 7: //nur Stop CTS
						if (SP.CtsHolding) {
							Btn_time_stopuhr_stopClick(null,null);
						}
						break;
					case 8: //nur Stop DSR
						if (SP.DsrHolding) {
							Btn_time_stopuhr_stopClick(null,null);
						}
						break;
				}
			}
			if (CB_RS232_G1_Datenaufnahme.SelectedIndex > 0) {
				//Graph zeichnen
				if (CHK_RS232_G1_fort.Checked) {
					Draw_graph1_Fortlaufend(0);
				} else {
					Draw_graph1_Selektiv();
				}
			}
		}
		void Data_recived(string text)
		{
			//wie gesendet wird, so soll auch empfangen werden...
			if (Sel_SendText.Checked) {
				//falls zuletzt was gesendet wurde,
				//zusätzlich einen "Recived:" reinschreiben
				if (recived_last) {
					txt_recive.Text += text; //text ausgeben
				} else {
					txt_recive.Text += "\r\nRecived:\r\n	"+text;//text ausgeben
				}
			} else if (Sel_SendBytes.Checked) {
				char[] chars = text.ToCharArray(); //text in Zeichenarray
				byte[] bytes = new byte[text.Length]; //Bytearray in der größe der Zeichenmenge
				bytes = UnicodeEncoding.Default.GetBytes(chars); //Zeichen in Bytes umwandeln
				string text_s = "";
				foreach (byte B in bytes) {
					text_s += " " + B.ToString(); //Jedes Byte ausgeben
				}
				if (recived_last) {
					txt_recive.Text += text_s;
				} else {
					txt_recive.Text += "\r\nRecived:\r\n	"+text_s;
				}
			}
			recived_last = true;
			//Letztes zeichen markieren und da hin scrollen,
			//bewirkt ein "mitlaufen" der Textbox
			txt_recive.Focus();
			txt_recive.Select(txt_recive.Text.Length,0);
			txt_recive.ScrollToCaret();
			
			label_status.Text = "Letzter Datenempfang (" + DateTime.Now.ToLongTimeString() + ")";
		}
		#endregion
		
		#region Tab_Conv1_16bit
		//Schaltflächen
		void Btn_convertClick(object sender, EventArgs e)
		{
			//festlegen, von wo convertiert wird
			if (Sel_bin.Checked) {
				convert_bin();
			} else if (Sel_dec.Checked) {
				convert_Dec();
			} else if (Sel_hex.Checked) {
				convert_Hex();
			}
		}
		void Btn_convert_saveClick(object sender, EventArgs e)
		{
			Main_Saveto_txt("conv1_16bit.txt",txt_convert.Text);
		}
		void Btn_conv_clearClick(object sender, EventArgs e)
		{
			txt_convert.Text = "";
		}
		void Txt_conv_in_hexKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData == Keys.Enter) {
				Sel_hex.Checked = true;
				Application.DoEvents();
				Btn_convertClick(null,null);
				txt_conv_in_hex.Select(2,2);
			}
		}
		void Txt_conv_in_decKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData == Keys.Enter) {
				Sel_dec.Checked = true;
				Application.DoEvents();
				Btn_convertClick(null,null);
				txt_conv_in_dec.SelectAll();
			}
		}
		
		//Funktionen
		void convert_Hex() {
			try {
				int dec = 0;
				dec = Convert.ToUInt16(txt_conv_in_hex.Text,16);
				//ausgabe der erzeugten Dezimalzahl
				byte[] bytes = BitConverter.GetBytes(dec);
				string Hex_s = BitConverter.ToString(bytes).Replace("-", "").Remove(4,4);
				string Conv = ">Hex:	0x"+Hex_s[2]+Hex_s[3]+Hex_s[0]+Hex_s[1];
				Conv += "\r\nDezi:	"+dec.ToString();
				Conv += "\r\nBinär:	"+conv_int_to_bin_16bit(dec)+"\r\n\r\n";
				txt_convert.Text = Conv + txt_convert.Text;
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Convert");
			}
		}
		void convert_Dec() {
			try {
				int dec = int.Parse(txt_conv_in_dec.Text);
				if (dec > 65535) {
					MessageBox.Show("Dezimalzahl ist zu groß.","Convert");
					return;
				}
				//ausgabe der erzeugten Dezimalzahl
				byte[] bytes = BitConverter.GetBytes(dec);
				string Hex_s = BitConverter.ToString(bytes).Replace("-", "").Remove(4,4);
				string Conv = "Hex:	0x"+Hex_s[2]+Hex_s[3]+Hex_s[0]+Hex_s[1];
				Conv += "\r\n>Dezi:	"+dec.ToString();
				Conv += "\r\nBinär:	"+conv_int_to_bin_16bit(dec)+"\r\n\r\n";
				txt_convert.Text = Conv + txt_convert.Text;
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Convert");
			}
		}
		void convert_bin() {
			try {
				int dec = 0;
				int wert = 1;
				//aus dem Zustand der Checkboxen eine Dezimalzahl erzeugen
				for (int i = 0;i < 16;i++ ) {
					//16 durchläufe für 16 bit
					foreach (Control C in TP_Conv1.Controls) {
						//für jedes element auf der Convert 1 Tabseite:
						//fragen ob der name Passt
						if (C.Name == "CB_conv_bit" + (i).ToString()) {
							//wenn ja, element als Checkbox deklarieren
							CheckBox CHK = C as CheckBox;
							if (CHK.Checked) {
								//wenn häckchen, dann den Wert dazu addieren
								dec += wert;
							}
							//wert wird immer mit 2 Multipiziert:
							//1,2,4,8,16,32,64,128...usw
							//so wird die wertigkeit der Checkbox in die Zahl umgesetzt
							wert = wert * 2;
							break; //da element gefunden, nicht weiter danach suchen...
						}
					}
				}
				//ausgabe der erzeugten Dezimalzahl
				byte[] bytes = BitConverter.GetBytes(dec);
				string Hex_s = BitConverter.ToString(bytes).Replace("-", "").Remove(4,4);
				string Conv = "Hex:	0x"+Hex_s[2]+Hex_s[3]+Hex_s[0]+Hex_s[1];
				Conv += "\r\nDezi:	"+dec.ToString();
				Conv += "\r\n>Binär:	"+conv_int_to_bin_16bit(dec)+"\r\n\r\n";
				txt_convert.Text = Conv + txt_convert.Text;
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Convert");
			}
		}
		string conv_int_to_bin_16bit(int data) {
			//dezimal in binärstring umwandeln
			string binary_s = "";
			if (data > 32767) { data-=32768; binary_s+="#"+" "; } else { binary_s+="_"+" "; }
			if (data > 16383) { data-=16384; binary_s+="#"+" "; } else { binary_s+="_"+" "; }
			if (data > 8191) { data-=8192; binary_s+="#"+" "; } else { binary_s+="_"+" "; }
			if (data > 4095) { data-=4096; binary_s+="#."+" "; } else { binary_s+="_."+" "; }
			if (data > 2047) { data-=2048; binary_s+="#"+" "; } else { binary_s+="_"+" "; }
			if (data > 1023) { data-=1024; binary_s+="#"+" "; } else { binary_s+="_"+" "; }
			if (data > 511) { data-=512; binary_s+="#"+" ";	} else { binary_s+="_"+" ";	}
			if (data > 255) { data-=256; binary_s+="#."+" ";	} else { binary_s+="_."+" ";	}
			if (data > 127) { data-=128; binary_s+="#"+" ";	} else { binary_s+="_"+" ";	}
			if (data > 63) { data-=64; binary_s+="#"+" ";	} else { binary_s+="_"+" ";	}
			if (data > 31) { data-=32; binary_s+="#"+" ";	} else { binary_s+="_"+" ";	}
			if (data > 15) { data-=16; binary_s+="#."+" ";	} else { binary_s+="_."+" ";	}
			if (data > 7) { data-=8; binary_s+="#"+" ";	} else { binary_s+="_"+" ";	}
			if (data > 3) { data-=4; binary_s+="#"+" ";	} else { binary_s+="_"+" ";	}
			if (data > 1) { data-=2; binary_s+="#"+" ";	} else { binary_s+="_"+" ";	}
			if (data > 0) { binary_s+="#";	} else { binary_s+="_";	}
			return binary_s; //text zurückgeben
		}
		#endregion
		
		#region Tab_Conv2_string
		//Schaltflächen
		void Btn_conv2_clearClick(object sender, EventArgs e)
		{
			txt_convert2.Text = "";
		}
		void Btn_convert2Click(object sender, EventArgs e)
		{
			//festlegen, von wo convertiert wird
			if (Sel_conv2_byte.Checked) {
				convert2_Byte();
			} else if (Sel_conv2_Hex.Checked) {
				convert2_Hex();
			} else if (Sel_conv2_Text.Checked) {
				convert2_txt();
			}
		}
		void Btn_convert2_saveClick(object sender, EventArgs e)
		{
			Main_Saveto_txt("conv2_string.txt",txt_convert2.Text);
		}
		void Txt_conv2_in_hexKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData == Keys.Enter) {
				Sel_conv2_Hex.Checked = true;
				Application.DoEvents();
				Btn_convert2Click(null,null);
			}
		}
		void Txt_conv2_in_decKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData == Keys.Enter) {
				Sel_conv2_byte.Checked = true;
				Application.DoEvents();
				Btn_convert2Click(null,null);
			}
		}
		void Txt_conv2_in_textKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData == Keys.Enter) {
				Sel_conv2_Text.Checked = true;
				Application.DoEvents();
				Btn_convert2Click(null,null);
			}
		}
		
		//Funktionen
		void convert2_Hex() {
			try {
				//textinhalt bei jedem Leerzeichen aufspalten
				string[] split_s = txt_conv2_in_hex.Text.Split(' ');
				byte[] buffer = new byte[split_s.Length]; //bytearray erstellen
				for (int i = 0; i<buffer.Length; i++) {
					buffer[i] = byte.Parse(split_s[i],System.Globalization.NumberStyles.HexNumber); //byte erfassen
				}
				conv2_Output(buffer); //umwandeln und ausgeben
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Convert 2");
			}
		}
		void convert2_Byte() {
			try {
				//textinhalt bei jedem Leerzeichen aufspalten
				string[] split_s = txt_conv2_in_dec.Text.Split(' ');
				byte[] buffer = new byte[split_s.Length]; //bytearray erstellen
				for (int i = 0; i<buffer.Length; i++) {
					buffer[i] = byte.Parse(split_s[i]); //byte erfassen
				}
				conv2_Output(buffer); //umwandeln und ausgeben
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Convert 2");
			}
		}
		void convert2_txt() {
			try {
				//textinhalt in Zeichenarray umsetzen
				char[] Chars = txt_conv2_in_text.Text.ToCharArray();
				byte[] buffer = UnicodeEncoding.Default.GetBytes(Chars);
				conv2_Output(buffer); //umwandeln und ausgeben
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Convert 2");
			}
		}
		void conv2_Output(byte[] buffer) 
		{
			//allgemeine Ausgabefunktion für Conv 2
			string buffer_b = "";
			string buffer_c = "";
			for (int i = 0; i<buffer.Length; i++) {
				//byte ausschreiben
				buffer_b += buffer[i].ToString()+" ";
				//sonderzeichen erfassen, falls aktiviert
				if (CHK_conv2_Sonderzeichen.Checked) {
					switch (buffer[i]) {
						case 0:
							buffer_c += "<NULL>"; break;
						case 9:
							buffer_c += "<TAB>"; break;
						case 10:
							buffer_c += "<LF>"; break;
						case 13:
							buffer_c += "<CR>"; break;
						case 32:
							buffer_c += "<SP>"; break;
						case 127:
							buffer_c += "<DEL>"; break;
						default:
							if (buffer[i] > 0) {
								buffer_c += ((Char)buffer[i]).ToString();
							} else {
								//char 0 löscht alles vorher im Text stehende
								buffer_c += "0";
							}
							break;
					}
				} else {
					if (buffer[i] > 0) {
						buffer_c += ((Char)buffer[i]).ToString();
					} else {
						//char 0 löscht alles vorher im Text stehende
						buffer_c += "0";
					}
				}
			}
			
			string hexstring = BitConverter.ToString(buffer).Replace('-', ' ');
			string Conv = "";
			//anzeigen, was das Quellformat war
			if (Sel_conv2_Hex.Checked) {
				Conv += ">Hex:	"+hexstring;
			} else {
				Conv += "Hex:	"+hexstring;
			}
			if (Sel_conv2_byte.Checked) {
				Conv += "\r\n>Byte:	"+buffer_b;
			} else {
				Conv += "\r\nByte:	"+buffer_b;
			}
			if (Sel_conv2_Text.Checked) {
				Conv += "\r\n>Text:	"+buffer_c+"\r\n\r\n";
			} else {
				Conv += "\r\nText:	"+buffer_c+"\r\n\r\n";
			}
			txt_convert2.Text = Conv + txt_convert2.Text;
		}
		#endregion
		
		#region Tab_Timer
		//stopuhr
		void Btn_time_stopuhr_startClick(object sender, EventArgs e)
		{
			timer_stopuhr.Enabled = true;
			label_stopuhr.BackColor = Color.Lime;
			btn_time_stopuhr_start.ForeColor = Color.LimeGreen;
		}
		void Btn_time_stopuhr_resetClick(object sender, EventArgs e)
		{
			label_stopuhr.Text = "0:00:00.0";
			stopuhr_h = 0;
			stopuhr_m = 0;
			stopuhr_s = 0;
		}
		void Btn_time_stopuhr_stopClick(object sender, EventArgs e)
		{
			timer_stopuhr.Enabled = false;
			label_stopuhr.BackColor = Color.Gainsboro;
			btn_time_stopuhr_start.ForeColor = Color.Black;
		}
		
		void Timer_stopuhrTick(object sender, EventArgs e)
		{
			//Zählen...
			stopuhr_s++;
			if (stopuhr_s == 600) {
				stopuhr_s = 0;
				stopuhr_m++;
				if (stopuhr_m == 60) {
					stopuhr_m = 0;
					stopuhr_h++;
				}
			}
			//ausgeben der Zähler
			float sec = stopuhr_s / 10f;
			if (stopuhr_m < 10) {
				label_stopuhr.Text = stopuhr_h.ToString()+":0"+stopuhr_m.ToString();
			} else {
				label_stopuhr.Text = stopuhr_h.ToString()+":"+stopuhr_m.ToString();
			}
			if (sec < 10) {
				label_stopuhr.Text += ":0"+sec.ToString();
			} else {
				label_stopuhr.Text += ":"+sec.ToString();
			}
		}
		
		//countdown
		void Btn_time_countdown_startClick(object sender, EventArgs e)
		{
			timer_countdown.Enabled = true;
			label_countdown.BackColor = Color.Lime;
			btn_time_countdown_start.ForeColor = Color.LimeGreen;
		}
		void Btn_time_countdown_stopClick(object sender, EventArgs e)
		{
			timer_countdown.Enabled = false;
			label_countdown.BackColor = Color.Gainsboro;
			btn_time_countdown_start.ForeColor = Color.Black;
		}
		void Btn_time_countdown_resetClick(object sender, EventArgs e)
		{
			countdown_h = CB_countdown_H.SelectedIndex;
			countdown_m = CB_countdown_M.SelectedIndex;
			countdown_s = CB_countdown_S.SelectedIndex;
			
			if (countdown_h < 10) {
				label_countdown.Text = "0"+countdown_h.ToString();
			} else {
				label_countdown.Text = countdown_h.ToString();
			}
			if (countdown_m < 10) {
				label_countdown.Text += ":0"+countdown_m.ToString();
			} else {
				label_countdown.Text += ":"+countdown_m.ToString();
			}
			if (countdown_s < 10) {
				label_countdown.Text += ":0"+countdown_s.ToString();
			} else {
				label_countdown.Text += ":"+countdown_s.ToString();
			}
		}
		
		void Timer_countdownTick(object sender, EventArgs e)
		{
			//Zählen...
			countdown_s--;
			if (countdown_s < 0) {
				countdown_s = 59;
				countdown_m--;
				if (countdown_m < 0) {
					countdown_m = 59;
					countdown_h--;
				}
			}
			//anzeigen
			if (countdown_h < 10) {
				label_countdown.Text = "0"+countdown_h.ToString();
			} else {
				label_countdown.Text = countdown_h.ToString();
			}
			if (countdown_m < 10) {
				label_countdown.Text += ":0"+countdown_m.ToString();
			} else {
				label_countdown.Text += ":"+countdown_m.ToString();
			}
			if (countdown_s < 10) {
				label_countdown.Text += ":0"+countdown_s.ToString();
			} else {
				label_countdown.Text += ":"+countdown_s.ToString();
			}
			if (countdown_h == 0 && countdown_m == 0 && countdown_s == 0) {
				//Timer ist abgelaufen
				Btn_time_countdown_stopClick(null,null);
				if (CHK_time_countdown_infobox.Checked) {
					MessageBox.Show("Countdown abgelaufen.");
				}
				if (CHK_time_countdown_rs232E.Checked) {
					switch (CB_time_countdown_rs232.SelectedIndex) {
						case 0: //Set RTS
							if (SP.IsOpen) {
								SP.RtsEnable = true;
								btn_rs232_RTS.BackColor = Color.Lime;
							}
							break;
						case 1: //Set DTR
							if (SP.IsOpen) {
								SP.DtrEnable = true;
								btn_rs232_DTR.BackColor = Color.Lime;
							}
							break;
						case 2: //Send Byte
							if (SP.IsOpen) {
								Sel_SendBytes.Checked = true;
								Btn_sendClick(null,null);
							}
							break;
						case 3: //Send Text
							if (SP.IsOpen) {
								Sel_SendText.Checked = true;
								Btn_sendClick(null,null);
							}
							break;
					}
				}
				//reset
				Btn_time_countdown_resetClick(null,null);
			}
		}
		#endregion
		
	}
}
