﻿using System;
using System.Text;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Globalization;

namespace Dev_Tools {
    public partial class STM32_GPIO_Conf : UserControl {
        #region Usercontrol
        bool UseAFunc_F1CRL = false;
        bool UseAFunc_F1CRH = false;
        public STM32_GPIO_Conf() {
            InitializeComponent();
            foreach (Control C in this.Controls) {
                if (C.Name.StartsWith("cb_dir")) {
                    int index = int.Parse(C.Name.Remove(0, 8));
                    ComboBox CBDir = C as ComboBox;
                    CBDir.SelectedIndex = 0;
                }
            }
        }

        public bool Get_AF_Online() {
            return UseAFunc_F1CRL | UseAFunc_F1CRH;
        }
        void Cb_dir_allSelectedIndexChanged(object sender, EventArgs e) {
            foreach (Control C in this.Controls) {
                if (C.Name.StartsWith("cb_dir")) {
                    int index = int.Parse(C.Name.Remove(0, 8));
                    ComboBox CBDir = C as ComboBox;
                    ComboBox CB_in = this.Controls.Find("cb_InTyp_P" + index.ToString(), true)[0] as ComboBox;
                    ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + index.ToString(), true)[0] as ComboBox;
                    ComboBox CB_out2 = this.Controls.Find("cb_OutSpeed_P" + index.ToString(), true)[0] as ComboBox;
                    if (CBDir.SelectedIndex == 0) {
                        //Input
                        CB_in.Enabled = true;
                        CB_out.Enabled = false;
                        CB_out2.Enabled = false;
                    }
                    else {
                        //Output
                        CB_in.Enabled = false;
                        CB_out.Enabled = true;
                        CB_out2.Enabled = true;
                    }
                }
            }
        }

        void Label_PortTextChanged(object sender, EventArgs e) {
            foreach (Control C in this.Controls) {
                if (C.Name.StartsWith("label_P")) {
                    Label L = C as Label;
                    L.Text = "P" + label_GpioPort.Text[label_GpioPort.Text.Length - 1].ToString()
                        + "_" + L.Name.Remove(0, 7);

                }
            }
        }
        void Label_TypTextChanged(object sender, EventArgs e) {
            switch (label_Typ.Text) {
                case "F1xx":
                    string[] INs1 = new string[] { "Floating", "Analog", "IF + Pull Up", "IF + Pull Down" };
                    kernel_change_cb_InTyp(INs1);
                    string[] Outs1 = new string[] { "Push-Pull 0V", "Open-Drain leitend", "Alt Push-Pull", "Alt Open-Drain", "Push-Pull 3.3V", "Open-Drain sperrend" };
                    kernel_change_cb_OutTyp(Outs1);
                    string[] Speed1 = new string[] { "max 50MHz", "max 10MHz", "max 2MHz" };
                    kernel_change_cb_OutSpeed(Speed1);
                    break;
                case "F4xx":
                    string[] INs4 = new string[] { "Floating", "Analog", "IF + Pull Up", "IF + Pull Down" };
                    kernel_change_cb_InTyp(INs4);
                    string[] Outs4 = new string[] { "Push-Pull", "Push-Pull + Pullup", "Push-Pull + Pulldown", "Open-Drain", "Open-Drain + Pullup", "Open-Drain + Pulldown", "Alt Push-Pull", "Alt Push-Pull + Pullup", "Alt Push-Pull + Pulldown", "Alt Open-Drain", "Alt Open-Drain + Pullup", "Alt Open-Drain + Pulldown" };
                    kernel_change_cb_OutTyp(Outs4);
                    string[] Speed4 = new string[] { "max 100MHz", "max 50MHz", "max 25MHz", "max 2MHz" };
                    kernel_change_cb_OutSpeed(Speed4);
                    break;
                default:
                    label_Typ.BackColor = Color.Red;
                    break;
            }
        }
        void kernel_change_cb_OutSpeed(string[] Items) {
            foreach (Control C in this.Controls) {
                if (C.Name.StartsWith("cb_OutSpeed_P")) {
                    ComboBox CB = C as ComboBox;
                    CB.Items.Clear();
                    foreach (string S in Items) {
                        CB.Items.Add(S);
                    }
                    CB.SelectedIndex = 0;
                }
            }
        }
        void kernel_change_cb_OutTyp(string[] Items) {
            foreach (Control C in this.Controls) {
                if (C.Name.StartsWith("cb_OutTyp_P")) {
                    ComboBox CB = C as ComboBox;
                    CB.Items.Clear();
                    foreach (string S in Items) {
                        CB.Items.Add(S);
                    }
                    CB.SelectedIndex = 0;
                }
            }
        }
        void kernel_change_cb_InTyp(string[] Items) {
            foreach (Control C in this.Controls) {
                if (C.Name.StartsWith("cb_InTyp_P")) {
                    ComboBox CB = C as ComboBox;
                    CB.Items.Clear();
                    foreach (string S in Items) {
                        CB.Items.Add(S);
                    }
                    CB.SelectedIndex = 0;
                }
            }
        }
        #endregion

        #region Ausgabe
        public string[] Report_F1xx_CRL() {
            string[] output = new string[3];
            string Port = label_GpioPort.Text[label_GpioPort.Text.Length - 1].ToString();
            StringBuilder SB = new StringBuilder();
            long Hexval = 0;
            UseAFunc_F1CRL = false;
            for (int i = 7; i >= 0; i--) {
                ComboBox CB_dir = this.Controls.Find("cb_dir_p" + i.ToString(), true)[0] as ComboBox;
                if (i == 3) { SB.Append(" | "); }
                switch (CB_dir.SelectedIndex) {
                    case 0: //input
                        ComboBox CB_in = this.Controls.Find("cb_InTyp_P" + i.ToString(), true)[0] as ComboBox;
                        switch (CB_in.SelectedIndex) {
                            case 0: SB.Append("IF "); Hexval += 1 << (i * 4) + 2; break;
                            case 1: SB.Append("IA "); break;
                            case 2: SB.Append("IU "); Hexval += 2 << (i * 4) + 2; break;
                            case 3: SB.Append("ID "); Hexval += 2 << (i * 4) + 2; break;
                        }
                        break;
                    case 1: //output
                        ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + i.ToString(), true)[0] as ComboBox;
                        ComboBox CB_out2 = this.Controls.Find("cb_OutSpeed_P" + i.ToString(), true)[0] as ComboBox;
                        switch (CB_out2.SelectedIndex) {
                            case 0: Hexval += 3 << (i * 4); break; //50mhz 
                            case 1: Hexval += 1 << (i * 4); break; //10mhz
                            case 2: Hexval += 2 << (i * 4); break; //2mhz
                        }
                        switch (CB_out.SelectedIndex) {
                            case 0: case 4: SB.Append("OP "); break; //PP
                            case 1: case 5: SB.Append("OD "); Hexval += 1 << (i * 4) + 2; break; //OD
                            case 2: SB.Append("AP "); Hexval += 2 << (i * 4) + 2; UseAFunc_F1CRL = true; break; //AP
                            case 3: SB.Append("AD "); Hexval += 3 << (i * 4) + 2; UseAFunc_F1CRL = true; break; //AD
                        }
                        break;
                }
            }
            Hexval = Hexval & 0xFFFFFFFF;
            output[0] = "GPIO" + Port + "->CRL = ";
            output[1] = "0x" + Hexval.ToString("X08");
            output[2] = ";   //" + SB.ToString() + " Pin 7-4|3-0";
            return output;
        }
        public string[] Report_F1xx_CRH() {
            string[] output = new string[3];
            string Port = label_GpioPort.Text[label_GpioPort.Text.Length - 1].ToString();
            StringBuilder SB = new StringBuilder();
            long Hexval = 0; UseAFunc_F1CRH = false;

            for (int i = 15; i >= 8; i--) {
                ComboBox CB_dir = this.Controls.Find("cb_dir_p" + i.ToString(), true)[0] as ComboBox;
                if (i == 11) {
                    SB.Append(" | ");
                }
                switch (CB_dir.SelectedIndex) {
                    case 0: //input
                        ComboBox CB_in = this.Controls.Find("cb_InTyp_P" + i.ToString(), true)[0] as ComboBox;
                        switch (CB_in.SelectedIndex) {
                            case 0: SB.Append("IF "); Hexval += 1 << ((i - 8) * 4) + 2; break;
                            case 1: SB.Append("IA "); break;
                            case 2: SB.Append("IU "); Hexval += 2 << ((i - 8) * 4) + 2; break;
                            case 3: SB.Append("ID "); Hexval += 2 << ((i - 8) * 4) + 2; break;
                        }
                        break;
                    case 1: //output
                        ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + i.ToString(), true)[0] as ComboBox;
                        ComboBox CB_out2 = this.Controls.Find("cb_OutSpeed_P" + i.ToString(), true)[0] as ComboBox;
                        switch (CB_out2.SelectedIndex) {
                            case 0: Hexval += 3 << ((i - 8) * 4); break; //50mhz 
                            case 1: Hexval += 1 << ((i - 8) * 4); break; //10mhz
                            case 2: Hexval += 2 << ((i - 8) * 4); break; //2mhz
                        }
                        switch (CB_out.SelectedIndex) {
                            case 0: case 4: SB.Append("OP "); break; //PP
                            case 1: case 5: SB.Append("OD "); Hexval += 1 << ((i - 8) * 4) + 2; break; //OD
                            case 2: SB.Append("AP "); Hexval += 2 << ((i - 8) * 4) + 2; UseAFunc_F1CRH = true; break; //AP
                            case 3: SB.Append("AD "); Hexval += 3 << ((i - 8) * 4) + 2; UseAFunc_F1CRH = true; break; //AD
                        }
                        break;
                }
            }
            Hexval = Hexval & 0xFFFFFFFF;
            output[0] = "GPIO" + Port + "->CRH = ";
            output[1] = "0x" + Hexval.ToString("X08");
            output[2] = ";   //" + SB.ToString() + " Pin 15-12|11-8";
            return output;
        }
        public string[] Report_F1xx_ODR() {
            string[] output = new string[3];
            string Port = label_GpioPort.Text[label_GpioPort.Text.Length - 1].ToString();
            long Hexval = 0;

            for (int i = 0; i < 16; i++) {
                ComboBox CB_dir = this.Controls.Find("cb_dir_p" + i.ToString(), true)[0] as ComboBox;
                switch (CB_dir.SelectedIndex) {
                    case 0: //input
                        ComboBox CB_in = this.Controls.Find("cb_InTyp_P" + i.ToString(), true)[0] as ComboBox;
                        switch (CB_in.SelectedIndex) {
                            case 0: case 1: case 3: break; //IF und IA
                            case 2: Hexval += 1 << i; break; //IU
                        }
                        break;
                    case 1: //output
                        ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + i.ToString(), true)[0] as ComboBox;
                        ComboBox CB_out2 = this.Controls.Find("cb_OutSpeed_P" + i.ToString(), true)[0] as ComboBox;
                        //						switch (CB_out2.SelectedIndex) {
                        //							case 0: Hexval+=3<<(i*4); break; //50mhz 
                        //							case 1: Hexval+=1<<(i*4); break; //10mhz
                        //							case 2: Hexval+=2<<(i*4); break; //2mhz
                        //						}
                        switch (CB_out.SelectedIndex) {
                            case 0: case 1: case 2: case 3: break; //
                            case 4: case 5: Hexval += 1 << i; break; //
                        }
                        break;
                }
            }
            Hexval = Hexval & 0xFFFFFFFF;
            output[0] = "GPIO" + Port + "->ODR = ";
            output[1] = "0x" + Hexval.ToString("X08");
            output[2] = ";   //Set/Reset Pins";
            return output;
        }

        public string[] Report_F4xx_MODER() {
            string[] output = new string[3];
            string Port = label_GpioPort.Text[label_GpioPort.Text.Length - 1].ToString();
            StringBuilder SB = new StringBuilder();
            long Hexval = 0;
            for (int i = 15; i >= 0; i--) {
                ComboBox CB_dir = this.Controls.Find("cb_dir_p" + i.ToString(), true)[0] as ComboBox;
                if (i == 7) { SB.Append(" | "); }
                switch (CB_dir.SelectedIndex) {
                    case 0: //input
                        ComboBox CB_in = this.Controls.Find("cb_InTyp_P" + i.ToString(), true)[0] as ComboBox;
                        switch (CB_in.SelectedIndex) {
                            case 0: SB.Append("IF "); break;
                            case 1: SB.Append("IA "); Hexval += 3 << (i * 2); break;
                            case 2: SB.Append("IU "); break;
                            case 3: SB.Append("ID "); break;
                        }
                        break;
                    case 1: //output
                        ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + i.ToString(), true)[0] as ComboBox;
                        switch (CB_out.SelectedIndex) {
                            case 0: case 1: case 2: SB.Append("PP "); Hexval += 1 << (i * 2); break; //PP
                            case 3: case 4: case 5: SB.Append("OD "); Hexval += 1 << (i * 2); break; //OD
                            case 6: case 7: case 8: SB.Append("AP "); Hexval += 2 << (i * 2); break; //AP
                            case 9: case 10: case 11: SB.Append("AD "); Hexval += 2 << (i * 2); break; //AD
                        }
                        break;
                }
            }
            Hexval = Hexval & 0xFFFFFFFF;
            output[0] = "GPIO" + Port + "->MODER = ";
            output[1] = "0x" + Hexval.ToString("X08");
            output[2] = ";   //" + SB.ToString() + " Pin 15-8|7-0";
            return output;
        }
        public string[] Report_F4xx_OTYPER() {
            string[] output = new string[3];
            string Port = label_GpioPort.Text[label_GpioPort.Text.Length - 1].ToString();
            StringBuilder SB = new StringBuilder();
            long Hexval = 0;
            for (int i = 15; i >= 0; i--) {
                ComboBox CB_dir = this.Controls.Find("cb_dir_p" + i.ToString(), true)[0] as ComboBox;
                if (i == 7) { SB.Append(" | "); }
                switch (CB_dir.SelectedIndex) {
                    case 0: //input
                        ComboBox CB_in = this.Controls.Find("cb_InTyp_P" + i.ToString(), true)[0] as ComboBox;
                        switch (CB_in.SelectedIndex) {
                            case 0: SB.Append("_ "); break;
                            case 1: SB.Append("_ "); break;
                            case 2: SB.Append("_ "); break;
                            case 3: SB.Append("_ "); break;
                        }
                        break;
                    case 1: //output
                        ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + i.ToString(), true)[0] as ComboBox;
                        switch (CB_out.SelectedIndex) {
                            case 0: case 1: case 2: SB.Append("PP "); break; //PP
                            case 3: case 4: case 5: SB.Append("OD "); Hexval += 1 << i; break; //OD
                            case 6: case 7: case 8: SB.Append("AP "); break; //AP
                            case 9: case 10: case 11: SB.Append("AD "); Hexval += 1 << i; break; //AD
                        }
                        break;
                }
            }
            Hexval = Hexval & 0xFFFFFFFF;
            output[0] = "GPIO" + Port + "->OTYPER = ";
            output[1] = "0x" + Hexval.ToString("X04");
            output[2] = ";   //TypeRegister (PP oder OD)";
            return output;
        }
        public string[] Report_F4xx_OSPEEDR() {
            string[] output = new string[3];
            string Port = label_GpioPort.Text[label_GpioPort.Text.Length - 1].ToString();
            long Hexval = 0;
            for (int i = 15; i >= 0; i--) {
                ComboBox CB_dir = this.Controls.Find("cb_dir_p" + i.ToString(), true)[0] as ComboBox;
                switch (CB_dir.SelectedIndex) {
                    case 1: //output
                        ComboBox CB_out2 = this.Controls.Find("cb_OutSpeed_P" + i.ToString(), true)[0] as ComboBox;
                        switch (CB_out2.SelectedIndex) {
                            case 0: Hexval += 3 << (i * 2); break; //100mhz 
                            case 1: Hexval += 2 << (i * 2); break; //50mhz
                            case 2: Hexval += 1 << (i * 2); break; //25mhz
                            case 3: break; //2mhz
                        }
                        break;
                }
            }
            Hexval = Hexval & 0xFFFFFFFF;
            output[0] = "GPIO" + Port + "->OSPEEDR = ";
            output[1] = "0x" + Hexval.ToString("X08");
            output[2] = ";   //Speed Control";
            return output;
        }
        public string[] Report_F4xx_PUPDR() {
            string[] output = new string[3];
            string Port = label_GpioPort.Text[label_GpioPort.Text.Length - 1].ToString();
            StringBuilder SB = new StringBuilder();
            long Hexval = 0;

            for (int i = 15; i >= 0; i--) {
                ComboBox CB_dir = this.Controls.Find("cb_dir_p" + i.ToString(), true)[0] as ComboBox;
                if (i == 7) { SB.Append(" | "); }
                switch (CB_dir.SelectedIndex) {
                    case 0: //input
                        ComboBox CB_in = this.Controls.Find("cb_InTyp_P" + i.ToString(), true)[0] as ComboBox;
                        switch (CB_in.SelectedIndex) {
                            case 0: SB.Append("-- "); break;
                            case 1: SB.Append("-- "); break;
                            case 2: SB.Append("IU "); Hexval += 1 << (i * 2); break;
                            case 3: SB.Append("ID "); Hexval += 2 << (i * 2); break;
                        }
                        break;
                    case 1: //output
                        ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + i.ToString(), true)[0] as ComboBox;
                        switch (CB_out.SelectedIndex) {
                            case 0: case 3: case 6: case 9: SB.Append("-- "); break;
                            case 1: case 4: case 7: case 10: SB.Append("Up "); Hexval += 1 << (i * 2); break;
                            case 2: case 5: case 8: case 11: SB.Append("Dn "); Hexval += 2 << (i * 2); break;
                        }
                        break;
                }
            }
            Hexval = Hexval & 0xFFFFFFFF;
            output[0] = "GPIO" + Port + "->PUPDR = ";
            output[1] = "0x" + Hexval.ToString("X08");
            output[2] = ";   //" + SB.ToString();
            return output;
        }
        #endregion

        #region Eingabe
        public void Set_F1xx_CRL(string hexwert) {
            long hex = long.Parse(hexwert, NumberStyles.HexNumber);
            UseAFunc_F1CRL = false;
            for (int i = 7; i >= 0; i--) {
                ComboBox CB_dir = this.Controls.Find("cb_dir_p" + i.ToString(), true)[0] as ComboBox;
                ComboBox CB_in = this.Controls.Find("cb_InTyp_P" + i.ToString(), true)[0] as ComboBox;
                ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + i.ToString(), true)[0] as ComboBox;
                ComboBox CB_out2 = this.Controls.Find("cb_OutSpeed_P" + i.ToString(), true)[0] as ComboBox;
                int Pinwert = (int)(hex >> i * 4 & 0xF);
                switch (Pinwert) {
                    case 0: CB_dir.SelectedIndex = 0; CB_in.SelectedIndex = 1; break; //IA
                    case 1: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 0; CB_out2.SelectedIndex = 1; break; //OP 10mhz
                    case 2: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 0; CB_out2.SelectedIndex = 2; break; //OP 2mhz
                    case 3: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 0; CB_out2.SelectedIndex = 0; break; //OP 50mhz
                    case 4: CB_dir.SelectedIndex = 0; CB_in.SelectedIndex = 0; break; //IF
                    case 5: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 1; CB_out2.SelectedIndex = 1; break; //OD 10mhz
                    case 6: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 1; CB_out2.SelectedIndex = 2; break; //OD 2mhz
                    case 7: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 1; CB_out2.SelectedIndex = 0; break; //OD 50mhz
                    case 8: CB_dir.SelectedIndex = 0; CB_in.SelectedIndex = 3; break; //IU/ID
                    case 9: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 2; CB_out2.SelectedIndex = 1; break; //AP 10mhz
                    case 10: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 2; CB_out2.SelectedIndex = 2; break; //AP 2mhz
                    case 11: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 2; CB_out2.SelectedIndex = 0; break; //AP 50mhz
                    case 12: break;
                    case 13: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 3; CB_out2.SelectedIndex = 1; break; //AD 10mhz
                    case 14: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 3; CB_out2.SelectedIndex = 2; break; //AD 2mhz
                    case 15: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 3; CB_out2.SelectedIndex = 0; break; //AD 50mhz
                }
                if (Pinwert > 8) { UseAFunc_F1CRL = true; }
            }
        }
        public void Set_F1xx_CRH(string hexwert) {
            long hex = long.Parse(hexwert, NumberStyles.HexNumber);
            UseAFunc_F1CRH = false;
            for (int i = 15; i >= 8; i--) {
                ComboBox CB_dir = this.Controls.Find("cb_dir_p" + i.ToString(), true)[0] as ComboBox;
                ComboBox CB_in = this.Controls.Find("cb_InTyp_P" + i.ToString(), true)[0] as ComboBox;
                ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + i.ToString(), true)[0] as ComboBox;
                ComboBox CB_out2 = this.Controls.Find("cb_OutSpeed_P" + i.ToString(), true)[0] as ComboBox;
                int Pinwert = (int)(hex >> (i - 8) * 4 & 0xF);
                switch (Pinwert) {
                    case 0: CB_dir.SelectedIndex = 0; CB_in.SelectedIndex = 1; break; //IA
                    case 1: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 0; CB_out2.SelectedIndex = 1; break; //OP 10mhz
                    case 2: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 0; CB_out2.SelectedIndex = 2; break; //OP 2mhz
                    case 3: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 0; CB_out2.SelectedIndex = 0; break; //OP 50mhz
                    case 4: CB_dir.SelectedIndex = 0; CB_in.SelectedIndex = 0; break; //IF
                    case 5: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 1; CB_out2.SelectedIndex = 1; break; //OD 10mhz
                    case 6: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 1; CB_out2.SelectedIndex = 2; break; //OD 2mhz
                    case 7: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 1; CB_out2.SelectedIndex = 0; break; //OD 50mhz
                    case 8: CB_dir.SelectedIndex = 0; CB_in.SelectedIndex = 3; break; //IU/ID
                    case 9: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 2; CB_out2.SelectedIndex = 1; break; //AP 10mhz
                    case 10: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 2; CB_out2.SelectedIndex = 2; break; //AP 2mhz
                    case 11: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 2; CB_out2.SelectedIndex = 0; break; //AP 50mhz
                    case 12: break;
                    case 13: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 3; CB_out2.SelectedIndex = 1; break; //AD 10mhz
                    case 14: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 3; CB_out2.SelectedIndex = 2; break; //AD 2mhz
                    case 15: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 3; CB_out2.SelectedIndex = 0; break; //AD 50mhz
                }
                if (Pinwert > 8) { UseAFunc_F1CRH = true; }
            }
        }
        public void Set_F1xx_ODR(string hexwert) {
            long hex = long.Parse(hexwert, NumberStyles.HexNumber);
            for (int i = 0; i < 16; i++) {
                ComboBox CB_dir = this.Controls.Find("cb_dir_p" + i.ToString(), true)[0] as ComboBox;
                ComboBox CB_in = this.Controls.Find("cb_InTyp_P" + i.ToString(), true)[0] as ComboBox;
                ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + i.ToString(), true)[0] as ComboBox;
                ComboBox CB_out2 = this.Controls.Find("cb_OutSpeed_P" + i.ToString(), true)[0] as ComboBox;
                int Pinwert = (int)(hex >> i & 1);
                if (Pinwert == 1) {
                    if (CB_dir.SelectedIndex == 0) { //Input 1
                        CB_in.SelectedIndex = 2;
                    }
                    else { //Output 1
                        if (CB_out.SelectedIndex == 0) {
                            CB_out.SelectedIndex = 4;
                        }
                        else if (CB_out.SelectedIndex == 1) {
                            CB_out.SelectedIndex = 5;
                        }
                    }
                }
            }
        }

        public void Set_F4xx_MODER(string hexwert) {

            long hex = long.Parse(hexwert, NumberStyles.HexNumber);
            for (int i = 0; i < 16; i++) {
                ComboBox CB_dir = this.Controls.Find("cb_dir_p" + i.ToString(), true)[0] as ComboBox;
                ComboBox CB_in = this.Controls.Find("cb_InTyp_P" + i.ToString(), true)[0] as ComboBox;
                ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + i.ToString(), true)[0] as ComboBox;
                //CB_dir.SelectedIndex=0; CB_in.SelectedIndex=0; CB_out.SelectedIndex=0; //reset
                int Pinwert = (int)(hex >> i * 2 & 0x3);
                switch (Pinwert) {
                    case 0: CB_dir.SelectedIndex = 0; CB_in.SelectedIndex = 0; break; //In
                    case 1: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 0; break; //gp
                    case 2: CB_dir.SelectedIndex = 1; CB_out.SelectedIndex = 6; break; //Afunc
                    case 3: CB_dir.SelectedIndex = 0; CB_in.SelectedIndex = 1; break; //analog mode
                }
            }
        }
        public void Set_F4xx_OTYPER(string hexwert) {
            long hex = long.Parse(hexwert, NumberStyles.HexNumber);
            for (int i = 0; i < 16; i++) {
                ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + i.ToString(), true)[0] as ComboBox;
                int Pinwert = (int)(hex >> i & 0x1);
                if (Pinwert == 1) { //set Open Drain
                    switch (CB_out.SelectedIndex) {
                        case 0: CB_out.SelectedIndex = 3; break; //OD
                        case 6: CB_out.SelectedIndex = 9; break; //AD
                    }
                }
                //				else { //set Push Pull
                ////					switch (CB_out.SelectedIndex) {
                ////						case 1: CB_out.SelectedIndex=0; break; //OP
                ////						case 3: CB_out.SelectedIndex=2; break; //AP
                ////					}
                //				}

            }
        }
        public void Set_F4xx_OSPEEDR(string hexwert) {
            long hex = long.Parse(hexwert, NumberStyles.HexNumber);
            for (int i = 0; i < 16; i++) {
                ComboBox CB_out2 = this.Controls.Find("cb_OutSpeed_P" + i.ToString(), true)[0] as ComboBox;
                int Pinwert = (int)(hex >> i * 2 & 0x3);
                switch (Pinwert) {
                    case 0: CB_out2.SelectedIndex = 3; break; //2 MHz
                    case 1: CB_out2.SelectedIndex = 2; break; //25 MHz
                    case 2: CB_out2.SelectedIndex = 1; break; //50 MHz
                    case 3: CB_out2.SelectedIndex = 0; break; //100 MHz
                }
            }
        }
        public void Set_F4xx_PUPDR(string hexwert) {
            long hex = long.Parse(hexwert, NumberStyles.HexNumber);
            for (int i = 0; i < 16; i++) {

                ComboBox CB_dir = this.Controls.Find("cb_dir_p" + i.ToString(), true)[0] as ComboBox;
                if (CB_dir.SelectedIndex == 0) {
                    ComboBox CB_in = this.Controls.Find("cb_InTyp_P" + i.ToString(), true)[0] as ComboBox;
                    int Pinwert = (int)(hex >> i * 2 & 0x3);
                    switch (Pinwert) {
                        case 1: CB_in.SelectedIndex = 2; break; //PU
                        case 2: CB_in.SelectedIndex = 3; break; //PD
                    }
                }
                else {
                    ComboBox CB_out = this.Controls.Find("cb_OutTyp_P" + i.ToString(), true)[0] as ComboBox;
                    int Pinwert = (int)(hex >> i * 2 & 0x3);
                    switch (Pinwert) {
                        case 0: break; //passt
                        case 1: //PU
                            CB_out.SelectedIndex = CB_out.SelectedIndex + 1;
                            break;
                        case 2: //PD
                            CB_out.SelectedIndex = CB_out.SelectedIndex + 2;
                            break;
                    }
                }
            }
        }
        #endregion

        void Label_GpioPortClick(object sender, EventArgs e) {

        }
        void Label_TypClick(object sender, EventArgs e) {
            StringBuilder SB = new StringBuilder();
            switch (label_Typ.Text) {
                case "F1xx":
                    string[] data = Report_F1xx_CRL();
                    SB.AppendLine(data[0] + data[1] + data[2]);
                    data = Report_F1xx_CRH();
                    SB.AppendLine(data[0] + data[1] + data[2]);
                    data = Report_F1xx_ODR();
                    SB.AppendLine(data[0] + data[1] + data[2]);
                    MessageBox.Show(SB.ToString().ToString());
                    break;
                case "F4xx":
                    string[] data2 = Report_F4xx_MODER();
                    SB.AppendLine(data2[0] + data2[1] + data2[2]);
                    data2 = Report_F4xx_OTYPER();
                    SB.AppendLine(data2[0] + data2[1] + data2[2]);
                    data2 = Report_F4xx_OSPEEDR();
                    SB.AppendLine(data2[0] + data2[1] + data2[2]);
                    data2 = Report_F4xx_PUPDR();
                    SB.AppendLine(data2[0] + data2[1] + data2[2]);
                    MessageBox.Show(SB.ToString().ToString());
                    break;
                default:
                    MessageBox.Show("Vorschau nicht verfügbar");
                    break;
            }
        }

    }
}
