﻿#region Usings...
using System;
using System.Text;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.IO.Ports;
using System.IO;
using System.Threading;
using System.Windows.Forms;
//using UsbHid;
using System.Diagnostics;


using System.Security.Cryptography; //crc
#endregion

namespace Dev_Tools
{
	public partial class MainForm : Form
	{		
		#region Allgemeines
		UsbHidPort usbHid = new UsbHidPort();
		bool Lock_CTRL = false;
		string STM32Chipmode = "";
		string STM32BoardCfgFilename = "";
		string[] STM32BoardCfgInhalt = new string[1];
		//Variablen
		string Last_RS232_Time = "";
		bool sending_bool = false;
		int HID_PenX = 0;
		int HID_PenY = 0;
		UnsafeBitmap ubmp_hid;
		int[,] data_RAW = new int[8000,6000];
        decimal FilebufferRatio = (decimal)(120d / 160d);
		string Filepath = "";
		byte[] Filepuffer;
		byte[] LastFilepuffer;
		public byte[] map_r = new byte[256];
        public byte[] map_g = new byte[256];
      	public byte[] map_b = new byte[256];
		//Delegaten zur interaktion zwischen 
		//verschiedenen Threads
		delegate void Dele_void();
		
		public MainForm()
		{
			InitializeComponent();
			//Comm Ports finden
			for (int i = 1;i < 30;i++ ) {
				SP.PortName = "COM"+i.ToString();
				try {
					SP.Open();
					if (SP.IsOpen) {
						CB_RS232_Port.Items.Add(SP.PortName);
						SP.Close();
					}
				} catch (Exception) {
					
				}
			}
			if (CB_RS232_Port.Items.Count == 0) {
				CB_RS232_Port.Items.Add("Keine Ports gefunden.");
			}
			//Encoding anpassen
			SP.Encoding = System.Text.Encoding.Default;
			//USB HID Setup
			usbHid.OnSpecifiedDeviceRemoved += new System.EventHandler(UsbHidOnSpecifiedDeviceRemoved);
			usbHid.OnDeviceArrived += new System.EventHandler(UsbHidOnDeviceArrived);
			usbHid.OnDeviceRemoved += new System.EventHandler(UsbHidOnDeviceRemoved);
			usbHid.OnDataRecieved += new DataRecievedEventHandler(UsbHidOnDataRecieved);
			usbHid.OnSpecifiedDeviceArrived += new System.EventHandler(UsbHidOnSpecifiedDeviceArrived);
			Btn_HID_PicClrClick(null,null);
			Btn_usb_finddeviceClick(null,null);
			draw_dual_palette(Color.White,Color.Black,false);
			CreateControls_font();
		}
		void CreateControls_font()
		{
			for (int x=0;x<8 ;x++ ) {
				for (int y=0;y<16 ;y++ ) {
					Label L = new Label();
					L.Name="LabFont_"+x.ToString()+"_"+y.ToString();
					L.BorderStyle=BorderStyle.FixedSingle;
					L.BackColor=Color.Gainsboro;
					L.Size=new Size(17,17);
					L.Location=new Point(25+(x*16),32+(y*16));
					L.MouseDown+= label_auto_font_AllMouseDown;
					
					group_conv_font.Controls.Add(L);
				}
			}
		}
		void MainFormLoad(object sender, EventArgs e)
		{
//			int zahl = Convert.ToInt32("1101", 2);;
//			MessageBox.Show(zahl.ToString());
			CB_RS232_Port.SelectedIndex = 0;
			CB_RS232_baud.SelectedIndex = 2;//115200
			cb_stm32_zugriff_port.SelectedIndex=0;
			cb_stm32_zugriff_typ.SelectedIndex=0;
			cb_stm32_pinC_port.SelectedIndex=0;
			cb_stm32_CTRL_txt1.SelectedIndex=0;
			cb_stm32_CTRL_txt1_font.SelectedIndex=5;
			cb_stm32_CTRL_btn1.SelectedIndex=0;
			cb_stm32_CTRL_btn1_font.SelectedIndex=5;
			cb_stm32_CTRL_PBar_Chan.SelectedIndex=0;
			cb_stm32_CTRL_Box_chan.SelectedIndex=0;
			cb_stm32_CTRL_Line_Chan.SelectedIndex=0;
			rad_STMF1.Checked=true;
			//GPIO Usercontrol Setup
			stM32_GPIO_ConfA.label_GpioPort.Text="GPIO A";
			stM32_GPIO_ConfB.label_GpioPort.Text="GPIO B";
			stM32_GPIO_ConfC.label_GpioPort.Text="GPIO C";
			stM32_GPIO_ConfD.label_GpioPort.Text="GPIO D";
			stM32_GPIO_ConfE.label_GpioPort.Text="GPIO E";
			stM32_GPIO_ConfF.label_GpioPort.Text="GPIO F";
			stM32_GPIO_ConfG.label_GpioPort.Text="GPIO G";
			stM32_GPIO_ConfH.label_GpioPort.Text="GPIO H";
			stM32_GPIO_ConfI.label_GpioPort.Text="GPIO I";
		}
		void MainFormFormClosing(object sender, FormClosingEventArgs e)
		{
			if (SP.IsOpen) {
				SP.Close();
			}
			usbHid.UnregisterHandle();
			usbHid.Dispose();
		}
		void CHK_TopmostCheckedChanged(object sender, EventArgs e)
		{
			this.TopMost = CHK_Topmost.Checked;
		}
		void Main_Saveto_txt(string Dateiname, string Inhalt)
		{
			if (File.Exists(Dateiname)) {
				//wenn die Datei schon existiert
				//fragen, ob der Inhalt hinhalt hinzugefügt werden soll
				DialogResult result = MessageBox.Show(Dateiname + " existiert schon.\r\n"
					+ "Soll der aktuelle Inhalt\r\nhinzugefügt werden?","Als TXT speichern", MessageBoxButtons.YesNo, MessageBoxIcon.Question,MessageBoxDefaultButton.Button1);
				if (result != DialogResult.Yes) {
					// wenn nicht auf JA gedrückt wird -> Abbruch
					return;
				}
			}
			TextWriter txt = new StreamWriter(Dateiname,true); //datei erstellen oder inhalt hinzufügen
			txt.Write(Inhalt); //datei befüllen
			txt.Close(); //datei schließen (hebt sperrung für andere Programme auf)
			MessageBox.Show(Dateiname+" erstellt.\r\n" +
			                "Eingefügte Zeichen: "+Inhalt.Length.ToString(),"Als TXT speichern");
		}
		
		void Btn_main_allClick(object sender, EventArgs e)
		{
			Button btn = sender as Button;
			switch (btn.Name[9].ToString()) {
				case "0": Application.Exit(); break;
				case "1": tabControl_main.SelectedTab = TP_RS232; break;
				case "2": tabControl_main.SelectedTab = TP_UsbHid; break;
				case "3": tabControl_main.SelectedTab = TP_Conv; break;
				case "4": tabControl_main.SelectedTab = TP_Fileformat; break;
				case "5": tabControl_main.SelectedTab = TP_STM32; break;
			}
		}
		
		void Btn_main_SaveScreenClick(object sender, EventArgs e)
		{
			int ID = 0;
			string pfad = txt_main_ScreenPath.Text;
			if (!pfad.EndsWith("//")) {
				pfad+="//";
			}
			if (!Directory.Exists(pfad)) {
				Directory.CreateDirectory(pfad);
			}
			while(File.Exists(pfad+"Screen_"+ID.ToString()+".jpg")){
				ID++;
			}
			try {
				if (Clipboard.ContainsImage()) {
//					Stream S = new FileStream(pfad+"Screen_"+ID.ToString()+".png",FileMode.Create);
//					Clipboard.GetImage().Save(S,ImageFormat.Png);
					Stream S = new FileStream(pfad+"Screen_"+ID.ToString()+".jpg",FileMode.Create);
					Clipboard.GetImage().Save(S,ImageFormat.Jpeg);
					S.Close(); S.Dispose();
					label_main_ScreenshotInfo.Text="Bild gespeichert: Screen_"+ID.ToString()+".jpg";
					label_main_ScreenshotInfo.BackColor=Color.LimeGreen; label_main_ScreenshotInfo.Refresh();
					Thread.Sleep(200);
					label_main_ScreenshotInfo.BackColor=Color.Gainsboro; 
					pictBox_StoreScreen.Image=Clipboard.GetImage();
				} else {
					label_main_ScreenshotInfo.Text="Kein Bild im Zwischenspeicher...\"druck\" oder \"alt+druck\" benutzen";
					label_main_ScreenshotInfo.BackColor=Color.Red; 
				}
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Fehler beim Speichern");
			}
		}
		void Btn_main_SaveScreenOpenFolderClick(object sender, EventArgs e)
		{
			string pfad = txt_main_ScreenPath.Text;
			if (!Directory.Exists(pfad)) {
				Directory.CreateDirectory(pfad);
			}
			try {
				System.Diagnostics.Process.Start(pfad);	
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
		}

        void txt_calc_input_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode == Keys.Enter) {
                try {
                    string input = txt_calc_input.Text.ToLower().Replace("x", "*");
                    txt_calc_ans.Text += txt_calc_input.Text + " -> " + new System.Data.DataTable().Compute(input, null).ToString() + "\r\n";
                }
                catch (Exception err) {
                    txt_calc_ans.Text += txt_calc_input.Text + " -> err:" + err.Message + "\r\n";
                }
            }
        }
        void btn_clan_clear_Click(object sender, EventArgs e) {
            txt_calc_ans.Text = "";
        }

        void btn_eval_Exec_Click(object sender, EventArgs e) {
            try {
                //(1+2)*5+System.Math.Sin(5);
                //System.Threading.Thread.Sleep(1000);
                //data = this.GetType().ToString();
                //System.Math.PI.ToString();
                string sourceCode = @"
		                public class clsEval {
                            " + txt_eval_input.Text + @"
		                    
		                }";
                //this.GetType().Name
                System.CodeDom.Compiler.CompilerParameters compParms = new System.CodeDom.Compiler.CompilerParameters {
                    GenerateExecutable = false,
                    GenerateInMemory = true
                };
                Microsoft.CSharp.CSharpCodeProvider csProvider = new Microsoft.CSharp.CSharpCodeProvider();
                System.CodeDom.Compiler.CompilerResults compilerResults =
                    csProvider.CompileAssemblyFromSource(compParms, sourceCode);
                object typeInstance =
                    compilerResults.CompiledAssembly.CreateInstance("clsEval");
                System.Reflection.MethodInfo mi = typeInstance.GetType().GetMethod("doEval");
                string methodOutput = (string)mi.Invoke(typeInstance, new object[] { 1 });
                txt_eval_Output.Text = methodOutput.ToString();
            }
            catch (Exception err) {
                txt_eval_Output.Text = "err:" + err.Message;
            }
        }

        void MainFormDragOver(object sender, DragEventArgs e)
		{
			if (e.Data.GetDataPresent(DataFormats.FileDrop)) {	
				if ((e.AllowedEffect & DragDropEffects.Move) != 0) {
					e.Effect = DragDropEffects.Move;
				}
			}
		}
		void MainFormDragDrop(object sender, DragEventArgs e)
		{
			
			try 
			{	
				if (e.Data.GetDataPresent (DataFormats.FileDrop))
				{	//versuche die gedropte datei als text zu laden
					string[] filepath = (string[]) e.Data.GetData (DataFormats.FileDrop);
					string[] splits0 = filepath[0].Split('\\');
					txt_fileformat_filename.Text = splits0[splits0.Length-1];
					Filepath = filepath[0];
					
					if (tabControl_main.SelectedTab==TP_ImageTransformer) {
						Kernel_IT_Filedrop(Filepath);
						return;
					}
					if (Filepath.ToUpper().EndsWith(".MCM")) {
						sub_readout_CharsetMaxOSD();
						return;
					}
					if (Filepath.EndsWith(".gui")) {
						sub_readout_Stm32Gui(Filepath);
						return;
					}
					if (chk_fileformat_redirect_stm32.Checked) { //################
						sub_readout_STM32();
						return;
					} //STM32 boardcfg.c #######################################
					label_fileformat2.Text=filepath[0];
					
					
					if (tabControl_file.SelectedTab==TP_Fileformat_bytes) {
						Kernel_Fileformat_Readfile();
					}
					if (tabControl_file.SelectedTab==TP_Fileformat_Bild) {
						Kernel_Fileformat_ReadfileToPic();
					}
					tabControl_main.SelectTab(TP_Fileformat);
				}
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
		}
		#endregion
		
		#region Tab_Serial_Terminal(RS232)
		//Schaltflächen
		void BTN_RS232_OpenClick(object sender, EventArgs e)
		{
			if (!CB_RS232_Port.SelectedItem.ToString().StartsWith("COM")) {
				Btn_rs232_refreshClick(null,null);
				if (!CB_RS232_Port.SelectedItem.ToString().StartsWith("COM")) { return; }
			}
			if (BTN_RS232_Open.ForeColor != Color.LimeGreen) {
				try {
					//SP.BaudRate = int.Parse(CB_RS232_baud.SelectedItem.ToString());
					SP.BaudRate = int.Parse(txt_rs232_baud.Text);
					SP.PortName = CB_RS232_Port.SelectedItem.ToString();
					
					SP.Open();
					if (SP.IsOpen) {
						BTN_RS232_Open.ForeColor = Color.LimeGreen;
						BTN_RS232_Open.Text = "Close";
					} else {
						BTN_RS232_Open.ForeColor = Color.Red;
					}
					Pin_Changed();
				} catch (Exception err) {
					BTN_RS232_Open.ForeColor = Color.Red;
					MessageBox.Show(err.Message,"Fehler beim öffnen des Ports");
				}
			} else {
				//farbe = grün... port ist offen, daher schließen
				BTN_RS232_Open.Text = "Open";
				BTN_RS232_Open.ForeColor = Color.Black;
				
				try {
					SP.Close();
				} catch (Exception) {
					Btn_rs232_refreshClick(null,null);
				}
				
			}
		}
		void Btn_rs232_RTSClick(object sender, EventArgs e)
		{
			//Steuerleitung vom Port
			if (btn_rs232_RTS.BackColor == Color.Lime) {
				SP.RtsEnable = false;
				btn_rs232_RTS.BackColor = Color.Gainsboro;
			} else {
				SP.RtsEnable = true;
				btn_rs232_RTS.BackColor = Color.Lime;
			}
		}
		void Btn_rs232_DTRClick(object sender, EventArgs e)
		{
			//Steuerleitung vom Port
			if (btn_rs232_DTR.BackColor == Color.Lime) {
				SP.DtrEnable = false;
				btn_rs232_DTR.BackColor = Color.Gainsboro;
			} else {
				SP.DtrEnable = true;
				btn_rs232_DTR.BackColor = Color.Lime;
			}
		}
		void BTN_RS232_SaveClick(object sender, EventArgs e)
		{
			saveFileDialog1.FileName = "rs232_Text.rtf";
			if (saveFileDialog1.ShowDialog()==DialogResult.OK) { 
				TXTR_Text.SaveFile(saveFileDialog1.FileName);
			}
			saveFileDialog1.FileName = "rs232_Byte.rtf";
			if (saveFileDialog1.ShowDialog()==DialogResult.OK) { 
				TXTR_Byte.SaveFile(saveFileDialog1.FileName);
			}
		}		
		void BTN_RS232_ClearClick(object sender, EventArgs e)
		{
			TXTR_Text.Clear();
			TXTR_Byte.Clear();
		}
		
		void btn_send_num_click(object sender, EventArgs e)
		{
			Button btn = sender as Button;
			if (!SP.IsOpen) {
				//da Port nicht offen das Senden abbrechen
				return;
			}
			SP.Write(btn.Name[9].ToString());
		}
		void Btn_rs232_refreshClick(object sender, EventArgs e)
		{
			CB_RS232_Port.Items.Clear();
			//Comm Ports finden
			int Baud = 0; int.TryParse(txt_rs232_baud.Text,out Baud);
			if (Baud==0) {
				MessageBox.Show("Baudrate ("+txt_rs232_baud.Text+") konnte nicht erkannt werden.");
				return;
			} else {
				SP.BaudRate = Baud;
			}
			for (int i = 1;i < 99;i++ ) {
				SP.PortName = "COM"+i.ToString();
				try {
					SP.Open();
					if (SP.IsOpen) {
						CB_RS232_Port.Items.Add(SP.PortName);
						SP.Close();
					}
				} catch (Exception) {
					
				}
			}
			if (CB_RS232_Port.Items.Count == 0) {
				CB_RS232_Port.Items.Add("Keine Ports gefunden.");
			}
			CB_RS232_Port.SelectedIndex = 0;
		}
		
		//für Textfelder
		void TXT_Send_SKeyDown(object sender, KeyEventArgs e)
		{
			if (!SP.IsOpen) { return; }
			if (e.KeyData == Keys.Enter) {
				sending_bool = true;
				string TX = "";
				if (CHK_RS232_UseStartByte.Checked) { TX=""+(char)num_RS232_Startbyte.Value; }
				TX=TX+TXT_Send_S.Text;
				if (CHK_RS232_SendChar13.Checked) { TX=TX+(char)13; }
				SP.Write(TX);
				//cursor zum anfang
				TXTR_Text.Select(0,0);
				//alles neu geschriebene einfärben
				if (CHK_txt_WriteTime.Checked) {
					TXTR_Text.SelectionColor = panel_txt_Time.BackColor;
					TXTR_Text.SelectedText += DateTime.Now.ToLongTimeString()+" ";
				}
				TXTR_Text.SelectionColor = panel_txt_send.BackColor;
				TXTR_Text.SelectedText += TX+"\r\n";
				if (CHK_RS232_ToBytes.Checked) {
					try {
						TXTR_Byte.Select(0,0);
						if (CHK_txt_WriteTime.Checked) {
							TXTR_Byte.SelectionColor = panel_txt_Time.BackColor;
							TXTR_Byte.SelectedText += DateTime.Now.ToLongTimeString()+" ";
						}
						TXTR_Byte.SelectionColor = panel_txt_send.BackColor;
						//textinhalt in Zeichenarray umsetzen
						char[] Chars = TX.ToCharArray();
						byte[] buffer = UnicodeEncoding.Default.GetBytes(Chars);
						if (CHK_RS232_Hexadecimal.Checked) {
							foreach (byte B in buffer) {
								TXTR_Byte.SelectedText += B.ToString("X02")+" ";
							}
						} else {
							foreach (byte B in buffer) {
								TXTR_Byte.SelectedText += B.ToString()+" ";
							}
						}
						
						TXTR_Byte.SelectedText += "\r\n";
					} catch (Exception err) {
						MessageBox.Show(err.Message,"Fehler beim Umwandeln in Bytes");
						sending_bool = false;
						return;
					}
				}
				sending_bool = false;
				Data_Received();
			}
		}
		void TXT_Send_BKeyDown(object sender, KeyEventArgs e)
		{
			if (!SP.IsOpen) { return; }
			if (e.KeyData == Keys.Enter) {
				sending_bool = true;
				StringBuilder SB = new StringBuilder(20);
				try {
					//buffer befüllen
					string[] split_s = TXT_Send_B.Text.Split(' ');
					byte[] buffer = new byte[split_s.Length];
					if (chk_rs232_SendLoop.Checked) {
						for (int i = 0; i<split_s.Length; i++) {
							buffer[i] = byte.Parse(split_s[i]);
							SP.Write(buffer,i,1);
							Thread.Sleep(10);
						}
					} else {
						for (int i = 0; i<split_s.Length; i++) {
							buffer[i] = byte.Parse(split_s[i]);
						}
						SP.Write(buffer,0,buffer.Length);
					}
					
					foreach (byte B in buffer)
					{
						if (B > 0) {
							SB.Append((char)B);
						} else {
							SB.Append('0');
						}
						
					}
				} catch (Exception err) {
					MessageBox.Show(err.Message,"Send Bytes Fail");
					sending_bool = false;
					return;
				}
				//cursor zum anfang
				TXTR_Text.Select(0,0);
				//alles neu geschriebene einfärben
				if (CHK_txt_WriteTime.Checked) {
					TXTR_Text.SelectionColor = panel_txt_Time.BackColor;
					TXTR_Text.SelectedText += DateTime.Now.ToLongTimeString()+" ";
				}
				TXTR_Text.SelectionColor = panel_txt_send.BackColor;
				TXTR_Text.SelectedText += SB.ToString()+"\r\n";
				if (CHK_RS232_ToBytes.Checked) {
					TXTR_Byte.Select(0,0);
					if (CHK_txt_WriteTime.Checked) {
						TXTR_Byte.SelectionColor = panel_txt_Time.BackColor;
						TXTR_Byte.SelectedText += DateTime.Now.ToLongTimeString()+" ";
					}
					TXTR_Byte.SelectionColor = panel_txt_send.BackColor;
					//textinhalt in Zeichenarray umsetzen
					TXTR_Byte.SelectedText += TXT_Send_B.Text+"\r\n";
				}
				sending_bool = false;
				Data_Received();
			}
		}
		
		void TXTR_TextKeyDown(object sender, KeyEventArgs e)
		{
			//Standardfarbe einstellen
			TXTR_Text.SelectionColor = panel_txt_default.BackColor;
		}
		void TXTR_ByteKeyDown(object sender, KeyEventArgs e)
		{
			//Standardfarbe einstellen
			TXTR_Byte.SelectionColor = panel_txt_default.BackColor;
		}
		void Panel_txt_sendClick(object sender, EventArgs e)
		{
			if (colorSET.ShowDialog() == DialogResult.OK) {
				panel_txt_send.BackColor = colorSET.Color;
			}
		}
		void Panel_txt_reciveClick(object sender, EventArgs e)
		{
			if (colorSET.ShowDialog() == DialogResult.OK) {
				panel_txt_recive.BackColor = colorSET.Color;
			}
		}
		void Panel_txt_TimeClick(object sender, EventArgs e)
		{
			if (colorSET.ShowDialog() == DialogResult.OK) {
				panel_txt_Time.BackColor = colorSET.Color;
			}
		}
		void Panel_txt_defaultClick(object sender, EventArgs e)
		{
			if (colorSET.ShowDialog() == DialogResult.OK) {
				panel_txt_default.BackColor = colorSET.Color;
				TXTR_Text.SelectionColor = colorSET.Color;
			}
		}
		void Txt_rs232_baudKeyDown(object sender, KeyEventArgs e)
		{
			try {
				if (e.KeyData == Keys.Enter) {
					if (SP.IsOpen) {
						BTN_RS232_OpenClick(null,null);
						Application.DoEvents();
					}
					int baud = 0;
					int.TryParse(txt_rs232_baud.Text, out baud);
					SP.BaudRate = baud;
					//MessageBox.Show(SP.BaudRate.ToString());
				}
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
		}
		void CB_RS232_baudSelectedIndexChanged(object sender, EventArgs e)
		{
			txt_rs232_baud.Text = CB_RS232_baud.SelectedItem.ToString();
		}
		
		void Txt_serKonv_HexKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyCode!=Keys.Enter) { return; }
			TextBox txt = sender as TextBox;
			//txt_serKonv_Bytes,
			try {
				StringBuilder SB = new StringBuilder();
				byte[] buffer=new byte[1];
				string[] split_s=new string[1];
				switch (txt.Name[12].ToString()) {
					case "S": //txt_serKonv_String
						char[] chars = txt.Text.ToCharArray();
						buffer = new byte[chars.Length];
						for (int i = 0; i<chars.Length; i++) {
							buffer[i] = (byte)chars[i];
						}
						Kernel_SerKonv(buffer);
						break;
					case "B": //txt_serKonv_Bytes
						split_s = txt.Text.Split(' ');
						buffer = new byte[split_s.Length];
						for (int i = 0; i<split_s.Length; i++) {
							buffer[i] = byte.Parse(split_s[i]);
						}
						Kernel_SerKonv(buffer);
						break;
					case "H": //txt_serKonv_Hex
						split_s = txt.Text.Split(' ');
						buffer = new byte[split_s.Length];
						for (int i = 0; i<split_s.Length; i++) {
							long dec = Convert.ToUInt32(split_s[i],16);
							buffer[i] = (byte)dec;
						}
						Kernel_SerKonv(buffer);
						break;
				}
				
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
			
		}
		void Kernel_SerKonv(byte[] Values) 
		{
			StringBuilder sb = new StringBuilder();
			sb.Append("string:\r\n");
			foreach(byte B in Values) {
				switch (B) {
					case 0: case 1: case 9: case 10: case 13:  
					case 28: case 29: case 30: case 31:
						sb.Append("-"); break;
					default: sb.Append((char)B); break;
				}
			}
			sb.Append("\r\nbyte:\r\n");
			foreach(byte B in Values) {
				sb.Append(B.ToString()+" ");
			}
			sb.Append("\r\nhex:\r\n");
			foreach(byte B in Values) {
				sb.Append(B.ToString("X02")+" ");
			}
			txt_serKonv_Out.Text=sb.ToString();
		}
		//Steuerleitung
		void SPPinChanged(object sender, SerialPinChangedEventArgs e)
		{
			this.BeginInvoke(new Dele_void(Pin_Changed));
		}
		void Pin_Changed()
		{
			//Steuerleitungslabels aktualisieren
			if (SP.CDHolding) {
				label_CD.BackColor = Color.Lime;
			} else {
				label_CD.BackColor = Color.Gainsboro;
			}
			if (SP.CtsHolding) {
				label_CTS.BackColor = Color.Lime;
			} else {
				label_CTS.BackColor = Color.Gainsboro;
			}
			if (SP.DsrHolding) {
				label_DSR.BackColor = Color.Lime;
			} else {
				label_DSR.BackColor = Color.Gainsboro;
			}
		}
		
		//Datenempfang
		void SPDataReceived(object sender, SerialDataReceivedEventArgs e)
		{
			this.BeginInvoke(new Dele_void(Data_Received));
		}
		void Data_Received()
		{
			if (sending_bool||CHK_Topmost.Checked) {
				//Port sendet gerade, empfang abbrechen
				return;
			}
			if (SP.BytesToRead > 0) {
				//cursor zum anfang
				if (!CHK_RS232_NotOnTop.Checked) {
					TXTR_Text.Select(0,0);
				}
				
				//alles neu geschriebene einfärben
				string time = DateTime.Now.ToLongTimeString()+" "; bool WasSameTime = true;
				if (CHK_txt_WriteTime.Checked&&time!=Last_RS232_Time) {
					TXTR_Text.SelectionColor = panel_txt_Time.BackColor;
					TXTR_Text.SelectedText += time;
					WasSameTime=false;
				}
				Last_RS232_Time=time;
				TXTR_Text.SelectionColor = panel_txt_recive.BackColor;
				StringBuilder SB_B = new StringBuilder(60);
				StringBuilder SB_S = new StringBuilder(30);
				try {
					string Input = SP.ReadExisting();
					//textinhalt in Zeichenarray umsetzen
					char[] Chars = Input.ToCharArray();
					byte[] buffer = UnicodeEncoding.Default.GetBytes(Chars);
					if (CHK_RS232_Sonderzeichen.Checked) {//Sonderzeichen Filtern
						foreach (byte B in buffer) {
							switch (B) {
								case 0:
									SB_B.Append("0 "); SB_S.Append("<NULL>"); break;
								case 9:
									SB_B.Append("9 "); SB_S.Append("<TAB>"); break;
								case 10:
									SB_B.Append("10 "); SB_S.Append("<LF>"); break;
								case 13:
									SB_B.Append("13 "); SB_S.Append("<CR>"); break;
								case 32:
									SB_B.Append("32 "); SB_S.Append("<SP>"); break;
								case 127:
									SB_B.Append("127 "); SB_S.Append("<DEL>"); break;
								default:
									SB_B.Append(B.ToString()+" "); SB_S.Append((char)B); break;
							}
						}
					} else { //Sonderzeichen nicht Filtern
						if (CHK_RS232_Hexadecimal.Checked) {
							foreach (byte B in buffer) {
								if (B > 0) {
									SB_B.Append(B.ToString("X02")+" ");
									SB_S.Append((char)B);
								} else {
									SB_B.Append("00 ");
									SB_S.Append('0');
								}
							}
						} else {
							foreach (byte B in buffer) {
								if (B > 0) {
									SB_B.Append(B.ToString()+" ");
									SB_S.Append((char)B);
								} else {
									SB_B.Append("0 ");
									SB_S.Append('0');
								}
							}
						}
					}
					
				} catch (Exception err) {
					MessageBox.Show(err.Message,"Fehler beim Umwandeln in Bytes");
					sending_bool = false;
					return;
				}
				if (WasSameTime) {
					TXTR_Text.SelectedText += SB_S.ToString();
				} else {
					TXTR_Text.SelectedText += SB_S.ToString()+"\r\n";
				}
				if (CHK_RS232_ToBytes.Checked) {
					try {
						if (!CHK_RS232_NotOnTop.Checked) {
							TXTR_Byte.Select(0,0);
						}
						
						if (CHK_txt_WriteTime.Checked&&!WasSameTime) {
							TXTR_Byte.SelectionColor = panel_txt_Time.BackColor;
							TXTR_Byte.SelectedText += time;
						}
						TXTR_Byte.SelectionColor = panel_txt_recive.BackColor;
						TXTR_Byte.SelectedText += SB_B.ToString()+"\r\n";
					} catch (Exception) {
						
					}
				}
			}
		}
		#endregion
		
		#region Tab_autoConvert
		void CHK_auto_convert16CheckedChanged(object sender, EventArgs e)
		{
			timer_conv16.Enabled = CHK_auto_convert16.Checked;
		}
		void Label_auto_conv16_bin0MouseDown(object sender, MouseEventArgs e)
		{
			try {
				Label L = sender as Label;
				//rechte maustaste -> alle switchen
				if (e.Button == MouseButtons.Right) {
					if (L.BackColor == Color.Gainsboro) {
						//alle rot machen
						for (int i = 0;i < 16;i++) {
							Label lab = group_conv_bin.Controls.Find("label_auto_conv16_bin"+i.ToString(),false)[0] as Label;
							lab.BackColor = Color.Gold;
						}
					} else {
						//alle grau machen
						for (int i = 0;i < 16;i++) {
							Label lab = group_conv_bin.Controls.Find("label_auto_conv16_bin"+i.ToString(),false)[0] as Label;
							lab.BackColor = Color.Gainsboro;
						}
					}
				}
				//linke maustaste -> einzeln switchen
				if (e.Button == MouseButtons.Left) {
					if (L.BackColor == Color.Gainsboro) {
						L.BackColor = Color.Gold;
					} else {
						L.BackColor = Color.Gainsboro;
					}
				}
				//aus dem Zustand der Checkboxen eine Dezimalzahl erzeugen
				int dec = 0;
				int wert = 1;
				for (int i = 0;i < 16;i++ ) {
					//16 durchläufe für 16 bit
					foreach (Control C in group_conv_bin.Controls) {
						//für jedes element auf der Convert 1 Tabseite:
						//fragen ob der name Passt
						if (C.Name == "label_auto_conv16_bin" + (i).ToString()) {
							//wenn ja, element als Checkbox deklarieren
							Label Lab = C as Label;
							if (Lab.BackColor!=Color.Gainsboro) {
								//wenn häckchen, dann den Wert dazu addieren
								dec += wert;
							}
							//wert wird immer mit 2 Multipiziert
							wert = wert * 2;
							break; //da element gefunden, nicht weiter danach suchen...
						}
					}
				}
				//ausgabe der erzeugten Dezimalzahl
				Kernel_Output(0,dec);
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
			
		}
		void Label_auto_conv32_bin0MouseDown(object sender, MouseEventArgs e)
		{
			try {
				Label L = sender as Label;
				//rechte maustaste -> alle switchen
				if (e.Button == MouseButtons.Right) {
					if (L.BackColor == Color.Gainsboro) {
						//alle rot machen
						for (int i = 0;i < 32;i++) {
							Label lab = group_conv_bin.Controls.Find("label_auto_conv32_bin"+i.ToString(),false)[0] as Label;
							lab.BackColor = Color.Gold;
						}
					} else {
						//alle grau machen
						for (int i = 0;i < 32;i++) {
							Label lab = group_conv_bin.Controls.Find("label_auto_conv32_bin"+i.ToString(),false)[0] as Label;
							lab.BackColor = Color.Gainsboro;
						}
					}
				}
				//linke maustaste -> einzeln switchen
				if (e.Button == MouseButtons.Left) {
					if (L.BackColor == Color.Gainsboro) {
						L.BackColor = Color.Gold;
					} else {
						L.BackColor = Color.Gainsboro;
					}
				}
				//aus dem Zustand der Checkboxen eine Dezimalzahl erzeugen
				long dec = 0;
				long wert = 1;
				for (int i = 0;i < 32;i++ ) {
					foreach (Control C in group_conv_bin.Controls) {
						//für jedes element auf der Convert 1 Tabseite:
						//fragen ob der name Passt
						if (C.Name == "label_auto_conv32_bin" + (i).ToString()) {
							//wenn ja, element als Checkbox deklarieren
							Label Lab = C as Label;
							if (Lab.BackColor!=Color.Gainsboro) {
								//wenn häckchen, dann den Wert dazu addieren
								dec += wert;
							}
							//wert wird immer mit 2 Multipiziert
							wert = wert * 2;
							break; //da element gefunden, nicht weiter danach suchen...
						}
					}
				}
				//ausgabe der erzeugten Dezimalzahl
				Kernel_Output(1,dec);
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
		}
		void Btn_conv16_bitshift_LClick(object sender, EventArgs e)
		{
			do_conv_bitshift(true);
		}
		void Btn_conv16_bitshift_RClick(object sender, EventArgs e)
		{
			do_conv_bitshift(false);
		}
		void Num_conv_decimalMouseDown(object sender, MouseEventArgs e)
		{
			num_conv_decimal.BackColor = Color.Gold;
			Kernel_Output(2,(long)num_conv_decimal.Value);
		}
		void Num_conv_decimalKeyDown(object sender, KeyEventArgs e)
		{
			Num_conv_decimalMouseDown(null,null);
		}
		void Txt_conv_hexadecimalKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData!= Keys.Enter) { return; }
			try {
				txt_conv_hexadecimal.BackColor=Color.Gold;
				string inhalt = txt_conv_hexadecimal.Text;
				if (inhalt.StartsWith("0x")||inhalt.StartsWith("0X")) { inhalt.Remove(0,2); }
				long dec = 0;
				dec = Convert.ToUInt32(inhalt,16);
				Kernel_Output(3,dec);
			} catch (Exception err) {
				MessageBox.Show(err.Message,"conv_hexadecimal");
			}
			
		}
		void Txt_conv_CharKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData!= Keys.Enter) { return; }
			try {
				txt_conv_Char.BackColor=Color.Gold;
				//string inhalt = txt_conv_Char.Text;
				long dec = (long)txt_conv_Char.Text[0];
				//dec = Convert.ToUInt32(inhalt.ToCharArray());
				Kernel_Output(4,dec);
			} catch (Exception err) {
				MessageBox.Show(err.Message,"conv_Char");
			}
		}
		void Label_Conv16_RGB565_ColorClick(object sender, EventArgs e)
		{
			if (colorSET.ShowDialog()==DialogResult.OK) {
				label_Conv16_RGB565_Color.BackColor=colorSET.Color;
				long dec = 0;
				dec=(colorSET.Color.R<<8&0xF800)|(colorSET.Color.G<<3&0x07E0)|(colorSET.Color.B>>3&0x001F);
				Kernel_Output(4,dec);
			}
		}
        void txt_conv_DigToV_FromDigit_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }

            try {
                //aquire inputs
                string[] input = txt_conv_DigToV_Settings.Text.Split(',');
                double VoltRangeMin = double.Parse(input[0]);
                double VoltRangeMax = double.Parse(input[1]);
                int NumberOfBits = int.Parse(input[2]);
                ushort Digit = ushort.Parse(txt_conv_DigToV_FromDigit.Text);

                //calculate
                double Maxrange = (double)((1 << (int)NumberOfBits) - 1);
                double Step = (VoltRangeMax - VoltRangeMin) / Maxrange;
                double Calc = ((double)Digit * Step) + VoltRangeMin;
                double StepmV = Step * 1000d;
                //output
                Kernel_Output(10, Digit);
                txt_conv_DigToV_Result.Text = "Dig: " + Digit.ToString() + " Volt: " + Math.Round(Calc, 3) + " V Step: " + Math.Round(StepmV, 3) + " mV";
            }
            catch (Exception ex) {
                MessageBox.Show(ex.Message);
            }
        }
        void txt_conv_DigToV_FromVolt_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }

            try {
                //aquire inputs
                string[] input = txt_conv_DigToV_Settings.Text.Split(',');
                double VoltRangeMin = double.Parse(input[0]);
                double VoltRangeMax = double.Parse(input[1]);
                int NumberOfBits = int.Parse(input[2]);
                double Volt = double.Parse(txt_conv_DigToV_FromVolt.Text);

                //calculate
                double Maxrange = (double)((1 << (int)NumberOfBits) - 1);
                double Step = (VoltRangeMax - VoltRangeMin) / Maxrange;
                double Calc = ((Volt - VoltRangeMin) / Step);
                double StepmV = Step * 1000d;
                //output
                Kernel_Output(10, (ushort)Calc);
                txt_conv_DigToV_Result.Text = "Dig: " + Math.Round(Calc, 3) + " Volt: " + Volt.ToString() + " V Step: " + Math.Round(StepmV, 3) + " mV";
            }
            catch (Exception ex) {
                MessageBox.Show(ex.Message);
            }
        }
        void Kernel_Output(int modus,long wert)
		{
			//0=16bit binäreingabe
			//1=32bit binäreingabe
			//2=dezimal eingabe
			//3=hexa eingabe
			//4=Farb eingabe
			if (wert>4294967295) { wert=4294967295; }
			if (modus!=0) { Refresh_auto_binlabel16(wert); }
			if (modus!=1) { Refresh_auto_binlabel32(wert); }
			if (modus!=2) { num_conv_decimal.BackColor = Color.Lime; num_conv_decimal.Value=(decimal)wert; }
			if (modus!=3) {
				if (modus==0||modus==4) { //16bit ausgabe
					txt_conv_hexadecimal.Text = "0x"+wert.ToString("X04");
				} else { //32bit ausgabe
					txt_conv_hexadecimal.Text = "0x"+wert.ToString("X08");
				}
				txt_conv_hexadecimal.BackColor = Color.Lime;
			}
			if (modus!=4) { label_Conv16_RGB565_Color.BackColor = Int16_to_RGB565(wert); }
			if (modus!=5) { 
				if (wert<256) {
					txt_conv_Char.BackColor=Color.White;
					txt_conv_Char.Text=((char)wert).ToString();
				} else {
					txt_conv_Char.Text="++";
					txt_conv_Char.BackColor=Color.Salmon;
				}
			}
		}
		
		void do_conv_bitshift(bool Leftshift)
		{
			long dec = 0;
			long wert = 1;
			for (int i = 0;i < 32;i++ ) {
				foreach (Control C in group_conv_bin.Controls) {
					//für jedes element auf der Convert 1 Tabseite:
					//fragen ob der name Passt
					if (C.Name == "label_auto_conv32_bin" + (i).ToString()) {
						//wenn ja, element als Checkbox deklarieren
						Label Lab = C as Label;
						if ((Lab.BackColor == Color.Gold)||
							(Lab.BackColor == Color.Lime)){
							//wenn häckchen, dann den Wert dazu addieren
							dec += wert;
						}
						//wert wird immer mit 2 Multipiziert
						wert = wert * 2;
						break; //da element gefunden, nicht weiter danach suchen...
					}
				}
			}
			if (Leftshift) {
				dec = dec<<(int)num_conv16_bitshift.Value;
			} else {
				dec = dec>>(int)num_conv16_bitshift.Value;
			}
			Kernel_Output(999,dec);
		}
		void Timer_conv16Tick(object sender, EventArgs e)
		{
			timer_conv16.Enabled = false;
			if (CHK_auto_copy.Checked) {
				SendKeys.Send("^c"); Application.DoEvents();
			}
			int state = 0;
			if (Clipboard.ContainsText()) {
				CHK_auto_convert16.ForeColor = Color.Lime; Application.DoEvents();
				string inhalt = Clipboard.GetText();
				if (inhalt.Length < 7) {
					txt_auto_conv16.Text = inhalt.Replace(" ","");
					if (inhalt.Contains("x")||inhalt.Contains("X")) {
						try {
							long dec = 0;
							dec = Convert.ToUInt32(inhalt,16);
							Kernel_Output(3,dec);
							state = 1; //hex pass
						} catch (Exception) {
							state = 2; //hex fail
						}
					} else {
						try {
							long dec = long.Parse(inhalt);
							if (dec < 4294967296) {
								//ausgabe der erzeugten Dezimalzahl
								Kernel_Output(2,dec);
								state = 3; //int pass
							} else {
								//über 16 bit
								state = 4; //int to high
							}
						} catch (Exception) {
							state = 5; //int fail
						}
					} //if hex
				} else {
					txt_auto_conv16.Text = inhalt;
					state = 6; //no conversion (overlengh)
				}
				Application.DoEvents();
				Refresh_auto_labels(state);
				label_auto_conv16_menge.Text = txt_auto_conv16.Text.Length.ToString();
			} else {
				CHK_auto_convert16.ForeColor = Color.Red; Application.DoEvents();
				txt_auto_conv16.Text = "";
				label_auto_conv16_menge.Text = txt_auto_conv16.Text.Length.ToString();
			}
			CHK_auto_convert16.ForeColor = Color.Black;
			timer_conv16.Enabled = CHK_auto_convert16.Checked;
			
		}
		void Refresh_auto_binlabel16(long data) 
		{
			data=data&0xFFFF;
			long wert = 32767;
			for (int i=15;i>=0;i-- ) {
				Label L = group_conv_bin.Controls.Find("label_auto_conv16_bin"+i.ToString(),false)[0] as Label;
				if (data > wert) {
					data-=wert+1;
					L.BackColor=Color.Lime;
				} else {
					L.BackColor=Color.Gainsboro;
				}
				wert=wert/2;
			}
//			if (data > 32767) { data-=32768; label_auto_conv16_bin15.BackColor = Color.Lime;	} else {label_auto_conv16_bin15.BackColor = Color.Gainsboro;}
//			if (data > 16383) { data-=16384; label_auto_conv16_bin14.BackColor = Color.Lime;	} else {label_auto_conv16_bin14.BackColor = Color.Gainsboro;}
//			if (data > 8191) { data-=8192; label_auto_conv16_bin13.BackColor = Color.Lime;	} else {label_auto_conv16_bin13.BackColor = Color.Gainsboro;}
//			if (data > 4095) { data-=4096; label_auto_conv16_bin12.BackColor = Color.Lime;	} else {label_auto_conv16_bin12.BackColor = Color.Gainsboro;}
//			if (data > 2047) { data-=2048; label_auto_conv16_bin11.BackColor = Color.Lime;	} else {label_auto_conv16_bin11.BackColor = Color.Gainsboro;}
//			if (data > 1023) { data-=1024; label_auto_conv16_bin10.BackColor = Color.Lime;	} else {label_auto_conv16_bin10.BackColor = Color.Gainsboro;}
//			if (data > 511) { data-=512; label_auto_conv16_bin9.BackColor = Color.Lime;	} else {label_auto_conv16_bin9.BackColor = Color.Gainsboro;}
//			if (data > 255) { data-=256; label_auto_conv16_bin8.BackColor = Color.Lime;	} else {label_auto_conv16_bin8.BackColor = Color.Gainsboro;}
//			if (data > 127) { data-=128; label_auto_conv16_bin7.BackColor = Color.Lime;	} else {label_auto_conv16_bin7.BackColor = Color.Gainsboro;}
//			if (data > 63) { data-=64; label_auto_conv16_bin6.BackColor = Color.Lime;	} else {label_auto_conv16_bin6.BackColor = Color.Gainsboro;}
//			if (data > 31) { data-=32; label_auto_conv16_bin5.BackColor = Color.Lime;	} else {label_auto_conv16_bin5.BackColor = Color.Gainsboro;}
//			if (data > 15) { data-=16; label_auto_conv16_bin4.BackColor = Color.Lime;	} else {label_auto_conv16_bin4.BackColor = Color.Gainsboro;}
//			if (data > 7) { data-=8; label_auto_conv16_bin3.BackColor = Color.Lime;	} else {label_auto_conv16_bin3.BackColor = Color.Gainsboro;}
//			if (data > 3) { data-=4; label_auto_conv16_bin2.BackColor = Color.Lime;	} else {label_auto_conv16_bin2.BackColor = Color.Gainsboro;}
//			if (data > 1) { data-=2; label_auto_conv16_bin1.BackColor = Color.Lime;	} else {label_auto_conv16_bin1.BackColor = Color.Gainsboro;}
//			if (data > 0) { label_auto_conv16_bin0.BackColor = Color.Lime;	} else {label_auto_conv16_bin0.BackColor = Color.Gainsboro;}
		}
		void Refresh_auto_binlabel32(long data) 
		{
			long wert = 2147483647;
			for (int i=31;i>=0;i-- ) {
				Label L = group_conv_bin.Controls.Find("label_auto_conv32_bin"+i.ToString(),false)[0] as Label;
				if (data > wert) {
					data-=wert+1;
					L.BackColor=Color.Lime;
				} else {
					L.BackColor=Color.Gainsboro;
				}
				wert=wert/2;
			}
		}
		void Refresh_auto_labels(int state)
		{
			switch (state) {
				case 1: //is hex pass
					txt_conv_hexadecimal.BackColor = Color.Lime;
					num_conv_decimal.BackColor = Color.Gainsboro;
					break;
				case 3: //int pass
					txt_conv_hexadecimal.BackColor = Color.Gainsboro;
					num_conv_decimal.BackColor = Color.Lime;
					break;
				case 4: //int to high
					txt_conv_hexadecimal.BackColor = Color.Gainsboro;
					num_conv_decimal.BackColor = Color.Red;
					Refresh_auto_binlabel16(0);
					Refresh_auto_binlabel32(0);
					break;
				case 2: //is hex fail	
				case 5: //int fail
				case 6: //no conversion (overlengh)
					txt_conv_hexadecimal.BackColor = Color.Gainsboro;
					num_conv_decimal.BackColor = Color.Gainsboro;
					Refresh_auto_binlabel16(0);
					Refresh_auto_binlabel32(0);
					break;
			}
			Application.DoEvents();
		}
		Color Int16_to_RGB565(long int_16)
		{
			int red = (int)((int_16>>8)&248);
			int green = (int)((int_16>>3)&252);
			int blue = (int)((int_16<<3)&248);
			if (red>255) { red=255; }
			if (green>255) { green=255; }
			if (blue>255) { blue=255; }
			return Color.FromArgb(255,red,green,blue);
		}
		long Color_to_Int16(Color C)
		{
			long dec = 0; 
			dec=(C.R<<8&0xF800)|(C.G<<3&0x07E0)|(C.B>>3&0x001F);
			return dec;
		}
		
		//Fontcode
		void label_auto_font_AllMouseDown(object sender, MouseEventArgs e)
		{
			Label L = sender as Label;
			L.BackColor=(L.BackColor==Color.LimeGreen) ? Color.Gainsboro : Color.LimeGreen;
			int x=0; int y=0;
			string[] splits = L.Name.Split('_');
			int.TryParse(splits[1],out x); int.TryParse(splits[2],out y);
//			this.Text= "X/Y: "+x.ToString()+"_"+y.ToString();
			Kernel_GenerateFontcode();
		}
		void Txt_auto_conv_fontcodeKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData!=Keys.Enter) {
				return;
			}
			try {
				string[] splits = txt_auto_conv_fontcode.Text.Split(',');
				foreach(Control C in group_conv_font.Controls) {
					if (C.Name.StartsWith("LabFont_")) {
						C.BackColor=Color.Red;
					}
				}
				for (int y=0;y<splits.Length ;y++ ) {
					if (y>15) { break; }
					if (splits[y].Contains("0x")||splits[y].Contains("0X")) {
						uint val = 0;
						val = Convert.ToUInt32(splits[y].Trim(),16);
						for (int x=0;x<8 ;x++ ) {
							Label L = group_conv_font.Controls.Find("LabFont_"+x.ToString()+"_"+y.ToString(),false)[0] as Label;
							if (((val>>7-x)&1)==1) {
								L.BackColor=Color.LimeGreen;
							} else {
								L.BackColor=Color.Gainsboro;
							}
						}
					}
				}
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Fehler beim Umwandeln von Hexwerten in Bitmatrix");
			}
			
		}
		void Btn_auto_conv_font_allONClick(object sender, EventArgs e)
		{
			int ende = (int)num_auto_conv_FontOutZeilen.Value+1;
			for (int y=0;y<ende ;y++ ) {
				for (int x=0;x<8 ;x++ ) {
					Label L = group_conv_font.Controls.Find("LabFont_"+x.ToString()+"_"+y.ToString(),false)[0] as Label;
					L.BackColor=Color.LimeGreen;
				}
			}
			Kernel_GenerateFontcode();
		}
		void Btn_auto_conv_font_allOFFClick(object sender, EventArgs e)
		{
			int ende = (int)num_auto_conv_FontOutZeilen.Value+1;
			for (int y=0;y<ende ;y++ ) {
				for (int x=0;x<8 ;x++ ) {
					Label L = group_conv_font.Controls.Find("LabFont_"+x.ToString()+"_"+y.ToString(),false)[0] as Label;
					L.BackColor=Color.Gainsboro;
				}
			}
			Kernel_GenerateFontcode();
		}
		void Kernel_GenerateFontcode()
		{
			try {
				StringBuilder SB = new StringBuilder();
				int ende = (int)num_auto_conv_FontOutZeilen.Value+1;
				for (int y=0;y<ende ;y++ ) {
					int val = 0;
					for (int x=0;x<8 ;x++ ) {
						Label Lab = group_conv_font.Controls.Find("LabFont_"+x.ToString()+"_"+y.ToString(),false)[0] as Label;
						if (Lab.BackColor==Color.LimeGreen) {
							val|=1<<7-x;
						}
					}
					SB.Append("0x"+val.ToString("X02")+",");
				}
				txt_auto_conv_fontcodeOut.Text=SB.ToString()+" //";
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Fehler bein Code erstellen");
			}
		}
		#endregion
		
		#region Tab_USB_HID
		void Btn_usb_finddeviceClick(object sender, EventArgs e)
		{
			try 
            { 
            	usbHid.ProductId = Int32.Parse(txt_usb_ProductID.Text, System.Globalization.NumberStyles.HexNumber);
                usbHid.VendorId = Int32.Parse(txt_usb_VendorID.Text, System.Globalization.NumberStyles.HexNumber);
                txt_usb_info.Text = "Suche...";
                usbHid.CheckDevicePresent();
                if (usbHid.SpecifiedDevice == null) {
                	btn_usb_finddevice.BackColor = Color.Gold;
                }
            } 
            catch ( Exception err ) 
            { 
            	MessageBox.Show(err.Message);
            }  
		}
		void Txt_hid_uart1TxKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Enter) {
				try {
				
				byte[] puffer = new byte[usbHid.SpecifiedDevice.OutputReportLength];
				puffer[1] = 10;
				char[] chars = ('\r'+txt_hid_uart1Tx.Text+'\r').ToCharArray();
				puffer[2] = (byte)chars.Length;
				for (int i = 0;i< chars.Length;i++ ) {
					puffer[3+i] = (byte)chars[i];
				}
                if (usbHid.SpecifiedDevice != null) {
                    usbHid.SpecifiedDevice.SendData(puffer);
                } else {
                    txt_usb_info.Text = "Grab Fail...\r\n" + txt_usb_info.Text;
                }
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Grab Fail");
			}
			}
		}
		void Btn_HID_PicClrClick(object sender, EventArgs e)
		{
			ubmp_hid = new UnsafeBitmap(320,240);
			Graphics G = Graphics.FromImage(ubmp_hid.Bitmap);
			G.DrawRectangle(new Pen(Color.White,1),new Rectangle(80,0,239,180));
			pic_HID.Image=ubmp_hid.Bitmap;
		}
		
		//Senden
		void Kernel_sendHID(byte[] data) 
		{
			if (btn_usb_finddevice.BackColor!=Color.LimeGreen) {
				return;
			}
			try {
				string[] split = txt_usb_send.Text.Split(' ');
				byte[] puffer = new byte[usbHid.SpecifiedDevice.OutputReportLength];
                for (int i = 0; i < data.Length; i++) 
                {
                	puffer[i+1] = data[i];
                }
                if (usbHid.SpecifiedDevice != null) {
                    usbHid.SpecifiedDevice.SendData(puffer);
                } else {
                    txt_usb_info.Text = "Send Fail...\r\n" + txt_usb_info.Text;
                }
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Send Fail");
			}
		}
		void Txt_usb_sendTextChanged(object sender, EventArgs e)
		{
			
		}
		void Txt_usb_sendKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData == Keys.Enter) {
				string[] split = txt_usb_send.Text.Replace(',',' ').Split(' ');
				byte[] puffer = new byte[split.Length];
                for (int i = 0; i < split.Length; i++) 
                {
                    if (split[i] != "") {
                		if (split[i].ToLower().Contains("x")) {
                			split[i].Remove(0,2);
                			long dec = 0;
							dec = Convert.ToUInt32(split[i],16);
							if (dec<0) { dec=0; } if (dec>255) { dec=255; }
							puffer[i] = (byte)dec;
                		} else {
	                		int value = Int32.Parse(split[i], System.Globalization.NumberStyles.Number);
	                        puffer[i] = (byte)Convert.ToByte(value);
                		}
                    }
                }
                Kernel_sendHID(puffer);
			}
		}
		void Chk_hid_led1CheckedChanged(object sender, EventArgs e)
		{
			if (chk_hid_led1.Checked) {
				Kernel_sendHID(new byte[]{2,1});
			} else {
				Kernel_sendHID(new byte[]{2,0});
			}
		}
		//Empfangen
		void UsbHidOnDataRecieved(object sender, DataUSBEventArgs args)
		{
			if (InvokeRequired) {
                try {
                    Invoke(new DataRecievedEventHandler(UsbHidOnDataRecieved), new object[] { sender, args });
                } catch (Exception ex) {
					MessageBox.Show(ex.ToString());
                }
            } else {
				//analogeingang
				if (args.data[1]==2) {
					int data = args.data[2]<<8 | args.data[3];
					if (data<4096) { bar_hid_an0.Value = data; } //B0
					data = args.data[3]<<1 | args.data[4]>>7;
					label_HID_Temp.Text=((float)data/2f).ToString();
					if (data<4096) { bar_hid_an1.Value = data; } //B1
					data = args.data[6]<<8 | args.data[7];
					if (data<4096) { bar_hid_an2.Value = data; }
					data = args.data[8]<<8 | args.data[9];
					if (data<4096) { bar_hid_an3.Value = data; }
				}
				//Uart1 Rx
				if (args.data[1]==9) {
					int menge = args.data[2];
					for (int i=0;i<menge;i++ ) {
						txt_hid_uart1Rx.Text += (char)args.data[3+i];
					}
					return;
				}
				//Key1 (GPIO A0)
				if (args.data[21]==2) {
					label_HID_key1.BackColor=Color.Lime;
				} else {
					label_HID_key1.BackColor=Color.Gainsboro;
				}
				//Stiftposition
				HID_PenX = (args.data[11]<<8 | args.data[12]);
				HID_PenY = (args.data[13]<<8 | args.data[14]);
				label_HID_PenX.Text=HID_PenX.ToString();
				label_HID_PenY.Text=HID_PenY.ToString();
				if (HID_PenX<320&&HID_PenX>0) {
					label_HID_PenX.BackColor=Color.Lime;
				} else {
					label_HID_PenX.BackColor=Color.Gainsboro;
				}
				if (HID_PenY<240&&HID_PenY>0) {
					label_HID_PenY.BackColor=Color.Lime;
				} else {
					label_HID_PenY.BackColor=Color.Gainsboro;
				}
				if (HID_PenX<320&&HID_PenY<240&&
				    HID_PenX>0&&HID_PenY>0) {
					Kernel_HID_Paint(HID_PenX,HID_PenY);
				}
				//Stiftfarbe
				switch (args.data[10]) {
					case 0: label_HID_PenColor.Text="Weiss"; label_HID_PenColor.BackColor=Color.White; break;
					case 1: label_HID_PenColor.Text="Rot"; label_HID_PenColor.BackColor=Color.Red; break;
					case 2: label_HID_PenColor.Text="Grün"; label_HID_PenColor.BackColor=Color.Lime; break;
					case 3: label_HID_PenColor.Text="Blau"; label_HID_PenColor.BackColor=Color.RoyalBlue; break;
				}
				if (args.data[15]==1) { //Löschen
					Btn_HID_PicClrClick(null,null);
				}
				//textausgabe
				string rec_data = "";
                for (int i = 1;i< usbHid.SpecifiedDevice.InputReportLength;i++ ) {
                	rec_data += args.data[i].ToString() + " ";
                }
                txt_usb_recive.Text = rec_data;
            } //else (InvokeRequired)
		}
		
		void Kernel_HID_Paint(int X ,int Y)
		{
			if (!chk_HID_PaintAll.Checked) {
				if (X<81||Y>179) {
					return;
				}
			}
			ubmp_hid.LockBitmap();
			PixelData C = new PixelData();
			C.red=label_HID_PenColor.BackColor.R;
			C.green=label_HID_PenColor.BackColor.G;
			C.blue=label_HID_PenColor.BackColor.B;
			if (label_HID_key1.BackColor==Color.Lime) {
				ubmp_hid.SetPixel(X,Y,C);
			} else {
				ubmp_hid.SetPixel(X,Y,C);
				ubmp_hid.SetPixel(X+1,Y,C);
				ubmp_hid.SetPixel(X,Y+1,C);
				ubmp_hid.SetPixel(X+1,Y+1,C);
			}
			ubmp_hid.UnlockBitmap();
			pic_HID.Image=ubmp_hid.Bitmap;
//			int H = ubmp_hid.Bitmap.Height;
//			int W = ubmp_hid.Bitmap.Width;
//			for (int x=0;x<W;x++) {
//				for (int y=0;y<H;y++) {
//					
//				}
//			}
		}
		void Kernel_usb_info(string Infoline)
		{
			txt_usb_info.Text = Infoline + "\r\n" + txt_usb_info.Text;
		}
		//Events
		protected override void OnHandleCreated(EventArgs e)
        {
            base.OnHandleCreated(e);
            usbHid.RegisterHandle(Handle);
        }
		protected override void WndProc(ref Message m)
        {
            usbHid.ParseMessages(ref m);
            base.WndProc(ref m);	// pass message on to base form
        }
		void UsbHidOnDeviceArrived(object sender, EventArgs e)
		{
			Kernel_usb_info("IN:  USB Gerät");
		}
		void UsbHidOnDeviceRemoved(object sender, EventArgs e)
		{
			if (InvokeRequired) {
                Invoke(new EventHandler(UsbHidOnDeviceRemoved), new object[] { sender, e });
            } else {
				Kernel_usb_info("OUT: USB Gerät");
            }
		}
		void UsbHidOnSpecifiedDeviceArrived(object sender, EventArgs e)
		{
			Kernel_usb_info("IN:  STM32 Board - I/O ("+usbHid.SpecifiedDevice.InputReportLength.ToString()+
				"/"+ usbHid.SpecifiedDevice.OutputReportLength.ToString()+")");
			btn_usb_finddevice.BackColor = Color.LimeGreen;
			if (chk_HID_selectTab.Checked) {
				tabControl_main.SelectTab(TP_UsbHid);
			}			
		}
		void UsbHidOnSpecifiedDeviceRemoved(object sender, EventArgs e)
		{
			if (InvokeRequired) {
                Invoke(new EventHandler(UsbHidOnSpecifiedDeviceRemoved), new object[] { sender, e });
            } else {
				Kernel_usb_info("OUT: STM32 Board");
				btn_usb_finddevice.BackColor = Color.Red;
            }
		}
		#endregion
		
		#region Tab_STM32_reg
		//Code
		void Num_stm32_codebox_zoomValueChanged(object sender, EventArgs e)
		{
			txt_STM32_Code.ZoomFactor = (float)num_stm32_codebox_zoom.Value;
		}
		void Btn_stm32_codebox_undoClick(object sender, EventArgs e)
		{
			txt_STM32_Code.Undo();
		}
		void Btn_stm32_codebox_redoClick(object sender, EventArgs e)
		{
			txt_STM32_Code.Redo();
		}
		void Btn_stm32_codebox_clearClick(object sender, EventArgs e)
		{
			txt_STM32_Code.Clear();
			txt_STM32_Code.ZoomFactor=1f;
			txt_STM32_Code.ZoomFactor=(float)num_stm32_codebox_zoom.Value;
		}
		
		void Btn_conv_calcHEXClick(object sender, EventArgs e)
		{
			//#define A15 (*((volatile unsigned long *) 0x422101BC))
			//0x08 = GPIO in
			//0x0C = GPIO out
			long hexa = 0;
			hexa = Convert.ToUInt32(txt_conv_addGPIO.Text,16);
			hexa = (hexa * 0x20) + ((long)num_conv_giopPin.Value*4);
			txt_STM32_Code.Text += "bit Word offset: "+Convert.ToString(hexa,16).ToString()+" ";
			hexa += Convert.ToUInt32(txt_conv_addGPIO_base.Text,16);
			txt_STM32_Code.Text += "Adress: "+Convert.ToString(hexa,16).ToString();
		}
		void Btn_stm32_zugriff_generateClick(object sender, EventArgs e)
		{
			long Port = 0; long Typ = 0; long Pin = (long)nume_stm32_zugriff_pin.Value;
			StringBuilder SB_PinName = new StringBuilder("GPIO");
			if (STM32Chipmode=="F1") {
				//STM32F1xx
				switch (cb_stm32_zugriff_port.SelectedIndex) {
					case 0: Port = 0x10800;	SB_PinName.Append("A_"); break;
					case 1: Port = 0x10C00;	SB_PinName.Append("B_"); break;
					case 2: Port = 0x11000;	SB_PinName.Append("C_"); break;
					case 3: Port = 0x11400;	SB_PinName.Append("D_"); break;
					case 4: Port = 0x11800;	SB_PinName.Append("E_"); break;
					case 5: Port = 0x11C00;	SB_PinName.Append("F_"); break;
					case 6: Port = 0x12000;	SB_PinName.Append("G_"); break;
					default: txt_STM32_Code.AppendColorText("Nicht unterstützt: "+
							cb_stm32_zugriff_port.SelectedItem.ToString()+"\r\n",Color.Red); return;
				}
				switch (cb_stm32_zugriff_typ.SelectedIndex) {
					case 0:	Typ = 0x08; SB_PinName.Append("I"); break; //IDR
					case 1:	Typ = 0x0C; SB_PinName.Append("O"); break; //ODR
					default: txt_STM32_Code.AppendColorText("Nicht unterstützt: "+
							cb_stm32_zugriff_typ.SelectedItem.ToString()+"\r\n",Color.Red); return;
				}
			} else if (STM32Chipmode=="F4") {
				//STM32F4xx
				switch (cb_stm32_zugriff_port.SelectedIndex) {
					case 0: Port = 0x20000;	SB_PinName.Append("A_"); break;
					case 1: Port = 0x20400;	SB_PinName.Append("B_"); break;
					case 2: Port = 0x20800;	SB_PinName.Append("C_"); break;
					case 3: Port = 0x20C00;	SB_PinName.Append("D_"); break;
					case 4: Port = 0x21000;	SB_PinName.Append("E_"); break;
					case 5: Port = 0x21400;	SB_PinName.Append("F_"); break;
					case 6: Port = 0x21800;	SB_PinName.Append("G_"); break;
					case 7: Port = 0x21C00;	SB_PinName.Append("H_"); break;
					case 8: Port = 0x22000;	SB_PinName.Append("I_"); break;
					default: txt_STM32_Code.AppendColorText("Nicht unterstützt: "+
							cb_stm32_zugriff_port.SelectedItem.ToString()+"\r\n",Color.Red); return;
				}
				switch (cb_stm32_zugriff_typ.SelectedIndex) {
					case 0:	Typ = 0x10; SB_PinName.Append("I"); break; //IDR
					case 1:	Typ = 0x14; SB_PinName.Append("O"); break; //ODR
					default: txt_STM32_Code.AppendColorText("Nicht unterstützt: "+
							cb_stm32_zugriff_typ.SelectedItem.ToString()+"\r\n",Color.Red); return;
				}
			} else {
				MessageBox.Show("STM32 Chip der Funktion nicht bekannt"); return;
			}
			
			SB_PinName.Append(Pin.ToString());
			long GPIO_Port = ((Port+Typ)*0x20)+(Pin*4);
			//STM32 Expert tutorial seite 22
			GPIO_Port+=0x42000000; //Peripheral bit band alias base
			
			txt_STM32_Code.AppendColorText("#define ",Color.DarkMagenta);
			txt_STM32_Code.AppendColorText(SB_PinName.ToString()+" (*((volatile unsigned long *) ",Color.Black);
			txt_STM32_Code.AppendColorText("0x"+GPIO_Port.ToString("X8"),Color.Blue);
			txt_STM32_Code.AppendColorText(")) ",Color.Black);
			txt_STM32_Code.AppendColorText("//"+SB_PinName.ToString()+"\r\n",Color.Green);
		}
		void Nume_stm32_zugriff_pinValueChanged(object sender, EventArgs e)
		{
			btn_stm32_zugriff_generate.PerformClick();
		}
		
		void Btn_stm32_gpio_GenerateClick(object sender, EventArgs e)
		{
			bool GenerateAF = false;
//			if (txt_STM32_Code.Text.Contains("STM32_GPIO_Setup")) {
//				txt_STM32_Code.Clear(); txt_STM32_Code.ZoomFactor=1f;
//				txt_STM32_Code.ZoomFactor=(float)num_stm32_codebox_zoom.Value;
//			}
			txt_STM32_Code.AppendColorText("void ",Color.Red);
			txt_STM32_Code.AppendColorText("STM32_GPIO_Setup()\r\n{\r\n",Color.Black);
			foreach(Control C in TP_STM32_Setup_GPIOSetup.Controls) {
				if (C.Enabled==false) { continue; }
				if (C.Name.StartsWith("chk_stm32Gpio")) {
					CheckBox chk = C as CheckBox;
					if (chk.Checked) {
						//MessageBox.Show(chk.Name.Remove(0,21));
						if (Kernel_GpioGenerate(chk.Name.Remove(0,21))) { GenerateAF=true; }
					} else {
						txt_STM32_Code.AppendColorText("\t//GPIO"+chk.Name.Remove(0,21)+" Offline\r\n",Color.Green);
					}
				}
			}
			if (GenerateAF) {
				txt_STM32_Code.AppendColorText("\r\n\tRCC->APB2ENR |= 1; ",Color.Black);
				txt_STM32_Code.AppendColorText("\t//Alternative Funktion Clock\r\n",Color.Green);
			} else {
				if (STM32Chipmode=="F1") {
					txt_STM32_Code.AppendColorText("\r\n\t//RCC->APB2ENR |= 1; //AF Clock Offline\r\n",Color.Green);
				}
			}
			txt_STM32_Code.AppendColorText("{ ",Color.Black);
			txt_STM32_Code.AppendColorText(" //STM32_GPIO_Setup()\r\n",Color.Green);
		}
		bool Kernel_GpioGenerate(string Port)
		{
			txt_STM32_Code.AppendColorText("\t//GPIO"+Port+" Setup:\r\n",Color.Green);
			bool use_AF = false; string[] data = new string[0];
			foreach(Control C in tabControl_stm32_GpioSetup.Controls) {
				foreach(Control CC in C.Controls) {
					if (CC.Name.StartsWith("stM32_GPIO")) {
						if (CC.Name.EndsWith(Port)) {
							STM32_GPIO_Conf CFG = CC as STM32_GPIO_Conf;
							switch (STM32Chipmode) {
								case "F1":
									switch (Port) {
										case "A": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<2; ",Color.Black); break;
										case "B": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<3; ",Color.Black); break;
										case "C": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<4; ",Color.Black); break;
										case "D": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<5; ",Color.Black); break;
										case "E": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<6; ",Color.Black); break;
										case "F": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<7; ",Color.Black); break;
										case "G": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<8; ",Color.Black); break;
									}
									txt_STM32_Code.AppendColorText("\t//Clock einschalten\r\n",Color.Green);
									data = CFG.Report_F1xx_CRL();
									txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
									txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
									txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									data = CFG.Report_F1xx_CRH();
									txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
									txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
									txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									data = CFG.Report_F1xx_ODR();
									txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
									txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
									txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									use_AF=CFG.Get_AF_Online();
									break;
								case "F4":
									switch (Port) {
										case "A": txt_STM32_Code.AppendColorText("\tRCC->APB1ENR |= 1; ",Color.Black); break;
										case "B": txt_STM32_Code.AppendColorText("\tRCC->APB1ENR |= 1<<1; ",Color.Black); break;
										case "C": txt_STM32_Code.AppendColorText("\tRCC->APB1ENR |= 1<<2; ",Color.Black); break;
										case "D": txt_STM32_Code.AppendColorText("\tRCC->APB1ENR |= 1<<3; ",Color.Black); break;
										case "E": txt_STM32_Code.AppendColorText("\tRCC->APB1ENR |= 1<<4; ",Color.Black); break;
										case "F": txt_STM32_Code.AppendColorText("\tRCC->APB1ENR |= 1<<5; ",Color.Black); break;
										case "G": txt_STM32_Code.AppendColorText("\tRCC->APB1ENR |= 1<<6; ",Color.Black); break;
										case "H": txt_STM32_Code.AppendColorText("\tRCC->APB1ENR |= 1<<7; ",Color.Black); break;
										case "I": txt_STM32_Code.AppendColorText("\tRCC->APB1ENR |= 1<<8; ",Color.Black); break;
									}
									txt_STM32_Code.AppendColorText("\t//Clock einschalten\r\n",Color.Green);
									data = CFG.Report_F4xx_MODER();
									txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
									txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
									txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									data = CFG.Report_F4xx_OTYPER();
									txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
									txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
									txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									data = CFG.Report_F4xx_OSPEEDR();
									txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
									txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
									txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									data = CFG.Report_F4xx_PUPDR();
									txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
									txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
									txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									use_AF=CFG.Get_AF_Online();
									break;
							}
							return use_AF;
						} //if (CC.Name.EndsWith
					} //if (CC.Name.StartsWith
				} //foreach(Control CC
			} //foreach(Control C
			return use_AF;
		}
		
		void Btn_stm32_pinC_generateClick(object sender, EventArgs e)
		{
			int Pin = (int)nume_stm32_pinC_pin.Value; 
			string port = ""; string reg = ""; string mask = ""; long hexval = 0; string typ = "";
			StringBuilder SB = new StringBuilder("GPIO");
			if (STM32Chipmode=="F1") {
				//STM32F1xx
				switch (cb_stm32_pinC_port.SelectedIndex) {
					case 0: port = "A"; break;
					case 1: port = "B"; break;
					case 2: port = "C"; break;
					case 3: port = "D"; break;
					case 4: port = "E"; break;
					case 5: port = "F"; break;
					case 6: port = "G"; break;
				}
				if (Pin>7) { 
					reg="CRH"; 
				} else { 
					reg="CRL"; 
				}
				switch (Pin) {
					case 0: case 8: mask = "0xFFFFFFF0"; break;
					case 1: case 9: mask = "0xFFFFFF0F"; break;
					case 2: case 10: mask = "0xFFFFF0FF"; break;
					case 3: case 11: mask = "0xFFFF0FFF"; break;
					case 4: case 12: mask = "0xFFF0FFFF"; break;
					case 5: case 13: mask = "0xFF0FFFFF"; break;
					case 6: case 14: mask = "0xF0FFFFFF"; break;
					case 7: case 15: mask = "0x0FFFFFFF"; break;
				}
				switch (cb_stm32_pinC_typ.SelectedIndex) {
					case 0: typ = "IF"; hexval = 4<<Pin*4; break; //IF = in Floating
					case 1: typ = "IA"; break; //IA = in Analog
					case 2: typ = "IU/ID"; hexval = 8<<Pin*4; break; //IU/ID = IF mit Pull up/down
					case 3: typ = "PP 50MHz"; hexval = 3<<Pin*4; break; //PP = PushPull 50MHz
					case 4: typ = "OD 50MHz"; hexval = 7<<Pin*4; break; //OD = OpenDrain 50MHz
					case 5: typ = "AP 50MHz"; hexval = 11<<Pin*4; break; //AP = Alt PP 50MHz
					case 6: typ = "AD 50MHz"; hexval = 15<<Pin*4; break; //AD = Alt OD 50MHz
					case 7: typ = "PP 10MHz"; hexval = 1<<Pin*4; break; //PP = PushPull 10MHz
					case 8: typ = "OD 10MHz"; hexval = 5<<Pin*4; break; //OD = OpenDrain 10MHz
					case 9: typ = "PP 2MHz"; hexval = 2<<Pin*4; break; //PP = PushPull 2MHz
					case 10: typ = "OD 2MHz"; hexval = 6<<Pin*4; break; //OD = OpenDrain 2MHz
				}
			} else if (STM32Chipmode=="F4") {
				//STM32F4xx
				switch (cb_stm32_pinC_port.SelectedIndex) {
					case 0: port = "A"; break;
					case 1: port = "B"; break;
					case 2: port = "C"; break;
					case 3: port = "D"; break;
					case 4: port = "E"; break;
					case 5: port = "F"; break;
					case 6: port = "G"; break;
					case 7: port = "H"; break;
					case 8: port = "I"; break;
				}
				reg="MODER"; 
				switch (Pin) {
					case 0: mask = "0xFFFFFFFC"; break;
					case 1: mask = "0xFFFFFFF3"; break;
					case 2: mask = "0xFFFFFFCF"; break;
					case 3: mask = "0xFFFFFF3F"; break;
					case 4: mask = "0xFFFFFCFF"; break;
					case 5: mask = "0xFFFFF3FF"; break;
					case 6: mask = "0xFFFFCFFF"; break;
					case 7: mask = "0xFFFF3FFF"; break;
					case 8: mask = "0xFFFCFFFF"; break;
					case 9: mask = "0xFFF3FFFF"; break;
					case 10: mask = "0xFFCFFFFF"; break;
					case 11: mask = "0xFF3FFFFF"; break;
					case 12: mask = "0xFCFFFFFF"; break;
					case 13: mask = "0xF3FFFFFF"; break;
					case 14: mask = "0xCFFFFFFF"; break;
					case 15: mask = "0x3FFFFFFF"; break;
				}
				switch (cb_stm32_pinC_typ.SelectedIndex) {
					case 0: typ = "IF"; break; //IF = in Floating
					case 1: typ = "IA"; hexval = 3<<Pin*2; break; //IA = in Analog
					case 2: typ = "Out PP/OD"; hexval = 1<<Pin*2; break; //OP = GPIO PP oder OD
					case 3: typ = "Out AP/AD"; hexval = 2<<Pin*2; break; //OA = GPIO AP oder AD
				}
			}
			
			txt_STM32_Code.AppendColorText("GPIO"+port+"->"+reg+" = (GPIO"+port+"->"+reg+" & ",Color.Black);
			txt_STM32_Code.AppendColorText(mask,Color.Blue);
			txt_STM32_Code.AppendColorText(") | ",Color.Black);
			txt_STM32_Code.AppendColorText("0x"+hexval.ToString("X08"),Color.Blue);
			txt_STM32_Code.AppendColorText(";   ",Color.Black);
			txt_STM32_Code.AppendColorText("//Pin"+Pin.ToString()+" -> "+typ+"\r\n",Color.Green);
			//GPIOC->CRL = (GPIOC->CRL & 0xF0FFFFFF) | 0x03000000; //Pin 6 OP
		}
		
		void Btn_stm32_BoardCfgClick(object sender, EventArgs e)
		{
			Kernel_boardconfigfile();
			btn_stm32_BoardCfg.BackColor=Color.LimeGreen; Thread.Sleep(300);
			btn_stm32_BoardCfg.BackColor=Color.Gainsboro;
		}
		void Kernel_boardconfigfile()
		{
			//Datei erstellen
			STM32BoardCfgInhalt=txt_STM32_Code.Lines;
//			if (STM32BoardCfgFilename=="") {
//				saveFileDialog1.FileName="boardcfg.c";
//				if (saveFileDialog1.ShowDialog()!=DialogResult.OK) { return; }
//				STM32BoardCfgFilename=saveFileDialog1.FileName;
//			}
			saveFileDialog1.FileName="boardcfg.c";
			if (saveFileDialog1.ShowDialog()!=DialogResult.OK) { return; }
			STM32BoardCfgFilename=saveFileDialog1.FileName;
			
			StreamWriter txt = new StreamWriter(STM32BoardCfgFilename);
			foreach(string S in STM32BoardCfgInhalt) {
				txt.WriteLine(S);
			}
			txt.Close();
		}
		
		//Setup
		void Rad_STMF1CheckedChanged(object sender, EventArgs e)
		{
			if (rad_STMF1.Checked) {
				if (STM32Chipmode=="F1") { return; }
				if (STM32Chipmode=="") { STM32Chipmode="F1"; Kernel_STM32ChipChange(); return; }
				if (MessageBox.Show("Chiptypwechsel setzt viele Einstellungen zurück.\r\n"+
				    	"Wechsel ausführen?","Wechsel auf F1xx",MessageBoxButtons.YesNo)==DialogResult.Yes) {
					STM32Chipmode="F1";
					Kernel_STM32ChipChange();
				}
			}
		}
		void Rad_STMF4CheckedChanged(object sender, EventArgs e)
		{
			if (rad_STMF4.Checked) {
				if (STM32Chipmode=="F4") { return; }
				if (STM32Chipmode=="") { STM32Chipmode="F4"; Kernel_STM32ChipChange(); return; }
				if (MessageBox.Show("Chiptypwechsel setzt viele Einstellungen zurück.\r\n"+
				    	"Wechsel ausführen?","Wechsel auf F4xx",MessageBoxButtons.YesNo)==DialogResult.Yes) {
					STM32Chipmode="F4";
					Kernel_STM32ChipChange();
				}
			}
		}
		void Chk_stm32Gpio_Enable_AllCheckedChanged(object sender, EventArgs e)
		{
			//chk_stm32Gpio_Enable_H
			CheckBox CHK = sender as CheckBox;
			CHK.BackColor=(CHK.Checked) ? Color.LimeGreen : Color.Gainsboro;
			Color C = (CHK.Checked) ? Color.LimeGreen : Color.Gainsboro;
			switch (CHK.Name[21]) {
				case 'A': stM32_GPIO_ConfA.label_GpioPort.BackColor=C; break;
				case 'B': stM32_GPIO_ConfB.label_GpioPort.BackColor=C; break;
				case 'C': stM32_GPIO_ConfC.label_GpioPort.BackColor=C; break;
				case 'D': stM32_GPIO_ConfD.label_GpioPort.BackColor=C; break;
				case 'E': stM32_GPIO_ConfE.label_GpioPort.BackColor=C; break;
				case 'F': stM32_GPIO_ConfF.label_GpioPort.BackColor=C; break;
				case 'G': stM32_GPIO_ConfG.label_GpioPort.BackColor=C; break;
				case 'H': stM32_GPIO_ConfH.label_GpioPort.BackColor=C; break;
				case 'I': stM32_GPIO_ConfI.label_GpioPort.BackColor=C; break;
			}
		}
		void Btn_stm32_GPIO_OverrideClick(object sender, EventArgs e)
		{
			string[] inhalt = txt_STM32_Code.Lines;
			Btn_stm32_codebox_clearClick(null,null);
			bool changed=false; string PortRemove = ""; bool Arbeitsbereich = false; bool fertig = false;
			for (int i=0;i<inhalt.Length ;i++ ) {
				
				if (!Arbeitsbereich) {
					if (!inhalt[i].Contains("STM32_GPIO_Setup()")) { 
						//bis zur Setupfunktion weitergelaufen
						txt_STM32_Code.AppendText(inhalt[i]+"\r\n");
						continue;
					}
					Arbeitsbereich=true;
				} else {
					if (inhalt[i].StartsWith("}  //STM32_GPIO_Setup()")) {
						fertig=true;
					}
					if (fertig) {
						txt_STM32_Code.AppendText(inhalt[i]+"\r\n"); continue;
					}
				}
				
				changed=false;
				if (inhalt[i].Contains("GPIO"+PortRemove+"->")) { continue; }
				foreach(Control C in TP_STM32_Setup_GPIOSetup.Controls) {
					if (C.Enabled==false) { continue; }
					if (C.Name.StartsWith("chk_")) {
						CheckBox chk = C as CheckBox; string Port = chk.Name.Remove(0,21);
						if (inhalt[i].Contains("(GPIO"+Port+"->")) { break; }
						if (chk.Checked) { //einschalten
							if (inhalt[i].Contains("GPIO"+Port)) {
								if (inhalt[i].Contains("//GPIO"+Port+" Offline")) {
									txt_STM32_Code.AppendColorText("\t//GPIO"+Port+" Setup:\r\n",Color.Green);
									switch (STM32Chipmode) {
										case "F1":
											switch (Port) {
												case "A": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<2; ",Color.Black); break;
												case "B": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<3; ",Color.Black); break;
												case "C": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<4; ",Color.Black); break;
												case "D": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<5; ",Color.Black); break;
												case "E": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<6; ",Color.Black); break;
												case "F": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<7; ",Color.Black); break;
												case "G": txt_STM32_Code.AppendColorText("\tRCC->APB2ENR |= 1<<8; ",Color.Black); break;
											}
											break;
										case "F4":
											switch (Port) {
												case "A": txt_STM32_Code.AppendColorText("\tRCC->AHB1ENR |= 1; ",Color.Black); break;
												case "B": txt_STM32_Code.AppendColorText("\tRCC->AHB1ENR |= 1<<1; ",Color.Black); break;
												case "C": txt_STM32_Code.AppendColorText("\tRCC->AHB1ENR |= 1<<2; ",Color.Black); break;
												case "D": txt_STM32_Code.AppendColorText("\tRCC->AHB1ENR |= 1<<3; ",Color.Black); break;
												case "E": txt_STM32_Code.AppendColorText("\tRCC->AHB1ENR |= 1<<4; ",Color.Black); break;
												case "F": txt_STM32_Code.AppendColorText("\tRCC->AHB1ENR |= 1<<5; ",Color.Black); break;
												case "G": txt_STM32_Code.AppendColorText("\tRCC->AHB1ENR |= 1<<6; ",Color.Black); break;
												case "H": txt_STM32_Code.AppendColorText("\tRCC->AHB1ENR |= 1<<7; ",Color.Black); break;
												case "I": txt_STM32_Code.AppendColorText("\tRCC->AHB1ENR |= 1<<8; ",Color.Black); break;
											}
											break;
									}
									txt_STM32_Code.AppendColorText("\t//Clock einschalten\r\n",Color.Green);
									sub_GpioOverride(Port,"ENABLE");
									changed=true; break;// if (inhalt[i].Contains("//GPIO"+Port+" Setup:"))
								} else { //ist schon aktiv
//									txt_STM32_Code.AppendColorText("\t//GPIO"+Port+" Setup:\r\n",Color.Green);									
									if (inhalt[i].Contains("GPIO"+Port+"->")) {
										sub_GpioOverride(Port, inhalt[i]);
										changed=true; break;
									}
									
								}
							}
						} else { //ausschalten
							if (inhalt[i].Contains("//GPIO"+Port+" Offline")) {
								txt_STM32_Code.AppendColorText("\t//GPIO"+Port+" Offline\r\n",Color.Green);
								changed=true; break;
							} else { //ist noch aktiv
								if (inhalt[i].Contains("//GPIO"+Port+" Setup:")) {
									txt_STM32_Code.AppendColorText("\t//GPIO"+Port+" Offline\r\n",Color.Green);
									PortRemove=Port;
									i++;//RCC->APB2ENR überspringen
									changed=true; break;
								}
							}
						}
					}
				}
				
				if (!changed) {
					txt_STM32_Code.AppendText(inhalt[i]+"\r\n");
				}
			}
			if (chk_stm32_overrideSave.Checked) {
				txt_stm32_Filepath.BackColor=Color.LimeGreen; txt_stm32_Filepath.Refresh();
				StreamWriter txt = new StreamWriter(txt_stm32_Filepath.Text);
				foreach(string S in txt_STM32_Code.Lines) {
					txt.WriteLine(S);
				}
				txt.Close();
				Thread.Sleep(300);
				txt_stm32_Filepath.BackColor=Color.White;
			}
		}
		void sub_GpioOverride(string Port, string S)
		{
			string[] data = new string[0];
			foreach(Control C in tabControl_stm32_GpioSetup.Controls) {
				foreach(Control CC in C.Controls) {
					if (CC.Name.StartsWith("stM32_GPIO")) {
						if (CC.Name.EndsWith(Port)) {
							STM32_GPIO_Conf CFG = CC as STM32_GPIO_Conf;
							switch (STM32Chipmode) {
								case "F1":
									if (S.Contains("CRL")) {
										data = CFG.Report_F1xx_CRL();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									} else if (S.Contains("CRH")) {
										data = CFG.Report_F1xx_CRH();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									} else if (S.Contains("ODR")) {
										data = CFG.Report_F1xx_ODR();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									} else if (S=="ENABLE") {
										data = CFG.Report_F1xx_CRL();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
										data = CFG.Report_F1xx_CRH();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
										data = CFG.Report_F1xx_ODR();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									}
									break;
								case "F4":
									if (S.Contains("MODER")) {
										data = CFG.Report_F4xx_MODER();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									} else if (S.Contains("OTYPER")) {
										data = CFG.Report_F4xx_OTYPER();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									} else if (S.Contains("OSPEEDR")) {
										data = CFG.Report_F4xx_OSPEEDR();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									} else if (S.Contains("PUPDR")) {
										data = CFG.Report_F4xx_PUPDR();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									} else if (S=="ENABLE") {
										data = CFG.Report_F4xx_MODER();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
										data = CFG.Report_F4xx_OTYPER();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
										data = CFG.Report_F4xx_OSPEEDR();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
										data = CFG.Report_F4xx_PUPDR();
										txt_STM32_Code.AppendColorText("\t"+data[0],Color.Black);
										txt_STM32_Code.AppendColorText(data[1],Color.DarkMagenta);
										txt_STM32_Code.AppendColorText(data[2]+"\r\n",Color.Green);
									}
									break;
							}
						} //if (CC.Name.EndsWith
					} //if (CC.Name.StartsWith
				} //foreach(Control CC
			} //foreach(Control C
		}
		
		void Kernel_STM32ChipChange()
		{
			cb_stm32_pinC_typ.Items.Clear();
			cb_stm32_pinC_typ.Items.Add("IF = in Floating");
			cb_stm32_pinC_typ.Items.Add("IA = in Analog");
			switch (STM32Chipmode) {
				case "F1":
					groupBox_GPIO_Bitadressenrechner.Text="GPIO Bitadressenrechner F1xx";
					if (tabControl_stm32_GpioSetup.TabPages.Contains(tabPage_GH)) {
						chk_stm32Gpio_Enable_H.Checked = false;
						chk_stm32Gpio_Enable_H.Enabled = false;
						tabControl_stm32_GpioSetup.TabPages.Remove(tabPage_GH);
					}
					if (tabControl_stm32_GpioSetup.TabPages.Contains(tabPage_GI)) {
						chk_stm32Gpio_Enable_I.Checked = false;
						chk_stm32Gpio_Enable_I.Enabled = false;
						tabControl_stm32_GpioSetup.TabPages.Remove(tabPage_GI);
					}
					cb_stm32_pinC_typ.Items.Add("IU/ID = IF mit Pull up/down");
					cb_stm32_pinC_typ.Items.Add("PP = PushPull 50MHz");
					cb_stm32_pinC_typ.Items.Add("OD = OpenDrain 50MHz");
					cb_stm32_pinC_typ.Items.Add("AP = Alt PP 50MHz");
					cb_stm32_pinC_typ.Items.Add("AD = Alt OD 50MHz");
					break;
				case "F4":
					groupBox_GPIO_Bitadressenrechner.Text="GPIO Bitadressenrechner F4xx";
					if (!tabControl_stm32_GpioSetup.TabPages.Contains(tabPage_GH)) {
						tabControl_stm32_GpioSetup.TabPages.Add(tabPage_GH);
						chk_stm32Gpio_Enable_H.Enabled = true;
					}
					if (!tabControl_stm32_GpioSetup.TabPages.Contains(tabPage_GI)) {
						tabControl_stm32_GpioSetup.TabPages.Add(tabPage_GI);
						chk_stm32Gpio_Enable_I.Enabled = true;
					}
					cb_stm32_pinC_typ.Items.Add("OP = GPIO PP oder OD");
					cb_stm32_pinC_typ.Items.Add("OA = GPIO AP oder AD");
					break;
			}
			stM32_GPIO_ConfA.label_Typ.Text=STM32Chipmode+"xx";
			stM32_GPIO_ConfB.label_Typ.Text=STM32Chipmode+"xx";
			stM32_GPIO_ConfC.label_Typ.Text=STM32Chipmode+"xx";
			stM32_GPIO_ConfD.label_Typ.Text=STM32Chipmode+"xx";
			stM32_GPIO_ConfE.label_Typ.Text=STM32Chipmode+"xx";
			stM32_GPIO_ConfF.label_Typ.Text=STM32Chipmode+"xx";
			stM32_GPIO_ConfG.label_Typ.Text=STM32Chipmode+"xx";
			stM32_GPIO_ConfH.label_Typ.Text=STM32Chipmode+"xx";
			stM32_GPIO_ConfI.label_Typ.Text=STM32Chipmode+"xx";
			cb_stm32_pinC_typ.SelectedIndex=0;
		}
		
		void sub_GrabSTM32Infos(string Port,string typ,string wert)
		{
			try {
				foreach(Control C in tabControl_stm32_GpioSetup.Controls) {
					foreach(Control CC in C.Controls) {
						if (CC.Name.StartsWith("stM32_GPIO")) {
							if (CC.Name.EndsWith(Port)) {
								STM32_GPIO_Conf CFG = CC as STM32_GPIO_Conf;
								switch (STM32Chipmode) {
									case "F1":
										switch (typ) {
											case "CRL": CFG.Set_F1xx_CRL(wert); break;
											case "CRH": CFG.Set_F1xx_CRH(wert); break;
											case "ODR": CFG.Set_F1xx_ODR(wert); break;
										}
										break;
									case "F4":
										switch (typ) {
											case "MODER": CFG.Set_F4xx_MODER(wert); break;
											case "OTYPER": CFG.Set_F4xx_OTYPER(wert); break;
											case "OSPEEDR": CFG.Set_F4xx_OSPEEDR(wert); break;
											case "PUPDR": CFG.Set_F4xx_PUPDR(wert); break;
										}
										break;
								}
							} //if (CC.Name.EndsWith
						} //if (CC.Name.StartsWith
					} //foreach(Control CC
				} //foreach(Control C
			} catch (Exception err) {
				MessageBox.Show(err.Message,"sub_GrabSTM32Infos()");
			}
		}
		//CTRL HID GUI ###############################
		void sub_clear_GUI_CBs()
		{
			cb_stm32_CTRL_txt1.Items.Clear();
			cb_stm32_CTRL_btn1.Items.Clear();
			cb_stm32_CTRL_PBar_Chan.Items.Clear();
			cb_stm32_CTRL_Box_chan.Items.Clear();
			cb_stm32_CTRL_Line_Chan.Items.Clear();
			cb_stm32_CTRL_txt1.Items.Add("Neuer Channel...");
			cb_stm32_CTRL_btn1.Items.Add("Neuer Channel...");
			cb_stm32_CTRL_PBar_Chan.Items.Add("Neuer Channel...");
			cb_stm32_CTRL_Box_chan.Items.Add("Neuer Channel...");
			cb_stm32_CTRL_Line_Chan.Items.Add("Neuer Channel...");
			cb_stm32_CTRL_txt1.SelectedIndex=0;
			cb_stm32_CTRL_btn1.SelectedIndex=0;
			cb_stm32_CTRL_PBar_Chan.SelectedIndex=0;
			cb_stm32_CTRL_Box_chan.SelectedIndex=0;
			cb_stm32_CTRL_Line_Chan.SelectedIndex=0;
		}
		void TabControl4SelectedIndexChanged(object sender, EventArgs e)
		{
	  		Lock_CTRL=false;
		}
		void Btn_stm32_CTRL_saveClick(object sender, EventArgs e)
		{
			//saveFileDialog1.InitialDirectory=Environment.CurrentDirectory;
			saveFileDialog1.Filter = "GUI Setup (*.gui)|*.gui|Alle Datein (*.*)|*.*";
			if (saveFileDialog1.ShowDialog()!=DialogResult.OK) {
				return;
			}
			StreamWriter txt = new StreamWriter(saveFileDialog1.FileName);
			// Rechtecke ###############################################
			foreach (Object O in cb_stm32_CTRL_Box_chan.Items) {
				txt.WriteLine(O.ToString());
			}
			// texte ###############################################
			foreach (Object O in cb_stm32_CTRL_txt1.Items) {
				txt.WriteLine(O.ToString());
			}
			// Buttons ###############################################
			foreach (Object O in cb_stm32_CTRL_btn1.Items) {
				txt.WriteLine(O.ToString());
			}
			// ProgressBars ###############################################
			foreach (Object O in cb_stm32_CTRL_PBar_Chan.Items) {
				txt.WriteLine(O.ToString());
			}
			// Lines ###############################################
			foreach (Object O in cb_stm32_CTRL_Line_Chan.Items) {
				txt.WriteLine(O.ToString());
			}
			txt.Close();
		}
		void Btn_stm32_CTRL_loadClick(object sender, EventArgs e)
		{
			//openFileDialog1.InitialDirectory=Environment.CurrentDirectory;
			openFileDialog1.Filter = "GUI Setup (*.gui)|*.gui|Alle Datein (*.*)|*.*";
			if (openFileDialog1.ShowDialog()!=DialogResult.OK) {
				return;
			}
			sub_readout_Stm32Gui(openFileDialog1.FileName);
			Lock_CTRL=false;
		}
		void Btn_stm32_CTRL_clearClick(object sender, EventArgs e)
		{
			sub_clear_GUI_CBs();
		}
		void Btn_stm32_CTRL_ClearLCDClick(object sender, EventArgs e)
		{
			if (!chk_stm32_CTRL_HIDSEND.Checked) { return; }
			if (btn_usb_finddevice.BackColor!=Color.LimeGreen) { return; }
			if (chk_stm32_CTRL_HIDSEND_autoredraw.Checked) {
				Kernel_sendHID(new byte[]{20,1});
				StringBuilder SB = new StringBuilder();
				//SB.AppendLine("auto redraw:");
				SB.AppendLine("//Rechtecke:");
				// Rechtecke ###############################################
				foreach (Object O in cb_stm32_CTRL_Box_chan.Items) {
					if (O.ToString().StartsWith("LCD")) {
						SB.AppendLine(O.ToString()); int offset=0;
						if (O.ToString().StartsWith("LCD_DrawFill")) { offset=19; } else { offset=13; }
						//Decode
						string[] splits = O.ToString().Remove(0,offset).Split(',');
						int X = 0; int Y = 0; int H = 0; int W = 0; long col = 0;
						int.TryParse(splits[0],out X);
						int.TryParse(splits[1],out Y);
						int.TryParse(splits[2],out H);
						int.TryParse(splits[3],out W);
						col = Convert.ToUInt32(splits[4].Split(')')[0].Trim(),16);
						
						//Transmit
						byte[] data = new byte[usbHid.SpecifiedDevice.OutputReportLength-2];
						data[0]=24;//GUI box
						data[1]=(byte)(X>>8&255);
						data[2]=(byte)(X&255);
						data[3]=(byte)(Y>>8&255);
						data[4]=(byte)(Y&255);
						data[5]=(byte)(H>>8&255);
						data[6]=(byte)(H&255);
						data[7]=(byte)(W>>8&255);
						data[8]=(byte)(W&255);
						data[9]=(byte)(col>>8&255);
						data[10]=(byte)(col&255);
						if (offset==19) { data[11]=1; } else { data[11]=0; }
						Kernel_sendHID(data); //Thread.Sleep(100);
					}
				}
				SB.AppendLine("//Texte:");
				// texte ###############################################
				foreach (Object O in cb_stm32_CTRL_txt1.Items) {
					if (O.ToString().StartsWith("LCD")) {
						SB.AppendLine(O.ToString());
						//Decode
						string[] splits = O.ToString().Remove(0,13).Split(',');
						int X = 0; int Y = 0; long Fore16bit = 0; long Back16bit = 0;
						int.TryParse(splits[0],out X);
						int.TryParse(splits[1],out Y);
						string text = splits[2].Trim().Replace("\"","");
						Fore16bit = Convert.ToUInt32(splits[3].Trim(),16);
						Back16bit = Convert.ToUInt32(splits[4].Trim(),16);
						string font = splits[5].Split('_')[1].Trim(); int count = 1;
						foreach(object o in cb_stm32_CTRL_txt1_font.Items) {
							if (font.StartsWith(o.ToString())) {
								break;
							}
							count++;
						}
						//Transmit
						byte[] data = new byte[usbHid.SpecifiedDevice.OutputReportLength-2];
						data[0]=21;
						data[1]=(byte)(X>>8&255);
						data[2]=(byte)(X&255);
						data[3]=(byte)(Y>>8&255);
						data[4]=(byte)(Y&255);
						data[5]=(byte)(Fore16bit>>8&255);
						data[6]=(byte)(Fore16bit&255);
						data[7]=(byte)(Back16bit>>8&255);
						data[8]=(byte)(Back16bit&255);
						data[9]=(byte)(count);
						data[10]=(byte)text.Length;
						int cnt = 11;
						foreach(char C in text) {
							data[cnt]=(byte)C;cnt++;
						}
						Kernel_sendHID(data); //Thread.Sleep(100);
					}
				}
				SB.AppendLine("//Buttons:");
				// Buttons ###############################################
				foreach (Object O in cb_stm32_CTRL_btn1.Items) {
					if (O.ToString().StartsWith("LCD")) {
						SB.AppendLine(O.ToString());
						//Decode
						string[] splits = O.ToString().Remove(0,15).Split(',');
						int X = 0; int Y = 0; int H = 0; int W = 0; long Fore16bit = 0; long Back16bit = 0;
						int.TryParse(splits[1],out X);
						int.TryParse(splits[2],out Y);
						int.TryParse(splits[3],out H);
						int.TryParse(splits[4],out W);
						string text = splits[5].Trim().Replace("\"","");
						string Typ = splits[6];
						Fore16bit = Convert.ToUInt32(splits[8].Trim(),16);
						Back16bit = Convert.ToUInt32(splits[9].Split(')')[0].Trim(),16);
						string font = splits[7].Split('_')[1].Trim(); int count = 1;
						foreach(object o in cb_stm32_CTRL_btn1_font.Items) {
							if (font.StartsWith(o.ToString())) {
								break;
							}
							count++;
						}
						//Transmit
						byte[] data = new byte[usbHid.SpecifiedDevice.OutputReportLength-2];
						data[0]=22;
						data[1]=(byte)(X>>8&255);
						data[2]=(byte)(X&255);
						data[3]=(byte)(Y>>8&255);
						data[4]=(byte)(Y&255);
						data[5]=(byte)(H>>8&255);
						data[6]=(byte)(H&255);
						data[7]=(byte)(W>>8&255);
						data[8]=(byte)(W&255);
						if (Typ=="BtnAnzeige") {
							data[9]=254;//btn normal
						} else {
							data[9]=255;//btn normal
						}					
						data[10]=(byte)(count);
						data[11]=(byte)(Fore16bit>>8&255);
						data[12]=(byte)(Fore16bit&255);
						data[13]=(byte)(Back16bit>>8&255);
						data[14]=(byte)(Back16bit&255);
						data[15]=(byte)text.Length;
						int cnt = 16;
						foreach(char C in text) {
							data[cnt]=(byte)C;cnt++;
						}
						Kernel_sendHID(data); //Thread.Sleep(100);
					}
				}
				SB.AppendLine("//Progressbars:");
				// ProgressBars ###############################################
				foreach (Object O in cb_stm32_CTRL_PBar_Chan.Items) {
					if (O.ToString().StartsWith("LCD")) {
						SB.AppendLine(O.ToString());
						//Decode
						string[] splits = O.ToString().Remove(0,15).Split(',');
						int X = 0; int Y = 0; int H = 0; int W = 0; int Max = 0; int Val = 0;
						long col = 0; bool Vert = false;
						int.TryParse(splits[1],out X);
						int.TryParse(splits[2],out Y);
						int.TryParse(splits[3],out H);
						int.TryParse(splits[4],out W);
						int.TryParse(splits[5],out Max);
						col = Convert.ToUInt32(splits[6].Trim(),16);
						if (splits[7].Contains("VERT")) { Vert=true; } else { Vert=false; }
						int.TryParse(splits[8].Split(')')[0],out Val);
						
						//Transmit
						byte[] data = new byte[usbHid.SpecifiedDevice.OutputReportLength-2];
						data[0]=23;//GUI bar
						data[1]=(byte)(X>>8&255);
						data[2]=(byte)(X&255);
						data[3]=(byte)(Y>>8&255);
						data[4]=(byte)(Y&255);
						data[5]=(byte)(H>>8&255);
						data[6]=(byte)(H&255);
						data[7]=(byte)(W>>8&255);
						data[8]=(byte)(W&255);
						data[9]=(byte)(Max>>8&255);
						data[10]=(byte)(Max&255);
						data[11]=(byte)(col>>8&255);
						data[12]=(byte)(col&255);
						if (Vert) { data[13]=1; } else { data[13]=0; }
						data[14]=(byte)(Val>>8&255);
						data[15]=(byte)(Val&255);
						Kernel_sendHID(data); //Thread.Sleep(100);
					}
				}
				SB.AppendLine("//Lines:");
				// Lines ###############################################
				foreach (Object O in cb_stm32_CTRL_Line_Chan.Items) {
					if (O.ToString().StartsWith("LCD")) {
						SB.AppendLine(O.ToString());
						//Decode
						string[] splits = O.ToString().Remove(0,13).Split(',');
						decimal X = 0; decimal Y = 0; decimal Len = 0;
						long col = 0;
						decimal.TryParse(splits[0],out X);
						decimal.TryParse(splits[1],out Y);
						decimal.TryParse(splits[2],out Len);
						//if (splits[3].Contains("VERT")) { Vert=true; } else { Vert=false; }
						col = Convert.ToUInt32(splits[4].Remove(6,splits[4].Length-6),16);
												
						//Transmit
						byte[] data = new byte[usbHid.SpecifiedDevice.OutputReportLength-2];
						data[0]=25;//GUI Line
						data[1]=(byte)((int)num_stm32_CTRL_Line_x.Value>>8&255);
						data[2]=(byte)((int)num_stm32_CTRL_Line_x.Value&255);
						data[3]=(byte)((int)num_stm32_CTRL_Line_y.Value>>8&255);
						data[4]=(byte)((int)num_stm32_CTRL_Line_y.Value&255);
						data[5]=(byte)((int)num_stm32_CTRL_Line_len.Value>>8&255);
						data[6]=(byte)((int)num_stm32_CTRL_Line_len.Value&255);
						if (chk_stm32_CTRL_Line_Vertikal.Checked) { data[7]=1; } else { data[7]=0; }
						long Col = Color_to_Int16(btn_stm32_CTRL_Line_color.BackColor);
						data[8]=(byte)(Col>>8&255);
						data[9]=(byte)(Col&255);
						Kernel_sendHID(data);
					}
				}
				txt_stm32_HIDautoredrawCode.Text = SB.ToString();
			}
		}
		
		void Num_stm32_CTRL_Box_wValueChanged(object sender, EventArgs e)
		{
			kernel_CTRL_Box();
		}
		void Btn_stm32_CTRL_Box_colorClick(object sender, EventArgs e)
		{
			if (colorSET.ShowDialog()==DialogResult.OK) {
				btn_stm32_CTRL_Box_color.BackColor=colorSET.Color;
				kernel_CTRL_Box();
			}
		}
		void Chk_stm32_CTRL_Box_filledCheckedChanged(object sender, EventArgs e)
		{
			kernel_CTRL_Box();
		}
		void Btn_stm32_CTRL_Box_ADDClick(object sender, EventArgs e)
		{
			kernel_CTRL_Box();
			if (txt_stm32_CTRL_Box_code.Text.Length<10||cb_stm32_CTRL_Box_chan.SelectedIndex!=0) { return; }
			if (!cb_stm32_CTRL_Box_chan.Items.Contains(txt_stm32_CTRL_Box_code.Text)) {
				cb_stm32_CTRL_Box_chan.Items.Add(txt_stm32_CTRL_Box_code.Text);
				cb_stm32_CTRL_Box_chan.SelectedIndex=cb_stm32_CTRL_Box_chan.Items.Count-1;
			} else {
				MessageBox.Show(txt_stm32_CTRL_PBar_code.Text+" war schon vorhanden","Channel nicht hinzugefügt");
			}
		}
		void Btn_stm32_CTRL_Box_CopyAllClick(object sender, EventArgs e)
		{
			StringBuilder SB = new StringBuilder();
			foreach (Object O in cb_stm32_CTRL_Box_chan.Items) {
				if (O.ToString().StartsWith("LCD")) {
					SB.AppendLine(O.ToString());
				}
			}
			Clipboard.SetText(SB.ToString());
			MessageBox.Show("In die Zwischenablage kopiert:\r\n"+SB.ToString());
		}
		void Cb_stm32_CTRL_Box_chanSelectedIndexChanged(object sender, EventArgs e)
		{
			if (Lock_CTRL) { return; }
			//LCD_DrawFilledRect(81,1,178,238,LCD_Black);
			//LCD_DrawRect(80,0,181,240,LCD_White);
			if (txt_stm32_CTRL_Box_code.Text==cb_stm32_CTRL_Box_chan.SelectedItem.ToString()||cb_stm32_CTRL_Box_chan.SelectedIndex==0) { return; }
			Lock_CTRL=true;
			string line = cb_stm32_CTRL_Box_chan.SelectedItem.ToString(); int offset = 0;
			if (line.StartsWith("LCD_DrawFill")) { offset=19; } else { offset=13; }
			string[] splits = line.Remove(0,offset).Split(',');
			decimal X = 0; decimal Y = 0; decimal H = 0; decimal W = 0; long Color16bit = 0;
			decimal.TryParse(splits[0],out X);
			decimal.TryParse(splits[1],out Y);
			decimal.TryParse(splits[2],out H);
			decimal.TryParse(splits[3],out W);
			num_stm32_CTRL_Box_x.Value=X;
			num_stm32_CTRL_Box_y.Value=Y;
			num_stm32_CTRL_Box_h.Value=H;
			num_stm32_CTRL_Box_w.Value=W;
			if (offset==19) {
				chk_stm32_CTRL_Box_filled.Checked=true;
			} else {
				chk_stm32_CTRL_Box_filled.Checked=false;
			}
			Color16bit = Convert.ToUInt32(splits[4].Split(')')[0].Trim(),16);
			btn_stm32_CTRL_Box_color.BackColor=Int16_to_RGB565(Color16bit);
			Lock_CTRL=false;
			kernel_CTRL_Box();
		}
		void kernel_CTRL_Box()
		{
			if (Lock_CTRL) { return; }
			StringBuilder SB = new StringBuilder(); bool isFilled = false;
			if (chk_stm32_CTRL_Box_filled.Checked) {
				SB.Append("LCD_DrawFilledRect("); isFilled=true;
			} else {
				SB.Append("LCD_DrawRect(");
			}
			
			SB.Append(num_stm32_CTRL_Box_x.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_Box_y.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_Box_h.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_Box_w.Value.ToString()+",");
			SB.Append("0x"+Color_to_Int16(btn_stm32_CTRL_Box_color.BackColor).ToString("X04")+");");
			
			txt_stm32_CTRL_Box_code.Text=SB.ToString();
			if (cb_stm32_CTRL_Box_chan.SelectedIndex>0) {
				Lock_CTRL=true;
				cb_stm32_CTRL_Box_chan.Items[cb_stm32_CTRL_Box_chan.SelectedIndex]=SB.ToString();
				Application.DoEvents();
				Lock_CTRL=false;
			}
			if (chk_stm32_CTRL_HIDSEND.Checked) {
				if (btn_usb_finddevice.BackColor!=Color.LimeGreen) { return; }
				byte[] data = new byte[usbHid.SpecifiedDevice.OutputReportLength-2];
				data[0]=24;//GUI box
				data[1]=(byte)((int)num_stm32_CTRL_Box_x.Value>>8&255);
				data[2]=(byte)((int)num_stm32_CTRL_Box_x.Value&255);
				data[3]=(byte)((int)num_stm32_CTRL_Box_y.Value>>8&255);
				data[4]=(byte)((int)num_stm32_CTRL_Box_y.Value&255);
				data[5]=(byte)((int)num_stm32_CTRL_Box_h.Value>>8&255);
				data[6]=(byte)((int)num_stm32_CTRL_Box_h.Value&255);
				data[7]=(byte)((int)num_stm32_CTRL_Box_w.Value>>8&255);
				data[8]=(byte)((int)num_stm32_CTRL_Box_w.Value&255);
				long Col = Color_to_Int16(btn_stm32_CTRL_Box_color.BackColor);
				data[9]=(byte)(Col>>8&255);
				data[10]=(byte)(Col&255);
				if (isFilled) { data[11]=1; } else { data[11]=0; }
				Kernel_sendHID(data);				
			}
		}
		
		void Btn_stm32_CTRL_txt1_ForecolClick(object sender, EventArgs e)
		{
			if (colorSET.ShowDialog()==DialogResult.OK) {
				txt_stm32_CTRL_txt1.ForeColor=colorSET.Color;
				kernel_CTRL_txt1();
			}
		}
		void Btn_stm32_CTRL_txt1_BackcolClick(object sender, EventArgs e)
		{
			if (colorSET.ShowDialog()==DialogResult.OK) {
				txt_stm32_CTRL_txt1.BackColor=colorSET.Color;
				kernel_CTRL_txt1();
			}
		}
		void Num_stm32_CTRL_txt1_ValueChanged(object sender, EventArgs e)
		{
			if (Lock_CTRL) { return; }
			kernel_CTRL_txt1();
		}
		void Cb_stm32_CTRL_txt1_fontSelectedIndexChanged(object sender, EventArgs e)
		{
			kernel_CTRL_txt1();
		}
		void Txt_stm32_CTRL_txt1KeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData==Keys.Enter) {
				kernel_CTRL_txt1();
			}
		}
		void Btn__stm32_CTRL_txt1_ADDClick(object sender, EventArgs e)
		{
			kernel_CTRL_txt1();
			if (txt_stm32_CTRL_txt1_code.Text.Length<10||cb_stm32_CTRL_txt1.SelectedIndex!=0) { return; }
			if (!cb_stm32_CTRL_txt1.Items.Contains(txt_stm32_CTRL_txt1_code.Text)) {
				cb_stm32_CTRL_txt1.Items.Add(txt_stm32_CTRL_txt1_code.Text);
				cb_stm32_CTRL_txt1.SelectedIndex=cb_stm32_CTRL_txt1.Items.Count-1;
			} else {
				MessageBox.Show(txt_stm32_CTRL_txt1_code.Text+" war schon vorhanden","Channel nicht hinzugefügt");
			}
		}
		void Cb_stm32_CTRL_txt1SelectedIndexChanged(object sender, EventArgs e)
		{
			//this.Text=cb_stm32_CTRL_txt1_font.SelectedIndex.ToString();
			if (Lock_CTRL) { return; }
			//LCD_Text(1, 0, "Txt 1", 0xF800, 0x0000);
			if (txt_stm32_CTRL_txt1_code.Text==cb_stm32_CTRL_txt1.SelectedItem.ToString()||cb_stm32_CTRL_txt1.SelectedIndex==0) { return; }
			Lock_CTRL=true;
			string[] splits = cb_stm32_CTRL_txt1.SelectedItem.ToString().Remove(0,13).Split(',');
			decimal X = 0; decimal Y = 0; long Fore16bit = 0; long Back16bit = 0;
			string font = splits[5].Split('_')[1].Trim(); int count = 0;
			decimal.TryParse(splits[0],out X);
			decimal.TryParse(splits[1],out Y);
			num_stm32_CTRL_txt1_x.Value=X;
			num_stm32_CTRL_txt1_y.Value=Y;
			txt_stm32_CTRL_txt1.Text = splits[2].Replace('"',' ').Trim();
			Fore16bit = Convert.ToUInt32(splits[3].Trim(),16);
			Back16bit = Convert.ToUInt32(splits[4].Trim(),16);
			foreach(object o in cb_stm32_CTRL_txt1_font.Items) {
				if (font.StartsWith(o.ToString())) {
					cb_stm32_CTRL_txt1_font.SelectedIndex=count; break;
				}
				count++;
			}
			txt_stm32_CTRL_txt1.ForeColor=Int16_to_RGB565(Fore16bit);
			txt_stm32_CTRL_txt1.BackColor=Int16_to_RGB565(Back16bit);
			Lock_CTRL=false;
			kernel_CTRL_txt1();
		}
		void Btn__stm32_CTRL_txt1_CopyAllClick(object sender, EventArgs e)
		{
			StringBuilder SB = new StringBuilder();
			foreach (Object O in cb_stm32_CTRL_txt1.Items) {
				if (O.ToString().StartsWith("LCD")) {
					SB.AppendLine(O.ToString());
				}
			}
			Clipboard.SetText(SB.ToString());
			MessageBox.Show("In die Zwischenablage kopiert:\r\n"+SB.ToString());
		}
		void kernel_CTRL_txt1()
		{
			if (Lock_CTRL) { return; }
			StringBuilder SB = new StringBuilder("LCD_DrawText(");
			
			SB.Append(num_stm32_CTRL_txt1_x.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_txt1_y.Value.ToString()+",\"");
			SB.Append(txt_stm32_CTRL_txt1.Text+"\",");
			SB.Append("0x"+Color_to_Int16(txt_stm32_CTRL_txt1.ForeColor).ToString("X04")+",");
			SB.Append("0x"+Color_to_Int16(txt_stm32_CTRL_txt1.BackColor).ToString("X04")+",");
			SB.Append("font_"+cb_stm32_CTRL_txt1_font.SelectedItem.ToString()+");");
			
			txt_stm32_CTRL_txt1_code.Text=SB.ToString();
			if (cb_stm32_CTRL_txt1.SelectedIndex>0) {
				Lock_CTRL=true;
				cb_stm32_CTRL_txt1.Items[cb_stm32_CTRL_txt1.SelectedIndex]=SB.ToString();
				Application.DoEvents();
				Lock_CTRL=false;
			}
			if (chk_stm32_CTRL_HIDSEND.Checked) {
				if (btn_usb_finddevice.BackColor!=Color.LimeGreen) { return; }
				byte[] data = new byte[usbHid.SpecifiedDevice.OutputReportLength-2];
				data[0]=21;//gui txt
				data[1]=(byte)((int)num_stm32_CTRL_txt1_x.Value>>8&255);
				data[2]=(byte)((int)num_stm32_CTRL_txt1_x.Value&255);
				data[3]=(byte)((int)num_stm32_CTRL_txt1_y.Value>>8&255);
				data[4]=(byte)((int)num_stm32_CTRL_txt1_y.Value&255);
				long ColF = Color_to_Int16(txt_stm32_CTRL_txt1.ForeColor);
				long ColB = Color_to_Int16(txt_stm32_CTRL_txt1.BackColor);
				data[5]=(byte)(ColF>>8&255);
				data[6]=(byte)(ColF&255);
				data[7]=(byte)(ColB>>8&255);
				data[8]=(byte)(ColB&255);
				data[9]=(byte)(cb_stm32_CTRL_txt1_font.SelectedIndex+1);
				data[10]=(byte)txt_stm32_CTRL_txt1.Text.Length;
				int cnt = 11;
				foreach(char C in txt_stm32_CTRL_txt1.Text) {
					data[cnt]=(byte)C;cnt++;
				}
				Kernel_sendHID(data);
				
			}
		}
		
		void num_stm32_CTRL_btn1(object sender, EventArgs e)
		{
			if (Lock_CTRL) { return; }
			kernel_CTRL_btn1();
		}
		void Chk_stm32_CTRL_btn1_IOCheckedChanged(object sender, EventArgs e)
		{
			kernel_CTRL_btn1();
		}
		void Txt_stm32_CTRL_btn1KeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData==Keys.Enter) {
				kernel_CTRL_btn1();
			}
		}
		void Btn_stm32_CTRL_btn1_ADDClick(object sender, EventArgs e)
		{
			kernel_CTRL_btn1();
			if (txt_stm32_CTRL_btn1_code.Text.Length<10||cb_stm32_CTRL_btn1.SelectedIndex!=0) { return; }
			if (!cb_stm32_CTRL_btn1.Items.Contains(txt_stm32_CTRL_btn1_code.Text)) {
				cb_stm32_CTRL_btn1.Items.Add(txt_stm32_CTRL_btn1_code.Text);
				cb_stm32_CTRL_btn1.SelectedIndex=cb_stm32_CTRL_btn1.Items.Count-1;
			} else {
				MessageBox.Show(txt_stm32_CTRL_btn1_code.Text+" war schon vorhanden","Channel nicht hinzugefügt");
			}
		}
		void Btn_stm32_CTRL_btn1_ColFClick(object sender, EventArgs e)
		{
			if (colorSET.ShowDialog()==DialogResult.OK) {
				btn_stm32_CTRL_btn1_ColF.BackColor=colorSET.Color;
				kernel_CTRL_btn1();
			}
		}
		void Btn_stm32_CTRL_btn1_ColBClick(object sender, EventArgs e)
		{
			if (colorSET.ShowDialog()==DialogResult.OK) {
				btn_stm32_CTRL_btn1_ColB.BackColor=colorSET.Color;
				kernel_CTRL_btn1();
			}
		}
		void Cb_stm32_CTRL_btn1_fontSelectedIndexChanged(object sender, EventArgs e)
		{
			if (Lock_CTRL) { return; }
			kernel_CTRL_btn1();
		}
		void Cb_stm32_CTRL_btn1SelectedIndexChanged(object sender, EventArgs e)
		{
			if (Lock_CTRL) { return; }
			//LCD_SetButtons(0,30, 41, 30, 40, "Btn 0");
			//LCD_SetButtons(1,242,3,31,75," T-Cam",BtnAnzeige);
			if (txt_stm32_CTRL_btn1_code.Text==cb_stm32_CTRL_btn1.SelectedItem.ToString()||cb_stm32_CTRL_btn1.SelectedIndex==0) { return; }
			Lock_CTRL=true;
			string[] splits = cb_stm32_CTRL_btn1.SelectedItem.ToString().Remove(0,15).Split(',');
			decimal X = 0; decimal Y = 0; decimal H = 0; decimal W = 0; long Fore16bit = 0; long Back16bit = 0;
			string font = splits[7].Split('_')[1].Trim(); int count = 0;
			decimal.TryParse(splits[1],out X);
			decimal.TryParse(splits[2],out Y);
			decimal.TryParse(splits[3],out H);
			decimal.TryParse(splits[4],out W);
			num_stm32_CTRL_btn1_x.Value=X;
			num_stm32_CTRL_btn1_y.Value=Y;
			num_stm32_CTRL_btn1_h.Value=H;
			num_stm32_CTRL_btn1_w.Value=W;
			txt_stm32_CTRL_btn1.Text = splits[5].Replace("\"","");
			if (splits[6].Contains("Anzeig")) {
				chk_stm32_CTRL_btn1_IO.Checked=true;
			} else {
				chk_stm32_CTRL_btn1_IO.Checked=false;
			}
			foreach(object o in cb_stm32_CTRL_btn1_font.Items) {
				if (font.StartsWith(o.ToString())) {
					cb_stm32_CTRL_btn1_font.SelectedIndex=count; break;
				}
				count++;
			}
			Fore16bit = Convert.ToUInt32(splits[8].Trim(),16);
			Back16bit = Convert.ToUInt32(splits[9].Split(')')[0].Trim(),16);
			btn_stm32_CTRL_btn1_ColF.BackColor=Int16_to_RGB565(Fore16bit);
			btn_stm32_CTRL_btn1_ColB.BackColor=Int16_to_RGB565(Back16bit);
			Lock_CTRL=false;
			kernel_CTRL_btn1();
		}
		void Btn_stm32_CTRL_btn1_CopyAllClick(object sender, EventArgs e)
		{
			StringBuilder SB = new StringBuilder();
			foreach (Object O in cb_stm32_CTRL_btn1.Items) {
				if (O.ToString().StartsWith("LCD")) {
					SB.AppendLine(O.ToString());
				}
			}
			Clipboard.SetText(SB.ToString());
			MessageBox.Show("In die Zwischenablage kopiert:\r\n"+SB.ToString());
		}
		void kernel_CTRL_btn1()
		{
			if (Lock_CTRL) { return; }
			int index = cb_stm32_CTRL_btn1.SelectedIndex;
			StringBuilder SB = new StringBuilder("LCD_SetButtons("+index.ToString()+",");
			
			SB.Append(num_stm32_CTRL_btn1_x.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_btn1_y.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_btn1_h.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_btn1_w.Value.ToString()+",\"");
			SB.Append(txt_stm32_CTRL_btn1.Text+"\",");
			if (chk_stm32_CTRL_btn1_IO.Checked) {
				SB.Append("BtnAnzeige,");
			} else {
				SB.Append("BtnNormal,");
			}
			SB.Append("font_"+cb_stm32_CTRL_btn1_font.SelectedItem.ToString()+",");
			SB.Append("0x"+Color_to_Int16(btn_stm32_CTRL_btn1_ColF.BackColor).ToString("X04")+",");
			SB.Append("0x"+Color_to_Int16(btn_stm32_CTRL_btn1_ColB.BackColor).ToString("X04")+");");
			
			txt_stm32_CTRL_btn1_code.Text=SB.ToString();
			if (cb_stm32_CTRL_btn1.SelectedIndex>0) {
				Lock_CTRL=true;
				cb_stm32_CTRL_btn1.Items[cb_stm32_CTRL_btn1.SelectedIndex]=SB.ToString();
				Application.DoEvents();
				Lock_CTRL=false;
			}
			if (chk_stm32_CTRL_HIDSEND.Checked) {
				if (btn_usb_finddevice.BackColor!=Color.LimeGreen) { return; }
				byte[] data = new byte[usbHid.SpecifiedDevice.OutputReportLength-2];
				data[0]=22;//gui btn
				data[1]=(byte)((int)num_stm32_CTRL_btn1_x.Value>>8&255);
				data[2]=(byte)((int)num_stm32_CTRL_btn1_x.Value&255);
				data[3]=(byte)((int)num_stm32_CTRL_btn1_y.Value>>8&255);
				data[4]=(byte)((int)num_stm32_CTRL_btn1_y.Value&255);
				data[5]=(byte)((int)num_stm32_CTRL_btn1_h.Value>>8&255);
				data[6]=(byte)((int)num_stm32_CTRL_btn1_h.Value&255);
				data[7]=(byte)((int)num_stm32_CTRL_btn1_w.Value>>8&255);
				data[8]=(byte)((int)num_stm32_CTRL_btn1_w.Value&255);
				if (chk_stm32_CTRL_btn1_IO.Checked) {
					data[9]=254;//switch
				} else {
					data[9]=255;//btn normal
				}
				data[10]=(byte)(cb_stm32_CTRL_btn1_font.SelectedIndex+1);
				long Col = Color_to_Int16(btn_stm32_CTRL_btn1_ColF.BackColor);
				data[11]=(byte)(Col>>8&255);
				data[12]=(byte)(Col&255);
				Col = Color_to_Int16(btn_stm32_CTRL_btn1_ColB.BackColor);
				data[13]=(byte)(Col>>8&255);
				data[14]=(byte)(Col&255);
				data[15]=(byte)txt_stm32_CTRL_btn1.Text.Length;
				int cnt = 16;
				foreach(char C in txt_stm32_CTRL_btn1.Text) {
					data[cnt]=(byte)C;cnt++;
				}
				Kernel_sendHID(data);
			}
		}
		
		void Chk_stm32_CTRL_PBar_VertikalCheckedChanged(object sender, EventArgs e)
		{
			kernel_CTRL_Pbar();
		}
		void Num_stm32_CTRL_PBar_valValueChanged(object sender, EventArgs e)
		{
			kernel_CTRL_Pbar();
		}
		void Btn_stm32_CTRL_PBar_colorClick(object sender, EventArgs e)
		{
			if (colorSET.ShowDialog()==DialogResult.OK) {
				btn_stm32_CTRL_PBar_color.BackColor=colorSET.Color;
				kernel_CTRL_Pbar();
			}
		}
		void Btn__stm32_CTRL_PBar_ADDClick(object sender, EventArgs e)
		{
			kernel_CTRL_Pbar();
			if (txt_stm32_CTRL_PBar_code.Text.Length<10||cb_stm32_CTRL_PBar_Chan.SelectedIndex!=0) { return; }
			if (!cb_stm32_CTRL_PBar_Chan.Items.Contains(txt_stm32_CTRL_PBar_code.Text)) {
				cb_stm32_CTRL_PBar_Chan.Items.Add(txt_stm32_CTRL_PBar_code.Text);
				cb_stm32_CTRL_PBar_Chan.SelectedIndex=cb_stm32_CTRL_PBar_Chan.Items.Count-1;
			} else {
				MessageBox.Show(txt_stm32_CTRL_PBar_code.Text+" war schon vorhanden","Channel nicht hinzugefügt");
			}
		}
		void Cb_stm32_CTRL_PBar_ChanSelectedIndexChanged(object sender, EventArgs e)
		{
			if (Lock_CTRL) { return; }
			//LCD_SetProgBar(0,90,30,140,20,255,LCD_Red,VERT,255);
			if (txt_stm32_CTRL_PBar_code.Text==cb_stm32_CTRL_PBar_Chan.SelectedItem.ToString()||cb_stm32_CTRL_PBar_Chan.SelectedIndex==0) { return; }
			Lock_CTRL=true;
			string[] splits = cb_stm32_CTRL_PBar_Chan.SelectedItem.ToString().Remove(0,15).Split(',');
			decimal X = 0; decimal Y = 0; decimal H = 0; decimal W = 0; decimal Max = 0; decimal Val = 0; long Color16bit = 0;
			decimal.TryParse(splits[1],out X);
			decimal.TryParse(splits[2],out Y);
			decimal.TryParse(splits[3],out H);
			decimal.TryParse(splits[4],out W);
			decimal.TryParse(splits[5],out Max);
			decimal.TryParse(splits[8].Split(')')[0],out Val);
			num_stm32_CTRL_PBar_x.Value=X;
			num_stm32_CTRL_PBar_y.Value=Y;
			num_stm32_CTRL_PBar_h.Value=H;
			num_stm32_CTRL_PBar_w.Value=W;
			num_stm32_CTRL_PBar_max.Value=Max;
			num_stm32_CTRL_PBar_val.Value=Val;
			if (splits[7].Contains("VERT")) {
				chk_stm32_CTRL_PBar_Vertikal.Checked=true;
			} else {
				chk_stm32_CTRL_PBar_Vertikal.Checked=false;
			}
			Color16bit = Convert.ToUInt32(splits[6].Trim(),16);
			btn_stm32_CTRL_PBar_color.BackColor=Int16_to_RGB565(Color16bit);
			Lock_CTRL=false;
			kernel_CTRL_Pbar();
		}
		void Btn_stm32_CTRL_PBar_CopyAllClick(object sender, EventArgs e)
		{
			StringBuilder SB = new StringBuilder();
			foreach (Object O in cb_stm32_CTRL_PBar_Chan.Items) {
				if (O.ToString().StartsWith("LCD")) {
					SB.AppendLine(O.ToString());
				}
			}
			Clipboard.SetText(SB.ToString());
			MessageBox.Show("In die Zwischenablage kopiert:\r\n"+SB.ToString());
		}
		void kernel_CTRL_Pbar()
		{
			if (Lock_CTRL) { return; }
			int index = cb_stm32_CTRL_PBar_Chan.SelectedIndex;
			StringBuilder SB = new StringBuilder("LCD_SetProgBar("+index.ToString()+",");
			
			SB.Append(num_stm32_CTRL_PBar_x.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_PBar_y.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_PBar_h.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_PBar_w.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_PBar_max.Value.ToString()+",");
			SB.Append("0x"+Color_to_Int16(btn_stm32_CTRL_PBar_color.BackColor).ToString("X04")+",");
			if (chk_stm32_CTRL_PBar_Vertikal.Checked) {
				SB.Append("VERT,");
			} else {
				SB.Append("HORI,");
			}
			SB.Append(num_stm32_CTRL_PBar_val.Value.ToString()+");");
			
			txt_stm32_CTRL_PBar_code.Text=SB.ToString();
			if (cb_stm32_CTRL_PBar_Chan.SelectedIndex>0) {
				Lock_CTRL=true;
				cb_stm32_CTRL_PBar_Chan.Items[cb_stm32_CTRL_PBar_Chan.SelectedIndex]=SB.ToString();
				Application.DoEvents();
				Lock_CTRL=false;
			}
			if (chk_stm32_CTRL_HIDSEND.Checked) {
				if (btn_usb_finddevice.BackColor!=Color.LimeGreen) { return; }
				byte[] data = new byte[usbHid.SpecifiedDevice.OutputReportLength-2];
				data[0]=23;//GUI bar
				data[1]=(byte)((int)num_stm32_CTRL_PBar_x.Value>>8&255);
				data[2]=(byte)((int)num_stm32_CTRL_PBar_x.Value&255);
				data[3]=(byte)((int)num_stm32_CTRL_PBar_y.Value>>8&255);
				data[4]=(byte)((int)num_stm32_CTRL_PBar_y.Value&255);
				data[5]=(byte)((int)num_stm32_CTRL_PBar_h.Value>>8&255);
				data[6]=(byte)((int)num_stm32_CTRL_PBar_h.Value&255);
				data[7]=(byte)((int)num_stm32_CTRL_PBar_w.Value>>8&255);
				data[8]=(byte)((int)num_stm32_CTRL_PBar_w.Value&255);
				data[9]=(byte)((int)num_stm32_CTRL_PBar_max.Value>>8&255);
				data[10]=(byte)((int)num_stm32_CTRL_PBar_max.Value&255);
				long Col = Color_to_Int16(btn_stm32_CTRL_PBar_color.BackColor);
				data[11]=(byte)(Col>>8&255);
				data[12]=(byte)(Col&255);
				if (chk_stm32_CTRL_PBar_Vertikal.Checked) { data[13]=1; } else { data[13]=0; }
				data[14]=(byte)((int)num_stm32_CTRL_PBar_val.Value>>8&255);
				data[15]=(byte)((int)num_stm32_CTRL_PBar_val.Value&255);
				Kernel_sendHID(data);
				
			}
		}
		
		void Num_stm32_CTRL_Line_valValueChanged(object sender, EventArgs e)
		{
			kernel_CTRL_Line();
		}
		void Chk_stm32_CTRL_Line_VertikalCheckedChanged(object sender, EventArgs e)
		{
			kernel_CTRL_Line();
		}
		void Btn_stm32_CTRL_Line_colorClick(object sender, EventArgs e)
		{
			if (colorSET.ShowDialog()==DialogResult.OK) {
				btn_stm32_CTRL_Line_color.BackColor=colorSET.Color;
				kernel_CTRL_Line();
			}
		}
		void Btn__stm32_CTRL_Line_ADDClick(object sender, EventArgs e)
		{
			kernel_CTRL_Line();
			if (txt_stm32_CTRL_Line_code.Text.Length<10||cb_stm32_CTRL_Line_Chan.SelectedIndex!=0) { return; }
			if (!cb_stm32_CTRL_Line_Chan.Items.Contains(txt_stm32_CTRL_Line_code.Text)) {
				cb_stm32_CTRL_Line_Chan.Items.Add(txt_stm32_CTRL_Line_code.Text);
				cb_stm32_CTRL_Line_Chan.SelectedIndex=cb_stm32_CTRL_Line_Chan.Items.Count-1;
			} else {
				MessageBox.Show(txt_stm32_CTRL_Line_code.Text+" war schon vorhanden","Channel nicht hinzugefügt");
			}
		}
		void Cb_stm32_CTRL_Line_ChanSelectedIndexChanged(object sender, EventArgs e)
		{
			if (Lock_CTRL) { return; }
			//LCD_SetProgBar(0,90,30,140,20,255,LCD_Red,VERT,255);
			if (txt_stm32_CTRL_Line_code.Text==cb_stm32_CTRL_Line_Chan.SelectedItem.ToString()||cb_stm32_CTRL_Line_Chan.SelectedIndex==0) { return; }
			Lock_CTRL=true;
			string[] splits = cb_stm32_CTRL_Line_Chan.SelectedItem.ToString().Remove(0,13).Split(',');
			decimal X = 0; decimal Y = 0; decimal Len = 0; long Color16bit = 0;
			decimal.TryParse(splits[0],out X);
			decimal.TryParse(splits[1],out Y);
			decimal.TryParse(splits[2],out Len);
			num_stm32_CTRL_Line_x.Value=X;
			num_stm32_CTRL_Line_y.Value=Y;
			num_stm32_CTRL_Line_len.Value=Len;
			if (splits[3].Contains("VERT")) {
				chk_stm32_CTRL_Line_Vertikal.Checked=true;
			} else {
				chk_stm32_CTRL_Line_Vertikal.Checked=false;
			}
			Color16bit = Convert.ToUInt32(splits[4].Remove(6,splits[4].Length-6),16);
			btn_stm32_CTRL_Line_color.BackColor=Int16_to_RGB565(Color16bit);
			Lock_CTRL=false;
			kernel_CTRL_Line();
		}
		void Btn_stm32_CTRL_Line_CopyAllClick(object sender, EventArgs e)
		{
			StringBuilder SB = new StringBuilder();
			foreach (Object O in cb_stm32_CTRL_Line_Chan.Items) {
				if (O.ToString().StartsWith("LCD")) {
					SB.AppendLine(O.ToString());
				}
			}
			Clipboard.SetText(SB.ToString());
			MessageBox.Show("In die Zwischenablage kopiert:\r\n"+SB.ToString());
		}
		void kernel_CTRL_Line()
		{
			if (Lock_CTRL) { return; }
			int index = cb_stm32_CTRL_Line_Chan.SelectedIndex;
			StringBuilder SB = new StringBuilder("LCD_DrawLine(");
			
			SB.Append(num_stm32_CTRL_Line_x.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_Line_y.Value.ToString()+",");
			SB.Append(num_stm32_CTRL_Line_len.Value.ToString()+",");
			if (chk_stm32_CTRL_Line_Vertikal.Checked) {
				SB.Append("VERT,");
			} else {
				SB.Append("HORI,");
			}
			SB.Append("0x"+Color_to_Int16(btn_stm32_CTRL_Line_color.BackColor).ToString("X04")+"); //"+index.ToString());
						
			txt_stm32_CTRL_Line_code.Text=SB.ToString();
			if (cb_stm32_CTRL_Line_Chan.SelectedIndex>0) {
				Lock_CTRL=true;
				cb_stm32_CTRL_Line_Chan.Items[cb_stm32_CTRL_Line_Chan.SelectedIndex]=SB.ToString();
				Application.DoEvents();
				Lock_CTRL=false;
			}
			if (chk_stm32_CTRL_HIDSEND.Checked) {
				if (btn_usb_finddevice.BackColor!=Color.LimeGreen) { return; }
				byte[] data = new byte[usbHid.SpecifiedDevice.OutputReportLength-2];
				data[0]=25;//GUI Line
				data[1]=(byte)((int)num_stm32_CTRL_Line_x.Value>>8&255);
				data[2]=(byte)((int)num_stm32_CTRL_Line_x.Value&255);
				data[3]=(byte)((int)num_stm32_CTRL_Line_y.Value>>8&255);
				data[4]=(byte)((int)num_stm32_CTRL_Line_y.Value&255);
				data[5]=(byte)((int)num_stm32_CTRL_Line_len.Value>>8&255);
				data[6]=(byte)((int)num_stm32_CTRL_Line_len.Value&255);
				if (chk_stm32_CTRL_Line_Vertikal.Checked) { data[7]=1; } else { data[7]=0; }
				long Col = Color_to_Int16(btn_stm32_CTRL_Line_color.BackColor);
				data[8]=(byte)(Col>>8&255);
				data[9]=(byte)(Col&255);
				Kernel_sendHID(data);
			}
		}
		#endregion
		
		#region Tab_Fileformat
		void Num_fileformat_startKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData==Keys.Enter) {
				try {
					Kernel_Fileformat_Readfile();
					label_fileformat.BackColor=Color.LimeGreen;
				} catch (Exception err) {
					MessageBox.Show(err.Message,"Fehler beim neu laden...");
				}
			}
		}
		void Btn_fileformat_openClick(object sender, EventArgs e)
		{
			//openFileDialog1.InitialDirectory=Environment.CurrentDirectory;
			openFileDialog1.Filter = "Alle Datein (*.*)|*.*";
			if (openFileDialog1.ShowDialog()!=DialogResult.OK) {
				return;
			}
			string filepath = openFileDialog1.FileName;
					
			string[] splits0 = filepath.Split('\\');
			txt_fileformat_filename.Text = splits0[splits0.Length-1];
			Filepath = filepath;
			if (Filepath.ToUpper().EndsWith(".MCM")) {
				sub_readout_CharsetMaxOSD();
				return;
			}
			if (Filepath.EndsWith(".gui")) {
				sub_readout_Stm32Gui(Filepath);
				return;
			}
			if (chk_fileformat_redirect_stm32.Checked) { //################
				sub_readout_STM32();
				return;
			} //STM32 boardcfg.c #######################################
			label_fileformat2.Text=filepath;
			Kernel_Fileformat_Readfile();
			//Kernel_Fileformat_ReadfileToPic();
			tabControl_main.SelectTab(TP_Fileformat);
		}
		void sub_readout_STM32()
		{
			txt_stm32_Filepath.Text=Filepath;
			StreamReader Read = new StreamReader(Filepath);
			string[] inhalt = Read.ReadToEnd().Split('\n');
			STM32BoardCfgInhalt = new string[inhalt.Length+1];
			inhalt.CopyTo(STM32BoardCfgInhalt,0);
			Read.Close();
			Btn_stm32_codebox_clearClick(null,null);
			foreach(Control C in TP_STM32_Setup_GPIOSetup.Controls) {
				if (C.Name.StartsWith("chk_")) {
					CheckBox chk = C as CheckBox;
					chk.Checked=false;
				}
			}
			string[] Ports = new string[]{"A","B","C","D","E","F","G","H","I"};
			bool ChipTypeIsSet = false;
			for (int i=0;i<inhalt.Length ;i++ ) {
				for (int P = 0;P<Ports.Length ;P++ ) {
					if (inhalt[i].Contains("GPIO"+Ports[P]+"->")) {
						if (inhalt[i].Contains("(GPIO"+Ports[P]+"->")) { continue; }
						foreach(Control C in TP_STM32_Setup_GPIOSetup.Controls) {
							if (C.Name.StartsWith("chk_")) {
								if (C.Name.EndsWith(Ports[P])) {
									CheckBox chk = C as CheckBox;
									chk.Checked=true;
									break;
								}
							}
						}
						string wert = inhalt[i].Split('=')[1].Split(';')[0].Trim().Remove(0,2);
						string typ = inhalt[i].Split('>')[1].Split('=')[0].Trim();
						if (ChipTypeIsSet==false) {
							ChipTypeIsSet=true;
							switch (typ) {
								case "CRL": case "CRH": case "ODR":
									STM32Chipmode="F1";
									Kernel_STM32ChipChange();
									rad_STMF1.Checked=true; Application.DoEvents(); break;
								case "MODER": case "OTYPER": case "OSPEEDR": case "PUPDR":
									STM32Chipmode="F4";
									Kernel_STM32ChipChange();
									rad_STMF4.Checked=true; Application.DoEvents(); break;
								default:
									MessageBox.Show("Typ der Einstellung: "+typ+"\r\nIst nicht bekannt.");
									break;
							}
						}
						sub_GrabSTM32Infos(Ports[P],typ,wert);
						break;
					}
				}
				STM32BoardCfgInhalt[i]=inhalt[i];
				txt_STM32_Code.AppendText(STM32BoardCfgInhalt[i]);
			}
			tabControl_main.SelectTab(TP_STM32);
		}
		void sub_readout_Stm32Gui(string datei)
		{
			try {
				StreamReader txt = new StreamReader(datei);
				sub_clear_GUI_CBs();
				
				Lock_CTRL=true;
				int index = 0;
				while (true) {
					string line = txt.ReadLine();
					if (line==null) { break; }
					if (line.StartsWith("Neuer")) { index++; continue; }
					switch (index) {
						case 1: cb_stm32_CTRL_Box_chan.Items.Add(line); break;
						case 2: cb_stm32_CTRL_txt1.Items.Add(line); break;
						case 3: cb_stm32_CTRL_btn1.Items.Add(line); break;
						case 4: cb_stm32_CTRL_PBar_Chan.Items.Add(line); break;
						case 5: cb_stm32_CTRL_Line_Chan.Items.Add(line); break;
					}
				}
				Lock_CTRL=false;
				Btn_stm32_CTRL_ClearLCDClick(null,null);
				
			} catch (Exception err) {
				Lock_CTRL=false;
				MessageBox.Show(err.Message,"Error load Config");
			}
		}
		void sub_readout_CharsetMaxOSD()
		{
			StreamReader Read = new StreamReader(Filepath);
			string[] inhalt = Read.ReadToEnd().Split('\n');
			Read.Close();
			StringBuilder sb = new StringBuilder("u8 Charline[]={\r\n");
			int line = 0;
			foreach(string s in inhalt) {
				if (s.StartsWith("0")||s.StartsWith("1")) {
					if (s=="") { break; }
					int wert=0; int pos=128;
					foreach(char C in s) {
						if (C=='1') { wert+=pos; }
						pos=pos/2;
					}
					//sb.Append("0b"+s.Replace('\r',' ')+", "); 
					sb.Append(wert.ToString()+",");
					line++;
					if (line==53) { sb.AppendLine(); line=0; }
				}
			}
			sb.Append("0};");
			Clipboard.SetText(sb.ToString());
			MessageBox.Show(Clipboard.GetText().Length.ToString()+" Zeichen im zwischenspeicher!");
		}
		
		//Datei byteweise auslesen
		void Chk_fileformat_redirect_stm32CheckedChanged(object sender, EventArgs e)
		{
			sub_readout_STM32();
		}
		void Txt_fileformat_out_txtSelectionChanged(object sender, EventArgs e)
		{
			txt_fileformat_out_bytes.Text="";
			int start = txt_fileformat_out_txt.SelectionStart;
			int startoff = (int)num_fileformat_start.Value;
			int stop = txt_fileformat_out_txt.SelectionStart+txt_fileformat_out_txt.SelectionLength;
			label_fileformat_selection.Text = "Start("+(start+startoff).ToString()+") " +
				" Länge("+txt_fileformat_out_txt.SelectionLength.ToString()+")";
			for (int i = start; i<stop;i++ ) {
				if (i<LastFilepuffer.Length) {
					if (LastFilepuffer[i]==Filepuffer[i]) {
						txt_fileformat_out_bytes.AppendColorText(Filepuffer[i].ToString()+" ",Color.Lime);
					} else {
						txt_fileformat_out_bytes.AppendColorText(Filepuffer[i].ToString()+" ",Color.Red);
					}
				} else {
					txt_fileformat_out_bytes.AppendColorText(Filepuffer[i].ToString()+" ",Color.Black);
				}
			}
		}
		void Txt_fileformat_findKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyData!= Keys.Enter) { return; }
			int startoff = (int)num_fileformat_start.Value;
			try {
				string[] split_s = txt_fileformat_find.Text.Split(' ');
				byte[] head = new byte[split_s.Length];
				for (int i = 0; i<split_s.Length; i++) {
					if (split_s[i].Length<1) { break; }
					head[i] = byte.Parse(split_s[i]);
				}
				int count = 0;
				bool gefunden = false; int first = 0;
				for (int i = 0; i<Filepuffer.Length-head.Length; i++) {
					for (int j=0;j<head.Length ;j++ ) {
						if (Filepuffer[i+j]!=head[j]) { break; }
						if (j==head.Length-1) {	
							gefunden = true; 
							if (first==0) { first = i; }
						}
					}
					if (gefunden) { count++; gefunden = false; }
				}
				first+=startoff;
				MessageBox.Show("found:"+count.ToString()+"\r\nfirst @ "+first.ToString());
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
		}
		void Label_fileformatMouseEnter(object sender, EventArgs e)
		{
			label_fileformat.BackColor=Color.Gold;
		}
		void Label_fileformatMouseLeave(object sender, EventArgs e)
		{
			label_fileformat.BackColor=Color.Gainsboro;
		}
		void Label_fileformatMouseDown(object sender, MouseEventArgs e)
		{
			try {
				Kernel_Fileformat_Readfile();
				label_fileformat.BackColor=Color.LimeGreen;
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Fehler beim neu laden...");
			}
		}
		void Kernel_Fileformat_Readfile()
		{
			int start = (int)num_fileformat_start.Value;
			int count = (int)(num_fileformat_count.Value);
			
			FileStream FS = File.OpenRead(Filepath);
			LastFilepuffer = Filepuffer;
			Filepuffer = new byte[count+1]; //FS.Length
			if (FS.Length<count+start) {
				count=(int)FS.Length-start;
				num_fileformat_count.Value=(decimal)count;
			}
			FS.Seek(start,SeekOrigin.Begin);
			FS.Read(Filepuffer,0,Filepuffer.Length-1);
			FS.Close();
			byte[] newPuffer = new byte[count]; 
			for (int i = 0;i<count ;i++ ) {
				newPuffer[i]=Filepuffer[i];
			}
			Filepuffer=newPuffer;
			label_fileformat.Text = "Bytes: "+ Filepuffer.Length.ToString()+"\r\n"+Filepath;
			
			if (LastFilepuffer==null) {
				LastFilepuffer = Filepuffer;
			}
			
			txt_fileformat_out_bytes.Text = "";
			txt_fileformat_out_txt.Text = "";
			for (int i = 0;i<Filepuffer.Length ;i++ ) {
				char C = '-';
				if (Filepuffer[i]>31&&Filepuffer[i]!=127) {
					C=(char)Filepuffer[i];
				}
				if (i<LastFilepuffer.Length) {
					if (LastFilepuffer[i]==Filepuffer[i]) {
						txt_fileformat_out_txt.AppendColorText(C.ToString(),Color.Blue);
					} else {
						txt_fileformat_out_txt.AppendColorText(C.ToString(),Color.Red);
					}
				} else {
					txt_fileformat_out_txt.AppendColorText(C.ToString(),Color.Black);
				}
				count--; if (count==0) { break; }
			}
		}
		
		//datei als Bild auslesen
		void Btn_filepic_ZeileUpClick(object sender, EventArgs e)
		{
			num_filepic_OpenByteoffset.Value+=num_filepic_StopCntX.Value*num_filepic_indexPlus.Value;
		}
		void Btn_filepic_ZeileDownClick(object sender, EventArgs e)
		{
			decimal D = num_filepic_StopCntX.Value*num_filepic_indexPlus.Value;
			if (num_filepic_OpenByteoffset.Value-D>0) {
				num_filepic_OpenByteoffset.Value-=D;
			} else {
				num_filepic_OpenByteoffset.Value=0;
			}
		}
		void Label_fileformat2MouseEnter(object sender, EventArgs e)
		{
			label_fileformat2.BackColor=Color.Gold;
		}
		void Label_fileformat2MouseLeave(object sender, EventArgs e)
		{
			label_fileformat2.BackColor=Color.Gainsboro;
		}
		void Label_fileformat2MouseDown(object sender, MouseEventArgs e)
		{
			try {
				Kernel_Fileformat_ReadfileToPic();
				label_fileformat2.BackColor=Color.LimeGreen;
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Fehler beim neu laden...");
			}
		}
		void NumericUpDown6ValueChanged(object sender, EventArgs e)
		{
//			if (Lock_CTRL) { return; }
			try {
				if ((int)num_filepic_offsetmax.Value<scroll_filepic_offset.Value) {
					scroll_filepic_offset.Value=(int)num_filepic_offsetmax.Value-1;
				}
				if ((int)num_filepic_offsetmin.Value>scroll_filepic_offset.Value) {
					scroll_filepic_offset.Value=(int)num_filepic_offsetmin.Value+1;
				}
				scroll_filepic_offset.Maximum=(int)num_filepic_offsetmax.Value;
				scroll_filepic_offset.Minimum=(int)num_filepic_offsetmin.Value;
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
		}
		void Scroll_filepic_offsetScroll(object sender, ScrollEventArgs e)
		{
			label_filepic_offset.Text = scroll_filepic_offset.Value.ToString();
			Kernel_Fileformat_DrawPic();
		}
		void Chk_filepic_rainbowCheckedChanged(object sender, EventArgs e)
		{
			if (Lock_CTRL) { return; }
			if (chk_filepic_rainbow.Checked) {
				draw_rainbow_palette();
			} else {
				draw_dual_palette(Color.White,Color.Black,false);
			}
			Kernel_Fileformat_ReadfileToPic();
		}
		void Btn_filepic_saveconfigClick(object sender, EventArgs e)
		{
			saveFileDialog1.Filter = "FilePic Configuration (*.cfg)|*.cfg|Alle Datein (*.*)|*.*";
			if (saveFileDialog1.ShowDialog()!=DialogResult.OK) {
				return;
			}
			StreamWriter txt = new StreamWriter(saveFileDialog1.FileName);
			txt.WriteLine(label_fileformat2.Text);
			txt.WriteLine(num_filepic_OpenByteoffset.Value.ToString());//startoffset
			txt.WriteLine(num_filepic_StopCntX.Value.ToString());//neue zeile nach
			txt.WriteLine(num_filepic_StopCntY.Value.ToString());//nehe spalte nach
			txt.WriteLine(rad_filepic_Bytetyp1.Checked.ToString());
			txt.WriteLine(rad_filepic_Bytetyp2.Checked.ToString());
			txt.WriteLine(rad_filepic_Bytetyp3.Checked.ToString());
			txt.WriteLine(num_filepic_indexPlus.Value.ToString());//indexerhöhung
			txt.WriteLine(chk_filepic_rainbow.Checked.ToString());//pseudocolor
			txt.WriteLine(num_filepic_endX.Value.ToString());//bild W
			txt.WriteLine(num_filepic_endY.Value.ToString());//bild H
			txt.WriteLine(num_filepic_span.Value.ToString());//span
			txt.WriteLine(num_filepic_offsetmin.Value.ToString());//offset min
			txt.WriteLine(num_filepic_offsetmax.Value.ToString());//offset max
			txt.WriteLine(scroll_filepic_offset.Value.ToString());//offset
			txt.WriteLine(chk_filepic_Bit15Korr.Checked.ToString());//bit15Korr
			txt.Close();
		}
		void Btn_filepic_loadconfigClick(object sender, EventArgs e)
		{
			try {
				openFileDialog1.Filter = "FilePic Configuration (*.cfg)|*.cfg|Alle Datein (*.*)|*.*";
				if (openFileDialog1.ShowDialog()!=DialogResult.OK) {
					return;
				}
				StreamReader txt = new StreamReader(openFileDialog1.FileName);
				Filepath=txt.ReadLine();
				Lock_CTRL=true;
				num_filepic_OpenByteoffset.Value = decimal.Parse(txt.ReadLine());//startoffset
				num_filepic_StopCntX.Value = decimal.Parse(txt.ReadLine());//neue zeile nach
				num_filepic_StopCntY.Value = decimal.Parse(txt.ReadLine());//nehe spalte nach
				rad_filepic_Bytetyp1.Checked = bool.Parse(txt.ReadLine());
				rad_filepic_Bytetyp2.Checked = bool.Parse(txt.ReadLine());
				rad_filepic_Bytetyp3.Checked = bool.Parse(txt.ReadLine());
				num_filepic_indexPlus.Value = decimal.Parse(txt.ReadLine());//indexerhöhung
				chk_filepic_rainbow.Checked = bool.Parse(txt.ReadLine());//pseudocolor
				num_filepic_endX.Value = decimal.Parse(txt.ReadLine());//bild W
				num_filepic_endY.Value = decimal.Parse(txt.ReadLine());//bild H
				num_filepic_span.Value = decimal.Parse(txt.ReadLine());//span
				num_filepic_offsetmin.Value = decimal.Parse(txt.ReadLine());//offset min
				num_filepic_offsetmax.Value = decimal.Parse(txt.ReadLine());//offset max
				scroll_filepic_offset.Value = int.Parse(txt.ReadLine());//offset
				chk_filepic_Bit15Korr.Checked = bool.Parse(txt.ReadLine());//bit15Korr
				Lock_CTRL=false;
				if (chk_filepic_rainbow.Checked) {
					draw_rainbow_palette();
				} else {
					draw_dual_palette(Color.White,Color.Black,false);
				}
				Kernel_Fileformat_ReadfileToPic();
			} catch (Exception err) {
				Lock_CTRL=false;
				MessageBox.Show(err.Message,"Error load Config");
			}
		}
		void Chk_filepic_Bit15KorrCheckedChanged(object sender, EventArgs e)
		{
			if (Lock_CTRL) { return; }
			Kernel_Fileformat_ReadfileToPic();
		}
		void num_filepic_All(object sender, EventArgs e)
		{
			if (Lock_CTRL) { return; }
            if ((sender as NumericUpDown).Name == "num_filepic_StopCntX") {
                Lock_CTRL = true;
                if (chk_filepic_LockRatio.Checked) {
                    num_filepic_StopCntY.Value = num_filepic_StopCntX.Value * FilebufferRatio;
                } else {
                    FilebufferRatio = num_filepic_StopCntY.Value / num_filepic_StopCntX.Value;
                }
                if (chk_filepic_UseForImg.Checked) {
                    num_filepic_endX.Value = num_filepic_StopCntX.Value;
                    num_filepic_endY.Value = num_filepic_StopCntY.Value;
                }
                Application.DoEvents();
                Lock_CTRL = false;
            }
			Kernel_Fileformat_ReadfileToPic();
		}
		void Rad_filepic_Bytetyp3Click(object sender, EventArgs e)
		{
			if (Lock_CTRL) { return; }
			Kernel_Fileformat_ReadfileToPic();
		}
		void Tbtn_filepic_offset_GrenzeUpClick(object sender, EventArgs e)
		{
			num_filepic_offsetmax.Value=(decimal)scroll_filepic_offset.Value;
		}
		void Tbtn_filepic_offset_GrenzeDownClick(object sender, EventArgs e)
		{
			num_filepic_offsetmin.Value=(decimal)scroll_filepic_offset.Value;
		}
		void Tbtn_filepic_offset_GrenzeFullClick(object sender, EventArgs e)
		{
			num_filepic_offsetmax.Value=65535;
			num_filepic_offsetmin.Value=-65535;
		}
		void Kernel_Fileformat_ReadfileToPic()
		{
			#if (!DEBUG)
			try {
			#endif
			int stopX = (int)num_filepic_endX.Value;
			int stopY = (int)num_filepic_endY.Value;
			for (int x=0;x<stopX ;x++ ) {
				for (int y=0;y<stopY ;y++ ) {
					data_RAW[x,y]=0;
				}
			}
			//diverse variablen
			StringBuilder SB = new StringBuilder();
			int Bytemode = 0;
			if (rad_filepic_Bytetyp1.Checked) { Bytemode=1; }
			if (rad_filepic_Bytetyp2.Checked) { Bytemode=2; }
			if (rad_filepic_Bytetyp3.Checked) { Bytemode=3; }
			int indexPlus = (int)num_filepic_indexPlus.Value;
			int StopCntX = (int)num_filepic_StopCntX.Value; int CntX = 0;
			int StopCntY = (int)num_filepic_StopCntY.Value; int CntY = 0;
			bool KorrBit15 = chk_filepic_Bit15Korr.Checked;
			bool Textinfos = chk_filepic_textinfos.Checked;
			int Entries = 0; int data_RAW_max = -99999; int data_RAW_min = 99999;
			//datei auslesen
			if (!File.Exists(Filepath)) {
				MessageBox.Show("Prüfe, ob die Datei unter folgnden Pfad zu finden ist:\r\n"+Filepath
				                +"\r\n\r\nfalls nicht, Datei per Drag&Drop laden...","Datei konnte nicht geöffnet werden");
				return;
			}
			FileStream FS = File.OpenRead(Filepath);
			LastFilepuffer = Filepuffer;
			Filepuffer = new byte[FS.Length];
			FS.Read(Filepuffer,0,Filepuffer.Length-1);
			FS.Close();
			
			for (int i = (int)num_filepic_OpenByteoffset.Value; i<Filepuffer.Length-1; i+=indexPlus) {
				int val = 0;
				switch (Bytemode) {
					case 1: val = Filepuffer[i+1]<<8|Filepuffer[i];
						if (Textinfos) { SB.Append(val.ToString()+" ("+Filepuffer[i+1].ToString()+"|"+Filepuffer[i].ToString()+") "); } 
						break;
					case 2: val = Filepuffer[i]<<8|Filepuffer[i+1];
						if (Textinfos) { SB.Append(val.ToString()+" ("+Filepuffer[i].ToString()+"|"+Filepuffer[i+1].ToString()+")"); } 
						break;
					case 3: val = Filepuffer[i];
						if (Textinfos) { SB.Append(val.ToString()+" "); } 
						break;
				}
				
				if (KorrBit15) {
					if (val>32767) {
						val-=32767;
					} else {
						val+=32767;
					}
				}
				
				if (CntX < StopCntX) {
					data_RAW[CntX,CntY] = val;
					CntX++;
				} else {
					CntX = 0;
					CntY++;
					if (Textinfos) { SB.Append("\r\n Zeile "+CntY.ToString()+": "); } 
					data_RAW[CntX,CntY] = val;
					CntX++;
					if (CntY==StopCntY) {
						break;
					}
				}
				if (CntX<StopCntX&&CntY<StopCntY) {
					if (data_RAW_max < val) { data_RAW_max = val; }
					if (data_RAW_min > val) { data_RAW_min = val; }
					Entries++;
				}
			}
			if (Textinfos) { 
				txt_filepic_Textausgabe.Text=
				"Val min: "+data_RAW_min.ToString()+" Val max: "+data_RAW_max.ToString()+"\r\n"+SB.ToString();
			}
			Kernel_Fileformat_DrawPic();
			
			#if (!DEBUG)
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Fehler beim öffnen...");
			}
			#endif
		}
		void Kernel_Fileformat_DrawPic()
		{
			int stopX = (int)num_filepic_endX.Value;
			int stopY = (int)num_filepic_endY.Value;
			decimal span = num_filepic_span.Value;
			int offset = (int)scroll_filepic_offset.Value;
			UnsafeBitmap pic = new UnsafeBitmap(stopX,stopY);
			PixelData C = new PixelData();
			pic.LockBitmap();
			
			for (int j = 0; j<stopX; j++) {
				for (int i = 0; i<stopY; i++) {
					int data = data_RAW[j,i];
					data = (int)((data-offset)/span);
					//byte grenze
					if (data > 255) { data = 255;}
					if (data < 0) { data = 0; }
					
					if (chk_filepic_rainbow.Checked) {
						C.red = map_r[data];
					    C.green = map_g[data];
					    C.blue = map_b[data];
					} else {
						C.red = (byte)data;
						C.green = (byte)data;
						C.blue = (byte)data;
					}
					
				    pic.SetPixel(j,i,C);
				}
			}
			pic.UnlockBitmap();
			picBox_filepic.Image=pic.Bitmap;
		}
		
		void draw_rainbow_palette()
		{
			//neue graustufen farbpalette
			int mode = 0; float steps=4f;
			float red = 255f; float green = 255f; float blue = 255f;
        	for ( int i = 0; i < 256; i++ )
			{
        		switch (mode) {
        			case 0: //weiss zu rot
        				green-=steps; blue-=steps;
        				if (green<1f||blue<1f) { mode++; }
        				break;
        			case 1: //rot zu gelb
        				green+=steps;
        				steps-=0.01f;
        				if (green>250f) { mode++;  }
        				break;
        			case 2: //gelbabstufung
        				red-=steps;
        				steps+=0.01f;
        				if (red<200f) { mode++; }
        				break;
        			case 3: //gelb zu grün
        				red-=steps;
        				if (red>100) {
        					steps+=0.1f;
        				} else {
        					green-=3f;
        					steps+=0.9f;
        				}
        				if (red<1f) { mode++; }
        				break;
        			case 4: //grün zu cyan
        				blue+=steps;
        				//steps-=0.3f;
        				if (blue>100) {
        					steps-=0.55f;
        				} else {
        					steps-=0.1f;
        				}
        				if (blue>254f) { mode++; }
        				break;
        			case 5: //cyan zu blau
        				green-=steps;
        				if (green<1f) { mode++; }
        				break;
        			case 6: //blau zu schwarz
        				blue-=steps;
        				if (blue<1f) { mode++; }
        				break;
        		}
        		if (red<0) { red=0; } if (red>255) { red=255; }
        		if (green<0) { green=0; } if (green>255) { green=255; }
        		if (blue<0) { blue=0; } if (blue>255) { blue=255; }
				map_r[255-i] = (byte)red;
				map_g[255-i] = (byte)green;
				map_b[255-i] = (byte)blue;
			}
        	
        	UnsafeBitmap Farbscala = new UnsafeBitmap(30,256);
			Farbscala.LockBitmap();
			PixelData C = new PixelData();
			for (int y=0;y<255 ;y++ ) {
				C.red=map_r[255-y]; 
				C.green=map_g[255-y];
				C.blue=map_b[255-y];
				for (int x=0;x<30 ;x++ ) {
					Farbscala.SetPixel(x,y,C);
				}
			}
        	Farbscala.UnlockBitmap();
        	picBox_Scala.Image = Farbscala.Bitmap;
		}
		void draw_dual_palette(Color startfarbe,Color endfarbe,bool isotherm)
		{	//erzeuge einen Farbverlauf und eine dementsprechende farbtabelle
			
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			Bitmap Farbscala = new Bitmap(30, 256);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(Farbscala);
			Rectangle rect = new Rectangle(0, 0, 30, 256);
			LinearGradientBrush GB = new LinearGradientBrush(rect, startfarbe, endfarbe, LinearGradientMode.Vertical);
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			
			picBox_Scala.Image = (Bitmap)Farbscala;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = Farbscala.GetPixel(1,255-i);
				map_r[i] = col.R;
				map_g[i] = col.G;
				map_b[i] = col.B;
			}
		}
		#endregion
		
		#region Tab_ImageTransformer
		bool Abbruch = false;
		Bitmap BackPic_IT=new Bitmap(10,10);
		void Kernel_IT_Filedrop(string Filename) 
		{
			try {
				if (Path.GetExtension(Filename)=="") {
					txt_ITFR_StartPfad.Text=Filename; return;
				}
				int PicSollW = (int)(num_IT_QuadWith.Value/2);
				Image source = Bitmap.FromFile(Filename);
				
				int PicSollH = (int)(((float)PicSollW/(float)source.Width)*(float)source.Height);
				if (num_IT_NextPos.Value==0) {
					BackPic_IT=new Bitmap((int)num_IT_QuadWith.Value,PicSollH*2);
					num_IT_NextPos.Value+=1; num_IT_NextPos.Refresh();
				}
				if (source.HorizontalResolution!=BackPic_IT.HorizontalResolution) {
					int PicSollWnew=(int)(((float)source.HorizontalResolution/(float)BackPic_IT.HorizontalResolution)*(float)PicSollW);
					int PicSollHnew=(int)(((float)source.HorizontalResolution/(float)BackPic_IT.HorizontalResolution)*(float)PicSollH);
					source=ResizeImage(source,PicSollWnew,PicSollHnew);
				} else {
					source=ResizeImage(source,PicSollW,PicSollH);
				}
				//pictBox_IT_Quad.Image=Image.FromFile(Filename);
				
				using (Graphics grfx = Graphics.FromImage(BackPic_IT))
				{
					switch ((int)num_IT_NextPos.Value) {
						case 1: grfx.DrawImage(source, 0, 0); break;
						case 2: grfx.DrawImage(source, PicSollW, 0); break;
						case 3: grfx.DrawImage(source, 0, PicSollH); break;
						case 4: grfx.DrawImage(source, PicSollW, PicSollH); break;
					}
				}
				num_IT_NextPos.Value+=1;
			    if (num_IT_NextPos.Value==5) {
			    	num_IT_NextPos.Value=1;
			    }
				pictBox_IT_Quad.Image=BackPic_IT;
			} catch (Exception err) {
				MessageBox.Show("Kernel_IT_Filedrop()->"+err.Message);
			}
			
			
		}
		public Bitmap ResizeImage(Image image, int width, int height)
		{
		    var destRect = new Rectangle(0, 0, width, height);
		    var destImage = new Bitmap(width, height);
		
		    destImage.SetResolution(image.HorizontalResolution, image.VerticalResolution);
		
		    using (var graphics = Graphics.FromImage(destImage))
		    {
		        graphics.CompositingMode = CompositingMode.SourceCopy;
		        graphics.CompositingQuality = CompositingQuality.HighQuality;
		        graphics.InterpolationMode = InterpolationMode.HighQualityBicubic;
		        graphics.SmoothingMode = SmoothingMode.HighQuality;
		        graphics.PixelOffsetMode = PixelOffsetMode.HighQuality;
		
		        using (var wrapMode = new ImageAttributes())
		        {
		            wrapMode.SetWrapMode(WrapMode.TileFlipXY);
		            graphics.DrawImage(image, destRect, 0, 0, image.Width,image.Height, GraphicsUnit.Pixel, wrapMode);
		        }
		    }
		
		    return destImage;
		}
		void TP_ImageTransformerDragEnter(object sender, DragEventArgs e)
		{
			if (e.Data.GetDataPresent(DataFormats.FileDrop)) {	
				if ((e.AllowedEffect & DragDropEffects.Move) != 0) {
					e.Effect = DragDropEffects.Move;
				}
			}
		}
		
		void TP_ImageTransformerDragDrop(object sender, DragEventArgs e)
		{
			try 
			{	
				if (e.Data.GetDataPresent (DataFormats.FileDrop))
				{	//versuche die gedropte datei als text zu laden
					string[] filepath = (string[]) e.Data.GetData (DataFormats.FileDrop);
					Kernel_IT_Filedrop(filepath[0]);
				}
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
		}
		
		void Btn_IT_SaveImageClick(object sender, EventArgs e)
		{
			Kernel_saveImage();
		}
		void Kernel_saveImage()
		{
			Abbruch = false;
			try {
			string TYP = ".jpg";
//			if (rad_cam_FormatPNG.Checked) {
//				TYP = ".png";
//			}
			long Rate = (long)num_IT_JpgRate.Value;
			if (pictBox_IT_Quad.Image==null) { return; }
			if (txt_IT_imgName.Text=="") {
				MessageBox.Show("Dateipfad oder Name ist leer... Bild wird nicht gespeichert","Kein Bild gespeichert"); return;
			}
			if (!Directory.Exists(txt_IT_ImgPath.Text)) {
				DialogResult result = MessageBox.Show("Der Ordner:\r\n"+txt_IT_ImgPath.Text+"\r\n\r\nExistiert noch nicht. Erstellen?\r\n","Ordner nicht vorhanden",MessageBoxButtons.YesNo);
				if (result!=DialogResult.Yes) { return; }
				Directory.CreateDirectory(txt_IT_ImgPath.Text);
			}
			
			string Dateiname = txt_IT_ImgPath.Text;//+"\\"+txt_ViErr_filename.Text;
			if (!Dateiname.EndsWith("\\")) { Dateiname=Dateiname+"\\"; }
			if (txt_IT_imgName.Text.Contains(".")) { //endung schon angegeben
				Dateiname=Dateiname+txt_IT_imgName.Text.Split('.')[0];
			} else {
				Dateiname=Dateiname+txt_IT_imgName.Text;
			}
			//MessageBox.Show(Dateiname);
			if (File.Exists(Dateiname+TYP)) {
				int ID = 0;
				while (File.Exists(Dateiname+"_"+ID.ToString()+TYP)) {
					ID++;
				}
				if (true) { //Umbenennen
					Dateiname = Dateiname+"_"+ID.ToString()+TYP;
				}
			}
			//Sicherstellen, dass dateiende vorhanden ist
			if (!Dateiname.EndsWith(TYP)) { Dateiname = Dateiname+TYP; }
			if (true) {
				// Encoder parameter for image quality
				EncoderParameter qualityParam = new EncoderParameter(System.Drawing.Imaging.Encoder.Quality, Rate);
				// Jpeg image codec
				ImageCodecInfo jpegCodec = getEncoderInfo("image/jpeg");
				EncoderParameters EPs = new EncoderParameters(1);
				EPs.Param[0] = qualityParam;
				//Bild Speichern
				//Bitmap img = (Bitmap)picbox_main.Image.Clone();
	    		pictBox_IT_Quad.Image.Save(Dateiname,jpegCodec,EPs); //
	    		
	    		if (chk_IT_Webpthump.Checked) {
	    			Dateiname=Dateiname.Split('.')[0]+"_th.jpg";
	    			qualityParam = new EncoderParameter(System.Drawing.Imaging.Encoder.Quality, 20L);
					EPs.Param[0] = qualityParam;
					//Bild Speichern
					//Bitmap img = (Bitmap)picbox_main.Image.Clone();
					Image source = (Image)pictBox_IT_Quad.Image.Clone();
					int H = (int)((float)source.Height/((float)source.Width/250f));
		    		source=ResizeImage(source,250,H);
		    		source.Save(Dateiname,jpegCodec,EPs);
	    		}
	    		//img.Dispose();
			} else {
				//Bitmap img = (Bitmap)picbox_main.Image.Clone();
	    		//pictBox_IT_Quad.Image.Save(Dateiname,ImageFormat.Png); //
	    		//img.Dispose();
			}
			
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Fehler beim Speichern");
			}
		}
		ImageCodecInfo getEncoderInfo(string mimeType)
		{
		   // Get image codecs for all image formats
		   ImageCodecInfo[] codecs = ImageCodecInfo.GetImageEncoders();
		
		   // Find the correct image codec
		   for (int i = 0; i < codecs.Length; i++)
		      if (codecs[i].MimeType == mimeType)
		         return codecs[i];
		   return null;
		}
		void Btn_IT_OpenFolderClick(object sender, EventArgs e)
		{
			string pfad = txt_IT_ImgPath.Text;
			if (!Directory.Exists(pfad)) {
				Directory.CreateDirectory(pfad);
			}
			try {
				System.Diagnostics.Process.Start(pfad);	
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
		}
		//folder Resize
		void Btn_ITFR_getFilesClick(object sender, EventArgs e)
		{
			Abbruch = false;
			chk_ITFR_Setup.Checked=false;
			string normalname = btn_ITFR_getFiles.Text;
			string startFolder = txt_ITFR_StartPfad.Text;
			try {
				dgw_ITFR_Datein.Rows.Clear();
				btn_ITFR_getFiles.BackColor=Color.LimeGreen; btn_ITFR_getFiles.Refresh();
				int index=0;
				GetFiles_ITFR(startFolder,ref index);
				if (chk_ITRF_AutoSortAtEnd.Checked) {
					dgw_ITFR_Datein.Sort(dgw_ITFR_Datein.Columns[3],System.ComponentModel.ListSortDirection.Descending);
				}
				btn_ITFR_getFiles.BackColor=Color.Gainsboro;
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
			txt_ITFR_StartPfad.Text=startFolder;
			btn_ITFR_getFiles.Text=normalname;
		}
		void GetFiles_ITFR(string Folder,ref int index)
		{
			if (Abbruch) { return; }
			txt_ITFR_StartPfad.Text=Folder; txt_ITFR_StartPfad.Refresh();
			string[] files = Directory.GetFiles(Folder,txt_ITFR_SearchPattern.Text);
			foreach(string S in files) {
				Application.DoEvents();
				if (Abbruch) { return; }
				FileInfo FI = new FileInfo(S);
				string Infoline="";
				int W=0;
				int H=0;
				try {
					btn_ITFR_getFiles.Text=index.ToString()+"/"+files.Length.ToString(); btn_ITFR_getFiles.Refresh();
					Image img = Image.FromFile(FI.FullName);
					W=img.Size.Width;
					H=img.Size.Height;
					img.Dispose();
				} catch (Exception err) {
					Infoline=err.Message;
				}
				if (chk_ITRF_SkipLowSize.Checked) {
					if (W<=(int)num_ITFR_SkipLowSize.Value) {
						continue;
					}
				}
				if (chk_ITRF_SkipLowSizeH.Checked) {
					if (H<=(int)num_ITFR_SkipLowSizeH.Value) {
						continue;
					}
				}
				dgw_ITFR_Datein.Rows.Add(index++,FI.FullName,FI.Name,W,H,Math.Round((double)(FI.Length/1000),1).ToString(),"-",Infoline);
			}
			if (!chk_ITRF_SearchSubFolder.Checked) {
				return;
			}
			string[] folders = Directory.GetDirectories(Folder);
			foreach(string S in folders) {
				GetFiles_ITFR(S,ref index);
			}
		}
		void Btn_ITFR_ProcessClick(object sender, EventArgs e)
		{
			Abbruch = false;
			string normalname = btn_ITFR_Process.Text;
			chk_ITFR_Setup.Checked=false;
			btn_ITFR_Process.BackColor=Color.LimeGreen;btn_ITFR_Process.Refresh();
			try {
//				long Rate = (long)num_IT_JpgRate.Value;
//				EncoderParameter qualityParam = new EncoderParameter(System.Drawing.Imaging.Encoder.Quality, Rate);
//				ImageCodecInfo jpegCodec = getEncoderInfo("image/jpeg");
//				EncoderParameters EPs = new EncoderParameters(1);
//				EPs.Param[0] = qualityParam;
				
				foreach(DataGridViewRow R in dgw_ITFR_Datein.Rows) {
					subProcessRow(R);
					btn_ITFR_Process.Text=R.Index.ToString()+"/"+dgw_ITFR_Datein.Rows.Count.ToString(); 
					Application.DoEvents();
					//btn_ITFR_Process.Refresh();
					if (Abbruch) { break; }
				}
				
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
			btn_ITFR_Process.Text=normalname;
			btn_ITFR_Process.BackColor=Color.Gainsboro;
		}
		void Chk_ITFR_SetupCheckedChanged(object sender, EventArgs e)
		{
			group_ITFR_Setup.Visible=chk_ITFR_Setup.Checked;
		}
		void Dgw_ITFR_DateinCellContentClick(object sender, DataGridViewCellEventArgs e)
		{
			if (e.RowIndex<0) { return; }
			if (e.ColumnIndex!=2) { return; }
			try {
				System.Diagnostics.Process.Start(dgw_ITFR_Datein.Rows[e.RowIndex].Cells[1].Value.ToString());
			} catch (Exception err) {
				MessageBox.Show(err.Message);
			}
		}
		void Btn_ITFR_AbbruchClick(object sender, EventArgs e)
		{
			Abbruch=true;
		}
		void Tbtn_ITFR_DelSelectedClick(object sender, EventArgs e)
		{
			if (dgw_ITFR_Datein.RowCount < 1) { return; }
//			try {
//				if (dgw_ITFR_Datein.SelectedRows.Count > 0) 
//				{
//					int menge = dgw_ITFR_Datein.SelectedRows.Count;
//					int beginn = dgw_ITFR_Datein.SelectedRows[0].Index;
//					
//					if (dgw_ITFR_Datein.SelectedRows[menge - 1].Index < dgw_ITFR_Datein.SelectedRows[0].Index) 
//					{ //falls von unten oben nach unten markiert wurde, dann liegt die zelle[0] ganz unten
//						beginn = dgw_ITFR_Datein.SelectedRows[menge - 1].Index;
//					}
//					if (dgw_ITFR_Datein.SelectedRows.Count == dgw_ITFR_Datein.RowCount) 
//					{
//						menge--;
//						beginn = 0;
//					}
//					this.BringToFront();;
//					DialogResult result;
//					result = MessageBox.Show("Sollen ("+menge+") Reihen von Index ("+(beginn+1)+") abwärts gelöscht werden?"
//						,"Datenreihen löschen?",MessageBoxButtons.YesNo);
//					if (result != DialogResult.Yes) 
//					{
//						return;
//					}
//					for (int i=0;i < menge ;i++)
//					{
//						dgw_ITFR_Datein.Rows.RemoveAt(beginn);
//					}
//				}
//			} catch (Exception err) {
//				MessageBox.Show(err.Message,"Fehler bei Tbtn_ITFR_DelSelectedClick");
//			}
			List<DataGridViewRow> L = new List<DataGridViewRow>();
			foreach(DataGridViewCell C in dgw_ITFR_Datein.SelectedCells) {
				if (!L.Contains(dgw_ITFR_Datein.Rows[C.RowIndex])) {
					L.Add(dgw_ITFR_Datein.Rows[C.RowIndex]);
				}
			}
			foreach (DataGridViewRow R in L) {
				dgw_ITFR_Datein.Rows.Remove(R);
			}
		}
		void Tbtn_ITRF_ProcessSelectedClick(object sender, EventArgs e)
		{
			List<DataGridViewRow> L = new List<DataGridViewRow>();
			foreach(DataGridViewCell C in dgw_ITFR_Datein.SelectedCells) {
				if (!L.Contains(dgw_ITFR_Datein.Rows[C.RowIndex])) {
					L.Add(dgw_ITFR_Datein.Rows[C.RowIndex]);
				}
			}
			foreach (DataGridViewRow R in L) {
				subProcessRow(R);
			}
		}
		void subProcessRow(DataGridViewRow R)
		{
			//0          1             2  3 4  5     6      7
			//index++,FI.FullName,FI.Name,W,H,size,status,Infoline);
			string istW = R.Cells[3].Value.ToString();
			string istH = R.Cells[4].Value.ToString();
			string Filename = R.Cells[1].Value.ToString();
			if (istW==""||istW=="0") { 
				R.Cells[6].Value="Skip";
				R.Cells[6].Style.BackColor=Color.Salmon;
				R.Cells[7].Value="zu klein: 'Breite ist'";
				return;
			}
			try {
				int PicSollW=0,PicSollH=0;
				Image source;
				if (rad_ITRF_ResizeToW.Checked) {
					PicSollW = (int)(num_ITFR_Wsoll.Value);
					if (PicSollW.ToString()==istW) {
						R.Cells[6].Value="Skip";
						R.Cells[6].Style.BackColor=Color.PaleGreen;
						R.Cells[7].Value="breite passt schon";
						return;
					}
					int Wist = int.Parse(istW);
					if (PicSollW>Wist) {
						R.Cells[6].Value="Skip";
						R.Cells[6].Style.BackColor=Color.Gold;
						R.Cells[7].Value="bild war kleiner";
						return;
					}
					source = Image.FromFile(Filename);
					PicSollH = (int)(((float)PicSollW/(float)source.Width)*(float)source.Height);
				} else {
					PicSollH = (int)(num_ITFR_Hsoll.Value);
					if (PicSollH.ToString()==istH) {
						R.Cells[6].Value="Skip";
						R.Cells[6].Style.BackColor=Color.PaleGreen;
						R.Cells[7].Value="Höhe passt schon";
						return;
					}
					int Hist = int.Parse(istH);
					if (PicSollH>Hist) {
						R.Cells[6].Value="Skip";
						R.Cells[6].Style.BackColor=Color.Gold;
						R.Cells[7].Value="bild war kleiner";
						return;
					}
					source = Image.FromFile(Filename);
					PicSollW = (int)(((float)PicSollH/(float)source.Height)*(float)source.Width);
				}
				Bitmap newBMP=(Bitmap)ResizeImage(source,PicSollW,PicSollH).Clone();
				source.Dispose();
				long Rate = (long)num_IT_JpgRate.Value;
				EncoderParameter qualityParam = new EncoderParameter(System.Drawing.Imaging.Encoder.Quality, Rate);
				ImageCodecInfo jpegCodec = getEncoderInfo("image/jpeg");
				EncoderParameters EPs = new EncoderParameters(1);
				EPs.Param[0] = qualityParam;
				newBMP.Save(Filename,jpegCodec,EPs);
				
				R.Cells[3].Value=PicSollW;
				R.Cells[4].Value=PicSollH;
				R.Cells[6].Value="Done";
				R.Cells[6].Style.BackColor=Color.PaleGreen;
				R.Cells[7].Value="";
			} catch (Exception err) {
				R.Cells[6].Value="Error";
				R.Cells[6].Style.BackColor=Color.Salmon;
				R.Cells[7].Value=err.Message;
			}	
		}
		
		
		#endregion
		
		//bool FrameSending = false;
		void Txt_calcKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyCode==Keys.Enter) {
				
			}
		}

        void btn_fileformat_toFloat_Click(object sender, EventArgs e) {
            try {
                StringBuilder sb = new StringBuilder();
                string[] splits = txt_fileformat_ToFloat.Text.Split(' ');
                if (splits.Length<4) {
                    MessageBox.Show("need 4 bytes.");
                    return;
                }
                byte[] bytes = new byte[splits.Length];
                byte[] bytesInv = new byte[splits.Length];
                for (int i = 0; i < bytes.Length; i++) {
                    if (splits[i]=="") { continue; }
                    bytes[i] = byte.Parse(splits[i]);
                    bytesInv[3-i] = byte.Parse(splits[i]);
                }
                float F = BitConverter.ToSingle(bytes, 0);
                sb.AppendLine("Float: " + F.ToString());
                F = BitConverter.ToSingle(bytesInv, 0);
                sb.AppendLine("Float inverse: " + F.ToString());
                sb.AppendLine("Ushort A1: " + ((bytes[0] << 8) | bytes[1]));
                sb.AppendLine("Ushort A2: " + ((bytes[1] << 8) | bytes[0]));
                sb.AppendLine("Ushort B1: " + ((bytes[2] << 8) | bytes[3]));
                sb.AppendLine("Ushort B2: " + ((bytes[3] << 8) | bytes[2]));
                MessageBox.Show(sb.ToString());
            }
            catch (Exception ex) {
                MessageBox.Show("EX: " + ex.Message);
            }
        }

        
    }
	
}
