﻿#region Usings...
using System;
using System.Text;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.IO.Ports;
using System.IO;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using UsbHid;
using System.Diagnostics;


using System.Security.Cryptography; //crc
using MiniStm32JoeC_CoreLibrary;
using UsbHid.USB.Classes;
using UsbHid.USB.Classes.Messaging;
#endregion

namespace Dev_Tools
{
    public partial class HidForm : Form {

        #region Allgemeines
        MiniStm32BoardJoeC _board = new MiniStm32BoardJoeC(ConnectionType.USB_HID);
        UsbHidDevice _hid;
        UnsafeBitmap colmap;

        int ReportOutLen = 63;

        public HidForm() {
            InitializeComponent();
            //init usercontrols
            uC_SPI1.Init(_board);
            uC_PinMap1.Init(_board);
            uC_ADC1.Init(_board);

            _board.Event_Send_ByteArray += _board_Event_Send_ByteArray;
            uC_PinMap1.SetReferenceOffsets(FromAppConfig("OffsetVoltageReferenceCounts", 0), FromAppConfig("OffsetTemperatureCounts", 0));
            if (FromAppConfig("SelectHidAnyDevice", 0) == 1) {
                rad_hid_selectAny.Checked = true;
            }
            string hidInitType = FromAppConfig("SelectHidByInitType", "");
            if (!string.IsNullOrWhiteSpace(hidInitType)) {
                txt_hid_selectInitType.Text = hidInitType;
                rad_hid_selectInitType.Checked = true;
            }
            string hidSerial = FromAppConfig("SelectHidBySerial", "");
            if (!string.IsNullOrWhiteSpace(hidSerial)) {
                txt_hid_selectId.Text = hidSerial;
                rad_hid_selectId.Checked = true;
            }
        }


        string FromAppConfig(string nameOf_AppConfig_Entry, string defaultValue) {
            try {
                string entry = System.Configuration.ConfigurationManager.AppSettings[nameOf_AppConfig_Entry];
                return entry;
            }
            catch (Exception err) {
                txt_usb_recive.Text += $"FromAppConfig('{nameOf_AppConfig_Entry}')->{err.Message}";
            }
            return defaultValue;
        }
        int FromAppConfig(string nameOf_AppConfig_Entry, int defaultValue) {
            string entry = FromAppConfig(nameOf_AppConfig_Entry, "");
            int output = 0;
            if (int.TryParse(entry, out output)) {
                return output;
            }
            txt_usb_recive.Text += $"FromAppConfig('{nameOf_AppConfig_Entry}')->Can't convert '{entry}' to integer.";
            return defaultValue;
        }

        UnsafeBitmap Generate_Colormap()
        {
            UnsafeBitmap ubmp = new UnsafeBitmap(310, 255);
            ubmp.LockBitmap();
            PixelData P = new PixelData();
            for(int H = 0; H < 256; H++) {
                int state = 0;
                byte R = 255, G = 0, B = 0;
                for(int W = 0; W < 310; W++) {
                    switch(state) {//5er schritte bis 255 -> 51 pixel pro run -> 306 pix für alle
                        case 0: G += 5; if(G == 255) { state++; } break; //rot -> gelb
                        case 1: R -= 5; if(R == 0) { state++; } break; //gelb -> grün
                        case 2: B += 5; if(B == 255) { state++; } break; //grün -> cyan
                        case 3: G -= 5; if(G == 0) { state++; } break; //cyan -> blau
                        case 4: R += 5; if(R == 255) { state++; } break; //blau -> magenta
                        case 5: G += 5; if(G == 255) { state++; } break; //magenta -> weiss
                    }
                    int data = (int)((float)R * (float)H / 255f);
                    if(data < 0) { data = 0; } if(data > 255) { data = 255; }
                    P.red = (byte)data;
                    data = (int)((float)G * (float)H / 255f);
                    if(data < 0) { data = 0; } if(data > 255) { data = 255; }
                    P.green = (byte)data;
                    data = (int)((float)B * (float)H / 255f);
                    if(data < 0) { data = 0; } if(data > 255) { data = 255; }
                    P.blue = (byte)data;
                    ubmp.SetPixel(W, 255 - H, P);
                }
            }
            ubmp.UnlockBitmap();
            return ubmp;
        }
        void MainFormShown(object sender, EventArgs e)
        {
            colmap = Generate_Colormap();
            picBox_LED.Image = (Bitmap)colmap.Bitmap.Clone();
            colmap.LockBitmap();
        }


        void _board_Event_Send_ByteArray(byte[] obj) {
            try {
                sendHID(obj);
            }
            catch (Exception ex) {
                txt_usb_recive.Text += "Ex: " + ex.Message;
            }
        }

        void MainFormLoad(object sender, EventArgs e)
        {
            //color map erstellen
            //
            dgw_LEDs.Rows.Add("100", "100", "100");
            dgw_LEDs.Rows.Add("100", "0", "0");
            dgw_LEDs.Rows.Add("0", "100", "0");
            dgw_LEDs.Rows.Add("0", "0", "100");

            dgw_LEDs.Rows.Add("100", "100", "100");
            dgw_LEDs.Rows.Add("0", "100", "100");
            dgw_LEDs.Rows.Add("100", "100", "0");
            dgw_LEDs.Rows.Add("100", "0", "100");

            CB_RS232_baud.SelectedIndex = 2;

            RefreshHidDevices();
        }
        VidPidMatcher GetVidPid() {
            UInt32 Vendor = UInt32.Parse(txt_usb_VendorID.Text, System.Globalization.NumberStyles.HexNumber);
            UInt32 Product = UInt32.Parse(txt_usb_ProductID.Text, System.Globalization.NumberStyles.HexNumber);
            return new VidPidMatcher(Vendor, Product);
        }
        void RefreshHidDevices() {
            txt_HidDevicesLog.Text = "";
            dgv_HidDevices.Rows.Clear();
            try {
                bool deviceSelected = false;
                if (_hid != null) {
                    if (_hid.IsDeviceConnected) {
                        deviceSelected = true;
                    }
                }

                //search Hid devices by VID and PID
                var devices = DeviceDiscovery.FindHidDevices(GetVidPid());
                txt_HidDevicesLog.Text += $"Found {devices.Count} Devices\r\n";
                foreach (var item in devices) {
                    dgv_HidDevices.Rows.Add(item.Value.Manufacturer,item.Value.Product,item.Value.Serial,item.Key);
                    if (!deviceSelected) {
                        if (rad_hid_selectAny.Checked) { 
                            deviceSelected = true;
                        }
                        else if (rad_hid_selectInitType.Checked) {
                            if (item.Value.Manufacturer.StartsWith(txt_hid_selectInitType.Text)) { deviceSelected = true; }
                        } else if (rad_hid_selectId.Checked) {
                            if (item.Value.Serial == txt_hid_selectId.Text) { deviceSelected = true; }
                        }
                        if (deviceSelected) {
                            HidDeviceConnect(item.Key, item.Value.Serial);
                        }
                    }
                    
                    if (item.Value.Serial == HidSelectedDeviceSerial) {
                        DataGridViewRow row = dgv_HidDevices.Rows[dgv_HidDevices.Rows.Count - 1];
                        row.Cells[0].Style.BackColor = Color.PaleGreen;
                        row.Cells[1].Style.BackColor = Color.PaleGreen;
                        row.Cells[2].Style.BackColor = Color.PaleGreen;
                        //skip column 3 (is button)
                    }
                }

            }
            catch (Exception ex) {
                txt_HidDevicesLog.Text += $"Error: {ex.Message}\r\n";
            }
        }
        string HidSelectedDeviceSerial = "";
        void HidDeviceConnect(string key, string serial) {
            HidDeviceDisconnect();
            try {
                _hid = new UsbHidDevice(key);
                _hid.DataReceived += OnEventReportRecieved;
                _hid.OnDisConnected += _hid_OnDisConnected;
                txt_deviceParameter.Text = $"In/Out ({_hid.DeviceInformation.Capabilities.InputReportByteLength}|{_hid.DeviceInformation.Capabilities.OutputReportByteLength})";
                txt_deviceParameter.BackColor = Color.PaleGreen;
                HidSelectedDeviceSerial = serial;
                txt_hid_selectedSerial.Text = serial;
            }
            catch (Exception ex) {
                txt_hid_selectedSerial.Text = "-";
                MessageBox.Show(ex.Message, "HidDeviceConnect()");
            }
        }

        void _hid_OnDisConnected() {
            //_hid.DataReceived -= OnEventReportRecieved;
            //_hid.OnDisConnected -= _hid_OnDisConnected;
            //_hid.Disconnect();
            //_hid.Dispose();
            txt_deviceParameter.BackColor = Color.Salmon;
            txt_hid_selectedSerial.Text = "-";
        }
        void HidDeviceDisconnect() { 
            if (_hid != null) {
                _hid.Disconnect();
                _hid.Dispose();
            }
        }

        void MainFormFormClosing(object sender, FormClosingEventArgs e)
        {
            HidDeviceDisconnect();
        }

        void chk_all_CheckedChanged_1(object sender, EventArgs e) {
            StringBuilder sbOut = new StringBuilder();
            sbOut.Append("2 10 ");
            if(chk_PC13.Checked) { sbOut.Append("1 "); } else { sbOut.Append("0 "); }
            Kernel_sendHID(sbOut.ToString());
        }
        #endregion

        #region Tab_RGB_LED
        void Btn_RGB_SetcolorClick(object sender, EventArgs e)
        {
            //			if (colorDialog1.ShowDialog()!=DialogResult.OK) {
            //				return;
            //			}
            //			byte b0 = colorDialog1.Color.R;
            //			byte b1 = colorDialog1.Color.G;
            //			byte b2 = colorDialog1.Color.B;
            //			byte b3 = (byte)num_RGB_LEDs.Value;

            StringBuilder sb = new StringBuilder();
            dgw_LEDs.RefreshEdit();
            dgw_LEDs.Refresh();
            sb.Append("14 " + num_RGB_LEDs.Value.ToString() + " ");
            for(int i = 0; i < dgw_LEDs.Rows.Count; i++) {
                DataGridViewRow R = dgw_LEDs.Rows[i];
                if(chk_led_swapRG.Checked) {
                    sb.Append(GetCellValue(R.Cells[1]) + " ");
                    sb.Append(GetCellValue(R.Cells[0]) + " ");
                    sb.Append(GetCellValue(R.Cells[2]) + " ");
                } else {
                    sb.Append(GetCellValue(R.Cells[0]) + " ");
                    sb.Append(GetCellValue(R.Cells[1]) + " ");
                    sb.Append(GetCellValue(R.Cells[2]) + " ");
                }
            }
            
            Kernel_sendHID(sb.ToString());
        }
        string GetCellValue(DataGridViewCell cell) {
            try {
                int number = int.Parse(cell.Value.ToString());
                return number.ToString();
            } catch (Exception) { }
            return "0";
        }

        void TrackBar_RGBLEDScroll(object sender, EventArgs e)
        {
            byte b0 = (byte)trackBar_RGBLED.Value;
            byte b3 = (byte)num_RGB_LEDs.Value;
            Kernel_sendHID("11 " + b0.ToString() + " " + b0.ToString() + " " + b0.ToString() + " " + b3.ToString());
        }

        void PicBox_LEDMouseMove(object sender, MouseEventArgs e)
        {
            label_LEDStat.Text = "Pos: " + e.X.ToString() + "x" + e.Y.ToString();
            int X = (int)((float)e.X / picBox_LED.Width * 310);
            int Y = (int)((float)e.Y / picBox_LED.Height * 255);
            if(X < 0 || Y < 0) { return; }
            if(X > 310 || Y > 255) { return; }
            PixelData pix = colmap.GetPixel(X, Y);
            label_LEDStat.Text += "\r\nR: " + pix.red.ToString();
            label_LEDStat.Text += "\r\nG: " + pix.green.ToString();
            label_LEDStat.Text += "\r\nB: " + pix.blue.ToString();
            if(e.Button == MouseButtons.Left) {
                byte b0 = pix.red;
                byte b1 = pix.green;
                byte b2 = pix.blue;
                byte b3 = (byte)num_RGB_LEDs.Value;
                if(chk_led_swapRG.Checked) {
                    Kernel_sendHID("11 " + b1.ToString() + " " + b0.ToString() + " " + b2.ToString() + " " + b3.ToString());
                } else {
                    Kernel_sendHID("11 " + b0.ToString() + " " + b1.ToString() + " " + b2.ToString() + " " + b3.ToString());
                }
            }
        }
        void picBox_LED_MouseDown(object sender, MouseEventArgs e) {
            PicBox_LEDMouseMove(sender, e);
        }
        void Ben_LEDOffClick(object sender, EventArgs e)
        {
            Kernel_sendHID("11 0 0 0 " + num_RGB_LEDs.Value.ToString());
        }
        #endregion

        #region Tab_UART
        void Txt_hid_uart1TxKeyDown(object sender, KeyEventArgs e)
        {
            if(e.KeyCode == Keys.Enter) {
                SendUartHid(1, txt_hid_uart1Tx.Text + "\r");
            }
        }
        void SendUartHid(int port, string uartTx) {
            try {
                char[] chars = uartTx.ToCharArray();
                int charsleft = chars.Length - 1;
                int readOffset = 0;
                while(charsleft > 0) {
                    byte[] puffer = new byte[ReportOutLen];
                    switch(port) {
                        case 1: puffer[0] = 10; break;
                        case 3: puffer[0] = 15; break;
                        default:
                            throw new Exception("Uart ports have to be 1 or 3.");
                    }
                    if(charsleft >= 60) {
                        charsleft -= 60;
                        puffer[1] = 60;
                    } else {
                        puffer[1] = (byte)chars.Length;
                        charsleft = 0;
                    }
                    for(int i = 0; i < puffer[1]; i++) {
                        puffer[2 + i] = (byte)chars[readOffset++];
                    }
                    sendHID(puffer);
                }
            } catch(Exception err) {
                MessageBox.Show(err.Message, $"SendUartHid(port={port})");
            }
        }
        void Txt_hid_uart3TxKeyDown(object sender, KeyEventArgs e)
        {
            if(e.KeyCode == Keys.Enter) {
                SendUartHid(3, txt_hid_uart3Tx.Text + "\r");
            }
        }
        void Btn_Usart3_sendSpaceClick(object sender, EventArgs e)
        {
            try {
                byte[] puffer = new byte[ReportOutLen];
                puffer[1] = 15; //send UART3
                puffer[2] = 1; //only one char
                puffer[3] = 32; //char value
                                //send
                sendHID(puffer);
            } catch(Exception err) {
                MessageBox.Show(err.Message, "Grab Fail");
            }
        }
        void CB_RS232_baud_SelectedIndexChanged(object sender, EventArgs e) {
            txt_rs232_baud.Text = CB_RS232_baud.SelectedItem.ToString();
        }

        #endregion

        #region Tab_USB_HID
        void btnUartSetupBaud_Click(object sender, EventArgs e) {
            try {
                UInt32 baud = UInt32.Parse(txt_rs232_baud.Text);
                byte[] puffer = new byte[ReportOutLen];
                puffer[0] = 21;
                if(radUartSetup1.Checked) { puffer[1] = 1; txt_hid_uart1Rx.Text += $"\r\nReinit with Baudrate: {baud}\r\n"; }
                if(radUartSetup3.Checked) { puffer[1] = 3; txt_hid_uart3Rx.Text += $"\r\nReinit with Baudrate: {baud}\r\n"; }
                puffer[2] = (byte)((baud >> 24) & 0xff);
                puffer[3] = (byte)((baud >> 16) & 0xff);
                puffer[4] = (byte)((baud >> 8) & 0xff);
                puffer[5] = (byte)(baud & 0xff);
                //transmission
                sendHID(puffer);

            } catch(Exception ex) {
                MessageBox.Show(ex.Message);
            }
        }
        //Senden
        void Kernel_sendHID(string bytesAsText)
        {
            string[] split = bytesAsText.Replace(',', ' ').Split(' ');
            byte[] puffer = new byte[split.Length];
            for(int i = 0; i < split.Length; i++) {
                if(split[i] != "") {
                    if(split[i].ToLower().Contains("x")) {
                        split[i].Remove(0, 2);
                        long dec = 0;
                        dec = Convert.ToUInt32(split[i], 16);
                        if(dec < 0) { dec = 0; } if(dec > 255) { dec = 255; }
                        puffer[i] = (byte)dec;
                    } else {
                        int value = Int32.Parse(split[i], System.Globalization.NumberStyles.Number);
                        puffer[i] = (byte)Convert.ToByte(value);
                    }
                }
            }
            sendHID(puffer);
        }
        void sendHID(byte[] data) {
            if (_hid == null) { return; }
            try {
                DirectMessage cmd = new DirectMessage(data);
                _hid.SendMessage(cmd);
            }
            catch (Exception err) {
                MessageBox.Show(err.Message, "sendHID Fail");
            }
        }


        void Txt_usb_sendKeyDown(object sender, KeyEventArgs e)
        {
            if(e.KeyData == Keys.Enter) {
                Kernel_sendHID(txt_usb_send.Text);
            }
        }

        //Empfangen
        void HidReportRecived(byte[] data)
        {
            //first check if handled by user control
            bool isHandled = _board.Recived_ByteArray(data);
            if (_board.SetRequestToZero) {
                
                sendHID(new byte[] { 1, 0 });
                _board.SetRequestToZero = false;
            }
            if (isHandled) {
                return; //is handled
            }
            //analogeingang
            switch(data[1]) {
                //case 11: case 12: return; //busy
                //case 52: HidReportRecived_SpiResponse(data); break;
                default:
                    //textausgabe
                    StringBuilder sbDataIn = new StringBuilder();
                    for(int i = 1; i < data.Length; i++) {
                        sbDataIn.Append(data[i].ToString() + " ");
                    }
                    txt_usb_recive.Text = sbDataIn.ToString();
                    break;
            }
            //index + 1 im gegensatz zu µC
            if(false) {
                //int id = 11;
                //int val = data[id] << 8 | data[id + 1]; id += 2;
                //if(val < 4096) { bar_hid_an0.Value = val; }
                //label_Ain0.Text = val.ToString();
                //            val = data[id] << 8 | data[id + 1]; id += 2;
                //            if (val < 4096) { bar_hid_an1.Value = val; }
                //label_Ain1.Text= val.ToString();
                //            val = data[id] << 8 | data[id + 1]; id += 2;
                //            if (val < 4096) { bar_hid_an2.Value = val; }
                //label_Ain2.Text= val.ToString();

                //digital Keys
                //label_HID_key0.BackColor = ((data[2] & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
                //label_HID_key1.BackColor = ((data[2] & 2) == 2) ? Color.LimeGreen : Color.Gainsboro;

                //id = 41;
                //label_I2CBytes.Text = $"{data[id]},{data[id + 1]}";
                //int rawTemp = 0; float TempMultiplier = 0;
                //if(rad_useLM75.Checked) {
                //    rawTemp = data[id] << 1 | data[id + 1] >> 7; //LM75 0.5°C
                //    TempMultiplier = 0.5f;
                //}
                //if(rad_useLM75A.Checked) {
                //    rawTemp = data[id] << 3 | data[id + 1] >> 5; //LM75A 0.125°C
                //    TempMultiplier = 0.125f;
                //}
                //label_I2CRawTemp.Text = rawTemp.ToString();
                //if((rawTemp & 1024) == 1024) {
                //    label_I2CCalcTemp.Text = (0 - (rawTemp * TempMultiplier)).ToString();
                //} else {
                //    label_I2CCalcTemp.Text = (rawTemp * TempMultiplier).ToString();
                //}
                //id = 61;
                //val = data[id] << 8 | data[id + 1]; id += 2;

            }
            //Uart1 Rx
            if(_board.LastModeGet == Mode_Get.Uart1Rx) {
                sendHID(new byte[] { 1, 1 });
                int menge = data[2];
                for(int i = 0; i < menge; i++) {
                    txt_hid_uart1Rx.Text += (char)data[3 + i];
                }
                return;
            }
            //Uart3 Rx
            if(_board.LastModeGet == Mode_Get.Uart3Rx) {
                sendHID(new byte[] { 1, 1 });
                int menge = data[2];
                for(int i = 0; i < menge; i++) {
                    txt_hid_uart3Rx.Text += (char)data[3 + i];
                }
                txt_hid_uart3Rx.SelectionStart = txt_hid_uart3Rx.Text.Length - 1;
                txt_hid_uart3Rx.ScrollToCaret();
                return;
            }

        }
        //Events
        public void OnEventReportRecieved(byte[] Data) {
            if(InvokeRequired) {
                try {
                    Invoke(new Action<byte[]>(OnEventReportRecieved), new object[] { Data });
                } catch(Exception) {
                }
                return;
            }
            try {
                HidReportRecived(Data);
            }
            catch (Exception ex) {
                txt_usb_recive.Text = "Error: " + ex.Message;

                sendHID(new byte[] { 5, 0 });
            }
        }
        public void OnEventDeviceRemoved() {
            if(InvokeRequired) {
                try {
                    Invoke(new Action(OnEventDeviceRemoved), null);
                } catch(Exception) {
                }
                return;
            }
            //txt_deviceString.BackColor = Color.Red;
        }

        #endregion

        #region Tab_Direct
        //ID
        void btn_GetBoardInformations_Click(object sender, EventArgs e) {
            try {
                uC_PinMap1.RefreshBoardInfo(chk_ReadGpio.Checked);
            }
            catch (Exception ex) {
                uC_PinMap1.AddToLog("Ex: " + ex.Message);
            }
        }
        void btn_Adc_ReadAll_Click(object sender, EventArgs e) {
            try {
                uC_ADC1.AdcReadDynamic();
            }
            catch (Exception ex) {
                //LogRs232_AppedTextOnly("btn_Adc_ReadAll_Click:" + ex.Message, Color.Fuchsia);
                uC_PinMap1.AddToLog("Ex: " + ex.Message);
            }
        }


        #endregion


        void btnMotorLeft_Click(object sender, EventArgs e)
        {
            DoStepperMotorDrive(1, 1);
        }
        void BtnMotorRight_Click(object sender, EventArgs e)
        {
            DoStepperMotorDrive(0, 1);
        }
        void btnMotorUp_Click(object sender, EventArgs e)
        {
            DoStepperMotorDrive(1, 2);
        }
        void btnMotorDown_Click(object sender, EventArgs e)
        {
            DoStepperMotorDrive(0, 2);
        }
        void DoStepperMotorDrive(byte direction, byte motor) {
            try {
                ushort steps = ushort.Parse(txtMotorSteps.Text);
                ushort speed = 0;
                if(radMotorSpeed1.Checked) { speed = ushort.Parse(txtMotorSpeed1.Text); }
                if(radMotorSpeed2.Checked) { speed = ushort.Parse(txtMotorSpeed2.Text); }
                byte[] puffer = new byte[ReportOutLen];
                puffer[1] = 22;
                puffer[2] = motor;
                puffer[3] = direction;
                puffer[4] = (byte)(steps & 0xff);
                puffer[5] = (byte)((steps >> 8) & 0xff);
                puffer[6] = (byte)(speed & 0xff);
                puffer[7] = (byte)((speed >> 8) & 0xff);
                //transmission
                sendHID(puffer);

            } catch(Exception ex) {
                MessageBox.Show(ex.Message);
            }
        }




        void btnLoadScript_Click(object sender, EventArgs e)
        {
            string path = Application.StartupPath + "\\scripts";
            if(!Directory.Exists(path)) {
                Directory.CreateDirectory(path);
            }
            openFileDialog1.InitialDirectory = path;
            if(DialogResult.OK != openFileDialog1.ShowDialog()) { return; }

            try {
                txtScriptFilename.Text = Path.GetFileName(openFileDialog1.FileName);
                StreamReader txt = new StreamReader(openFileDialog1.FileName);
                txtScriptContent.Text = txt.ReadToEnd();
                txt.Close();
                ParseScript(false);
            } catch(Exception ex) {
                txtScriptContent.Text = $"Exception: {ex.Message}";
                MessageBox.Show(ex.Message, "script exception");
            }
        }
        bool _scrptStop = false;
        void btnScriptStop_Click(object sender, EventArgs e)
        {
            _scrptStop = true;
        }

        void btnScriptRun_Click(object sender, EventArgs e)
        {
            btnScriptRun.BackColor = Color.LimeGreen;
            btnScriptRun.Refresh();
            RunScript();
            //Task<int> x = RunScript();
            //int result = await x;
            btnScriptRun.BackColor = Color.Gainsboro;
            btnScriptRun.Refresh();

        }

        void RunScript()
        {
            try {
                txtScriptLog.Text = "";
                AddScriptLog("Start script");
                long startTics = DateTime.Now.Ticks;
                ParseScript(true);
                AddScriptLog("End script");
                TimeSpan timeSpan = new TimeSpan(DateTime.Now.Ticks - startTics);
                //AddScriptLog($"Total Timespan {String.Format("{0:HH:mm:ss}", timeSpan)}");
                AddScriptLog($"Total Timespan TotalSeconds {timeSpan.TotalSeconds}");

            } catch(Exception ex) {
                txtScriptLog.Text += $"\r\nException: {ex.Message}";
                btnScriptRun.BackColor = Color.Red;
                btnScriptRun.Refresh();
                MessageBox.Show(ex.Message, "script exception");
            }
        }
        void ParseScript(bool isExecute) {
            StringBuilder sbProblems = new StringBuilder();
            try {
                _scrptStop = false;
                string[] lines = txtScriptContent.Lines;
                string info = "";
                for(int i = 0; i < lines.Length; i++) {
                    if(lines[i].Length < 3) { continue; }
                    //filter comments
                    int commentMarker = lines[i].IndexOf('#');
                    if(commentMarker < 0) { commentMarker = lines[i].Length; }
                    string line = lines[i].Substring(0, commentMarker);
                    if(line.Length < 3) { continue; }
                    string[] subsplits = line.Split(':');
                    if(subsplits.Length != 2) {
                        info = $"line[{i}] syntax error, need only one ':' for <cmd>:<parameter>, line value: {line}";
                        if(isExecute) { AddScriptLog(info); } else { sbProblems.Append("\r\n" + info); }
                        continue;
                    }
                    switch(subsplits[0]) {
                        // begin script commands ######################################
                        case "MSGBOX": ScriptCmd_MSGBOX(subsplits[1], isExecute); break;
                        case "SLEEP": ScriptCmd_SLEEP(subsplits[1], isExecute); break;
                        case "SPITARGET": ScriptCmd_SPITARGET(subsplits[1], isExecute); break;
                        case "SENDUART1": ScriptCmd_SENDUART(1, subsplits[1], isExecute); break;
                        case "SENDUART3": ScriptCmd_SENDUART(3, subsplits[1], isExecute); break;
                        case "SPI8": ScriptCmd_SPI8(subsplits[1], isExecute); break;
                        case "SPI16": ScriptCmd_SPI16(subsplits[1], isExecute); break;
                        case "SPI32": ScriptCmd_SPI32(subsplits[1], isExecute); break;
                        // end script commands ######################################
                        default:
                            info = $"line[{i}] unknown command, line value: {subsplits[0]}";
                            if(isExecute) { AddScriptLog(info); } else { sbProblems.Append("\r\n" + info); }
                            break;
                    }
                    Application.DoEvents();
                    if(_scrptStop) {
                        AddScriptLog($"User request to stop script...");
                        return;
                    }
                }
            } catch(Exception ex) {
                if(!isExecute) {
                    sbProblems.Append($"\r\nException: {ex.Message}");
                } else {
                    throw ex;
                }
            }
            if(!isExecute) {
                if(sbProblems.Length == 0) { return; }
                MessageBox.Show(sbProblems.ToString(),"Script problems detected");
            }
        }
        void ScriptCmd_MSGBOX(string parameter, bool isExecute) {
            if(!isExecute) { return; }
            AddScriptLog($"MessageBox({parameter})");

            DialogResult result = MessageBox.Show(parameter + "\r\nContinue with Script?", "Script popup message", MessageBoxButtons.YesNo);
            if(result != DialogResult.Yes) {
                _scrptStop = true;
            }
        }
        void ScriptCmd_SLEEP(string parameter, bool isExecute) {
            if(!isExecute) { return; }
            int value = 0;
            AddScriptLog($"Sleep({parameter})");

            if(!int.TryParse(parameter,out value)) {
                throw new Exception($"cannot parse '{parameter}' to an int.");
            }
            Thread.Sleep(value);
        }
        void ScriptCmd_SENDUART(int uart,string parameter, bool isExecute)
        {
            if(!isExecute) { return; }
            //int value = 0;
            AddScriptLog($"SendUart(port={uart}):{parameter}");
            if(uart != 1 && uart != 3) {
                throw new Exception("Uart ports have to be 1 or 3.");
            }
            switch(uart) {
                case 1: SendUartHid(1, parameter); break;
                case 3: SendUartHid(3, parameter); break;
                default:
                    throw new Exception("Uart ports have to be 1 or 3.");
            }
        }
        void ScriptCmd_SPITARGET(string parameter, bool isExecute) {
            if(!isExecute) { return; }
            AddScriptLog($"SpiTarget({parameter})");
            uC_SPI1.SetSpiTarget(parameter);
        }
        void ScriptCmd_SPI8(string parameter, bool isExecute) {
            if(!isExecute) { return; }
            int dtype = 0;
            if(parameter.StartsWith("DEC|")) { dtype = 1; }
            if(parameter.StartsWith("HEX|")) { dtype = 2; }
            if(dtype == 0) {
                throw new Exception($"Spi8({parameter})->Datatype not defined, need 'DEC|' or 'HEX|'.");
            }
            
            //Build and perform Transmission
            string[] splits = parameter.Remove(0,4).TrimEnd().Split(',');
            byte[] tx = new byte[splits.Length];

            StringBuilder sbDataIn = new StringBuilder();
            if(dtype == 1) {
                for(int i = 0; i < tx.Length; i++) {
                    if(!byte.TryParse(splits[i], out tx[i])) {
                        throw new Exception($"Can't parse '{splits[i]}' to a byte");
                    }
                    sbDataIn.Append($"{tx[i]},");
                }
            }
            if(dtype == 2) {
                for(int i = 0; i < tx.Length; i++) {
                    if(!byte.TryParse(splits[i], System.Globalization.NumberStyles.HexNumber, null, out tx[i])) {
                        throw new Exception($"Can't parse '{splits[i]}' to a byte");
                    }
                    sbDataIn.Append($"{tx[i].ToString("X02")},");
                }
            }
            int target = uC_SPI1.SpiTarget;
            byte[] rx = _board.TransmissionSpi8(target, tx.Length, tx);
            if(rx == null) { AddScriptLog($"Spi8({parameter}):{sbDataIn.ToString()} -> null (transmission error)"); return; }

            StringBuilder sbDataOut = new StringBuilder();
            if(dtype == 1) {
                for(int i = 0; i < rx.Length; i++) {
                    sbDataOut.Append($"{rx[i]},");
                }
            }
            if(dtype == 2) {
                for(int i = 0; i < rx.Length; i++) {
                    sbDataOut.Append($"{rx[i].ToString("X02")},");
                }
            }
            AddScriptLog($"Spi8({parameter.Substring(0,3)}): {sbDataIn.ToString()} -> {sbDataOut.ToString()}");
        }
        void ScriptCmd_SPI16(string parameter, bool isExecute) {
            if(!isExecute) { return; }
            int dtype = 0;
            if(parameter.StartsWith("DEC|")) { dtype = 1; }
            if(parameter.StartsWith("HEX|")) { dtype = 2; }
            if(dtype == 0) {
                throw new Exception($"Spi16({parameter})->Datatype not defined, need 'DEC|' or 'HEX|'.");
            }
            
            //Build and perform Transmission
            string[] splits = parameter.Remove(0,4).TrimEnd().Split(',');
            ushort[] tx = new ushort[splits.Length];

            StringBuilder sbDataIn = new StringBuilder();
            if(dtype == 1) {
                for(int i = 0; i < tx.Length; i++) {
                    if(!ushort.TryParse(splits[i], out tx[i])) {
                        throw new Exception($"Can't parse '{splits[i]}' to a ushort");
                    }
                    sbDataIn.Append($"{tx[i]},");
                }
            }
            if(dtype == 2) {
                for(int i = 0; i < tx.Length; i++) {
                    if(!ushort.TryParse(splits[i], System.Globalization.NumberStyles.HexNumber, null, out tx[i])) {
                        throw new Exception($"Can't parse '{splits[i]}' to a ushort");
                    }
                    sbDataIn.Append($"{tx[i].ToString("X04")},");
                }
            }
            int target = uC_SPI1.SpiTarget;
            ushort[] rx = _board.TransmissionSpi16(target, tx.Length, tx);
            if(rx == null) { AddScriptLog($"Spi16({parameter}): {sbDataIn.ToString()} -> null (transmission error)"); return; }

            StringBuilder sbDataOut = new StringBuilder();
            if(dtype == 1) {
                for(int i = 0; i < rx.Length; i++) {
                    sbDataOut.Append($"{rx[i]},");
                }
            }
            if(dtype == 2) {
                for(int i = 0; i < rx.Length; i++) {
                    sbDataOut.Append($"{rx[i].ToString("X04")},");
                }
            }
            AddScriptLog($"Spi16({parameter.Substring(0,3)}): {sbDataIn.ToString()} -> {sbDataOut.ToString()}");
        }
        void ScriptCmd_SPI32(string parameter, bool isExecute)
        {
            if(!isExecute) { return; }
            int dtype = 0;
            if(parameter.StartsWith("DEC|")) { dtype = 1; }
            if(parameter.StartsWith("HEX|")) { dtype = 2; }
            if(dtype == 0) {
                throw new Exception($"Spi32({parameter})->Datatype not defined, need 'DEC|' or 'HEX|'.");
            }

            //Build and perform Transmission
            string[] splits = parameter.Remove(0, 4).TrimEnd().Split(',');
            UInt32[] tx = new UInt32[splits.Length];

            StringBuilder sbDataIn = new StringBuilder();
            if(dtype == 1) {
                for(int i = 0; i < tx.Length; i++) {
                    if(!UInt32.TryParse(splits[i], out tx[i])) {
                        throw new Exception($"Can't parse '{splits[i]}' to a UInt32");
                    }
                    sbDataIn.Append($"{tx[i]},");
                }
            }
            if(dtype == 2) {
                for(int i = 0; i < tx.Length; i++) {
                    if(!UInt32.TryParse(splits[i], System.Globalization.NumberStyles.HexNumber, null, out tx[i])) {
                        throw new Exception($"Can't parse '{splits[i]}' to a UInt32");
                    }
                    sbDataIn.Append($"{tx[i].ToString("X08")},");
                }
            }
            int target = uC_SPI1.SpiTarget;
            UInt32[] rx = _board.TransmissionSpi32(target, tx.Length, tx);
            if(rx == null) { AddScriptLog($"Spi32({parameter}): {sbDataIn.ToString()} -> null (transmission error)"); return; }

            StringBuilder sbDataOut = new StringBuilder();
            if(dtype == 1) {
                for(int i = 0; i < rx.Length; i++) {
                    sbDataOut.Append($"{rx[i]},");
                }
            }
            if(dtype == 2) {
                for(int i = 0; i < rx.Length; i++) {
                    sbDataOut.Append($"{rx[i].ToString("X08")},");
                }
            }
            AddScriptLog($"Spi32({parameter.Substring(0, 3)}): {sbDataIn.ToString()} -> {sbDataOut.ToString()}");
        }


        void AddScriptLog(string info) {
            txtScriptLog.Text += String.Format("{0:HH:mm:ss}", DateTime.Now) + $"\t{info}\r\n";
            txtScriptLog.Refresh();
        }

        

        void btn_hid_refreshDevices_Click(object sender, EventArgs e) {
            RefreshHidDevices();
        }

        void dgv_HidDevices_CellContentClick(object sender, DataGridViewCellEventArgs e) {
            if (e.RowIndex<0) {
                return;
            }
            if (e.ColumnIndex == 3) {
                //Key
                HidDeviceConnect(dgv_HidDevices.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString(), 
                    dgv_HidDevices.Rows[e.RowIndex].Cells[2].Value.ToString());
            }
        }

        void chk_hid_autoCheckForDevices_CheckedChanged(object sender, EventArgs e) {
            timer_SearchDevices.Enabled = chk_hid_autoCheckForDevices.Checked;
        }
        void timer_SearchDevices_Tick(object sender, EventArgs e) {
            RefreshHidDevices();
        }
    }
}
