﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace MiniStm32JoeC_CoreLibrary.Views {
    public partial class UC_SPI : UserControl {
        MiniStm32BoardJoeC _board;
        public int SpiTarget = 0;
        public UC_SPI() {
            InitializeComponent();
        }
        public void Init(MiniStm32BoardJoeC miniStm32) {
            _board = miniStm32;

            cb_hid_Spi1_ConfSpeed.SelectedIndex = 5;
            cb_hid_Spi_Port.SelectedIndex = 1;
            cb_hid_Spi_Mode.SelectedIndex = 0;
            txt_hid_Spi1_ConfWaitTeiler.Text = (7.9521).ToString();
        }
        bool _closing = false;
        public void Close() {
            _closing = true;
        }
        void WaitforBusy(int timeoutInSeconds) {
            DateTime dtTimeout = DateTime.Now.AddSeconds(timeoutInSeconds);
            while (_board.IsBusy) {
                if (DateTime.Now.Ticks > dtTimeout.Ticks) {
                    throw new Exception($"WaitforBusy timeout after '{timeoutInSeconds}'");
                }
                Application.DoEvents();
                System.Threading.Thread.Sleep(10);
            }
        }

        void lb_Cs_xAll_MouseDown(object sender, MouseEventArgs e) {
            SpiTarget = 0;
            //toggle state
            Label lbl = (sender as Label);
            if (lbl.BackColor == Color.Gainsboro) {
                lbl.BackColor = Color.LimeGreen;
            } else {
                lbl.BackColor = Color.Gainsboro;
            }
            lbl.Refresh();

            //read
            if (lb_Cs_0.BackColor == Color.LimeGreen) { SpiTarget += 1; }
            if (lb_Cs_1.BackColor == Color.LimeGreen) { SpiTarget += 2; }
            if (lb_Cs_2.BackColor == Color.LimeGreen) { SpiTarget += 4; }
            if (lb_Cs_3.BackColor == Color.LimeGreen) { SpiTarget += 8; }
            if (lb_Cs_4.BackColor == Color.LimeGreen) { SpiTarget += 16; }
            if (lb_Cs_5.BackColor == Color.LimeGreen) { SpiTarget += 32; }
            if (lb_Cs_6.BackColor == Color.LimeGreen) { SpiTarget += 64; }
            if (lb_Cs_7.BackColor == Color.LimeGreen) { SpiTarget += 128; }
            txt_hid_Spi1TxTarget.Text = SpiTarget.ToString();
        }
        void txt_hid_Spi1TxTarget_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            try {
                SetSpiTarget(txt_hid_Spi1TxTarget.Text);
                txt_hid_Spi1TxTarget.BackColor = Color.White;
            }
            catch (Exception) {
                txt_hid_Spi1TxTarget.BackColor = Color.Salmon;
            }
        }
        public void SetSpiTarget(string target) {
            int targetValue = int.Parse(target);
            lb_Cs_0.BackColor = ((targetValue & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_1.BackColor = ((targetValue >> 1 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_2.BackColor = ((targetValue >> 2 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_3.BackColor = ((targetValue >> 3 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_4.BackColor = ((targetValue >> 4 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_5.BackColor = ((targetValue >> 5 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_6.BackColor = ((targetValue >> 6 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            lb_Cs_7.BackColor = ((targetValue >> 7 & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
            SpiTarget = targetValue;
        }
        void btn_Cs_WriteSetup_Click(object sender, EventArgs e) {
            try {
                List<string> pins = new List<string>();
                int PinCnt = (int)num_Cs_UsedPins.Value;
                for (int i = 0; i < PinCnt; i++) {
                    string pinNr = "-";
                    switch (i) {
                        case 0: pinNr = txt_CsPin_0.Text; break;
                        case 1: pinNr = txt_CsPin_1.Text; break;
                        case 2: pinNr = txt_CsPin_2.Text; break;
                        case 3: pinNr = txt_CsPin_3.Text; break;
                        case 4: pinNr = txt_CsPin_4.Text; break;
                        case 5: pinNr = txt_CsPin_5.Text; break;
                        case 6: pinNr = txt_CsPin_6.Text; break;
                        case 7: pinNr = txt_CsPin_7.Text; break;
                    }
                    PinInfo pininfo = new PinInfo(pinNr);
                    pins.Add(pininfo.PinCfg);
                }
                _board.SetSpiCsPinLine(pins.ToArray());
            } catch (Exception ex) {
                txt_hid_Spi1Rx.Text += "Ex: " + ex.Message;
            }

        }
        void chk_CsSetup_CheckedChanged(object sender, EventArgs e) {
            groupBox_CsSetup.Visible = chk_CsSetup.Checked;
            if (groupBox_CsSetup.Visible) {
                tabControl_SPI.SelectedIndex = 0;
            }
        }

        void Txt_hid_Spi1TxArray8_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            try {
                WaitforBusy(3);
                _board.IsBusy = true;
                int target = int.Parse(txt_hid_Spi1TxTarget.Text);

                //Build and perform Transmission
                string[] splits = txt_hid_Spi1TxArray8.Text.TrimEnd().Split(' ');
                byte[] tx = new byte[splits.Length];

                StringBuilder sbDataIn = new StringBuilder();
                sbDataIn.Append("Tx8: ");
                for (int i = 0; i < tx.Length; i++) {
                    if (!byte.TryParse(splits[i], System.Globalization.NumberStyles.HexNumber, null, out tx[i])) {
                        throw new Exception($"Can't parse '{splits[i]}' to a byte");
                    }
                    sbDataIn.Append($"{tx[i].ToString("X02")} ");
                }

                txt_hid_Spi1Rx.Text += $"{sbDataIn.ToString()} -> ";
                byte[] rx = _board.TransmissionSpi8(target, tx.Length, tx);
                if (rx == null) { txt_hid_Spi1Rx.Text += "<NULL>\r\n"; return; }

                sbDataIn = new StringBuilder();
                for (int i = 0; i < rx.Length; i++) {
                    sbDataIn.Append($"{rx[i].ToString("X02")} ");
                }
                txt_hid_Spi1Rx.Text += $"{sbDataIn.ToString()}\r\n";
            }
            catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                txt_hid_Spi1Rx.Text += $"Error: {ex.Message}\r\n";
            }
            _board.IsBusy = false;
        }
        void Txt_hid_Spi1TxArray16_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            try {
                WaitforBusy(3);
                _board.IsBusy = true;
                int target = int.Parse(txt_hid_Spi1TxTarget.Text);

                //Build and perform Transmission
                string[] splits = txt_hid_Spi1TxArray16.Text.TrimEnd().Split(' ');
                ushort[] tx = new ushort[splits.Length];

                StringBuilder sbDataIn = new StringBuilder();
                sbDataIn.Append("Tx16: ");
                for (int i = 0; i < tx.Length; i++) {
                    if (!ushort.TryParse(splits[i], System.Globalization.NumberStyles.HexNumber, null, out tx[i])) {
                        throw new Exception($"Can't parse '{splits[i]}' to a ushort");
                    }
                    sbDataIn.Append($"{tx[i].ToString("X04")} ");
                }

                txt_hid_Spi1Rx.Text += $"{sbDataIn.ToString()} -> ";
                ushort[] rx = _board.TransmissionSpi16(target, tx.Length, tx);
                if (rx == null) { txt_hid_Spi1Rx.Text += "<NULL>\r\n"; return; }

                sbDataIn = new StringBuilder();
                for (int i = 0; i < rx.Length; i++) {
                    sbDataIn.Append($"{rx[i].ToString("X04")} ");
                }
                txt_hid_Spi1Rx.Text += $"{sbDataIn.ToString()}\r\n";
            }
            catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                txt_hid_Spi1Rx.Text += $"Error: {ex.Message}\r\n";
            }
            _board.IsBusy = false;
        }
        void Txt_hid_Spi1TxArray32_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            try {
                WaitforBusy(3);
                _board.IsBusy = true;
                int target = int.Parse(txt_hid_Spi1TxTarget.Text);

                //Build and perform Transmission
                string[] splits = txt_hid_Spi1TxArray32.Text.TrimEnd().Split(' ');
                UInt32[] tx = new UInt32[splits.Length];

                StringBuilder sbDataIn = new StringBuilder();
                sbDataIn.Append("Tx32: ");
                for (int i = 0; i < tx.Length; i++) {
                    if (!UInt32.TryParse(splits[i], System.Globalization.NumberStyles.HexNumber, null, out tx[i])) {
                        throw new Exception($"Can't parse '{splits[i]}' to a UInt32");
                    }
                    sbDataIn.Append($"{tx[i].ToString("X08")} ");
                }

                txt_hid_Spi1Rx.Text += $"{sbDataIn.ToString()} -> ";
                UInt32[] rx = _board.TransmissionSpi32(target, tx.Length, tx);
                if (rx == null) { txt_hid_Spi1Rx.Text += "<NULL>\r\n"; return; }

                sbDataIn = new StringBuilder();
                for (int i = 0; i < rx.Length; i++) {
                    sbDataIn.Append($"{rx[i].ToString("X08")} ");
                }
                txt_hid_Spi1Rx.Text += $"{sbDataIn.ToString()}\r\n";
            }
            catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                txt_hid_Spi1Rx.Text += $"Error: {ex.Message}\r\n";
            }
            _board.IsBusy = false;
        }
        void btn_hid_Spi1_ConfWrite_Click(object sender, EventArgs e) {
            try {
                WaitforBusy(3);
                _board.IsBusy = true;
                byte spiPort = (byte)(cb_hid_Spi_Port.SelectedIndex + 1);
                byte mode = 0;
                string modeStr = cb_hid_Spi_Mode.SelectedItem.ToString().Split('_')[0];
                mode = byte.Parse(modeStr);
                byte bits = 8;
                if (rad_hid_Spi1_ConfBits8.Checked) { bits = 8; }
                if (rad_hid_Spi1_ConfBits16.Checked) { bits = 16; }
                ushort wait = 0;
                if (chk_hid_Spi1_ConfWait.Checked) {
                    double waituS = double.Parse(txt_hid_Spi1_ConfWait.Text);
                    double teiler = double.Parse(txt_hid_Spi1_ConfWaitTeiler.Text);
                    wait = (ushort)Math.Round((waituS * teiler), 0);
                }

                //transmission
                _board.SetSpiConfig(spiPort, mode, bits, (byte)cb_hid_Spi1_ConfSpeed.SelectedIndex, wait);
                txt_hid_Spi1Rx.Text += $"Write Spi1Config: spiPort={spiPort} Mode={mode} Bits={bits} Speed={cb_hid_Spi1_ConfSpeed.SelectedIndex} WaitAfterBlock_µS={wait}\r\n";
                _board.IsBusy = false;
            }
            catch (Exception err) {
                _board.IsBusy = false;
                if (_closing) { return; }
                MessageBox.Show(err.Message, "Write Spi config Fail");
            }
        }
        void btn_hid_Spi1_off_Click(object sender, EventArgs e) {
            try {
                WaitforBusy(3);
                _board.IsBusy = true;
                //transmission
                _board.SetSpiConfig(0, 255, 0, 0, 0);
                txt_hid_Spi1Rx.Text += $"Write Spi1Config: OFF\r\n";
                _board.IsBusy = false;
            }
            catch (Exception err) {
                _board.IsBusy = false;
                if (_closing) { return; }
                MessageBox.Show(err.Message, "Write Spi config Fail");
            }
        }

        void cb_hid_Spi1_ConfSpeed_SelectedIndexChanged(object sender, EventArgs e) {
            try {
                double prescale = double.Parse(cb_hid_Spi1_ConfSpeed.SelectedItem.ToString());
                double speed = 72 / prescale;
                if (cb_hid_Spi_Port.SelectedIndex == 1) {
                    speed = 36 / prescale;
                }
                txt_hid_Spi1_ConfSpeed.Text = Math.Round(speed, 3).ToString() + " MHz";
            }
            catch (Exception ex) {
                txt_hid_Spi1_ConfSpeed.Text = "Ex: " + ex.Message;
            }
        }
        void cb_hid_Spi_Port_SelectedIndexChanged(object sender, EventArgs e) {
            cb_hid_Spi1_ConfSpeed_SelectedIndexChanged(sender, e);
        }
        //Tab Table8
        void txtSpiMasterTransData8_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            try {
                WaitforBusy(3);
                _board.IsBusy = true;
                int cnt = 0;
                if (int.TryParse(txtSpiTransCnt8.Text, out cnt)) {
                    txtSpiTransCnt8.BackColor = Color.White;
                }
                else {
                    txtSpiTransCnt8.BackColor = Color.Salmon;
                    return;
                }
                string targetStr = txt_hid_Spi1TxTarget.Text;
                int target = int.Parse(targetStr);
                int BaseRowID = CommonPrepareTable(DGVSpiTrans8, 8, cnt, targetStr);

                //Build and perform Transmission
                string[] splits = txtSpiMasterTransData8.Text.TrimEnd().Split(' ');
                byte[] tx = new byte[splits.Length];

                for (int i = 0; i < cnt; i++) {
                    if (i >= splits.Length) {
                        DGVSpiTrans8.Rows[BaseRowID].Cells[i + 2].Value = 0;
                        continue;
                    }
                    //convert Hex to decimal for transfer
                    long dec = 0;
                    dec = Convert.ToUInt32(splits[i], 16);

                    DGVSpiTrans8.Rows[BaseRowID].Cells[i + 2].Value = dec.ToString("x02");
                    if (i < tx.Length) {
                        tx[i] = (byte)dec;
                    }

                }

                byte[] rx = _board.TransmissionSpi8(target, cnt, tx);
                if (rx == null) { return; }

                //DGVSpiMasterTransmission.Refresh();
                for (int i = 0; i < rx.Length; i++) {
                    //convert Hex to decimal for transfer
                    if (DGVSpiTrans8.Rows[0].Cells.Count - 1 == i) {
                        break;
                    }
                    DataGridViewRow R = DGVSpiTrans8.Rows[BaseRowID + 1];
                    R.Cells[i + 2].Value = rx[i].ToString("X02");

                    if (tx.Length <= i) { continue; }
                    if (chkSpicolorLoopback.Checked) {
                        if (rx[i] == tx[i] && (rx[i] != 0) && (rx[i] != 0xff)) {
                            R.Cells[i + 2].Style.BackColor = Color.Yellow;
                        }
                    }
                }
                DGVSpiTrans8.FirstDisplayedScrollingRowIndex = BaseRowID;
                _board.IsBusy = false;
            }
            catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                MessageBox.Show(ex.Message, "Exeption SPI_8 Transmission");
            }
        }
        void btnSpiMasterTransClear8_Click(object sender, EventArgs e) {
            CommonClearTable(DGVSpiTrans8);
        }
        //Tab Table16
        void txtSpiMasterTransData16_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            try {
                WaitforBusy(3);
                _board.IsBusy = true;
                int cnt = 0;
                if (int.TryParse(txtSpiTransCnt16.Text, out cnt)) {
                    txtSpiTransCnt16.BackColor = Color.White;
                }
                else {
                    txtSpiTransCnt16.BackColor = Color.Salmon;
                    return;
                }
                string targetStr = txt_hid_Spi1TxTarget.Text;
                int target = int.Parse(targetStr);
                int BaseRowID = CommonPrepareTable(DGVSpiTrans16, 16, cnt, targetStr);

                //Build and perform Transmission
                string[] splits = txtSpiMasterTransData16.Text.TrimEnd().Split(' ');
                ushort[] tx = new ushort[splits.Length];

                for (int i = 0; i < cnt; i++) {
                    if (i >= splits.Length) {
                        DGVSpiTrans16.Rows[BaseRowID].Cells[i + 2].Value = 0;
                        continue;
                    }
                    //convert Hex to decimal for transfer
                    long dec = 0;
                    dec = Convert.ToUInt32(splits[i], 16);

                    DGVSpiTrans16.Rows[BaseRowID].Cells[i + 2].Value = dec.ToString("x04");
                    if (i < tx.Length) {
                        tx[i] = (ushort)dec;
                    }

                }

                ushort[] rx = _board.TransmissionSpi16(target, cnt, tx);
                if (rx == null) { return; }

                //DGVSpiMasterTransmission.Refresh();
                for (int i = 0; i < rx.Length; i++) {
                    //convert Hex to decimal for transfer
                    if (DGVSpiTrans16.Rows[0].Cells.Count - 1 == i) {
                        break;
                    }
                    DataGridViewRow R = DGVSpiTrans16.Rows[BaseRowID + 1];
                    R.Cells[i + 2].Value = rx[i].ToString("X04");

                    if (tx.Length <= i) { continue; }
                    if (chkSpicolorLoopback.Checked) {
                        if (rx[i] == tx[i] && (rx[i] != 0) && (rx[i] != 0xffff)) {
                            R.Cells[i + 2].Style.BackColor = Color.Yellow;
                        }
                    }
                }
                DGVSpiTrans16.FirstDisplayedScrollingRowIndex = BaseRowID;
                _board.IsBusy = false;
            }
            catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                MessageBox.Show(ex.Message, "Exeption SPI_16 Transmission");
            }
        }
        void btnSpiMasterTransClear16_Click(object sender, EventArgs e) {
            CommonClearTable(DGVSpiTrans16);
        }
        //Tab Table32
        void txtSpiMasterTransData32_KeyDown(object sender, KeyEventArgs e) {
            if (e.KeyCode != Keys.Enter) { return; }
            e.SuppressKeyPress = true; //no more 'DING' sound
            try {
                WaitforBusy(3);
                _board.IsBusy = true;
                int cnt = 0;
                if (int.TryParse(txtSpiTransCnt32.Text, out cnt)) {
                    txtSpiTransCnt32.BackColor = Color.White;
                }
                else {
                    txtSpiTransCnt32.BackColor = Color.Salmon;
                    return;
                }
                string targetStr = txt_hid_Spi1TxTarget.Text;
                int target = int.Parse(targetStr);
                int BaseRowID = CommonPrepareTable(DGVSpiTrans32, 32, cnt, targetStr);

                //Build and perform Transmission
                string[] splits = txtSpiMasterTransData32.Text.TrimEnd().Split(' ');
                UInt32[] tx = new UInt32[splits.Length];

                for (int i = 0; i < cnt; i++) {
                    if (i >= splits.Length) {
                        DGVSpiTrans32.Rows[BaseRowID].Cells[i + 2].Value = 0;
                        continue;
                    }
                    //convert Hex to decimal for transfer
                    long dec = 0;
                    dec = Convert.ToUInt32(splits[i], 16);

                    DGVSpiTrans32.Rows[BaseRowID].Cells[i + 2].Value = dec.ToString("x08");
                    if (i < tx.Length) {
                        tx[i] = (UInt32)dec;
                    }

                }
                UInt32[] rx = _board.TransmissionSpi32(target, cnt, tx);
                if (rx == null) { return; }

                //DGVSpiMasterTransmission.Refresh();
                for (int i = 0; i < rx.Length; i++) {
                    //convert Hex to decimal for transfer
                    if (DGVSpiTrans32.Rows[0].Cells.Count - 1 == i) {
                        break;
                    }
                    DataGridViewRow R = DGVSpiTrans32.Rows[BaseRowID + 1];
                    R.Cells[i + 2].Value = rx[i].ToString("X08");

                    if (tx.Length <= i) { continue; }
                    if (chkSpicolorLoopback.Checked) {
                        if (rx[i] == tx[i] && (rx[i] != 0) && (rx[i] != 0xffffffff)) {
                            R.Cells[i + 2].Style.BackColor = Color.Yellow;
                        }
                    }
                }
                DGVSpiTrans32.FirstDisplayedScrollingRowIndex = BaseRowID;
                _board.IsBusy = false;
            }
            catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                MessageBox.Show(ex.Message, "Exeption SPI_32 Transmission");
            }
        }

        void btnSpiMasterTransClear32_Click(object sender, EventArgs e) {
            CommonClearTable(DGVSpiTrans32);
        }

        //common for all tables
        void CommonClearTable(DataGridView dgv) {
            dgv.Rows.Clear();
            dgv.Columns.Clear();
        }
        int CommonPrepareTable(DataGridView dgv, int transmissionLength, int cnt, string target) {
            if (dgv.Columns.Count == 0) {
                dgv.Rows.Clear();
                dgv.Columns.Clear();

                //Build default table columns
                dgv.Columns.Add("Dir", "Direction");
                dgv.Columns.Add("tar", "Target");
                dgv.Columns[1].Width = 40;
                dgv.Columns[1].CellTemplate.Style.Alignment = DataGridViewContentAlignment.MiddleCenter;
                for (int i = 0; i < cnt; i++) {
                    DataGridViewTextBoxColumn TBC = new DataGridViewTextBoxColumn();
                    TBC.Name = "Block" + i.ToString();
                    TBC.HeaderText = i.ToString();
                    TBC.AutoSizeMode = DataGridViewAutoSizeColumnMode.None;
                    switch (transmissionLength) {
                        case 8: TBC.Width = 22; break;
                        case 16: TBC.Width = 33; break;
                        case 32: TBC.Width = 52; break;
                    }

                    dgv.Columns.Add(TBC);
                }
            }
            else {
                if (dgv.Columns.Count < cnt + 2) {
                    int start = dgv.Columns.Count - 2;
                    for (int i = start; i < cnt; i++) {
                        DataGridViewTextBoxColumn TBC = new DataGridViewTextBoxColumn();
                        TBC.Name = "Block" + i.ToString();
                        TBC.HeaderText = i.ToString();
                        TBC.AutoSizeMode = DataGridViewAutoSizeColumnMode.None;
                        switch (transmissionLength) {
                            case 8: TBC.Width = 22; break;
                            case 16: TBC.Width = 33; break;
                            case 32: TBC.Width = 52; break;
                        }
                        dgv.Columns.Add(TBC);
                    }
                }
            }
            //Build default table rows
            int Retry = dgv.Rows.Count / 2;
            int BaseRowID = dgv.Rows.Count;
            dgv.Rows.Add($"{Retry + 1} MOSI (send)", target);
            dgv.Rows.Add($"{Retry + 1} MISO (recive)", target);
            dgv.Rows[BaseRowID].Cells[0].Style.ForeColor = Color.Red;
            dgv.Rows[BaseRowID + 1].Cells[0].Style.ForeColor = Color.Blue;
            return BaseRowID;
        }

        void chk_spi_manualLogAll_CheckedChanged(object sender, EventArgs e) {
            if (chk_spi_manualLogAll.Checked) {
                _board.Event_SpiLogAll += _board_Event_SpiLogAll;
            }
            else {
                _board.Event_SpiLogAll -= _board_Event_SpiLogAll;
            }
        }

        void _board_Event_SpiLogAll(string info) {
            txt_hid_Spi1Rx.Text += $"{info}";
        }

        void btn_log_clear_Click(object sender, EventArgs e) {
            txt_hid_Spi1Rx.Text = "";
        }

        void chk_log_FilterSingleZero_CheckedChanged(object sender, EventArgs e) {
            _board.isSpiFilterSingleZero = chk_log_FilterSingleZero.Checked;
        }

        void txt_hid_Spi1_ConfWait_TextChanged(object sender, EventArgs e) {
            
        }

        void ExecuteSignalCheck() {
            _board.SetSensedMasterSignalCheck(0, Mode_Set.AdcMaSenseDone1); //init
            txt_SignalCheckLog.Text += $"{_board.LastModeSet},";
            ushort[] adcs = _board.GetAdcArrayReadout(12); //read clk, mosi, miso
            if (adcs.Length < 12) {
                throw new Exception($"Not enough ADC entries, got only '{string.Join(",", adcs)}'");
            }
            //Adc are <PP_Low>,<InPullDown>,<PP_High>,<InPullUp>
            //Table are <PP_Low>,<PP_High>,<InPullDown>,<InPullUp>
            dgv_SignalState.Rows.Add("B13", "B0", "SPI2 CLK", adcs[0], adcs[2], adcs[1], adcs[3]);
            dgv_SignalState.Rows.Add("B14", "A7", "SPI2 MISO", adcs[4], adcs[6], adcs[5], adcs[7]);
            dgv_SignalState.Rows.Add("B13", "B0", "SPI2 MOSI", adcs[8], adcs[10], adcs[9], adcs[11]);
            _board.SetSensedMasterSignalCheck(1, Mode_Set.AdcMaSenseDone2); //continue
            txt_SignalCheckLog.Text += $"{_board.LastModeSet},";
            adcs = _board.GetAdcArrayReadout(12); //read cs0,cs1,cs2
            if (adcs.Length < 12) {
                throw new Exception($"Not enough ADC entries, got only '{string.Join(",", adcs)}'");
            }
            dgv_SignalState.Rows.Add("B12", "B1", "CS Out_0", adcs[0], adcs[2], adcs[1], adcs[3]);
            dgv_SignalState.Rows.Add("B3", "A5", "CS Out_1", adcs[4], adcs[6], adcs[5], adcs[7]);
            dgv_SignalState.Rows.Add("B4", "A4", "CS Out_2", adcs[8], adcs[10], adcs[9], adcs[11]);
            _board.SetSensedMasterSignalCheck(1, Mode_Set.AdcMaSenseDone3); //continue
            txt_SignalCheckLog.Text += $"{_board.LastModeSet},";
            adcs = _board.GetAdcArrayReadout(12); //read cs3,cs4,-
            if (adcs.Length < 12) {
                throw new Exception($"Not enough ADC entries, got only '{string.Join(",", adcs)}'");
            }
            dgv_SignalState.Rows.Add("B5", "A3", "CS Out_3", adcs[0], adcs[2], adcs[1], adcs[3]);
            dgv_SignalState.Rows.Add("B9", "A0", "CS Out_4", adcs[4], adcs[6], adcs[5], adcs[7]);
            //dgv_SignalState.Rows.Add("B4", "A4", "CS Out_2", adcs[8], adcs[9], adcs[10], adcs[11]);
        }
        void ExecuteSignalCheckColors() {
            foreach (DataGridViewRow item in dgv_SignalState.Rows) {
                SetSignalCheckCellColor(item.Cells[3], false);
                SetSignalCheckCellColor(item.Cells[4], true);
                SetSignalCheckCellColor(item.Cells[5], false);
                SetSignalCheckCellColor(item.Cells[6], true);
            }
        }
        void SetSignalCheckCellColor(DataGridViewCell cell, bool shouldBeHigh) {
            try {
                decimal number = decimal.Parse(cell.Value.ToString());
                if (shouldBeHigh) {
                    if (number > num_SignalCheck_GrHigh.Value) {
                        cell.Style.BackColor = Color.PaleGreen;
                        return;
                    }
                    if (number > num_SignalCheck_YHigh.Value) {
                        cell.Style.BackColor = Color.Gold;
                        return;
                    }
                } else { //should be low
                    if (number < num_SignalCheck_GrLow.Value) { 
                        cell.Style.BackColor = Color.PaleGreen; 
                        return;
                    }
                    if (number < num_SignalCheck_YLow.Value) {
                        cell.Style.BackColor = Color.Gold;
                        return;
                    }
                }
                
                cell.Style.BackColor = Color.Salmon;
            } catch (Exception ex) {
                cell.ToolTipText = "Ex: " + ex.Message; 
                cell.Style.BackColor = Color.Fuchsia;
            }
        }

        void btn_SignalCheck_Click(object sender, EventArgs e) {
            if (_board.IsBusy) {
                return;
            }
            _board.IsBusy = true;
            dgv_SignalState.Rows.Clear();
            txt_SignalCheckLog.Text = "";
            dgv_SignalState.Refresh();
            try {
                ExecuteSignalCheck();
                ExecuteSignalCheckColors();
            } catch (Exception err) {
                txt_SignalCheckLog.Text += "Err:" + err.Message;
            }
            _board.IsBusy = false;
        }

        
    }
}
