﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MiniStm32JoeC_CoreLibrary {
	public class PinInfo {
		string _pinName = "";
		public string PinName {
			get { return _pinName; }
			set { _pinName = value; }
		}
		string _pinCfg;
		public string PinCfg {
			get { return _pinCfg; }
			set { _pinCfg = value; }
		}
		string _label = "";
		public string Label {
			get { return _label; }
			set { _label = value; }
		}
		PinMode _enumPinMode = PinMode.Undefined;
		public PinMode EnumPinMode {
			get { return _enumPinMode; }
			set { _enumPinMode = value; }
		}
		PinHwSpeed _enumPinSpeed = PinHwSpeed.Undefined;
		public PinHwSpeed EnumPinSpeed {
			get { return _enumPinSpeed; }
			set { _enumPinSpeed = value; }
		}
		PinLogicalState _enumPinOdrState = PinLogicalState.Undefined;
		public PinLogicalState EnumPinOdrState {
			get { return _enumPinOdrState; }
			set { _enumPinOdrState = value; }
		}
		PinLogicalState _enumPinIdrState = PinLogicalState.Undefined;
		public PinLogicalState EnumPinIdrState {
			get { return _enumPinIdrState; }
			set { _enumPinIdrState = value; }
		}
		public PinInfo(string info) : this(info, false, PinMode.Undefined) { }
		public PinInfo(string info, bool infoIsConfig, PinMode pinEnum) {
			_enumPinMode = pinEnum;
			byte PinNr = 255;
			if (infoIsConfig) { //AF
                try {
					PinNr = byte.Parse(info[1].ToString(), NumberStyles.HexNumber);
                }
                catch (Exception) {
					throw new Exception($"Can't parse HexNumber from '{info[1]}' ");
                }
				_pinName = info[0].ToString() + PinNr.ToString();
				_pinCfg = info;
			}
			else { //A15
				try {
					PinNr = byte.Parse(info.Remove(0, 1));
				}
				catch (Exception) {
					throw new Exception($"Can't parse Number from '{info.Remove(0, 1)}' ");
				}
				_pinName = info;
				_pinCfg = $"{_pinName[0]}{PinNr.ToString("X")}";
			}
			_label = info[0].ToString() + "." + PinNr.ToString();
		}
		public ushort GetPinConfigValue() {
			ushort val = (ushort)(((Byte)_pinCfg[0] << 8) | ((byte)_pinCfg[1]));
			return val;
		}
	}
}
