﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MiniStm32JoeC_CoreLibrary {
    public class MotionInfo {
        public ushort StepsToMove = 0;
        public ushort Position_UD = 0;
        public ushort Position_LR = 0;
        public ushort Position_Foc = 0;

        public MotionInfo() {
        }
        public MotionInfo(byte[] data, int indexoffset) {
            //0=ever 1;//Read IDs, boardconfig
            if (data == null) {
                return;
            }
            int i = 1 + indexoffset;
            StepsToMove |= (ushort)(data[i++] << 8);
            StepsToMove |= (ushort)(data[i++]);
            Position_UD |= (ushort)(data[i++] << 8);
            Position_UD |= (ushort)(data[i++]);
            Position_LR |= (ushort)(data[i++] << 8);
            Position_LR |= (ushort)(data[i++]);
            Position_Foc |= (ushort)(data[i++] << 8);
            Position_Foc |= (ushort)(data[i++]);
        }
    }
}