﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO.Ports;
using UsbHid;
using JoeC;
using System.Globalization;
using System.Threading;

namespace MiniStm32JoeC_CoreLibrary
{
    public class MiniStm32BoardJoeC {
        //SerPort SP;
        //UsbHIDCore _usbHid;
        public ConnectionType Connection = ConnectionType.Undefined;
        //HidWaitForResponse _hidWaitForResponse = HidWaitForResponse.NoWait;
        public PortInfo PortInfoA;
        StringBuilder sb = new StringBuilder();
        bool isBusy = false;
        public bool IsBusy {
            get { return isBusy; }
            set { isBusy = value; }
        }
        public bool isSpiFilterSingleZero = false;
        public Mode_Get LastModeGet = Mode_Get.NoRequest;
        public Mode_Set LastModeSet = Mode_Set.NoRequest;
        

        public MiniStm32BoardJoeC(ConnectionType connection) {
            Connection = connection;
        }
        public double ReferenceVoltage = 0;

        public bool DebugLogStatesActive = false;
        public StringBuilder DebugLogStatesGet = new StringBuilder();
        public StringBuilder DebugLogStatesSet = new StringBuilder();

        #region Events
        //uart
        public event Func<string, string> Event_Transmission_Text;
        public string OnEvent_Transmission_Text(string text) {
            string resp = "";
            if (Event_Transmission_Text != null) { resp = Event_Transmission_Text(text); }
            return resp;
        }
        //hid (async)
        
        public int ByteArraySizeHid = 63;
        public event Action<byte[]> Event_Send_ByteArray;
        public void OnEvent_Write_ByteArray(byte[] data) {
            if (Event_Send_ByteArray != null) { Event_Send_ByteArray(data); }
            Thread.Sleep(1);
        }
        public event Action<string> Event_SpiLogAll;
        public void OnEvent_Event_SpiLogAll(string info) {
            if (Event_SpiLogAll != null) { Event_SpiLogAll(info); }
        }

        byte[] HidRxArray = null;
        public bool SetRequestToZero = false;

        public bool Recived_ByteArray(byte[] data) {
            //Byte index + 1 because data[0] -> Endpoint
            LastModeGet = (Mode_Get)data[63];
            LastModeSet = (Mode_Set)data[62];

            //if (LastModeGet != Mode_Get.NoRequest) {
            //    data[0]++; //has no effect, only for break points
            //}
            if (DebugLogStatesActive) {
                DebugLogStatesGet.Append($"{data[63]},");
                DebugLogStatesSet.Append($"{data[62]},");
            }
            
            if (LastModeGet == Mode_Get.Uart1Rx) {
                return false;
            }
            if (isWaitForGetResponseType) {
                //waiting for a board response...
                switch (LastModeSet) { //check for errors
                    case Mode_Set.SpiNotInitialised:
                        isWaitForGetResponseType = false;
                        break;

                }
                if (WaitNotModeSet != Mode_Set.NoRequest) {
                    //wait a set mode is changed
                    //if (WaitNotModeSet == Mode_Set.AdcMaSense) {
                    //    switch (LastModeSet) {
                    //        case Mode_Set.AdcMaSenseDone1:
                    //        case Mode_Set.AdcMaSenseDone2:
                    //        case Mode_Set.AdcMaSenseDone3:
                    //        case Mode_Set.AdcMaSenseDone4:
                    //            isWaitForGetResponseType = false;
                    //            HidCopyArray(data);
                    //            return true;
                    //    }
                    //}
                    if (WaitNotModeSet == LastModeSet) {
                        return true; //borard is working
                    }
                    isWaitForGetResponseType = false;
                    HidCopyArray(data);
                    return true;
                    
                }
                if (WaitModeSet != Mode_Set.NoRequest) {
                    if (WaitModeSet != LastModeSet) {
                        return true; //borard is working
                    }
                    isWaitForGetResponseType = false;
                    HidCopyArray(data);
                    return true;
                }
                if (WaitModeGet != LastModeGet) {
                    return true;
                }
                switch (LastModeGet) {
                    case Mode_Get.NoRequest:
                        break;
                    case Mode_Get.GetBoardId: HidCopyArray(data); break;
                    case Mode_Get.GetGPIOConfig:
                        if (WaitModeSetPin[0] != data[2]) { return true; } //check port
                        HidCopyArray(data);
                        break;
                    case Mode_Get.GetPinDigital:
                        if (WaitModeSetPin[0] != data[2]) { return true; } //check port
                        if (WaitModeSetPin[1] != data[3]) { return true; } //check pin
                        HidCopyArray(data);
                        break;
                    case Mode_Get.GetAdcSingle:
                        if (WaitModeSetPin[0] != data[2]) { return true; } //check port
                        if (WaitModeSetPin[1] != data[3]) { return true; } //check pin
                        HidCopyArray(data);
                        break;
                    case Mode_Get.GetMotionStatus:
                        break;
                    case Mode_Get.GetADCPinArrayCfg: HidCopyArray(data); break;
                    case Mode_Get.GetADCPinArray: HidCopyArray(data); break;
                    case Mode_Get.GetSpi1Rx:
                        HidReportRecived_SpiResponse(data);
                        break;
                    default:
                        break;
                }
                return true;
            }
            return false;
        }
        bool isWaitForGetResponseType = false;
        Mode_Get WaitModeGet = Mode_Get.NoRequest;
        void WaitForHid_GetMode(Mode_Get modeGet, double seconds = 1) {
            DateTime ziel = DateTime.Now.AddSeconds(seconds);
            WaitModeGet = modeGet;
            isWaitForGetResponseType = true;
            while (DateTime.Now < ziel) {
                if (!isWaitForGetResponseType) { break; }
                System.Windows.Forms.Application.DoEvents();
                Thread.Sleep(1);
            }

            if (isWaitForGetResponseType) {
                isWaitForGetResponseType = false;
                string info = $"Timeout while wait for Mode_Get '{modeGet}': last state is '{LastModeGet}'!";
                throw new Exception(info);
            }
            if (LastModeSet == Mode_Set.SpiNotInitialised) {
                throw new Exception("Spi1 is not initialised.");
            }
            if (HidRxArray == null) {
                throw new Exception("HidRxArray is null.");
            }
        }
        Mode_Set WaitModeSet = Mode_Set.NoRequest;
        Mode_Set WaitNotModeSet = Mode_Set.NoRequest;
        byte[] WaitModeSetPin = new byte[2];
        void WaitForHid_ModeSet(Mode_Set modeSet, double seconds = 1) {
            DateTime ziel = DateTime.Now.AddSeconds(seconds);
            WaitModeSet = modeSet;
            isWaitForGetResponseType = true;
            while (DateTime.Now < ziel) {
                if (!isWaitForGetResponseType) { break; }
                System.Windows.Forms.Application.DoEvents();
                Thread.Sleep(1);
            }
            WaitModeSet = Mode_Set.NoRequest;
            if (isWaitForGetResponseType) {
                isWaitForGetResponseType = false;
                string info = $"Timeout while wait for Mode_Set '{modeSet}': last state is '{LastModeSet}'!";
                throw new Exception(info);
            }
        }
        void WaitForHid_NotModeSet(Mode_Set modeNotSet, double seconds = 1) {
            DateTime ziel = DateTime.Now.AddSeconds(seconds);
            WaitNotModeSet = modeNotSet;
            isWaitForGetResponseType = true;
            while (DateTime.Now < ziel) {
                if (!isWaitForGetResponseType) { break; }
                System.Windows.Forms.Application.DoEvents();
                Thread.Sleep(1);
            }
            WaitNotModeSet = Mode_Set.NoRequest;
            if (isWaitForGetResponseType) {
                isWaitForGetResponseType = false;
                string info = $"Timeout while wait for not Mode_Set '{modeNotSet}'!";
                throw new Exception(info);
            }
        }
        void HidReportRecived_SpiResponse(byte[] data) {
            if (Event_SpiLogAll!=null && isWaitForGetResponseType) {
                StringBuilder sbDataIn = new StringBuilder();
                sbDataIn.Append("Get[");
                for (int i = 0; i < data[2]; i++) {
                    sbDataIn.Append(data[i + 3].ToString("X02") + " ");
                }
                sbDataIn.Append("]");
                Event_SpiLogAll($"[{sbDataIn.ToString()}]");
            }
            HidRxArray = new byte[data[2]];
            Array.Copy(data, 3, HidRxArray, 0, data[2]);
            isWaitForGetResponseType = false;
            SetRequestToZero = true;
        }
        void HidCopyArray(byte[] data, int count = 63) { 
            HidRxArray = new byte[count+1];
            Array.Copy(data, 1, HidRxArray, 0, count);
            isWaitForGetResponseType = false;
        }
        
        #endregion

        #region Calculations
        public double[] CalculateTemperatureAndReferenceVoltage(ushort[] raw, ref string optionalLog) {
            StringBuilder sb = new StringBuilder();
            double adcRawRef = raw[0];
            double adcRawTemp = raw[1];

            ReferenceVoltage = 1.2 * (4095.0 / adcRawRef);
            double adcMvSteps = ReferenceVoltage / 4.095;
            sb.Append("mV Steps: " + adcMvSteps);
            double mVTemp = ((adcRawTemp * ReferenceVoltage) / 4.095) * adcMvSteps;
            sb.Append("\r\nmV Temp: " + mVTemp);
            double temp = ((mVTemp - 760.0) / 2.5) + 25;
            sb.Append("\r\nRef: " + ReferenceVoltage);
            sb.Append("\r\nTemp: " + temp);

            if (optionalLog != null) {
                optionalLog = sb.ToString();
            }
            return new double[] { ReferenceVoltage, temp };
        }
        public string CalculateTimeStringFromTotalSeconds(UInt32 totalSeconds) {
            if (totalSeconds == 0) {
                return "[0] 00:00:00";
            }
            TimeSpan timeSpan = TimeSpan.FromSeconds(totalSeconds);
            int hr = timeSpan.Hours;
            int mn = timeSpan.Minutes;
            int sec = timeSpan.Seconds;
            string output = $"[{Math.Round(timeSpan.TotalDays, 1)}] {hr.ToString("00")}:{mn.ToString("00")}:{sec.ToString("00")}";
            return output;
        }
        byte[] ConvertHexLineToData(string rx, int startoffset) { 
            List<byte> response = new List<byte>();
            int start = rx.IndexOf('|');
            int end = rx.TrimEnd().Length;
            if (start < 0) {
                return null;
            }
            for (int i = start + 1; i < end; i+=2) {
                string hex = $"{rx[i]}{rx[i + 1]}";
                byte b = byte.Parse(hex, NumberStyles.HexNumber);
                if (startoffset > 0) {
                    startoffset--;
                    continue;
                }
                response.Add(b);
            }
            return response.ToArray();
        }
        #endregion

        public Mode_Set GetModeSet() {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    string rx = OnEvent_Transmission_Text($"#X3|5,").TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    byte[] data = ConvertHexLineToData(rx, 0);
                    LastModeSet = (Mode_Set)data[1];
                    LastModeGet = (Mode_Get)data[2];
                    return LastModeSet;
                case ConnectionType.USB_HID:
                    return LastModeSet;
            }
            return Mode_Set.NoRequest;
        }
        public Mode_Get GetModeGet() {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    string rx = OnEvent_Transmission_Text($"#X3|5,").TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    byte[] data = ConvertHexLineToData(rx, 0);
                    LastModeSet = (Mode_Set)data[1];
                    LastModeGet = (Mode_Get)data[2];
                    return LastModeGet;
                case ConnectionType.USB_HID:
                    return LastModeGet;
            }
            return Mode_Get.NoRequest;
        }

        # region Tab GPIO_Verion_PinRemap
        public BoardInfo GetBoardInfo() {
            BoardInfo boardInfo = new BoardInfo();
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    string rx = OnEvent_Transmission_Text("#X29|1,");
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    //X[30]:01|0100A005066FFF525451885167154008FFFF00FF00008A8A0000001D\r
                    byte[] data = ConvertHexLineToData(rx, 0);
                    boardInfo = new BoardInfo(data, 1);
                    return boardInfo;
                case ConnectionType.USB_HID:
                    OnEvent_Write_ByteArray(new byte[] { (byte)Mode_Set.SetModeGet, (byte)Mode_Get.GetBoardId });
                    HidRxArray = null;
                    WaitForHid_GetMode(Mode_Get.GetBoardId);
                    boardInfo = new BoardInfo(HidRxArray, 1);
                    return boardInfo;
            }
            return null;
        }
        public PortInfo GetPortInfo(string Port) {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    string rx = OnEvent_Transmission_Text($"#X20|2,{(byte)Port[0]},");
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    //#X[20]:02:02414444B4B4B8B00000000000400000BF40AA55\r
                    byte[] data = ConvertHexLineToData(rx, 0);
                    return new PortInfo(data, 1);
                case ConnectionType.USB_HID:
                    OnEvent_Write_ByteArray(new byte[] { (byte)Mode_Set.SetModeGet, (byte)Mode_Get.GetGPIOConfig, (byte)Port[0] });
                    HidRxArray = null;
                    WaitModeSetPin[0] = (byte)Port[0];
                    WaitForHid_GetMode(Mode_Get.GetGPIOConfig);
                    PortInfo info = new PortInfo(HidRxArray, 1);
                    return info;
            }
            return null;
        }
        public bool GetPinInputState(string pinCfg) {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    string rx = OnEvent_Transmission_Text($"#X2|3,{(byte)pinCfg[0]},{(byte)pinCfg[1]},").TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    //#X[2]:03|0342\r
                    if (rx.EndsWith("42")) { return true; }
                    if (rx.EndsWith("41")) { return false; }
                    throw new Exception($"response '{rx}' not expected.");
                case ConnectionType.USB_HID:
                    OnEvent_Write_ByteArray(new byte[] { (byte)Mode_Set.SetModeGet, (byte)Mode_Get.GetPinDigital, (byte)pinCfg[0], (byte)pinCfg[1] });
                    HidRxArray = null;
                    WaitModeSetPin[0] = (byte)pinCfg[0];
                    WaitModeSetPin[1] = (byte)pinCfg[1];
                    WaitForHid_GetMode(Mode_Get.GetPinDigital);
                    if (HidRxArray[3] == 'B') { return true; }
                    if (HidRxArray[3] == 'A') { return false; }
                    throw new Exception($"response '{HidRxArray[3]}' not expected.");
            }
            return false;
        }
        public ushort GetPinAdc(string pinCfg) {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    string rx = OnEvent_Transmission_Text($"#X5|4,{(byte)pinCfg[0]},{(byte)pinCfg[1]},").TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    byte[] data = ConvertHexLineToData(rx, 0);
                    ushort value = (ushort)(data[3] << 8 | data[4]);
                    return value;
                case ConnectionType.USB_HID:
                    OnEvent_Write_ByteArray(new byte[] { (byte)Mode_Set.SetModeGet, (byte)Mode_Get.GetAdcSingle, (byte)pinCfg[0], (byte)pinCfg[1] });
                    HidRxArray = null;
                    WaitModeSetPin[0] = (byte)pinCfg[0];
                    WaitModeSetPin[1] = (byte)pinCfg[1];
                    WaitForHid_GetMode(Mode_Get.GetAdcSingle);
                    ushort value2 = (ushort)(HidRxArray[3] << 8 | HidRxArray[4]);
                    return value2;
            }
            return 0xffff;
        }
        public ushort[] GetTemperatureAndReferenceVoltageRaw() {
            int refRaw = 0;
            int tempRaw = 0;
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    string rx = OnEvent_Transmission_Text("#S18|8,8,82,48,82,48,82,48,82,48,84,48,84,48,84,48,84,48,");
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    for (int i = 0; i < 3; i++) {
                        Mode_Set req = GetModeSet();
                        if (req == Mode_Set.AdcPinArrayDone) {
                            break;
                        }
                        Thread.Sleep(100);
                    }
                    rx = OnEvent_Transmission_Text("#X18|8,");

                    byte[] resp = ConvertHexLineToData(rx, 0);
                    for (int i = 1; i < resp.Length - 1; i += 2) {
                        if (i < 8) {
                            refRaw += (resp[i] << 8 | resp[i + 1]);
                        }
                        else {
                            tempRaw += (resp[i] << 8 | resp[i + 1]);
                        }
                    }
                    //bitshift averrage
                    refRaw = refRaw >> 2;
                    tempRaw = tempRaw >> 2;
                    return new ushort[] { (ushort)refRaw, (ushort)tempRaw };
                case ConnectionType.USB_HID:
                    OnEvent_Write_ByteArray(new byte[] { (byte)Mode_Set.SetAdcPinArray, 8, 82, 48, 82, 48, 82, 48, 82, 48, 84, 48, 84, 48, 84, 48, 84, 48, });
                    Thread.Sleep(1);
                    WaitForHid_ModeSet(Mode_Set.AdcPinArrayDone, 3);
                    OnEvent_Write_ByteArray(new byte[] { (byte)Mode_Set.SetModeGet, (byte)Mode_Get.GetADCPinArray });
                    Thread.Sleep(1);

                    HidRxArray = null;
                    WaitForHid_GetMode(Mode_Get.GetADCPinArray);
                    for (int i = 1; i < HidRxArray.Length - 1; i += 2) {
                        if (i > 16) {
                            break;
                        }
                        if (i < 8) {
                            refRaw += (HidRxArray[i] << 8 | HidRxArray[i + 1]);
                        }
                        else {
                            tempRaw += (HidRxArray[i] << 8 | HidRxArray[i + 1]);
                        }
                    }
                    //bitshift averrage
                    refRaw = refRaw >> 2;
                    tempRaw = tempRaw >> 2;
                    return new ushort[] { (ushort)refRaw, (ushort)tempRaw };
            }
            return null;
        }
        public void SetDigitalPin(PinInfo pinInfo, bool state) {
            if (pinInfo == null) {
                throw new Exception("SetDigitalPin()->pinInfo is NULL");
            }
            PinSetState setState = PinSetState.PinState_In_Float;
            switch (pinInfo.EnumPinMode) {
                case PinMode.IP_In_PullUp:
                case PinMode.ID_In_PullDown:
                    setState = (state) ? PinSetState.PinState_In_PUp : PinSetState.PinState_In_PDown;
                    break;
                case PinMode.OP_Out_PushPull:
                    setState = (state) ? PinSetState.PinState_PP_High : PinSetState.PinState_PP_Low;
                    break;
                case PinMode.OD_Out_OpenDrain:
                    setState = (state) ? PinSetState.PinState_OD_High : PinSetState.PinState_OD_Low;
                    break;
                default:
                    throw new Exception($"SetDigitalPin() EnumPinMode='{pinInfo.EnumPinMode}' is not supported.");
            }
            SetPinLine(new string[] { pinInfo.PinCfg }, setState);
        }
        public void SetPinLine(string[] pinCfg, PinSetState pinMode) {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    StringBuilder sb = new StringBuilder(100);
                    sb.Append($"#S{((pinCfg.Length*2) + 3)}|2,{pinCfg.Length},{(byte)pinMode},");
                    foreach (var item in pinCfg) {
                        sb.Append($"{(byte)item[0]},{(byte)item[1]},");
                    }
                    string rx = OnEvent_Transmission_Text(sb.ToString()).TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    return;
                case ConnectionType.USB_HID:
                    byte[] buffer = new byte[ByteArraySizeHid];
                    //buffer[0] = 0;
                    buffer[0] = (byte)Mode_Set.SetPinLine;
                    buffer[1] = (byte)pinCfg.Length;
                    buffer[2] = (byte)pinMode;
                    int index = 3;
                    foreach (var item in pinCfg) {
                        buffer[index] = (byte)item[0];
                        buffer[index+1] = (byte)item[1];
                        index += 2;
                    }
                    OnEvent_Write_ByteArray(buffer);
                    Thread.Sleep(1);
                    return;
            }
            return;
        }
        #endregion
        #region SPI_master
        public void SetSpiConfig(byte spiport, byte mode, byte bits, byte speed, ushort wait) {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    byte w0 = (byte)((wait >> 8) & 0xff);
                    byte w1 = (byte)(wait & 0xff);
                    string rx = OnEvent_Transmission_Text($"#S5|20,{spiport},{mode},{bits},{speed},{w0},{w1},").TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    break;
                case ConnectionType.USB_HID:
                    byte[] puffer = new byte[ByteArraySizeHid];
                    puffer[0] = 20; //SpiSetup
                    puffer[1] = spiport;
                    puffer[2] = mode;
                    puffer[3] = bits;
                    puffer[4] = speed;
                    puffer[5] = (byte)((wait & 0xff00) >> 8);
                    puffer[6] = (byte)(wait & 0xff);
                    OnEvent_Write_ByteArray(puffer);
                    break;
            }
        }
        public void SetSpiCsPinLine(string[] pinCfg) {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    StringBuilder sb = new StringBuilder(100);
                    sb.Append($"#S{((pinCfg.Length * 2) + 2)}|22,{pinCfg.Length},");
                    foreach (var item in pinCfg) {
                        sb.Append($"{(byte)item[0]},{(byte)item[1]},");
                    }
                    string rx = OnEvent_Transmission_Text(sb.ToString()).TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    return;
                case ConnectionType.USB_HID:
                    byte[] buffer = new byte[ByteArraySizeHid];
                    //buffer[0] = 0;
                    buffer[0] = (byte)Mode_Set.SetSpiCsPinArray;
                    buffer[1] = (byte)pinCfg.Length;
                    int index = 2;
                    foreach (var item in pinCfg) {
                        buffer[index] = (byte)item[0];
                        buffer[index + 1] = (byte)item[1];
                        index += 2;
                    }
                    OnEvent_Write_ByteArray(buffer);
                    Thread.Sleep(1);
                    return;
            }
            return;
        }

        public byte[] TransmissionSpi8(int target, int len, byte[] txArray) {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    StringBuilder sb = new StringBuilder(100);
                    sb.Append($"#S{(len + 3)}|16,{target},{len},");
                    for (int i = 0; i < len; i++) {
                        sb.Append($"{txArray[i]},");
                    }
                    string rx = OnEvent_Transmission_Text(sb.ToString()).TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    WaitForUartModeSet(Mode_Set.BusySpiResponse);
                    rx = OnEvent_Transmission_Text($"#X{(len + 2)}|11,").TrimEnd();
                    byte[] data = ConvertHexLineToData(rx, 2);
                    return data;
                case ConnectionType.USB_HID:
                    byte[] puffer = new byte[ByteArraySizeHid];
                    puffer[0] = 16; //8bit
                    puffer[1] = (byte)target;
                    puffer[2] = (byte)len;

                    int cnt = 3;
                    for (int i = 0; i < txArray.Length; i++) {
                        puffer[cnt++] = txArray[i];
                        if (cnt == ByteArraySizeHid) {
                            throw new Exception($"to much tx data... Max({ByteArraySizeHid}).");
                        }
                    }
                    //transmission
                    HidRxArray = null;
                    OnEvent_Write_ByteArray(puffer);
                    WaitForHid_GetMode(Mode_Get.GetSpi1Rx);

                    return HidRxArray;
            }
            return null;
        }
        public ushort[] TransmissionSpi16(int target, int len, ushort[] txArray) {
            int cnt = 0;
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    StringBuilder sb = new StringBuilder(100);
                    sb.Append($"#S{((len * 2) + 3)}|17,{target},{(len * 2)},"); //len * 2 -> 16bit
                    for (int i = 0; i < len; i++) {
                        byte b0 = (byte)((txArray[i] >> 8) & 0xff);
                        byte b1 = (byte)(txArray[i] & 0xff);
                        sb.Append($"{b0},{b1},");
                    }
                    
                    string rx = OnEvent_Transmission_Text(sb.ToString()).TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    WaitForUartModeSet(Mode_Set.BusySpiResponse);
                    rx = OnEvent_Transmission_Text($"#X{((len * 2) + 2)}|11,").TrimEnd(); //|11 -> readSpi1 buffer
                    byte[] data = ConvertHexLineToData(rx, 2);
                    ushort[] rx2 = new ushort[data.Length / 2];
                    cnt = 0;
                    for (int i = 0; i < rx2.Length; i++) {
                        rx2[i] = (ushort)((data[cnt] << 8) | data[cnt + 1]);
                        cnt += 2;
                    }
                    return rx2;
                case ConnectionType.USB_HID:
                    byte[] puffer = new byte[ByteArraySizeHid];
                    puffer[0] = 17; //16bit
                    puffer[1] = (byte)target;
                    puffer[2] = (byte)(len * 2);

                    cnt = 3;
                    for (int i = 0; i < txArray.Length; i++) {
                        puffer[cnt++] = (byte)((txArray[i] & 0xFF00) >> 8);
                        puffer[cnt++] = (byte)(txArray[i] & 0xFF);
                        if (cnt == ByteArraySizeHid) {
                            throw new Exception($"to much tx data... Max({ByteArraySizeHid}).");
                        }
                    }
                    //transmission
                    HidRxArray = null;
                    OnEvent_Write_ByteArray(puffer);
                    WaitForHid_GetMode(Mode_Get.GetSpi1Rx);

                    //translate to ushort
                    ushort[] rx16 = new ushort[HidRxArray.Length / 2];
                    cnt = 0;
                    for (int i = 0; i < rx16.Length; i++) {
                        rx16[i] = (ushort)((HidRxArray[cnt] << 8) | HidRxArray[cnt + 1]);
                        cnt += 2;
                    }
                    return rx16;
            }
            return null;
            
        }
        public UInt32[] TransmissionSpi32(int target, int len, UInt32[] txArray) {
            int cnt = 0;
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    StringBuilder sb = new StringBuilder(100);
                    sb.Append($"#S{((len * 2) + 3)}|18,{target},{(len * 4)},"); //len * 2 -> 16bit
                    for (int i = 0; i < len; i++) {
                        byte b0 = (byte)((txArray[i] >> 24) & 0xff);
                        byte b1 = (byte)((txArray[i] >> 16) & 0xff);
                        byte b2 = (byte)((txArray[i] >> 8) & 0xff);
                        byte b3 = (byte)(txArray[i] & 0xff);
                        sb.Append($"{b0},{b1},{b2},{b3},");
                    }

                    string rx = OnEvent_Transmission_Text(sb.ToString()).TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    WaitForUartModeSet(Mode_Set.BusySpiResponse);
                    rx = OnEvent_Transmission_Text($"#X{((len * 4) + 2)}|11,").TrimEnd(); //|11 -> readSpi1 buffer
                    byte[] data = ConvertHexLineToData(rx, 2);
                    UInt32[] rx2 = new UInt32[data.Length / 4];
                    cnt = 0;
                    for (int i = 0; i < rx2.Length; i++) {
                        ushort msb = (ushort)((data[cnt] << 8) | data[cnt + 1]);
                        ushort lsb = (ushort)((data[cnt + 2] << 8) | data[cnt + 3]);
                        UInt32 val = (UInt32)(msb << 8);
                        rx2[i] = (val << 8) | lsb;

                        //overflow exception...
                        //rx[i] = (UInt32)((SpiRxArray[cnt] << 24) | (SpiRxArray[cnt + 1] << 16) | (SpiRxArray[cnt + 2] << 8) | SpiRxArray[cnt + 3]);
                        cnt += 4;
                    }
                    return rx2;
                case ConnectionType.USB_HID:
                    byte[] puffer = new byte[ByteArraySizeHid];
                    puffer[0] = 18; //32bit
                    puffer[1] = (byte)target;
                    puffer[2] = (byte)(len * 4);

                    cnt = 3;
                    for (int i = 0; i < txArray.Length; i++) {
                        puffer[cnt++] = (byte)((txArray[i] & 0xFF000000) >> 24);
                        puffer[cnt++] = (byte)((txArray[i] & 0xFF0000) >> 16);
                        puffer[cnt++] = (byte)((txArray[i] & 0xFF00) >> 8);
                        puffer[cnt++] = (byte)(txArray[i] & 0xFF);
                        if (cnt == ByteArraySizeHid) {
                            throw new Exception($"to much tx data... Max({ByteArraySizeHid}).");
                        }
                    }
                    //transmission
                    HidRxArray = null;
                    OnEvent_Write_ByteArray(puffer);
                    WaitForHid_GetMode(Mode_Get.GetSpi1Rx);

                    //translate to ushort

                    UInt32[] rx32 = new UInt32[HidRxArray.Length / 4];
                    cnt = 0;
                    for (int i = 0; i < rx32.Length; i++) {
                        ushort msb = (ushort)((HidRxArray[cnt] << 8) | HidRxArray[cnt + 1]);
                        ushort lsb = (ushort)((HidRxArray[cnt + 2] << 8) | HidRxArray[cnt + 3]);
                        UInt32 val = (UInt32)(msb << 8);
                        rx32[i] = (val << 8) | lsb;

                        //overflow exception...
                        //rx[i] = (UInt32)((SpiRxArray[cnt] << 24) | (SpiRxArray[cnt + 1] << 16) | (SpiRxArray[cnt + 2] << 8) | SpiRxArray[cnt + 3]);
                        cnt += 4;
                    }
                    return rx32;
            }
            return null;
            
        }

        void WaitForUartModeSet(Mode_Set mode) {
            Mode_Set request = GetModeSet();
            if (request == Mode_Set.SpiNotInitialised) {
                throw new Exception($"response not expected: '{request}'");
            }
            for (int i = 0; i < 5; i++) {
                if (request == mode) {
                    break;
                }
                Thread.Sleep(10);
                request = GetModeSet();
            }
            if (request != mode) {
                throw new Exception($"WaitForUartModeSet(): response not expected: '{request}'");
            }
        }
        void WaitForUart_NotModeSet(Mode_Set modeNot) {
            Mode_Set request = GetModeSet();
            for (int i = 0; i < 10; i++) {
                if (request != modeNot) {
                    break;
                }
                Thread.Sleep(10);
                request = GetModeSet();
            }
            if (request == modeNot) {
                throw new Exception($"WaitForUartNotModeSet(): response still: '{request}'");
            }
        }
        #endregion
        #region ADC_array
        public void SetAdcPinArray(string[] PinConfigs) {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    byte cnt = 2; //mode+cnt
                    sb.Clear();
                    for (int i = 0; i < PinConfigs.Length; i++) {
                        if (PinConfigs[i].Length < 2) {
                            continue; //not enough chars
                        }
                        sb.Append($"{(byte)PinConfigs[i][0]},{(byte)PinConfigs[i][1]},");
                        cnt += 2;
                    }
                    string rx = OnEvent_Transmission_Text($"#S{cnt}|8,{PinConfigs.Length},{sb.ToString()}").TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    break;
                case ConnectionType.USB_HID:
                    byte[] buffer = new byte[ByteArraySizeHid];
                    buffer[0] = (byte)Mode_Set.SetAdcPinArray;
                    buffer[1] = (byte)PinConfigs.Length;
                    int index = 2;
                    foreach (var item in PinConfigs) {
                        buffer[index] = (byte)item[0];
                        buffer[index + 1] = (byte)item[1];
                        index += 2;
                    }
                    OnEvent_Write_ByteArray(buffer);
                    WaitForHid_ModeSet(Mode_Set.AdcPinArrayDone);
                    return;
            }
        }
        public ushort[] GetAdcArrayReadout(int pinCount) {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    //pincnt*2 -> 2bytes per value, + 3-><mode><7 for ADC><x for PinCnt>
                    string rx = OnEvent_Transmission_Text($"#X{(pinCount*2)+2}|8,").TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    byte[] resp = ConvertHexLineToData(rx, 0);
                    List<ushort> outputs = new List<ushort>();
                    for (int i = 1; i < resp.Length-1; i+=2) {
                        ushort value = (ushort)(resp[i] << 8 | resp[i + 1]);
                        outputs.Add(value);
                    }
                    return outputs.ToArray();
                case ConnectionType.USB_HID:
                    OnEvent_Write_ByteArray(new byte[] { (byte)Mode_Set.SetModeGet, (byte)Mode_Get.GetADCPinArray});
                    HidRxArray = null;
                    WaitForHid_GetMode(Mode_Get.GetADCPinArray);
                    List<ushort> outputs2 = new List<ushort>();
                    int stop = pinCount * 2;
                    for (int i = 1; i < stop; i += 2) {
                        ushort value = (ushort)(HidRxArray[i] << 8 | HidRxArray[i + 1]);
                        outputs2.Add(value);
                    }
                    return outputs2.ToArray();
            }
            return null;
        }
        public string[] GetAdcArrayCfg() {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    //pincnt*2 -> 2bytes per value, + 3-><mode><7 for ADC><x for PinCnt>
                    string rx = OnEvent_Transmission_Text($"#X22|7,").TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    byte[] resp = ConvertHexLineToData(rx, 0);
                    List<string> outputs = new List<string>();
                    outputs.Add(resp[21].ToString());
                    for (int i = 1; i < resp.Length - 1; i += 2) {
                        string value = $"{(char)resp[i]}{(char)resp[i + 1]}";
                        outputs.Add(value);
                    }
                    return outputs.ToArray();
                case ConnectionType.USB_HID:
                    OnEvent_Write_ByteArray(new byte[] { (byte)Mode_Set.SetModeGet, (byte)Mode_Get.GetADCPinArrayCfg });
                    HidRxArray = null;
                    WaitForHid_GetMode(Mode_Get.GetADCPinArrayCfg);
                    List<string> outputs2 = new List<string>();
                    outputs2.Add(HidRxArray[21].ToString());
                    int stop = 20;
                    //TODO GetAdcArrayCfg() untested implementation
                    for (int i = 1; i < stop; i += 2) {
                        string value = $"{(char)HidRxArray[i]}{(char)HidRxArray[i + 1]}";
                        outputs2.Add(value);
                    }
                    return outputs2.ToArray();
            }
            return null;
        }
        public void SetSensedMasterSignalCheck(byte mode, Mode_Set waitForMode) {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    //pincnt*2 -> 2bytes per value, + 3-><mode><7 for ADC><x for PinCnt>
                    string rx = OnEvent_Transmission_Text($"#S3|9,{mode},").TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    Thread.Sleep(10);
                    WaitForUart_NotModeSet(Mode_Set.AdcPinArraySet);
                    return;
                case ConnectionType.USB_HID:
                    OnEvent_Write_ByteArray(new byte[] { (byte)Mode_Set.SetMasterSenseLines, mode });
                    HidRxArray = null;
                    WaitForHid_ModeSet(waitForMode);
                    return;
            }
            return;
        }
        #endregion

        //motion
        public MotionInfo GetMotionInfo() {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    string rx = OnEvent_Transmission_Text($"#X9|6,").TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    byte[] data = ConvertHexLineToData(rx, 0);
                    MotionInfo motionInfo = new MotionInfo(data, 0);
                    return motionInfo;
                case ConnectionType.USB_HID:
                    //TODO hid: PortInfo GetPortInfo(string Port)
                    throw new NotImplementedException("Not Implemented: " + System.Reflection.MethodBase.GetCurrentMethod());
            }
            return null;
        }
        public void SetMotionMoveStepsAsync(int motor, int dir, int steps, int timeout) {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    byte s0 = (byte)((steps >> 8) & 0xff);
                    byte s1 = (byte)(steps & 0xff);
                    byte t0 = (byte)((timeout >> 8) & 0xff);
                    byte t1 = (byte)(timeout & 0xff);
                    string rx = OnEvent_Transmission_Text($"#S7|6,{dir},{s0},{s1},{t0},{t1},{motor},").TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    break;
                case ConnectionType.USB_HID:
                    //TODO hid: PortInfo GetPortInfo(string Port)
                    throw new NotImplementedException("Not Implemented: " + System.Reflection.MethodBase.GetCurrentMethod());
            }
        }
        public void SetMotionHomingAsync(int motor, int stepsMax, int timeout) {
            switch (Connection) {
                case ConnectionType.Serial_RS232_UART:
                    byte s0 = (byte)((stepsMax >> 8) & 0xff);
                    byte s1 = (byte)(stepsMax & 0xff);
                    byte t0 = (byte)((timeout >> 8) & 0xff);
                    byte t1 = (byte)(timeout & 0xff);
                    string rx = OnEvent_Transmission_Text($"#S6|7,{s0},{s1},{t0},{t1},{motor},").TrimEnd();
                    if (rx.EndsWith("!")) {
                        throw new Exception(rx);
                    }
                    break;
                case ConnectionType.USB_HID:
                    //TODO hid: PortInfo GetPortInfo(string Port)
                    throw new NotImplementedException("Not Implemented: " + System.Reflection.MethodBase.GetCurrentMethod());
            }
        }
        
        


    }
}
