﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MiniStm32JoeC_CoreLibrary {
    public enum ConnectionType {
        Undefined,
        Serial_RS232_UART = 0,
        USB_HID
    }
    public enum PinMode {
        Undefined,
        IF_In_Floating,
        IP_In_PullUp,
        ID_In_PullDown,
        IA_In_Analog,
        OP_Out_PushPull,
        OD_Out_OpenDrain,
        AP_Alt_PushPull,
        AD_Alt_OpenDrain,
    }
    public enum PinSetState {
        Undefined,
        PinState_In_Float = '0',
        PinState_PP_Low = '1',
        PinState_PP_High = '2',
        PinState_In_PDown = '3',
        PinState_In_PUp = '4',
        PinState_In_Analog = '5',
        PinState_OD_Low = '6',
        PinState_OD_High = '7',
        PinState_AP_Low = '8',
        PinState_AP_High = '9',
        PinState_AD_Low = 'A',
        PinState_AD_High = 'B',
    }
    public enum PinLogicalState {
        Undefined,
        High,
        Low
    }
    public enum PinHwSpeed {
        Undefined,
        Mhz_2,
        Mhz_10,
        Mhz_50
    }
    public enum Mode_Get {
        NoRequest = 0,
        GetBoardId = 1,
        GetGPIOConfig = 2,
        GetPinDigital = 3,
        GetAdcSingle = 4,
        GetModeSetGet = 5,
        GetMotionStatus = 6,
        GetADCPinArrayCfg = 7,
        GetADCPinArray = 8,
        //9
        //10
        GetSpi1Rx = 11,

        //auto assigned by board
        Uart1Rx = 100,
        Uart3Rx = 101,
        BusyI2c1Trans = 110,
        I2c1Response = 111,
    }
    public enum Mode_Set { 
        NoRequest = 0,
        SetModeGet = 1,
        SetPinLine = 2,
        //3 I2C_Send(u8 adresse, u8 reg, u8 data)
        SetI2cRead = 4,
        //5
        SetMoveSteps = 6,
        SetMoveHoming = 7,
        SetAdcPinArray = 8,
        SetMasterSenseLines = 9,
        SetUart1TxDma = 10,
        WS2812_WriteAll_SingleColor = 11,
        //12 WS2812_rainbow_Loop
        WS2812_WriteAll_Off = 13,
        WS2812_WriteAll_MultiColor = 14,
        SetUart3TxDma = 15,
        SetSpiTX8 = 16,
        SetSpiTX16 = 17,
        SetSpiTX32 = 18,
        SetSpiTarget = 19,
        SPI1_MasterConfig = 20,
        InitUartBaudrate = 21,
        SetSpiCsPinArray = 22,

        //auto assigned by board
        AdcPinArraySet = 100,
        AdcPinArrayDone = 101,
        AdcMaSense = 102,
        AdcMaSenseDone1 = 103,
        AdcMaSenseDone2 = 104,
        AdcMaSenseDone3 = 105,
        AdcMaSenseDone4 = 106,
        MotionMove = 110,
        MotionIsMoving = 111,
        MotionHomeSearch = 112,
        MotionHomeToPos = 113,
        MotionHomeFailed = 114,
        BusySpiTrans = 120,
        BusySpiResponse = 121,
        SpiNotInitialised = 122,
    }

}
