﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MiniStm32JoeC_CoreLibrary {
    public class BoardInfo {
        public byte InitType = 0;
        public byte[] FirmwareVersion = new byte[3];
        public string UniqeID = "";
        public UInt32 MainLoopCount = 0;
        public UInt32 ActiveSeconds = 0;

        public BoardInfo() {
        }
        public BoardInfo(byte[] data, int indexoffset) {
            //0=ever 1;//Read IDs, boardconfig
            if (data == null) {
                return;
            }
            int i = indexoffset;
            byte comm_mode = data[i++];
            InitType = data[i++];
            FirmwareVersion[0] = data[i++];
            FirmwareVersion[1] = data[i++];
            FirmwareVersion[2] = data[i++];
            ushort[] partId = new ushort[6];
            partId[0] |= (ushort)(data[i++] << 8);
            partId[0] |= (ushort)(data[i++]);
            partId[1] |= (ushort)(data[i++] << 8);
            partId[1] |= (ushort)(data[i++]);

            partId[2] |= (ushort)(data[i++] << 8);
            partId[2] |= (ushort)(data[i++]);
            partId[3] |= (ushort)(data[i++] << 8);
            partId[3] |= (ushort)(data[i++]);

            partId[4] |= (ushort)(data[i++] << 8);
            partId[4] |= (ushort)(data[i++]);
            partId[5] |= (ushort)(data[i++] << 8);
            partId[5] |= (ushort)(data[i++]);

            UniqeID = $"{partId[0].ToString("X04")} {partId[1].ToString("X04")} " +
            $"{partId[2].ToString("X04")} {partId[3].ToString("X04")} " +
            $"{partId[4].ToString("X04")} {partId[5].ToString("X04")}";

            MainLoopCount |= (UInt32)(data[i++] << 24);
            MainLoopCount |= (UInt32)(data[i++] << 16);
            MainLoopCount |= (UInt32)(data[i++] << 8);
            MainLoopCount |= (UInt32)(data[i++]);

            ActiveSeconds |= (UInt32)(data[i++] << 24);
            ActiveSeconds |= (UInt32)(data[i++] << 16);
            ActiveSeconds |= (UInt32)(data[i++] << 8);
            ActiveSeconds |= (UInt32)(data[i++]);
        }
    }
}
