﻿using System;

namespace UsbHid.USB.Classes.Messaging
{
    public class DirectMessage : IMesage
    {
        private byte[] _parameters;
        public byte[] MessageData { get { return GetMessageData(); } }

        private byte[] GetMessageData()
        {
            var result = new byte[64]; //was 65 before, work on win10 but not on win7
            if (Parameters != null) {
                Array.Copy(Parameters, 0 ,result, 1, Parameters.Length);
            }
            return result;
        }

    
        public byte[] Parameters
        {
            get { return _parameters; }
            set
            {
                if (value.Length < 1) throw new ArgumentOutOfRangeException("value", "Paramater needs to be at least 1 byte long");
                if (value.Length > 63) throw new ArgumentOutOfRangeException("value", "Paramater canot be longer than 63 bytes");
                _parameters = value;
            }
        }

        public DirectMessage(byte[] parameters) {
            Parameters = parameters;
        }

    }
}
