﻿#region Usings...
using System;
using System.Text;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.IO.Ports;
using System.IO;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using UsbHid;
using System.Diagnostics;


using System.Security.Cryptography; //crc
using MiniStm32JoeC_CoreLibrary;
using UsbHid.USB.Classes;
using UsbHid.USB.Classes.Messaging;
using System.Reflection;
#endregion

namespace Dev_Tools
{
    public partial class HidForm : Form {

        #region Allgemeines
        MiniStm32BoardJoeC _board = new MiniStm32BoardJoeC(ConnectionType.USB_HID);
        UsbHidDevice _hid;

        int ReportOutLen = 63;

        public HidForm() {
            InitializeComponent();
            //init usercontrols
            uC_SPI1.Init(_board);
            uC_PinMap1.Init(_board);
            uC_ADC1.Init(_board);
            uC_RgbLed1.Init(_board);
            uC_I2C1.Init(_board);
            uC_Script1.Init(_board);
            uC_I2C_Slaves1.Init(_board);
            uC_StepperMotion1.Init(_board);

            _board.Event_Send_ByteArray += _board_Event_Send_ByteArray;
            uC_PinMap1.SetReferenceOffsets(FromAppConfig("OffsetVoltageReferenceCounts", 0), FromAppConfig("OffsetTemperatureCounts", 0));
            if (FromAppConfig("SelectHidAnyDevice", 0) == 1) {
                rad_hid_selectAny.Checked = true;
            }
            string hidInitType = FromAppConfig("SelectHidByInitType", "");
            if (!string.IsNullOrWhiteSpace(hidInitType)) {
                txt_hid_selectInitType.Text = hidInitType;
                rad_hid_selectInitType.Checked = true;
            }
            string hidSerial = FromAppConfig("SelectHidBySerial", "");
            if (!string.IsNullOrWhiteSpace(hidSerial)) {
                txt_hid_selectId.Text = hidSerial;
                rad_hid_selectId.Checked = true;
            }
        }


        string FromAppConfig(string nameOf_AppConfig_Entry, string defaultValue) {
            try {
                string entry = System.Configuration.ConfigurationManager.AppSettings[nameOf_AppConfig_Entry];
                return entry;
            }
            catch (Exception err) {
                txt_usb_recive.Text += $"FromAppConfig('{nameOf_AppConfig_Entry}')->{err.Message}";
            }
            return defaultValue;
        }
        int FromAppConfig(string nameOf_AppConfig_Entry, int defaultValue) {
            string entry = FromAppConfig(nameOf_AppConfig_Entry, "");
            int output = 0;
            if (int.TryParse(entry, out output)) {
                return output;
            }
            txt_usb_recive.Text += $"FromAppConfig('{nameOf_AppConfig_Entry}')->Can't convert '{entry}' to integer.";
            return defaultValue;
        }

        
        void MainFormShown(object sender, EventArgs e)
        {
            
        }


        void _board_Event_Send_ByteArray(byte[] obj) {
            try {
                sendHID(obj);
            }
            catch (Exception ex) {
                txt_usb_recive.Text += "Ex: " + ex.Message;
            }
        }

        void MainFormLoad(object sender, EventArgs e)
        {

            CB_RS232_baud.SelectedIndex = 2;

            RefreshHidDevices();
        }
        VidPidMatcher GetVidPid() {
            UInt32 Vendor = UInt32.Parse(txt_usb_VendorID.Text, System.Globalization.NumberStyles.HexNumber);
            UInt32 Product = UInt32.Parse(txt_usb_ProductID.Text, System.Globalization.NumberStyles.HexNumber);
            return new VidPidMatcher(Vendor, Product);
        }
        void RefreshHidDevices() {
            txt_HidDevicesLog.Text = "";
            dgv_HidDevices.Rows.Clear();
            try {
                bool deviceSelected = false;
                if (_hid != null) {
                    if (_hid.IsDeviceConnected) {
                        deviceSelected = true;
                    }
                }

                //search Hid devices by VID and PID
                var devices = DeviceDiscovery.FindHidDevices(GetVidPid());
                txt_HidDevicesLog.Text += $"Found {devices.Count} Devices\r\n";
                foreach (var item in devices) {
                    dgv_HidDevices.Rows.Add(item.Value.Manufacturer,item.Value.Product,item.Value.Serial,item.Key);
                    if (!deviceSelected) {
                        if (rad_hid_selectAny.Checked) { 
                            deviceSelected = true;
                        }
                        else if (rad_hid_selectInitType.Checked) {
                            if (item.Value.Manufacturer.StartsWith(txt_hid_selectInitType.Text)) { deviceSelected = true; }
                        } else if (rad_hid_selectId.Checked) {
                            if (item.Value.Serial == txt_hid_selectId.Text) { deviceSelected = true; }
                        }
                        if (deviceSelected) {
                            HidDeviceConnect(item.Key, item.Value.Serial);
                        }
                    }
                    
                    if (item.Value.Serial == HidSelectedDeviceSerial) {
                        DataGridViewRow row = dgv_HidDevices.Rows[dgv_HidDevices.Rows.Count - 1];
                        row.Cells[0].Style.BackColor = Color.PaleGreen;
                        row.Cells[1].Style.BackColor = Color.PaleGreen;
                        row.Cells[2].Style.BackColor = Color.PaleGreen;
                        //skip column 3 (is button)
                    }
                }

            }
            catch (Exception ex) {
                txt_HidDevicesLog.Text += $"Error: {ex.Message}\r\n";
            }
        }
        string HidSelectedDeviceSerial = "";
        void HidDeviceConnect(string key, string serial) {
            HidDeviceDisconnect();
            try {
                _hid = new UsbHidDevice(key);
                _hid.DataReceived += OnEventReportRecieved;
                _hid.OnDisConnected += _hid_OnDisConnected;
                txt_deviceParameter.Text = $"In/Out ({_hid.DeviceInformation.Capabilities.InputReportByteLength}|{_hid.DeviceInformation.Capabilities.OutputReportByteLength})";
                txt_deviceParameter.BackColor = Color.PaleGreen;
                HidSelectedDeviceSerial = serial;
                txt_hid_selectedSerial.Text = serial;
            }
            catch (Exception ex) {
                txt_hid_selectedSerial.Text = "-";
                MessageBox.Show(ex.Message, "HidDeviceConnect()");
            }
        }

        void _hid_OnDisConnected() {
            //_hid.DataReceived -= OnEventReportRecieved;
            //_hid.OnDisConnected -= _hid_OnDisConnected;
            //_hid.Disconnect();
            //_hid.Dispose();
            txt_deviceParameter.BackColor = Color.Salmon;
            txt_hid_selectedSerial.Text = "-";
        }
        void HidDeviceDisconnect() { 
            if (_hid != null) {
                _hid.Disconnect();
                _hid.Dispose();
            }
        }

        void MainFormFormClosing(object sender, FormClosingEventArgs e)
        {
            HidDeviceDisconnect();
        }

        void chk_all_CheckedChanged_1(object sender, EventArgs e) {
            StringBuilder sbOut = new StringBuilder();
            sbOut.Append("2 10 ");
            if(chk_PC13.Checked) { sbOut.Append("1 "); } else { sbOut.Append("0 "); }
            Kernel_sendHID(sbOut.ToString());
        }
        #endregion

        #region Tab_UART
        void Txt_hid_uart1TxKeyDown(object sender, KeyEventArgs e)
        {
            if(e.KeyCode == Keys.Enter) {
                SendUartHid(1, txt_hid_uart1Tx.Text + "\r");
            }
        }
        void SendUartHid(int port, string uartTx) {
            try {
                char[] chars = uartTx.ToCharArray();
                int charsleft = chars.Length - 1;
                int readOffset = 0;
                while(charsleft > 0) {
                    byte[] puffer = new byte[ReportOutLen];
                    switch(port) {
                        case 1: puffer[0] = 10; break;
                        case 3: puffer[0] = 15; break;
                        default:
                            throw new Exception("Uart ports have to be 1 or 3.");
                    }
                    if(charsleft >= 60) {
                        charsleft -= 60;
                        puffer[1] = 60;
                    } else {
                        puffer[1] = (byte)chars.Length;
                        charsleft = 0;
                    }
                    for(int i = 0; i < puffer[1]; i++) {
                        puffer[2 + i] = (byte)chars[readOffset++];
                    }
                    sendHID(puffer);
                }
            } catch(Exception err) {
                MessageBox.Show(err.Message, $"SendUartHid(port={port})");
            }
        }
        void Txt_hid_uart3TxKeyDown(object sender, KeyEventArgs e)
        {
            if(e.KeyCode == Keys.Enter) {
                SendUartHid(3, txt_hid_uart3Tx.Text + "\r");
            }
        }
        void Btn_Usart3_sendSpaceClick(object sender, EventArgs e)
        {
            try {
                byte[] puffer = new byte[ReportOutLen];
                puffer[1] = 15; //send UART3
                puffer[2] = 1; //only one char
                puffer[3] = 32; //char value
                                //send
                sendHID(puffer);
            } catch(Exception err) {
                MessageBox.Show(err.Message, "Grab Fail");
            }
        }
        void CB_RS232_baud_SelectedIndexChanged(object sender, EventArgs e) {
            txt_rs232_baud.Text = CB_RS232_baud.SelectedItem.ToString();
        }

        #endregion

        #region Tab_USB_HID
        void btnUartSetupBaud_Click(object sender, EventArgs e) {
            try {
                UInt32 baud = UInt32.Parse(txt_rs232_baud.Text);
                byte[] puffer = new byte[ReportOutLen];
                puffer[0] = 21;
                if(radUartSetup1.Checked) { puffer[1] = 1; txt_hid_uart1Rx.Text += $"\r\nReinit with Baudrate: {baud}\r\n"; }
                if(radUartSetup3.Checked) { puffer[1] = 3; txt_hid_uart3Rx.Text += $"\r\nReinit with Baudrate: {baud}\r\n"; }
                puffer[2] = (byte)((baud >> 24) & 0xff);
                puffer[3] = (byte)((baud >> 16) & 0xff);
                puffer[4] = (byte)((baud >> 8) & 0xff);
                puffer[5] = (byte)(baud & 0xff);
                //transmission
                sendHID(puffer);

            } catch(Exception ex) {
                MessageBox.Show(ex.Message);
            }
        }
        //Senden
        void Kernel_sendHID(string bytesAsText)
        {
            string[] split = bytesAsText.Replace(',', ' ').Split(' ');
            byte[] puffer = new byte[split.Length];
            for(int i = 0; i < split.Length; i++) {
                if(split[i] != "") {
                    if(split[i].ToLower().Contains("x")) {
                        split[i].Remove(0, 2);
                        long dec = 0;
                        dec = Convert.ToUInt32(split[i], 16);
                        if(dec < 0) { dec = 0; } if(dec > 255) { dec = 255; }
                        puffer[i] = (byte)dec;
                    } else {
                        int value = Int32.Parse(split[i], System.Globalization.NumberStyles.Number);
                        puffer[i] = (byte)Convert.ToByte(value);
                    }
                }
            }
            sendHID(puffer);
        }
        void sendHID(byte[] data) {
            if (_hid == null) { return; }
            try {
                DirectMessage cmd = new DirectMessage(data);
                _hid.SendMessage(cmd);
            }
            catch (Exception err) {
                MessageBox.Show(err.Message, "sendHID Fail");
            }
        }


        void Txt_usb_sendKeyDown(object sender, KeyEventArgs e)
        {
            if(e.KeyData == Keys.Enter) {
                Kernel_sendHID(txt_usb_send.Text);
            }
        }

        //Empfangen
        void HidReportRecived(byte[] data)
        {
            //first check if handled by user control
            bool isHandled = _board.Recived_ByteArray(data);
            if (_board.SetRequestToZero) {
                
                sendHID(new byte[] { 1, 0 });
                _board.SetRequestToZero = false;
            }
            if (isHandled) {
                return; //is handled
            }
            //analogeingang
            switch(data[1]) {
                //case 11: case 12: return; //busy
                //case 52: HidReportRecived_SpiResponse(data); break;
                default:
                    //textausgabe
                    StringBuilder sbDataIn = new StringBuilder();
                    for(int i = 1; i < data.Length; i++) {
                        sbDataIn.Append(data[i].ToString() + " ");
                    }
                    txt_usb_recive.Text = sbDataIn.ToString();
                    break;
            }
            //index + 1 im gegensatz zu µC
            if(false) {
                //int id = 11;
                //int val = data[id] << 8 | data[id + 1]; id += 2;
                //if(val < 4096) { bar_hid_an0.Value = val; }
                //label_Ain0.Text = val.ToString();
                //            val = data[id] << 8 | data[id + 1]; id += 2;
                //            if (val < 4096) { bar_hid_an1.Value = val; }
                //label_Ain1.Text= val.ToString();
                //            val = data[id] << 8 | data[id + 1]; id += 2;
                //            if (val < 4096) { bar_hid_an2.Value = val; }
                //label_Ain2.Text= val.ToString();

                //digital Keys
                //label_HID_key0.BackColor = ((data[2] & 1) == 1) ? Color.LimeGreen : Color.Gainsboro;
                //label_HID_key1.BackColor = ((data[2] & 2) == 2) ? Color.LimeGreen : Color.Gainsboro;

                //id = 41;
                //label_I2CBytes.Text = $"{data[id]},{data[id + 1]}";
                //int rawTemp = 0; float TempMultiplier = 0;
                //if(rad_useLM75.Checked) {
                //    rawTemp = data[id] << 1 | data[id + 1] >> 7; //LM75 0.5°C
                //    TempMultiplier = 0.5f;
                //}
                //if(rad_useLM75A.Checked) {
                //    rawTemp = data[id] << 3 | data[id + 1] >> 5; //LM75A 0.125°C
                //    TempMultiplier = 0.125f;
                //}
                //label_I2CRawTemp.Text = rawTemp.ToString();
                //if((rawTemp & 1024) == 1024) {
                //    label_I2CCalcTemp.Text = (0 - (rawTemp * TempMultiplier)).ToString();
                //} else {
                //    label_I2CCalcTemp.Text = (rawTemp * TempMultiplier).ToString();
                //}
                //id = 61;
                //val = data[id] << 8 | data[id + 1]; id += 2;

            }
            //Uart1 Rx
            if(_board.LastModeGet == Mode_Get.Uart1Rx) {
                sendHID(new byte[] { 1, 1 });
                int menge = data[2];
                for(int i = 0; i < menge; i++) {
                    txt_hid_uart1Rx.Text += (char)data[3 + i];
                }
                return;
            }
            //Uart3 Rx
            if(_board.LastModeGet == Mode_Get.Uart3Rx) {
                sendHID(new byte[] { 1, 1 });
                int menge = data[2];
                for(int i = 0; i < menge; i++) {
                    txt_hid_uart3Rx.Text += (char)data[3 + i];
                }
                txt_hid_uart3Rx.SelectionStart = txt_hid_uart3Rx.Text.Length - 1;
                txt_hid_uart3Rx.ScrollToCaret();
                return;
            }

        }
        //Events
        public void OnEventReportRecieved(byte[] Data) {
            if(InvokeRequired) {
                try {
                    Invoke(new Action<byte[]>(OnEventReportRecieved), new object[] { Data });
                } catch(Exception) {
                }
                return;
            }
            try {
                HidReportRecived(Data);
            }
            catch (Exception ex) {
                txt_usb_recive.Text = "Error: " + ex.Message;

                sendHID(new byte[] { 5, 0 });
            }
        }
        public void OnEventDeviceRemoved() {
            if(InvokeRequired) {
                try {
                    Invoke(new Action(OnEventDeviceRemoved), null);
                } catch(Exception) {
                }
                return;
            }
            //txt_deviceString.BackColor = Color.Red;
        }

        #endregion

        #region Tab_Direct
        //ID
        void btn_GetBoardInformations_Click(object sender, EventArgs e) {
            try {
                uC_PinMap1.RefreshBoardInfo(chk_ReadGpio.Checked);
            }
            catch (Exception ex) {
                uC_PinMap1.AddToLog("Ex: " + ex.Message);
            }
        }
        void btn_Adc_ReadAll_Click(object sender, EventArgs e) {
            try {
                uC_ADC1.AdcReadDynamic();
            }
            catch (Exception ex) {
                //LogRs232_AppedTextOnly("btn_Adc_ReadAll_Click:" + ex.Message, Color.Fuchsia);
                uC_PinMap1.AddToLog("Ex: " + ex.Message);
            }
        }


        #endregion


        void btn_hid_refreshDevices_Click(object sender, EventArgs e) {
            RefreshHidDevices();
        }

        void dgv_HidDevices_CellContentClick(object sender, DataGridViewCellEventArgs e) {
            if (e.RowIndex<0) {
                return;
            }
            if (e.ColumnIndex == 3) {
                //Key
                HidDeviceConnect(dgv_HidDevices.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString(), 
                    dgv_HidDevices.Rows[e.RowIndex].Cells[2].Value.ToString());
            }
        }

        void chk_hid_autoCheckForDevices_CheckedChanged(object sender, EventArgs e) {
            timer_SearchDevices.Enabled = chk_hid_autoCheckForDevices.Checked;
        }
        void timer_SearchDevices_Tick(object sender, EventArgs e) {
            RefreshHidDevices();
        }

        void btn_reflection_execute_Click(object sender, EventArgs e) {
            try {
                string str = txt_reflection_mehtod.Text;
                int first = str.IndexOf('(');
                if (first == -1) {
                    throw new Exception("missing '(' char");
                }
                string metName = str.Remove(first, str.Length - first);
                string strLeft = str.Remove(0, first + 1);
                int last = strLeft.IndexOf(')');
                if (last == -1) {
                    throw new Exception("missing ')' char");
                }
                string strParaTypes = strLeft.Remove(last, strLeft.Length - last);
                string[] splitParaTypes = strParaTypes.Split(',');

                Type boardType = _board.GetType();

                MethodInfo info = boardType.GetMethod(metName);
                info.Invoke(_board, splitParaTypes);
            }
            catch (Exception ex) {
                MessageBox.Show(ex.Message);
            }
            
        }
    }
}
