﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace MiniStm32JoeC_CoreLibrary.Views {
    public partial class UC_RgbLed : UserControl {

        MiniStm32BoardJoeC _board;
        UnsafeBitmap colmap;
        public UC_RgbLed() {
            InitializeComponent();

            colmap = Generate_Colormap();
            picBox_LED.Image = (Bitmap)colmap.Bitmap.Clone();
            colmap.LockBitmap();

            dgw_LEDs.Rows.Add("100", "100", "100");
            dgw_LEDs.Rows.Add("100", "0", "0");
            dgw_LEDs.Rows.Add("0", "100", "0");
            dgw_LEDs.Rows.Add("0", "0", "100");

            dgw_LEDs.Rows.Add("100", "100", "100");
            dgw_LEDs.Rows.Add("0", "100", "100");
            dgw_LEDs.Rows.Add("100", "100", "0");
            dgw_LEDs.Rows.Add("100", "0", "100");
        }
        public void Init(MiniStm32BoardJoeC miniStm32) {
            _board = miniStm32;
        }
        void WaitforBusy(int timeoutInSeconds) {
            DateTime dtTimeout = DateTime.Now.AddSeconds(timeoutInSeconds);
            while (_board.IsBusy) {
                if (DateTime.Now.Ticks > dtTimeout.Ticks) {
                    throw new Exception($"WaitforBusy timeout after '{timeoutInSeconds}'");
                }
                Application.DoEvents();
                System.Threading.Thread.Sleep(10);
            }
        }
        UnsafeBitmap Generate_Colormap() {
            UnsafeBitmap ubmp = new UnsafeBitmap(310, 255);
            ubmp.LockBitmap();
            PixelData P = new PixelData();
            for (int H = 0; H < 256; H++) {
                int state = 0;
                byte R = 255, G = 0, B = 0;
                for (int W = 0; W < 310; W++) {
                    switch (state) {//5er schritte bis 255 -> 51 pixel pro run -> 306 pix für alle
                        case 0: G += 5; if (G == 255) { state++; } break; //rot -> gelb
                        case 1: R -= 5; if (R == 0) { state++; } break; //gelb -> grün
                        case 2: B += 5; if (B == 255) { state++; } break; //grün -> cyan
                        case 3: G -= 5; if (G == 0) { state++; } break; //cyan -> blau
                        case 4: R += 5; if (R == 255) { state++; } break; //blau -> magenta
                        case 5: G += 5; if (G == 255) { state++; } break; //magenta -> weiss
                    }
                    int data = (int)((float)R * (float)H / 255f);
                    if (data < 0) { data = 0; }
                    if (data > 255) { data = 255; }
                    P.red = (byte)data;
                    data = (int)((float)G * (float)H / 255f);
                    if (data < 0) { data = 0; }
                    if (data > 255) { data = 255; }
                    P.green = (byte)data;
                    data = (int)((float)B * (float)H / 255f);
                    if (data < 0) { data = 0; }
                    if (data > 255) { data = 255; }
                    P.blue = (byte)data;
                    ubmp.SetPixel(W, 255 - H, P);
                }
            }
            ubmp.UnlockBitmap();
            return ubmp;
        }
        void Btn_RGB_SetcolorClick(object sender, EventArgs e) {
            if (_board.IsBusy) {
                return;
            }
            dgw_LEDs.RefreshEdit();
            dgw_LEDs.Refresh();
            int ledCnt = (int)num_RGB_LEDs.Value;
            byte[] R = new byte[ledCnt];
            byte[] G = new byte[ledCnt];
            byte[] B = new byte[ledCnt];
            for (int i = 0; i < dgw_LEDs.Rows.Count; i++) {
                DataGridViewRow row = dgw_LEDs.Rows[i];
                R[i] = GetCellValue(row.Cells[0]);
                G[i] = GetCellValue(row.Cells[1]);
                B[i] = GetCellValue(row.Cells[2]);
            }
            _board.SetRgbLed_MultiColor(R, G, B, ledCnt);
        }
        byte GetCellValue(DataGridViewCell cell) {
            try {
                byte number = byte.Parse(cell.Value.ToString());
                return number;
            } catch (Exception) { }
            return 0;
        }

        void TrackBar_RGBLEDScroll(object sender, EventArgs e) {
            if (_board.IsBusy) {
                return;
            }
            byte b0 = (byte)trackBar_RGBLED.Value;
            try {
                _board.SetRgbLed_SingleColor(b0, b0, b0, (int)num_RGB_LEDs.Value);
            } catch (Exception ex) {
                label_LEDStat.Text = "Ex: " + ex.Message;
            }
        }

        void PicBox_LEDMouseMove(object sender, MouseEventArgs e) {
            if (_board.IsBusy) {
                return;
            }
            label_LEDStat.Text = "Pos: " + e.X.ToString() + "x" + e.Y.ToString();
            int X = (int)((float)e.X / picBox_LED.Width * 310);
            int Y = (int)((float)e.Y / picBox_LED.Height * 255);
            if (X < 0 || Y < 0) { return; }
            if (X > 310 || Y > 255) { return; }
            PixelData pix = colmap.GetPixel(X, Y);
            label_LEDStat.Text += "\r\nR: " + pix.red.ToString();
            label_LEDStat.Text += "\r\nG: " + pix.green.ToString();
            label_LEDStat.Text += "\r\nB: " + pix.blue.ToString();
            if (e.Button == MouseButtons.Left) {
                try {
                    _board.SetRgbLed_SingleColor(pix.red, pix.green, pix.blue, (int)num_RGB_LEDs.Value);
                } catch (Exception ex) {
                    label_LEDStat.Text = "Ex: " + ex.Message;
                }
            }
        }
        void picBox_LED_MouseDown(object sender, MouseEventArgs e) {
            if (_board.IsBusy) {
                return;
            }
            PicBox_LEDMouseMove(sender, e);
        }
        void Ben_LEDOffClick(object sender, EventArgs e) {
            WaitforBusy(3);
            try {
                _board.SetRgbLedOff((int)num_RGB_LEDs.Value);
            } catch (Exception ex) {
                label_LEDStat.Text = "Ex: " + ex.Message;
            }
        }

        void chk_led_swapRG_CheckedChanged(object sender, EventArgs e) {
            _board.isRgbLedSwapRedGreen = chk_led_swapRG.Checked;
        }

        void num_RGB_LEDs_ValueChanged(object sender, EventArgs e) {
            _board.RgbLedCount = (int)num_RGB_LEDs.Value;
        }

        void ben_LEDOff2_Click(object sender, EventArgs e) {
            try {
                _board.SetRgbLed_SingleColor(0, 0, 0, (int)num_RGB_LEDs.Value);
            } catch (Exception ex) {
                label_LEDStat.Text = "Ex: " + ex.Message;
            }
        }

        void btn_RainBowLoop_Click(object sender, EventArgs e) {
            try {
                _board.SetRgbLed_RainbowLoop();
            } catch (Exception ex) {
                label_LEDStat.Text = "Ex: " + ex.Message;
            }
        }
    }
}
