﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Windows.Forms.DataVisualization.Charting;

namespace MiniStm32JoeC_CoreLibrary.Views {
    public partial class UC_ADC : UserControl {
        MiniStm32BoardJoeC _board;
        Color[] LineColors = new Color[] { 
            Color.Red, Color.Green, Color.Blue, Color.DimGray, Color.Magenta, 
            Color.Cyan, Color.Yellow, Color.Gold, Color.PaleGreen, Color.Salmon
        };
        
        public UC_ADC() {
            InitializeComponent();
            chart1.ChartAreas[0].AxisX.LabelStyle.Format = "HH:mm:ss";
            chart1.ChartAreas[0].AxisX.MajorGrid.LineColor = Color.LightGray;
            chart1.ChartAreas[0].AxisX.MinorGrid.LineColor = Color.LightGray;
            chart1.ChartAreas[0].AxisY.MajorGrid.LineColor = Color.LightGray;
            chart1.ChartAreas[0].AxisY.MinorGrid.LineColor = Color.LightGray;
        }
        public void Init(MiniStm32BoardJoeC miniStm32) {
            _board = miniStm32;
            //propertyGrid1.SelectedObject = chart1;
        }
        bool _closing = false;
        public void Close() {
            _closing = true;
            timer_AdcAll.Enabled = false;
        }

        void WaitforBusy(int timeoutInSeconds) {
            DateTime dtTimeout = DateTime.Now.AddSeconds(timeoutInSeconds);
            while (_board.IsBusy) {
                if (DateTime.Now.Ticks > dtTimeout.Ticks) {
                    throw new Exception($"WaitforBusy timeout after '{timeoutInSeconds}'");
                }
                Application.DoEvents();
                System.Threading.Thread.Sleep(10);
            }
        }
        #region Controls
        void num_Adc_Timer_ValueChanged(object sender, EventArgs e) {
            timer_AdcAll.Interval = (int)num_Adc_Timer.Value;
        }
        void chk_Adc_Timer_CheckedChanged(object sender, EventArgs e) {
            timer_AdcAll.Enabled = chk_Adc_Timer.Checked;
        }
        void timer_AdcAll_Tick(object sender, EventArgs e) {
            AdcReadDynamic();
        }
        void btn_Adc_GraphClear_Click(object sender, EventArgs e) {
            WaitforBusy(3);
            GraphClear(null);
        }
        void dgv_Adc_All_CellClick(object sender, DataGridViewCellEventArgs e) {
            if (e.RowIndex<0) {
                return;
            }
            if (chart1.Series.Count<2) {
                return;
            }
            if (e.ColumnIndex == 0) {
                colorDialog1.Color = chart1.Series[e.RowIndex].Color;
                DialogResult dr = colorDialog1.ShowDialog();
                if (dr == DialogResult.OK) {
                    chart1.Series[e.RowIndex].Color = colorDialog1.Color;
                    dgv_Adc_All.Rows[e.RowIndex].Cells[0].Style.BackColor = colorDialog1.Color;
                }
            }
            if (e.ColumnIndex == 3) {
                string value = dgv_Adc_All.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString();
                switch (value) {
                    case "ON":
                        dgv_Adc_All.Rows[e.RowIndex].Cells[e.ColumnIndex].Value = "-";
                        chart1.Series[e.RowIndex].Enabled = false;
                        break;
                    default:
                        dgv_Adc_All.Rows[e.RowIndex].Cells[e.ColumnIndex].Value = "ON";
                        chart1.Series[e.RowIndex].Enabled = true;
                        break;
                }
            }
            if (e.ColumnIndex == 4) {
                string value = dgv_Adc_All.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString();
                switch (value) {
                    case "ON":
                        dgv_Adc_All.Rows[e.RowIndex].Cells[e.ColumnIndex].Value = "-";
                        chart1.Series[e.RowIndex].IsValueShownAsLabel = false;
                        break;
                    default:
                        dgv_Adc_All.Rows[e.RowIndex].Cells[e.ColumnIndex].Value = "ON";
                        chart1.Series[e.RowIndex].IsValueShownAsLabel = true;
                        break;
                }
            }
        }

        void chart1_MouseClick(object sender, MouseEventArgs e) {
            if (e.Button == MouseButtons.Right) {
                chart1.ChartAreas[0].AxisX.ScaleView.ZoomReset(0);
                chart1.ChartAreas[0].AxisY.ScaleView.ZoomReset(0);
            }
        }
        void chk_chart_ShowLegend_CheckedChanged(object sender, EventArgs e) {
            chart1.Legends[0].Enabled = chk_chart_ShowLegend.Checked;
        }

        void chk_chart_Show3d_CheckedChanged(object sender, EventArgs e) {
            chart1.ChartAreas[0].Area3DStyle.Enable3D = chk_chart_Show3d.Checked;
        }
        #endregion
        
        void GraphClear(string[] pins) {
            chart1.Series.Clear();
            chart1.Titles.Clear();
            
            if (pins == null) {
                chart1.Series.Add($"empty");
                return;
            }
            for (int i = 0; i < pins.Length; i++) {
                if (string.IsNullOrEmpty(pins[i])) { continue; }
                Series item = new Series($"{i}|{pins[i]}");
                item.ChartType = SeriesChartType.Line;
                item.XValueType = ChartValueType.DateTime;
                if (i < LineColors.Length) {
                    item.Color = LineColors[i];
                }
                else {
                    item.Color = Color.Gainsboro;
                }
                chart1.Series.Add(item);
            }
        }

        public void AdcReadDynamic() {
            AdcReadDynamic(txt_Adc_ReadAllPins.Text);
        }
        public void AdcReadDynamic(string inputPins) {
            if (_board.IsBusy) {
                return;
            }
            try {
                _board.IsBusy = true;
                dgv_Adc_All.Rows.Clear();

                string[] splitPins = inputPins.Split(',');
                if (chart1.Series.Count != (splitPins.Length-1)) {
                    GraphClear(splitPins);
                }
                List<string> PinCfg = new List<string>();

                //StringBuilder sb = new StringBuilder();
                //sb.Append("ADC.ALL.");
                int index = 0;
                foreach (var item in splitPins) {
                    if (item.Length < 2) { continue; }
                    string port = item[0].ToString().ToUpper();
                    string pin = item.Remove(0, 1);
                    int pinInt = int.Parse(pin);
                    PinCfg.Add($"{port}{pinInt.ToString("X")}");
                    string btnEnabled = (chart1.Series[index].Enabled) ? "ON" : "-";
                    string btnLabel = (chart1.Series[index].IsValueShownAsLabel) ? "ON" : "-";

                    dgv_Adc_All.Rows.Add(item, "", "", btnEnabled, btnLabel);
                    dgv_Adc_All.Rows[dgv_Adc_All.Rows.Count - 1].Cells[0].Style.BackColor = chart1.Series[index].Color;
                    index++;
                }
                _board.SetAdcPinArray(PinCfg.ToArray());
                if (_board.Connection == ConnectionType.Serial_RS232_UART) {
                    Mode_Set request = _board.GetModeSet();
                    if (request != Mode_Set.AdcPinArrayDone) {
                        System.Threading.Thread.Sleep(100);
                        request = _board.GetModeSet();
                        if (request != Mode_Set.AdcPinArrayDone) {
                            MessageBox.Show("Requesttype not expected: " + request);
                        }
                    }
                }
                
                ushort[] rx = _board.GetAdcArrayReadout(PinCfg.Count);
                _board.IsBusy = false;

                double voltCountStep = (double)num_Adc_Vref.Value / 4095.0;

                //int position = chart1.Series[0].Points.Count;
                DateTime dt = DateTime.Now;
                for (int i = 0; i < rx.Length; i++) {
                    dgv_Adc_All.Rows[i].Cells[1].Value = rx[i];
                    double volt = voltCountStep * (double)rx[i];
                    dgv_Adc_All.Rows[i].Cells[2].Value = Math.Round(volt, 3);
                    if (rad_ChartValue_Volt.Checked) { chart1.Series[i].Points.AddXY(dt, volt); }
                    if (rad_ChartValue_Counts.Checked) { chart1.Series[i].Points.AddXY(dt, rx[i]); }
                }
            }
            catch (Exception ex) {
                _board.IsBusy = false;
                if (_closing) { return; }
                throw ex;
            }
        }

        void btn_Graph_ToCsv_Click(object sender, EventArgs e) {
            try {
                if (DialogResult.OK != saveFileDialog1.ShowDialog()) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                int entries = chart1.Series[0].Points.Count;
                int linesCount = 0;

                //head
                sb.Append($"DateTime,");
                for (int j = 0; j < chart1.Series.Count; j++) {
                    if (!chart1.Series[j].Enabled) { continue; }
                    sb.Append($"{chart1.Series[j].Name},");
                    linesCount++;
                }
                sb.AppendLine();
                //data
                for (int i = 0; i < entries; i++) {
                    sb.Append($"{DateTime.FromOADate(chart1.Series[0].Points[i].XValue).ToString("HH:mm:ss")},");
                    for (int j = 0; j < chart1.Series.Count; j++) {
                        if (!chart1.Series[j].Enabled) { continue; }
                        sb.Append($"{chart1.Series[j].Points[i].YValues[0]},");
                    }
                    sb.AppendLine();
                }
                
                //write to file
                StreamWriter txt = new StreamWriter(saveFileDialog1.FileName);
                txt.WriteLine($"Lines: {linesCount}");
                txt.WriteLine($"Values per Line: {entries}");
                txt.WriteLine(sb.ToString());
                txt.Close();

                MessageBox.Show(saveFileDialog1.FileName,"Graph lines stored");
            }
            catch (Exception ex) {
                if (_closing) { return; }
                MessageBox.Show(ex.Message);
            }
        }

        void saveFileDialog1_FileOk(object sender, CancelEventArgs e) {

        }

        void btn_read_PinCfg_Click(object sender, EventArgs e) {
            try {
                string[] pins = _board.GetAdcArrayCfg();
                txt_readPinCfg.Text = string.Join(",", pins);
            } catch (Exception ex) {
                MessageBox.Show(ex.Message, "btn_read_PinCfg_Click()");
            }
        }
    }
}
