﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MiniStm32JoeC_CoreLibrary {
    public class PortInfo {
        public List<PinInfo> Pins = new List<PinInfo>();
        public string Port = "";
        public uint CRH = 0;
        public uint CRL = 0;
        public uint ODR = 0;
        public uint IDR = 0;

        public PortInfo(string Ports, string CRHs, string CRLs, string ODRs) {
            Port = Ports;
            CRH = uint.Parse(CRHs, System.Globalization.NumberStyles.HexNumber);
            CRL = uint.Parse(CRLs, System.Globalization.NumberStyles.HexNumber);
            ODR = uint.Parse(ODRs, System.Globalization.NumberStyles.HexNumber);
            Calculate();
        }
        public PortInfo(byte[] data, int indexoffset) {

            //0=ever 2;//Read GPIO
            int i = 0 + indexoffset;
            Port = ((char)data[i++]).ToString();
            CRH |= (uint)(data[i++] << 24);
            CRH |= (uint)(data[i++] << 16);
            CRH |= (uint)(data[i++] << 8);
            CRH |= (uint)(data[i++]);
            CRL |= (uint)(data[i++] << 24);
            CRL |= (uint)(data[i++] << 16);
            CRL |= (uint)(data[i++] << 8);
            CRL |= (uint)(data[i++]);
            ODR |= (uint)(data[i++] << 24);
            ODR |= (uint)(data[i++] << 16);
            ODR |= (uint)(data[i++] << 8);
            ODR |= (uint)(data[i++]);
            IDR |= (uint)(data[i++] << 24);
            IDR |= (uint)(data[i++] << 16);
            IDR |= (uint)(data[i++] << 8);
            IDR |= (uint)(data[i++]);

            Calculate();
        }
        void AddPin(PinInfo pin, bool odrPinState, bool idrPinState, uint PinType) { 
            pin.EnumPinOdrState = (odrPinState) ? PinLogicalState.High : PinLogicalState.Low;
            pin.EnumPinIdrState = (idrPinState) ? PinLogicalState.High : PinLogicalState.Low;

            switch (PinType) {
                case 0b0000: pin.EnumPinMode = PinMode.IA_In_Analog; break;
                case 0b0100: pin.EnumPinMode = PinMode.IF_In_Floating; break;
                case 0b1000:
                    if (odrPinState) {
                        pin.EnumPinMode = PinMode.IP_In_PullUp;
                    } else {
                        pin.EnumPinMode = PinMode.ID_In_PullDown;
                    } 
                    break;
                case 0b0001: pin.EnumPinMode = PinMode.OP_Out_PushPull; pin.EnumPinSpeed = PinHwSpeed.Mhz_10; break;
                case 0b0010: pin.EnumPinMode = PinMode.OP_Out_PushPull; pin.EnumPinSpeed = PinHwSpeed.Mhz_2; break;
                case 0b0011: pin.EnumPinMode = PinMode.OP_Out_PushPull; pin.EnumPinSpeed = PinHwSpeed.Mhz_50; break;
                case 0b0101: pin.EnumPinMode = PinMode.OD_Out_OpenDrain; pin.EnumPinSpeed = PinHwSpeed.Mhz_10; break;
                case 0b0110: pin.EnumPinMode = PinMode.OD_Out_OpenDrain; pin.EnumPinSpeed = PinHwSpeed.Mhz_2; break;
                case 0b0111: pin.EnumPinMode = PinMode.OD_Out_OpenDrain; pin.EnumPinSpeed = PinHwSpeed.Mhz_50; break;
                case 0b1001: pin.EnumPinMode = PinMode.AP_Alt_PushPull; pin.EnumPinSpeed = PinHwSpeed.Mhz_10; break;
                case 0b1010: pin.EnumPinMode = PinMode.AP_Alt_PushPull; pin.EnumPinSpeed = PinHwSpeed.Mhz_2; break;
                case 0b1011: pin.EnumPinMode = PinMode.AP_Alt_PushPull; pin.EnumPinSpeed = PinHwSpeed.Mhz_50; break;
                case 0b1101: pin.EnumPinMode = PinMode.AD_Alt_OpenDrain; pin.EnumPinSpeed = PinHwSpeed.Mhz_10; break;
                case 0b1110: pin.EnumPinMode = PinMode.AD_Alt_OpenDrain; pin.EnumPinSpeed = PinHwSpeed.Mhz_2; break;
                case 0b1111: pin.EnumPinMode = PinMode.AD_Alt_OpenDrain; pin.EnumPinSpeed = PinHwSpeed.Mhz_50; break;
                default:
                    pin.EnumPinMode = PinMode.Undefined;
                    break;
            }
            Pins.Add(pin);
        }
        void Calculate() {
            Pins.Clear();
            int startPin = 0;
            switch (Port) {
                case "A": case "B": break;
                case "C": startPin = 13; break;
            }
            for (int i = startPin; i < 8; i++) {
                string Pinname = $"{Port}{i}";
                PinInfo pin = new PinInfo(Pinname);
                uint PinType = ((CRL >> (i * 4)) & 0xF);
                bool odrPinState = ((ODR & (1 << i)) == (1 << i));
                bool idrPinState = ((IDR & (1 << i)) == (1 << i));
                AddPin(pin, odrPinState, idrPinState, PinType);
            }
            //offset = 0;
            if (startPin == 0) { startPin = 8; }
            for (int i = startPin; i < 16; i++) {
                string Pinname = $"{Port}{i}";
                PinInfo pin = new PinInfo(Pinname);
                uint PinType = ((CRH >> ((i - 8) * 4)) & 0xF);
                bool odrPinState = ((ODR & (1 << i)) == (1 << i));
                bool idrPinState = ((IDR & (1 << i)) == (1 << i));
                AddPin(pin, odrPinState, idrPinState, PinType);
            }
        }
    }
}
