﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MiniStm32JoeC_CoreLibrary {
    public class MotionInfo {
        public ushort StepsToMove = 0;
        public ushort Position_LR = 0;
        public ushort Position_UD = 0;
        public ushort Position_Foc = 0;
        public byte MotionStateByte = 0;
        public byte MotionConfigByte = 0;
        public MotionStateType MotionState = MotionStateType.Undefined;

        public enum MotionStateType { 
            Undefined = 0,
            NOT_INIT = 1,
            READY = 2,
            STOP = 3,
            MOVING_UP = 5,
            MOVING_DOWN = 6,
            MOVING_POS = 7,
            HOMING_SEARCH = 10,
            HOMING_TO_POS = 11,
            FAIL_SELECT_MOTOR = 200,
            HOMING_FAILED = 201,
            unknown = 255
        }

        public MotionInfo() {
        }
        public MotionInfo(byte[] data, int indexoffset) {
            //0=ever 1;//Read IDs, boardconfig
            if (data == null) {
                return;
            }
            int i = indexoffset;
            try {
                MotionStateByte = data[i];
                MotionState = (MotionStateType)data[i];
            } catch (Exception) {
                MotionState = MotionStateType.unknown;
            }
            i++;
            MotionConfigByte = data[i++];
            StepsToMove |= (ushort)(data[i++] << 8);
            StepsToMove |= (ushort)(data[i++]);
            Position_LR |= (ushort)(data[i++] << 8);
            Position_LR |= (ushort)(data[i++]);
            Position_UD |= (ushort)(data[i++] << 8);
            Position_UD |= (ushort)(data[i++]);
            Position_Foc |= (ushort)(data[i++] << 8);
            Position_Foc |= (ushort)(data[i++]);
        }
    }
}