﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace MiniStm32JoeC_CoreLibrary {
    public class I2cResponseInfo {
        public byte[] RawRxData = null;
        public I2cStateType I2cState = I2cStateType.Undefined;
        public byte I2cStateByte = 0;
        int TransmittedBytes_W = 0;
        int TransmittedBytes_R = 0;
        public byte[] ResponseArray = null;
        string nullResponse = "";

        public enum I2cStateType { 
            Undefined =             0,
            //busy states
            CFG_HW_OFF =            97,
            CFG_HW_DONE =           98,
            INIT_HW =               99,
            BEGIN =                 100,
            WAIT_CLK_STR =          101,
            SEND_STOP =             102,
            SEND_ADD =              103,
            SEND_R_BYTE =           104,
            SEND_W_BYTE =           105,
            //success states
            DONE =                  155,
            BUS_UNLOCKED =          156,
            //fail states
            SLAVE_NAC =               201,
            TIMEOUT =                 202,
            SLAVE_W_NAC =             203,
            SEQUENCE_FAIL =           204,
            TIMEOUT_START_DATA_LOW =  205,
            TIMEOUT_START_CLK_LOW =   206,
            BUS_STILL_LOCKED =        207,

            UNKNOWN =                 255
        }

        public I2cResponseInfo() {
        }
        public I2cResponseInfo(byte[] data, int startindex, string mode) {
            if (data == null) {
                nullResponse = "<NULL>";
                return;
            }
            RawRxData = new byte[data.Length];
            Array.Copy(data, RawRxData, data.Length);


            int i = startindex;
            try {
                I2cStateByte = data[i];
                I2cState = (I2cStateType)data[i];
            } catch (Exception) {
                I2cState = I2cStateType.Undefined;
            }
            i++;
            TransmittedBytes_W = data[i++];
            TransmittedBytes_R = data[i++];
            int FinalLengh = TransmittedBytes_W + TransmittedBytes_R;
            switch (mode) {
                case "WR":
                    FinalLengh = TransmittedBytes_R;
                    break;
            }
            if ((FinalLengh + i) > data.Length) {
                FinalLengh = data.Length - i;
            }
            ResponseArray = new byte[FinalLengh];
            Array.Copy(data, i, ResponseArray, 0, ResponseArray.Length);
            //MotionConfigByte = data[i++];
            //StepsToMove |= (ushort)(data[i++] << 8);
            //StepsToMove |= (ushort)(data[i++]);
        }
        public string GetResponse(bool isHexMode) {
            if (!string.IsNullOrEmpty(nullResponse)) {
                return nullResponse;
            }
            StringBuilder sb = new StringBuilder(100);
            sb.Append($"[{I2cStateByte}]");
            sb.Append(I2cState);
            sb.Append(": ");
            for (int i = 0; i < ResponseArray.Length; i++) {
                if (isHexMode) {
                    sb.Append($"{ResponseArray[i].ToString("X02")} ");
                } else {
                    sb.Append($"{ResponseArray[i]} ");
                }
            }
            return sb.ToString();
        }
    }
}